/******************************************************************************
					                        chat.cpp
					                   -------------------
		begin                : Mon May 8 2000
		copyright            : (C) 2000 by Benjamin Meyer
		email                : ben@meyerhome.net
 ******************************************************************************/

#include "chat.h"
#include "linkdialog.h"
#include "browser.h"
#include "sound.h"
#include "smiliespopup.h"
#include "taim.h"
#include "qstylesheet.h"
#include <kfiledialog.h>
#include <qprinter.h>
#include <qmsgbox.h>
#include <qdatetime.h>
#include <qclipboard.h>
#include <kcolordialog.h>
#include <kapp.h>
#include <qpixmap.h>
#include <qpalette.h>
#include <qaccel.h>
#include <qpaintdevicemetrics.h>
#include <qfont.h>
#include <kmenubar.h>
#include <qsimplerichtext.h>

#include <ktoolbar.h>
#include <kiconloader.h>
#include <qtoolbutton.h>
#include <qsplitter.h>
#include <qmultilineedit.h>
#include <kpopupmenu.h>
#include <qcolor.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qlabel.h>

/******************************************************************************
 * Constructor
 ******************************************************************************/
Chat::Chat(QString userName, QString buddysName, QWidget *parent, QString alias): QMainWindow(parent,buddysName.latin1()){
	myName = userName;
	buddyName = buddysName;
	name = buddyName;
	room = 0;
 
	chatSoundMuteButton = 0;
	chatLogButton = 0;
	chatTimeButton = 0;
	
	sentAwayMessageToBuddy = false; 
	shiftIsPressed = false;
	fontSize = 3;
	flashNumber = false;
	cleared = false;
	temp_BuddyBgColor.setRgb(255,255,255);
	temp_BuddyTextColor.setRgb(0,0,0);
	lastMessage = "";
	currentMessageOut = "";
	
	if (alias.length() > 0)
          this->setCaption(alias + " (" + buddyName + ")" + QString(" - Kinkatta"));
        else
          this->setCaption(buddyName + QString(" - Kinkatta"));


	chatSettings = setup::settings()->chatSettings;
	toolBarSettings = setup::settings()->chatToolBarSettings;
	colorSettings = setup::settings()->chatColorSettings;
	fontSettings = setup::settings()->chatFontSettings;
	soundSettings = setup::settings()->chatSoundSettings;
	
	//These are the only settings that can be changed from this chat window, so
	//we save them seperately.
	chatSettings_chat_log = chatSettings->chat_log;
	toolBarSettings_chat_log = toolBarSettings->chat_log;
	soundSettings_chat_sound = soundSettings->chat_sound;
	soundSettings_chat_sound_beepReceive = soundSettings->chat_sound_beepReceive;
	soundSettings_chat_sound_beepSend = soundSettings->chat_sound_beepSend;
	chatSettings_chat_show_time = chatSettings->chat_show_time;
	chatSettings_chat_log_time = chatSettings->chat_log_time;
	colorSettings_chat_yourbg_color = colorSettings->chat_yourbg_color;
	colorSettings_chat_yourText_color = colorSettings->chat_yourText_color;
	colorSettings_chat_buddybg_color = colorSettings->chat_buddybg_color;
	colorSettings_chat_buddyText_color = colorSettings->chat_buddyText_color;

	if(chatSettings_chat_log)
		openLogFile();

	default_yourFont = true;
	default_buddyFont = true;
        
	kmenuBar = new KMenuBar(this, "MenuBar");
	fileMenu=new KPopupMenu(kmenuBar, "FileMenu");
	editMenu=new KPopupMenu(kmenuBar, "EditMenu");
	viewMenu=new KPopupMenu(kmenuBar, "ViewMenu");
	buddyMenu = new KPopupMenu(kmenuBar, "BuddyMenu");
	insertMenu = new KPopupMenu(kmenuBar, "InsertMenu");
	insertFaceMenu = new KPopupMenu(insertMenu, "FaceMenu");
	connect(insertFaceMenu, SIGNAL(activated(int)), this, SLOT(slotInsertFace(int)));
	helpMenu = new KPopupMenu(kmenuBar, "HelpMenu");
					
	// MENUBAR CONFIGURATION
	// set menuBar() the current menuBar
	kmenuBar->clear();
	kmenuBar->insertItem("&File", fileMenu);
	kmenuBar->insertItem("&Edit", editMenu);
	kmenuBar->insertItem("&View", viewMenu);
	kmenuBar->insertItem("&Insert", insertMenu);
	kmenuBar->insertItem("&Buddy", buddyMenu);
	kmenuBar->insertItem("&Help", helpMenu);
	
	this->initMenuBar();
	// Create Tool Bars
	fileToolbar = new KToolBar(this, "file operations", true, true);
	textToolbar = new KToolBar(this, "text operations", true, true);
	//fileToolbar->setHorizontalStretchable (true);
	//textToolbar->setHorizontalStretchable (true);
	// Fill Tool bars
	this->setIcon(SmallIcon("kinkatta"));
}

/******************************************************************************
 * Deconstructor
 ******************************************************************************/
Chat::~Chat(){
	if (chatSettings_chat_log == true){
		// End log file and close it.
		if (chatSettings->chat_log_inHtml == true)
			logStream << "</BODY>\n</HTML>";
		logFile.close();
	}
}

/******************************************************************************
 * Load the new settings
 ******************************************************************************/
void Chat::updateChatSettings(){
	chatSettings = setup::settings()->chatSettings;

	if (chatSettings_chat_log !=
									chatSettings->chat_log)
		slotChatLog();

	if (chatSettings_chat_show_time !=
									chatSettings->chat_show_time)
		slotViewTimeStamp();

}

/******************************************************************************
 * Load the toolbar with the new settings
 ******************************************************************************/
void Chat::updateChatToolBarSettings(){
	//qDebug("Chat::updateChatToolBarSettings\n");
	toolBarSettings = setup::settings()->chatToolBarSettings;

	// View Text
	if ( toolBarSettings->view_text == true) {
		textToolbar->show();
		viewMenu->setItemChecked(ID_VIEW_TEXTTOOLBAR, true);
	}
	else{
		textToolbar->hide();
		viewMenu->setItemChecked(ID_VIEW_TEXTTOOLBAR, false);
	}
	// View Chat
	if ( toolBarSettings->view_chat == true) {
		fileToolbar->show();
		viewMenu->setItemChecked(ID_VIEW_CHATTOOLBAR, true);
	}
	else{
		fileToolbar->hide();
		viewMenu->setItemChecked(ID_VIEW_CHATTOOLBAR, false);
	}

	this->initToolBar();

	// scroll to the current text
	chatWindow->ensureVisible(0, chatWindow->contentsHeight());
}

/******************************************************************************
 * Load the new settings
 ******************************************************************************/
void Chat::updateChatColorSettings(){
	colorSettings = setup::settings()->chatColorSettings;

	colorSettings_chat_yourbg_color = colorSettings->chat_yourbg_color;
	colorSettings_chat_yourText_color = colorSettings->chat_yourText_color;
	colorSettings_chat_buddybg_color = colorSettings->chat_buddybg_color;
	colorSettings_chat_buddyText_color = colorSettings->chat_buddyText_color;

        applytoInputWindow();
        applytoChatWindow();
}

/******************************************************************************
 * Load the new settings
 ******************************************************************************/
void Chat::updateChatFontSettings(){
	fontSettings = setup::settings()->chatFontSettings;

	/* set to boolean default flags to true if user is using default font */
	QFont tempfont = qApp->font();
	default_yourFont = (fontSettings->chat_yourFont.family() == tempfont.family())
		&& (fontSettings->chat_yourFont.pointSize() == 12);
	default_buddyFont = (fontSettings->chat_buddyFont.family() == tempfont.family())
		&& (fontSettings->chat_buddyFont.pointSize() == 12);
	fontSize = normalFontSize = ptsizetohtml(fontSettings->chat_yourFont.pointSize());

	// toggle menu items and toolbars depending on font...

        if ( fontSettings->chat_yourFont.weight() == QFont::Bold ) {
	       	insertMenu->setItemEnabled ( ID_INSERT_BOLD, false );
		if (toolBarSettings->text_bold == true)
			textToolbar->setItemEnabled( ID_INSERT_BOLD, false);
        } else {
		insertMenu->setItemEnabled ( ID_INSERT_BOLD, true );
		if (toolBarSettings->text_bold == true)
			textToolbar->setItemEnabled( ID_INSERT_BOLD, true);
	}

        if ( fontSettings->chat_yourFont.italic() ) {
	       	insertMenu->setItemEnabled ( ID_INSERT_ITALIC, false );
		if (toolBarSettings->text_italic == true)
			textToolbar->setItemEnabled( ID_INSERT_ITALIC, false);
        } else {
		insertMenu->setItemEnabled ( ID_INSERT_ITALIC, true );
		if (toolBarSettings->text_italic == true)
			textToolbar->setItemEnabled( ID_INSERT_ITALIC, true);
	}


        applytoInputWindow();
}

/******************************************************************************
 * Load the new settings
 ******************************************************************************/
void Chat::updateChatSoundSettings(){
	soundSettings = setup::settings()->chatSoundSettings;

	//soundSettings_chat_sound = soundSettings->chat_sound;
	soundSettings_chat_sound_beepReceive = soundSettings->chat_sound_beepReceive;
	soundSettings_chat_sound_beepSend = soundSettings->chat_sound_beepSend;

	if (soundSettings_chat_sound !=
								soundSettings->chat_sound)
		slotChatSound();
}

/******************************************************************************
 * MenuBar setup
 ******************************************************************************/
void Chat::initMenuBar(){
	// menuBar entry fileMenu
	fileMenu->clear();
	fileMenu->insertItem(SmallIcon("history"), "&Log", this, SLOT(slotChatLog()), CTRL+Key_L, ID_FILE_LOG);
	fileMenu->insertItem(SmallIcon("kinkatta_bell"), "&Sound", this, SLOT(slotChatSound()), 0, ID_FILE_SOUND);
	fileMenu->insertItem(SmallIcon("editclear"), "&Clear", this, SLOT(slotChatClear()), CTRL+Key_D, ID_FILE_CLEAR);
	fileMenu->insertItem(SmallIcon("filesave"), "&Save as...", this, SLOT(slotChatSaveAs()), 0,ID_FILE_SAVE_AS);
	fileMenu->insertSeparator();
	fileMenu->insertItem(SmallIcon("fileprint"), "&Print...", this, SLOT(slotChatPrint()), CTRL+Key_P, ID_FILE_PRINT);
	fileMenu->insertSeparator();
	fileMenu->insertItem(SmallIcon("fileclose"), "Close", this, SLOT(slotChatClose()), CTRL+Key_Q, ID_FILE_CLOSE);

	if (chatSettings_chat_log == true)
		fileMenu->setItemChecked(ID_FILE_LOG, true);
	else
		fileMenu->setItemChecked(ID_FILE_LOG, false);

	if (soundSettings_chat_sound == true)
		fileMenu->setItemChecked(ID_FILE_SOUND, true);
	else
		fileMenu->setItemChecked(ID_FILE_SOUND, false);

	// menuBar entry editMenu
	editMenu->clear();
	editMenu->insertItem(SmallIcon("undo"), "U&ndo", this, SLOT(slotEditUndo()), CTRL+Key_N, ID_EDIT_UNDO);
	editMenu->insertItem(SmallIcon("redo"), "R&edo", this, SLOT(slotEditRedo()), CTRL+Key_E, ID_EDIT_REDO);
	editMenu->insertSeparator();
	editMenu->insertItem(SmallIcon("editcut"), "Cu&t", this, SLOT(slotEditCut()), CTRL+Key_X, ID_EDIT_CUT);
	editMenu->insertItem(SmallIcon("editcopy"), "&Copy", this, SLOT(slotEditCopy()), CTRL+Key_C, ID_EDIT_COPY);
	editMenu->insertItem(SmallIcon("editpaste"), "&Paste", this, SLOT(slotEditPaste()), CTRL+Key_V, ID_EDIT_PASTE);
	editMenu->insertSeparator();
	editMenu->insertItem("&Select All", this, SLOT(slotEditSelectAll()), CTRL+Key_A, ID_EDIT_SELECT_ALL);

	editMenu->setItemEnabled ( ID_EDIT_UNDO, false );
	editMenu->setItemEnabled ( ID_EDIT_REDO, false );

	// menuBar entry viewMenu
	viewMenu->clear();
	viewMenu->setCheckable(true);
	viewMenu->insertItem(SmallIcon("kinkatta_time"), "&Time Stamp", this, SLOT(slotViewTimeStamp()), Key_F2, ID_VIEW_TIME);
	viewMenu->insertSeparator();
	viewMenu->insertItem("&Chat Toolbar", this, SLOT(slotViewChatToolBar()), 0, ID_VIEW_CHATTOOLBAR);
	viewMenu->insertItem("Text Tool&bar", this, SLOT(slotViewTextToolBar()), 0, ID_VIEW_TEXTTOOLBAR);

	viewMenu->setItemChecked(ID_VIEW_CHATTOOLBAR, true);
	viewMenu->setItemChecked(ID_VIEW_TEXTTOOLBAR, true);

	if (toolBarSettings->chat_time == true)
		viewMenu->setItemChecked(ID_VIEW_TIME, true);
	else
		viewMenu->setItemChecked(ID_VIEW_TIME, false);

	insertMenu->clear();

	insertMenu->insertItem(SmallIcon("smilies"), "&Smilies",  insertFaceMenu);
	insertMenu->insertSeparator();
	insertFaceMenu->clear();
	insertFaceMenu->insertItem(SmallIcon("face_smile"), " " /* ":-)" */,  FACE_SMILE_ID);
	insertFaceMenu->setAccel(CTRL + Key_1, FACE_SMILE_ID);
	insertFaceMenu->insertItem(SmallIcon("face_sad")," " /* ":-(" */, FACE_SAD_ID);
	insertFaceMenu->setAccel(CTRL + Key_2, FACE_SAD_ID);
	insertFaceMenu->insertItem(SmallIcon("face_wink")," " /* ";-)" */, FACE_WINK_ID);
	insertFaceMenu->setAccel(CTRL + Key_3, FACE_WINK_ID);
	insertFaceMenu->insertItem(SmallIcon("face_tongue")," " /* ":-P" */, FACE_TONGUE_ID);
	insertFaceMenu->setAccel(CTRL + Key_4, FACE_TONGUE_ID);

	insertFaceMenu->insertItem(SmallIcon("face_scream")," " /* "=-O" */, FACE_SCREAM_ID);
	insertFaceMenu->setAccel(CTRL + Key_5, FACE_SCREAM_ID);
	insertFaceMenu->insertItem(SmallIcon("face_kiss")," " /* ":-*" */,  FACE_KISS_ID);
	insertFaceMenu->setAccel(CTRL + Key_6, FACE_KISS_ID);
	insertFaceMenu->insertItem(SmallIcon("face_yell")," " /* ">:o" */, FACE_YELL_ID);
	insertFaceMenu->setAccel(CTRL + Key_7, FACE_YELL_ID);
	insertFaceMenu->insertItem(SmallIcon("face_glasses")," " /* "8-)" */, FACE_GLASSES_ID);
	insertFaceMenu->setAccel(CTRL + Key_8, FACE_GLASSES_ID);

	insertFaceMenu->insertItem(SmallIcon("face_oneeye")," " /* "O-)" */, FACE_ONEEYE_ID);
	insertFaceMenu->setAccel(CTRL + Key_9, FACE_ONEEYE_ID);

	insertFaceMenu->insertItem(SmallIcon("face_moneymouth")," " /* ":-$" */, FACE_MONEYMOUTH_ID);
	insertFaceMenu->setAccel(ALT + Key_1, FACE_MONEYMOUTH_ID);
	insertFaceMenu->insertItem(SmallIcon("face_burp")," " /* ":-!" */,  FACE_BURP_ID);
	insertFaceMenu->setAccel(ALT + Key_2, FACE_BURP_ID);
	insertFaceMenu->insertItem(SmallIcon("face_embarrassed")," " /* ":-[" */, FACE_EMBARRASSED_ID);
	insertFaceMenu->setAccel(ALT + Key_3, FACE_EMBARRASSED_ID);
	insertFaceMenu->insertItem(SmallIcon("face_angel")," " /* "O:-)" */, FACE_ANGEL_ID);
	insertFaceMenu->setAccel(ALT + Key_4, FACE_ANGEL_ID);

	insertFaceMenu->insertItem(SmallIcon("face_think")," " /* ":-\\" */, FACE_THINK_ID);
	insertFaceMenu->setAccel(ALT + Key_5, FACE_THINK_ID);
	insertFaceMenu->insertItem(SmallIcon("face_cry")," " /* ":'(" */,  FACE_CRY_ID);
	insertFaceMenu->setAccel(ALT + Key_6, FACE_CRY_ID);
	insertFaceMenu->insertItem(SmallIcon("face_crossedlips")," " /* ":-X" */, FACE_CROSSEDLIPS_ID);
	insertFaceMenu->setAccel(ALT + Key_7, FACE_CROSSEDLIPS_ID);
	insertFaceMenu->insertItem(SmallIcon("face_bigsmile")," " /* ":-D" */, FACE_BIGSMILE_ID);
	insertFaceMenu->setAccel(ALT + Key_8, FACE_BIGSMILE_ID);

	insertFaceMenu->insertItem(SmallIcon("face_luke")," " /* "C:-)" */, FACE_LUKE_ID);
	insertFaceMenu->setAccel(ALT + Key_9, FACE_LUKE_ID);

	insertMenu->insertItem(SmallIcon("text_bold"), "&Bold", this, SLOT(slotInsertBold()), CTRL+Key_B, ID_INSERT_BOLD);
	insertMenu->insertItem(SmallIcon("text_italic"), "&Italic", this, SLOT(slotInsertItalic()), CTRL+Key_I, ID_INSERT_ITALIC);
	insertMenu->insertItem(SmallIcon("text_under"), "&Underline", this, SLOT(slotInsertUnderline()), CTRL+Key_U, ID_INSERT_UNDERLINE);
	insertMenu->insertSeparator();
	insertMenu->insertItem(SmallIcon("kinkatta_textsmall"), "S&hrink Font", this, SLOT(slotInsertShrinkFont()), CTRL+Key_Minus, ID_INSERT_FONTSMALL);
	insertMenu->insertItem(SmallIcon("kinkatta_textnormal"), "&Normal Font", this, SLOT(slotInsertNormalFont()), 0, ID_INSERT_FONTNORM);
	insertMenu->insertItem(SmallIcon("kinkatta_textbig"), "In&crease Font", this, SLOT(slotInsertIncreaseFont()), CTRL+Key_Plus, ID_INSERT_FONTBIG);
	insertMenu->insertSeparator();
	insertMenu->insertItem(SmallIcon("kinkatta_palette"), "B&ackground Color...", this, SLOT(slotInsertBackGroundColor()), 0, ID_INSERT_BACCOLOR);
	insertMenu->insertItem(SmallIcon("kinkatta_pen"), "&Pen Color...", this, SLOT(slotInsertPenColor()), 0, ID_INSERT_PENCOLOR);
	insertMenu->insertItem(SmallIcon("kinkatta_chat_link"), "&Link", this, SLOT(slotInsertLink()), CTRL+Key_K, ID_INSERT_LINK);
	insertMenu->insertSeparator();
	insertMenu->insertItem("L&ast Message", this, SLOT(slotInsertLastMessage()),Key_Insert, ID_INSERT_LASTMESSAGE);

	buddyMenu->clear();
	buddyMenu->insertItem(SmallIcon("mail_send"), "&Send Message", this, SLOT(slotBuddySendMessage()), CTRL+Key_S, ID_BUDDY_SEND);

	// menuBar entry helpMenu
	helpMenu->clear();
	helpMenu->insertItem(SmallIcon("gohome"), "&Open Web Site", this, SIGNAL(openHomePage()));
	helpMenu->insertSeparator();
	helpMenu->insertItem(SmallIcon("kinkatta"), "&About...", this, SIGNAL(showAbout()), 0, ID_HELP_ABOUT);
}

/******************************************************************************
 * ToolBar setup  Clears the toolbars and fills them with the widgets
 * specified in toolBarSettings then oriants the toolbars as chosen.
 ******************************************************************************/
void Chat::initToolBar(){
	//qDebug("Chat::initToolBar\n");

  // File Tool Bar
  //fileToolbar->setVerticalStretchable(true);
  //fileToolbar->setOrientation (Vertical);
  fileToolbar->hide();
  fileToolbar->clear();

  if (toolBarSettings->chat_clear == true)
    fileToolbar->insertButton("editclear",-1,SIGNAL(clicked()),
       this, SLOT(slotChatClear()),true,"Clear Chat", -1);

  if (toolBarSettings->chat_save == true)
    fileToolbar->insertButton("filesave",-1,SIGNAL(clicked()),
       this, SLOT(slotChatSaveAs()),true,"Save Chat As", -1);

  if (toolBarSettings->chat_print == true)
    fileToolbar->insertButton("fileprint",-1,SIGNAL(clicked()),
       this, SLOT(slotChatPrint()),true,"Print Chat", -1);

  if (toolBarSettings->chat_time == true) {
    chatTimeButton = fileToolbar->insertButton("kinkatta_time", ID_VIEW_TIME_BUTTON, SIGNAL(clicked()),
       this, SLOT(slotViewTimeStamp()),true,"Toggle Timestamp", -1);
    fileToolbar->setToggle(ID_VIEW_TIME_BUTTON);
    if (chatSettings_chat_show_time == true)
       fileToolbar->setButton(ID_VIEW_TIME_BUTTON, true);
    else
       fileToolbar->setButton(ID_VIEW_TIME_BUTTON, false);
  } else {
    chatTimeButton = 0;
  }

  if (toolBarSettings->chat_log == true) {
    chatLogButton = fileToolbar->insertButton("history", ID_LOG_BUTTON, SIGNAL(clicked()),
       this, SLOT(slotChatLog()),true,"Toggle Logging", -1);
    fileToolbar->setToggle(ID_LOG_BUTTON);
    if (chatSettings_chat_log == true)
       fileToolbar->setButton(ID_LOG_BUTTON, true);
    else
       fileToolbar->setButton(ID_LOG_BUTTON, false);
  } else {
       chatLogButton = 0;
  }

  if (toolBarSettings->chat_sound == true) {
    chatSoundMuteButton = fileToolbar->insertButton("kinkatta_bell", ID_SOUND_MUTE_BUTTON, SIGNAL(clicked()),
       this, SLOT(slotChatSound()), true,"Toggle Sound", -1);
    fileToolbar->setToggle(ID_SOUND_MUTE_BUTTON);
    if (soundSettings_chat_sound == true)
       fileToolbar->setButton(ID_SOUND_MUTE_BUTTON, true);
    else
       fileToolbar->setButton(ID_SOUND_MUTE_BUTTON, false);
  } else {
       chatSoundMuteButton = 0;
  }

  if (toolBarSettings->view_chat == true){
    fileToolbar->show();
    if (toolBarSettings->loc_chat == 0){
      QMainWindow::moveToolBar(fileToolbar,QMainWindow::Top);
    }
    if (toolBarSettings->loc_chat == 1){
      QMainWindow::moveToolBar(fileToolbar,QMainWindow::Right);
    }
    if (toolBarSettings->loc_chat == 2){
      QMainWindow::moveToolBar(fileToolbar,QMainWindow::Bottom);
    }
    if (toolBarSettings->loc_chat == 3){
      QMainWindow::moveToolBar(fileToolbar,QMainWindow::Left);
    }
  }

  textToolbar->hide();
  // TextToolBar
  textToolbar->clear();

  bool chunk4 = (toolBarSettings->text_smiley == true);

  if (toolBarSettings->text_bold == true)
    textToolbar->insertButton("text_bold",ID_INSERT_BOLD,SIGNAL(clicked()),
       this, SLOT(slotInsertBold()),true,"Bold", -1);

  if (toolBarSettings->text_italic == true)
    textToolbar->insertButton("text_italic",ID_INSERT_ITALIC,SIGNAL(clicked()),
       this, SLOT(slotInsertItalic()),true,"Italic", -1);

  if (toolBarSettings->text_underline == true)
    textToolbar->insertButton("text_under",-1,SIGNAL(clicked()),
       this, SLOT(slotInsertUnderline()),true,"Underline", -1);

  if (toolBarSettings->text_fontbig == true)
     textToolbar->insertButton("kinkatta_textsmall",-1,SIGNAL(clicked()),
       this, SLOT(slotInsertShrinkFont()),true,"Decrease Font", -1);

  if (toolBarSettings->text_fontnormal == true)
    textToolbar->insertButton("kinkatta_textnormal",-1,SIGNAL(clicked()),
       this, SLOT(slotInsertNormalFont()),true,"Normal Font", -1);

  if (toolBarSettings->text_fontdown == true)
   textToolbar->insertButton("kinkatta_textbig",-1,SIGNAL(clicked()),
       this, SLOT(slotInsertIncreaseFont()),true,"Increase Font", -1);

  if (toolBarSettings->text_bgcolor == true)
    textToolbar->insertButton("kinkatta_palette",-1,SIGNAL(clicked()),
       this, SLOT(slotInsertBackGroundColor()),true,"Background Color", -1);

  if (toolBarSettings->text_pencolor == true)
     textToolbar->insertButton("kinkatta_pen",-1,SIGNAL(clicked()),
       this, SLOT(slotInsertPenColor()),true,"Pen Color", -1);

  if (toolBarSettings->text_link == true)
     textToolbar->insertButton("kinkatta_chat_link",-1,SIGNAL(clicked()),
       this, SLOT(slotInsertLink()),true,"Insert Link", -1);

  // load smilies icon using KIconLoader and insert in toolbar
  QPixmap smilieicon;
  if (chunk4 ){

    KPopupMenu *smileyPopupMenu = new KPopupMenu(this, "smileyPopupMenu");
    smilieicon = BarIcon("kinkatta_smilies");
    textToolbar->insertButton(smilieicon, -1, smileyPopupMenu, true, ":-D", -1);

    Smilies *smileyPopup = new Smilies(smileyPopupMenu, "smileyPopup");
    smileyPopupMenu->insertItem(smileyPopup, 1, 1);
    connect(smileyPopup, SIGNAL(smileyButtonClicked(int)), this, SLOT(slotInsertFace(int)));

  }

  if (toolBarSettings->chat_send == true)
    chatLogButton = textToolbar->insertButton("mail_send", 0, SIGNAL(clicked()),
       this, SLOT(slotBuddySendMessage()),true,"Send Message", -1);

  if (toolBarSettings->view_text == true){
    textToolbar->show();
    if (toolBarSettings->loc_text == 0){
      QMainWindow::moveToolBar(textToolbar,QMainWindow::Top);
    }
    if (toolBarSettings->loc_text == 1){
      QMainWindow::moveToolBar(textToolbar,QMainWindow::Right);
    }
    if (toolBarSettings->loc_text == 2){
      QMainWindow::moveToolBar(textToolbar,QMainWindow::Bottom);
    }
    if (toolBarSettings->loc_text == 3){
      QMainWindow::moveToolBar(textToolbar,QMainWindow::Left);
    }
  }

  //if (toolBarSettings->prev_send == true)
 //   sendMessageButton = new QToolButton(BarIcon("mail_send"), "Send Message", 0, this,
  //                                        SLOT(slotBuddySendMessage()), previewToolbar);

}

/******************************************************************************
 * Sets up the input window and the chat window
 ******************************************************************************/
void Chat::initChatWindow(){
	//spliter = new QSplitter(this, "Splitter" );
	spliter->setOrientation(QSplitter::Vertical);

	chatWindow = new KinkattaTextBrowser(spliter, "ChatWindow");
	chatWindow->setHScrollBarMode(QScrollView::AlwaysOff);
	QFont tempFont = chatWindow->font();
	tempFont.setPointSize(12);
	chatWindow->setFont(tempFont);
  chatWindow->setNotifyClick(true);

	connect(chatWindow, SIGNAL(urlClick( const QString &)), this, SLOT(urlClicked(const QString &)));
  connect(chatWindow, SIGNAL(mailClick( const QString &, const QString &)), this, SLOT(mailToClicked(const QString &, const QString &)));

	inputWindow = new QMultiLineEdit( spliter , "InputWindow");
	inputWindow->setWordWrap(QMultiLineEdit::WidgetWidth);
	connect(inputWindow, SIGNAL(undoAvailable(bool)), this, SLOT(slotEditTurnOnOffUndo(bool)));
	connect(inputWindow, SIGNAL(redoAvailable(bool)), this, SLOT(slotEditTurnOnOffRedo(bool)));
	connect(inputWindow, SIGNAL(textChanged()), this, SLOT(inputTextChanged()));
	connect(inputWindow, SIGNAL(copyAvailable(bool)), this, SLOT( copyChanged(bool)));
	postNumber = 0;
	flashWindow = false;
	spliter->setResizeMode(inputWindow, QSplitter::KeepSize);
	spliter->setResizeMode(chatWindow, QSplitter::Stretch);

	connect(inputWindow, SIGNAL(returnPressed()), this, SLOT(enterKeyPressed()));
	QValueList<int> list;
	list = spliter->sizes();
	list[1] = 40;
	spliter->setSizes(list);

	this->setCentralWidget( spliter );
	inputWindow->setFocus();
}

/******************************************************************************
 * The multiline edit send out a signal stating if it is able to copy, save
 * that data here.
 ******************************************************************************/
void Chat::copyChanged(bool copy){
 canCopy = copy;
}

/******************************************************************************
 * Open this url in a web browser.  Use the global browser interface.
 ******************************************************************************/
void Chat::urlClicked(const QString &url){
	browser->openURL(url);
}


/******************************************************************************
 * Open this url in the system mail editor.
 ******************************************************************************/
void Chat::mailToClicked(const QString &name, const QString &address){
	kapp->invokeMailer( address, QString::null );
}

void Chat::applytoChatWindow(){
  // apply colors
  QPalette tempPalette = inputWindow->palette();
  //tempPalette.setColor(QColorGroup::Text, colorSettings_chat_yourText_color);
  tempPalette.setColor(QColorGroup::Base, colorSettings_chat_yourbg_color);
  chatWindow->setPalette(tempPalette);

}

/******************************************************************************
 * apply settings to inputWindow widget
 ******************************************************************************/
void Chat::applytoInputWindow(){
	QFont tempFont = fontSettings->chat_yourFont;

	QStyleSheet* tempStyle;

	// set to adjust font pointSize by equiv html size from up/down arrows in chat
	if (fontSize != 3) {
		if (this->chatWindow) {
			tempStyle = chatWindow->styleSheet();
			tempFont.setPointSize(12);
			tempStyle->scaleFont(tempFont,fontSize);
		}
	} else {
			tempFont.setPointSize(12);
	}

	inputWindow->setFont(tempFont);

        // apply colors
	QPalette tempPalette = inputWindow->palette();
	tempPalette.setColor(QColorGroup::Text, colorSettings_chat_yourText_color);
	tempPalette.setColor(QColorGroup::Base, colorSettings_chat_yourbg_color);
        inputWindow->setPalette(tempPalette);
}

/******************************************************************************
 * The buddy signed off and so somthing should be written.
 ******************************************************************************/
void Chat::buddySignedOff(){
	QString CurrentTime = QTime::currentTime().toString();
	QString message = QString("<B>") + buddyName + " Signed off at: " + CurrentTime + "</B>\n";
	if (postNumber == 0)
		chatWindow->setText(message);
	else
		chatWindow->append(message);
	postNumber++;

	conversationBuffer += message;
	conversationTimeBuffer += message;

	chatWindow->ensureVisible(0, chatWindow->contentsHeight());
	// This should not be a hard coded value like this!!!
	chatWindow->repaintContents(0,0, 10000, 20000, true);

	// Add to the logs.
	if (chatSettings_chat_log == true){
		if (chatSettings->chat_log_inHtml == true){
			logStream << QString("<B>") + buddyName + " Signed off at: " + CurrentTime + "</B><br/>\n";
;
		}
		else{
			logStream << buddyName + " Signed off at: " + CurrentTime + "\n";
		}
	}
}

/******************************************************************************
 * The buddy signed on and so somthing should be written.
 ******************************************************************************/
void Chat::buddySignedOn(){
	QString CurrentTime = QTime::currentTime().toString();
	QString message = QString("<B>") + buddyName + " Signed on at: " + CurrentTime + "</B>\n";
	if (postNumber == 0)
		chatWindow->setText(message);
	else
		chatWindow->append(message);
	postNumber++;

	conversationBuffer += message;
	conversationTimeBuffer += message;

	chatWindow->ensureVisible(0, chatWindow->contentsHeight());
	// This should not be a hard coded value like this!!!
	chatWindow->repaintContents(0,0, 10000, 20000, true);
	// Add to the logs.
	if (chatSettings_chat_log == true){
		if (chatSettings->chat_log_inHtml == true){
			logStream << QString("<B>") + buddyName + " Signed off at: " + CurrentTime + "</B><br/>\n";
;
		}
		else{
			logStream << buddyName + " Signed off at: " + CurrentTime + "\n";
		}
	}
}

/******************************************************************************
 * From another part of the system a message is being sent from you.
 ******************************************************************************/
void Chat::pounceMessage(QString message){
	inputWindow->setText(message);
	slotBuddySendMessage();
}

/******************************************************************************
 * When you send an Away message to someone put it on the chat window also.
 ******************************************************************************/
void Chat::awayMessage(QString message){
	message = QString("<B>") + "Auto Reply:</B> " + message +"\n";
	if (postNumber == 0)
		chatWindow->setText(message);
	else
		chatWindow->append(message);
	postNumber++;

	conversationBuffer += message;
	conversationTimeBuffer += message;

	chatWindow->ensureVisible(0, chatWindow->contentsHeight());
	// This should not be a hard coded value like this!!!
	chatWindow->repaintContents(0,0, 10000, 20000, true);
	// Add to the logs.
	if (chatSettings_chat_log == true){
		if (chatSettings->chat_log_inHtml == true){
			logStream << QString("<B>") + "Auto Reply:</B> " + message + "<br/>\n";
		}
		else{
			logStream << buddyName + "Auto Reply: " + message + "\n";
		}
	}
}

/******************************************************************************
 * Sets the log variable
 ******************************************************************************/
void Chat::slotChatLog(){
	if (chatSettings_chat_log == false){
		chatSettings_chat_log = true;
		fileMenu->setItemChecked(ID_FILE_LOG, true);
		if (toolBarSettings_chat_log == true && chatLogButton != 0){
                        fileToolbar->setButton(ID_LOG_BUTTON, true);
		}
		openLogFile();
	}
	else{
		chatSettings_chat_log = false;
		fileMenu->setItemChecked(ID_FILE_LOG, false);
		if (toolBarSettings_chat_log == true && chatLogButton != 0){
                        fileToolbar->setButton(ID_LOG_BUTTON, false);
		}
		// Delete log file
		//qDebug("logFile.close() %s\n", logFile.name().latin1());
		logFile.close();
		if (logFile.remove() == false)
			QMessageBox::critical(0, APP_NAME, QString("Can not delete logfile "), "OK");
	}
}

/******************************************************************************
 * Clear the chat window
 ******************************************************************************/
void Chat::slotChatClear(){
	cleared = true;
	chatWindow->setText( "", chatWindow->context());
	postNumber = 0;
	// Clear conversation
	if (chatSettings->chat_log_inHtml == true){
		conversationBuffer = "<HTML>\n<HEAD>\n<TITLE>Conversations with ";
		conversationBuffer += buddyName;
		conversationBuffer += "</TITLE>\n</HEAD>\n<BODY BGCOLOR=\"#FFFFFF\">\n";
		// Clear other conversation buffer
		conversationTimeBuffer = "<HTML>\n<HEAD>\n<TITLE>Conversations with ";
		conversationTimeBuffer += buddyName;
		conversationTimeBuffer += "</TITLE>\n</HEAD>\n<BODY BGCOLOR=\"#FFFFFF\">\n";
	}
	else{
		conversationBuffer = "Conversations with " + buddyName + "\n";
		// Clear other conversation buffer
		conversationTimeBuffer = "Conversations with " + buddyName + "\n";
	}
}

/******************************************************************************
 * Save the chat in a file.
 ******************************************************************************/
void Chat::slotChatSaveAs(){
	QString fn = KFileDialog::getSaveFileName(0, 0, this);
	if (!fn.isEmpty()){
		// open file for appending, to add the new message
		QFile SaveFile(fn);
		if (SaveFile.open( IO_WriteOnly ) == false)
			QMessageBox::critical(0, APP_NAME, QString("Unable to open ") + fn + " for appending.", "OK");
		else{
			// All text
			QTextStream fileStream(&SaveFile);
			if (cleared == false){
				if (chatSettings->chat_log_inHtml == true){
					fileStream << "<HTML>\n<HEAD>\n<TITLE>Conversations with ";
					fileStream << buddyName;
					fileStream << "</TITLE>\n</HEAD>\n<BODY BGCOLOR=\"#FFFFFF\">\n";
				}
				else{
					fileStream << "Conversations with " << buddyName << "\n";
				}
			}
			if (( chatSettings_chat_log_time == true) || (
											chatSettings_chat_log == true))
				if (chatSettings->chat_log_inHtml == false)
 	  fileStream << (parseAndProcessALL(conversationTimeBuffer));
	else
	  fileStream << conversationTimeBuffer;
			else
				fileStream << conversationBuffer;

			if (chatSettings->chat_log_inHtml == true){
				fileStream << "</BODY>\n</HTML>";
			}
			SaveFile.close();
			QMessageBox::information(0, APP_NAME, QString("Chat so far is saved in\n") + fn , "OK");
		}
	}
	else{
		// Cancel was hit, do nothing.
	}
}

/******************************************************************************
 * Print out the chat
 ******************************************************************************/
void Chat::slotChatPrint(){
	QPrinter printer;
	printer.setFullPage(true);
	if ( printer.setup() ) {
		QPainter p( &printer );
		QPaintDeviceMetrics metrics(p.device());
		int dpix = metrics.logicalDpiX();
		int dpiy = metrics.logicalDpiY();
		const int margin = 72; // pt
		QRect body(margin*dpix/72, margin*dpiy/72, metrics.width()-margin*dpix/72*2,
			metrics.height()-margin*dpiy/72*2 );
		QFont font("times", 10);
		QSimpleRichText richText( conversationBuffer, font, chatWindow->context(), chatWindow->styleSheet(),
			chatWindow->mimeSourceFactory(), body.height() );
		richText.setWidth( &p, body.width() );
		QRect view( body );
		int page = 1;
		do {
			// Draw the first page
			richText.draw( &p,body.left(), body.top(), view, colorGroup() );
			view.moveBy( 0, body.height() );
			p.translate( 0 , -body.height() );
			// Draw page number
			p.setFont( font );
			p.drawText( view.right() - p.fontMetrics().width( QString::number(page) ),
				view.bottom() + p.fontMetrics().ascent() + 5, QString::number(page) );
			// Check if it is time to stop printing
			if ( view.top()  >= richText.height() ) break;
			// Guess it isn't so start a new page
			printer.newPage();
			// Set the new page number
			page++;
		} while (true);
	}
}

/******************************************************************************
 * Turn Sound on and off
 ******************************************************************************/
void Chat::slotChatSound(){
	if (soundSettings_chat_sound == false){
		soundSettings_chat_sound = true;
		fileMenu->setItemChecked(ID_FILE_SOUND, true);
		if (toolBarSettings->chat_sound == true && chatSoundMuteButton != 0){
			fileToolbar->setButton(ID_SOUND_MUTE_BUTTON, true );
//			chatSoundMuteButton->setTextLabel ("Sound Enabled", true);
		}
		if (soundSettings_chat_sound_beepReceive == false &&
				soundSettings_chat_sound_beepSend == false){
			soundSettings_chat_sound_beepReceive = true;
			soundSettings_chat_sound_beepSend = true;
		}
	}
	else{
		soundSettings_chat_sound = false;
		fileMenu->setItemChecked(ID_FILE_SOUND, false);
		if (toolBarSettings->chat_sound == true && chatSoundMuteButton != 0){
			fileToolbar->setButton(ID_SOUND_MUTE_BUTTON, false );
//			chatSoundMuteButton->setTextLabel ("Sound Muted", true);
		}
	}
}

/******************************************************************************
 * Close out of the Chat
 ******************************************************************************/
void Chat::closeEvent(QCloseEvent *) {
	// Close window
	emit quiting(buddyName, room);
}

/******************************************************************************
 * Close out of the Chat
 ******************************************************************************/
void Chat::slotChatClose(){
	QApplication::sendEvent(this, new QCloseEvent());
}

/******************************************************************************
 * Cut highlighted
 ******************************************************************************/
void Chat::slotEditCut(){
	if (inputWindow->hasFocus())
		inputWindow->cut();
}

/******************************************************************************
 * Copy highlighted to clipboard
 ******************************************************************************/
void Chat::slotEditCopy(){
	if (inputWindow->hasFocus())
		inputWindow->copy();
	else
		chatWindow->copy();
}

/******************************************************************************
 * Paste the clipboard to edit box
 ******************************************************************************/
void Chat::slotEditPaste(){
	if (inputWindow->hasFocus())
		inputWindow->paste();
}

/******************************************************************************
 * Select All
 ******************************************************************************/
void Chat::slotEditSelectAll(){
	if (inputWindow->hasFocus())
		inputWindow->selectAll();
	else
		chatWindow->selectAll();
}

/******************************************************************************
 *  Enable/disable undo
 ******************************************************************************/
void Chat::slotEditTurnOnOffUndo(bool change){
	if (change == false)
		editMenu->setItemEnabled ( ID_EDIT_UNDO, false );
	else
		editMenu->setItemEnabled ( ID_EDIT_UNDO, true );
}

/******************************************************************************
 * Enable/disable redo
 ******************************************************************************/
void Chat::slotEditTurnOnOffRedo(bool change){
	if (change == false)
		editMenu->setItemEnabled ( ID_EDIT_REDO, false );
	else
		editMenu->setItemEnabled ( ID_EDIT_REDO, true );
}

/******************************************************************************
 * Edit Undo
 ******************************************************************************/
void Chat::slotEditUndo(){
	if (inputWindow->hasFocus())
		inputWindow->undo();
}

/******************************************************************************
 * Edit Redo
 ******************************************************************************/
void Chat::slotEditRedo(){
	if (inputWindow->hasFocus())
		inputWindow->redo();
}


/******************************************************************************
 * Toggle the Chat Toolbar
 ******************************************************************************/
void Chat::slotViewChatToolBar(){
	// turn Toolbar on or off
	if (fileToolbar->isVisible())
	{
		fileToolbar->hide();
		viewMenu->setItemChecked(ID_VIEW_CHATTOOLBAR, false);
	}
	else
	{
		fileToolbar->show();
		viewMenu->setItemChecked(ID_VIEW_CHATTOOLBAR, true);
	};
}

/******************************************************************************
 * Toggle the Text Toolbar
 ******************************************************************************/
void Chat::slotViewTextToolBar(){
	// turn Toolbar on or off
	if (textToolbar->isVisible())
	{
		textToolbar->hide();
		viewMenu->setItemChecked(ID_VIEW_TEXTTOOLBAR, false);
	}
	else
	{
		textToolbar->show();
		viewMenu->setItemChecked(ID_VIEW_TEXTTOOLBAR, true);
	};
}


/******************************************************************************
 * Toggle the TimeStamp Variable
 ******************************************************************************/
void Chat::slotViewTimeStamp(){
	if (chatSettings_chat_show_time == false){
		chatSettings_chat_show_time = true;
		viewMenu->setItemChecked(ID_VIEW_TIME, true);
		if ( toolBarSettings->chat_time == true && chatTimeButton != 0)
                        fileToolbar->setButton(ID_VIEW_TIME_BUTTON, true);
//			chatTimeButton->setDown ( true );
		chatSettings_chat_log_time = true;
		chatWindow->setText(conversationTimeBuffer);
		if (chatSettings_chat_log == true){
			// Turn off
			slotChatLog();
			// And back on, but with time (in case)
			slotChatLog();
		}
	}
	else{
		chatSettings_chat_show_time = false;
		viewMenu->setItemChecked(ID_VIEW_TIME, false);
		if ( toolBarSettings->chat_time == true && chatTimeButton != 0)
                        fileToolbar->setButton(ID_VIEW_TIME_BUTTON, false);
//			chatTimeButton->setDown ( false );
		chatSettings_chat_log_time = true;
		chatWindow->setText(conversationBuffer);
	}
	// scroll to the new text
	chatWindow->ensureVisible(0, chatWindow->contentsHeight());
}

/******************************************************************************
 * Insert one of those "emotions" into the window.  Boy do I hate these.
 * When done update the currentMessageOut sense no signal is emmited
 ******************************************************************************/
void Chat::slotInsertFace(int face){
#define doface(x, y) \
	if (face == x){ \
		inputWindow->insert(y); \
		currentMessageOut = inputWindow->text(); \
		return; \
	}

	doface(FACE_SMILE_ID, FACE_SMILE_TEXT);
	doface(FACE_SAD_ID, FACE_SAD_TEXT);
	doface(FACE_WINK_ID, FACE_WINK_TEXT);
	doface(FACE_TONGUE_ID, FACE_TONGUE_TEXT);
	doface(FACE_SCREAM_ID, FACE_SCREAM_TEXT);
	doface(FACE_KISS_ID, FACE_KISS_TEXT);
	doface(FACE_YELL_ID, FACE_YELL_TEXT);
	doface(FACE_GLASSES_ID, FACE_GLASSES_TEXT);
	doface(FACE_ONEEYE_ID, FACE_ONEEYE_TEXT);
	doface(FACE_MONEYMOUTH_ID, FACE_MONEYMOUTH_TEXT);
	doface(FACE_BURP_ID, FACE_BURP_TEXT);
	doface(FACE_EMBARRASSED_ID, FACE_EMBARRASSED_TEXT);
	doface(FACE_ANGEL_ID, FACE_ANGEL_TEXT);
	doface(FACE_THINK_ID, FACE_THINK_TEXT);
	doface(FACE_CRY_ID, FACE_CRY_TEXT);
	doface(FACE_CROSSEDLIPS_ID, FACE_CROSSEDLIPS_TEXT);
	doface(FACE_BIGSMILE_ID, FACE_BIGSMILE_TEXT);
	doface(FACE_LUKE_ID, FACE_LUKE_TEXT);

#undef doface
}

/******************************************************************************
 * Inserts a set of tags into the input window.
 ******************************************************************************/
void Chat::slotInsertTags(QString open, QString close){
	QString oldtext = "";
	if (canCopy){
		// Cut any selected text to clipboard
		inputWindow->cut();
		// Copy text from the clipboard (paste)
		oldtext = QApplication::clipboard()->text();
	}
	// Add tags
	oldtext = open  + oldtext + close;
	// paste new text into input window
	inputWindow->insert(oldtext);
	int a,b;
	inputWindow->getCursorPosition(&a,&b);
	inputWindow->setCursorPosition(a,b-close.length(),false);
	currentMessageOut = inputWindow->text();
}

/******************************************************************************
 * Insert bold tags in the input window
 ******************************************************************************/
void Chat::slotInsertBold(){
	slotInsertTags( "<b>" , "</b>" );
}

/******************************************************************************
 * Insert italic tags in the input window
 ******************************************************************************/
void Chat::slotInsertItalic(){
	slotInsertTags( "<i>" , "</i>" );
}

/******************************************************************************
 * Insert underline tags in the input window
 ******************************************************************************/
void Chat::slotInsertUnderline(){
	slotInsertTags( "<u>" , "</u>" );
}

/******************************************************************************
 * Insert small tags in the input window
 ******************************************************************************/
void Chat::slotInsertShrinkFont(){
	if (fontSize > 0)
		fontSize--;
        applytoInputWindow();
}

/******************************************************************************
 * Set the Font back to normal
 ******************************************************************************/
void Chat::slotInsertNormalFont(){
	fontSize = normalFontSize;
        applytoInputWindow();
}

/******************************************************************************
 * insert font tags
 ******************************************************************************/
void Chat::slotInsertIncreaseFont(){
	if (fontSize < 7)
		fontSize++;
        applytoInputWindow();
}

/******************************************************************************
 *  Get the background color you want.
 ******************************************************************************/
void Chat::slotInsertBackGroundColor(){
	KColorDialog::getColor ( colorSettings_chat_yourbg_color, this );
        applytoInputWindow();
        applytoChatWindow();
}

/******************************************************************************
 * Brings up the color dialog and get the pen color.
 ******************************************************************************/
void Chat::slotInsertPenColor(){
	KColorDialog::getColor ( colorSettings_chat_yourText_color, this );
        applytoInputWindow();
        applytoChatWindow();
}

/******************************************************************************
 * Inserts the link tags into the input window
 ******************************************************************************/
void Chat::slotInsertLink(){
	//KinkattaLinkDialog *linkDlg = new	KinkattaLinkDialog(this, "link dialog", TRUE);
	KinkattaLinkDialog linkDlg(this, "link dialog", true);

	linkDlg.setURLText( QApplication::clipboard()->text() );
	linkDlg.setDescText( QApplication::clipboard()->text() );

	QString tag = linkDlg.go();

	if(!tag.isEmpty()){
		inputWindow->cut();
		inputWindow->insert(tag);
		currentMessageOut = inputWindow->text();
	}
}

/***************************************************************************
 * Puts the last message sent into the input box.
 ***************************************************************************/
void Chat::slotInsertLastMessage(){
	if (inputWindow->text() == QString(""))
		inputWindow->setText(lastMessage);
	else
		inputWindow->append(lastMessage);
}

#include <iostream.h>
#include <string.h>
/******************************************************************************
 * Send the message in the input window
 ******************************************************************************/
void Chat::slotBuddySendMessage(){
	//currentMessageOut = "";
	QString fontsizeTag = "";
	QString fontfaceTag = "";
	QString fontcolorTag = "";

	// Example Output HTML
	//<HTML><BODY BGCOLOR="#FFFF00"><FONT COLOR="#FF00FF">Room for one more?</FONT></BODY></HTML>
	//inputWindow->setCursorPosition(0, 0, true);
	bool send = true;
	// A blank QMultilineedit has 2 chars in it at start \n\n??
	//printf("Input length: %i\n", inputWindow->length());
	if ((inputWindow->length() == 0) && (chatSettings->chat_send_blank == false)){
		send = false;
		QString message = inputWindow->text();
		if(message == "\n")
			inputWindow->setText( "" );
	}
	if (send == true){
		QString nameRGB;
		nameRGB= colorSettings->chat_yourName_color.name();
		QString myRGB = "";
		if( colorSettings_chat_yourText_color != Qt::black )
	    myRGB= colorSettings_chat_yourText_color.name();
		QString bgRGB = "";
		if(colorSettings_chat_yourbg_color != Qt::white )
	    bgRGB = colorSettings_chat_yourbg_color.name();

		// Send the input window data
		QString message = inputWindow->text();
		inputWindow->setText( "" );
		// Save this message in case people want to use it.
		QString lastLetter = message.mid(message.length()-1,1);
		if (lastLetter == "\n"){
			message = message.mid(0, message.length()-1);
			lastMessage = message;
		}
		lastLetter = message.mid(message.length()-1,1);
		if (lastLetter == "\n"){
			message = message.mid(0, message.length()-1);
			lastMessage = message;
		}

		QRegExp url;
		QString link;
		int len = 0, start = 0, end = 0, endanchor = 0;
		int starthttp = 0, startwww = 0, startanchor = 0, skipto = 0;
		int lenhttp = 0, lenwww = 0;
		bool http;
		url.setCaseSensitive(FALSE);

		//qDebug("message %s\n", message.latin1());
		while(start != -1){
			//first we search for any already-inserted anchors, that would be here
			//from "Insert->Link" so as not to process them and leave them alone.
			url.setPattern("<a href");
			startanchor = url.match(message, end);
			if(startanchor != -1){
				url.setPattern("</a>");
				endanchor = url.match(message, startanchor, &len);
				skipto = endanchor + len;
				//qDebug("skipto %d end %d\n", skipto, end);
			}

			url.setPattern( "http://[a-zA-Z0-9][^ ^\n^\r^\t]*" );
			starthttp = url.match(message, end, &lenhttp);
			url.setPattern( "www\\.[a-zA-Z0-9][^ ^\n^\r^\t]*" );
			startwww = url.match(message, end, &lenwww);

			//qDebug("startanchor %d startwww %d starthttp %d\n", startanchor, startwww, starthttp);
			//qDebug("lenwww %d lenhttp %d\n", lenwww, lenhttp);

			if( (startanchor != -1)
				&& (startanchor < (starthttp > -1 ? starthttp : startanchor+1) )
				&& (startanchor < (startwww > -1 ? startwww : startanchor+1) ) ){
				end = skipto;
				//qDebug("SKIP skipto: %d\n", skipto);
				goto SKIP;
			}

			if( (starthttp == -1) && (startwww == -1) ) //neither found
				break;
			else if(starthttp == -1){ //http not found
				start = startwww;
				end = startwww + lenwww;
				http = FALSE;
			}else if(startwww == -1){ //www not found
				start = starthttp;
				end = starthttp + lenhttp;
				http = TRUE;
			} else { //both found. use the first one!
				start = (starthttp < startwww) ? starthttp : startwww;
				end = (starthttp < startwww) ? starthttp + lenhttp : startwww + lenwww;
				http = (starthttp < startwww) ? TRUE : FALSE;
			}

			//url.setPattern( QString("[ \n\r\t]") );  //e.g, any whitespace
			//end = url.match(message, start+len, 0, TRUE);

			//this happens when the damn end of the url is at the end of message
			if(end == -1)
				end = message.length();

			//insert this first, makes it easier.
			message.insert(end, "</a>");

			if(http)
				link = "<a href=\"" + message.mid(start, end-start) + "\">";
			else //need the leading "http://"
				link = "<a href=\"http://" + message.mid(start, end-start) + "\">";

			message.insert(start, link );
			end += link.length() + 4; // </a> == 4

			SKIP:
			 ; //pacifying g++

		}

		//qDebug("Sending This Message: %s\n", message.latin1());

		// wrap bold around if bold font selected...
		if ( fontSettings->chat_yourFont.weight() == QFont::Bold )
			message = QString("<b>") + message + "</b>";

		// wrap italics around if italic font selected...
		if ( fontSettings->chat_yourFont.italic() )
			message = QString("<i>") + message + "</i>";

		// render message to be sent with HTML in the chatwindow (TextBrowser widget)
		updateHTML(message, myName, nameRGB);

		// get the font tag...
		QString fontTag;
		fontTag = fontTagHTML(fontSettings->chat_yourFont.family(), myRGB, fontSize);

		// wrap it around the message...
		if(!fontTag.isEmpty()){
			fontTag = "<FONT" + fontTag + ">";
		 	message = fontTag + message + "</FONT>";
		}

		// add background color tag
		if(!bgRGB.isEmpty())
			message = QString("<BODY BGCOLOR=\"") + bgRGB + "\">" + message + "</BODY>";
		else
			message = QString("<BODY>") + message + "</BODY>";

		// fix for smily rendering in winAim
		message = fontFixSmilies(message, fontTag);

		//printf("%s\n",message.latin1());

		message = QString("<HTML>") + message + "</HTML>";
		emit( messageOut( message, buddyName, room ) );
		// emit beep in wanted.
		if (( soundSettings_chat_sound == true ) &&
			( soundSettings_chat_sound_beepSend == true) &&
			( soundSettings->chat_sound_playFile == false)){
			sound->beep();
		}
		else{
			if (( soundSettings_chat_sound == true ) &&
			( soundSettings_chat_sound_beepSend == true) &&
			( soundSettings->chat_sound_playFile == true)){
				sound->playFile(soundSettings->chat_sound_fileSend);
			}

		}
	}
}

/***************************************************************************
 * Occurs when the message comes in
 ***************************************************************************/
void Chat::messageIn(QString message){
	if(message.length() == 0 || message == "" )
		message = "  ";
	QString buddyRGB;
	buddyRGB = colorSettings->chat_buddyName_color.name();

	if (chatSettings->chat_raise_window == true){
		this->show();
		this->raise();
	}

	// render the incoming message in the chatwindow
	if (chatSettings->chat_ignore_buddyhtml == true)
		updateHTML(parseAndProcessALL(message), buddyName, buddyRGB);
	else
		updateHTML(message, buddyName, buddyRGB);

	// flash icon on panel bar
	if (chatSettings->chat_flash_on_new_message == true){
		if (flashWindow == false){
			flashWindow = true;
			flashIcon();
		}
		// Set off timer that will change icon until got focus
		// new function needed.
	}

	// make a sound
	if (( soundSettings_chat_sound == true ) &&
			( soundSettings_chat_sound_beepReceive == true) &&
			( soundSettings->chat_sound_playFile == false)){
		sound->beep();
	}
	if (( soundSettings_chat_sound == true ) &&
			( soundSettings_chat_sound_beepReceive == true) &&
			( soundSettings->chat_sound_playFile == true)){
			sound->playFile(soundSettings->chat_sound_fileReceive);
	}
}

/***************************************************************************
 * Helper Function
 ***************************************************************************/
inline bool tagIsOpen(const QString &html, const QString &tag){
	return html.contains("<" + tag + ">", false) > html.contains("</" + tag + ">", false);
}

/***************************************************************************
 * update (render) the HTML in chatwindow widget
 ***************************************************************************/
void Chat::updateHTML(QString message, QString sender, QString HTMLColor){
	message = stripTags(message);

	// Add img tags for smilies
	if( chatSettings->chat_show_smilies )
		message = updateHTMLSmilyPic(message);

	// render at least a space
	if (message.length() == 1 || message.length() == 0 || message == "")
		message += " ";

	//printf("message:%s\n", message.latin1());

	// Get Timestamp info
	QString CurrentTime = QTime::currentTime().toString();


	// Get the font tag...
	QString fontTag;
	if (sender == myName)
	  fontTag = fontTagHTML(fontSettings->chat_yourFont.family(),
	     colorSettings_chat_yourText_color.name(), fontSize);
	else
	  fontTag = fontTagHTML(fontSettings->chat_buddyFont.family(),
	    colorSettings_chat_buddyText_color.name(), 3);

	// Wrap it around the message...
	if(!fontTag.isEmpty()){
	   fontTag = "<FONT" + fontTag + ">";
	  message = fontTag + message + "</FONT>";
	}


  int found = -1;
  bool done = false;
  while ( done == false )
  {
    found = message.find("/me", found+1);
    if (found != -1)
    {
      QString before = message.left(found);
      int left = before.contains("<");
      int right = before.contains(">");
      if ( left == right )
      {
        if ( QString(message.at(found-1)) != QString(">")  && left > 0 )
          found = -1;
        done = true;
      }
    }
    else
      done = true;
  }

  if ( found != -1 ){
    sender = QString( "***" ) + sender;
    message = message.mid( 0, found) + message.mid( found+ 4, message.length()-4-found);
  }

        /***** Get the name and : ****/
	QString TimeMessage = QString("<B><font color=\"") +
	  HTMLColor + QString("\">") + CurrentTime + " " + sender + ": </font></B>"  + message;

	QString Message = QString("<B><font color=\"") +
	  HTMLColor + QString("\">") + " " + sender + ": </font></B>"  + message;

	QString bgRGB = "#ffffff";
	if (sender == myName)
		bgRGB = colorSettings_chat_yourbg_color.name();
	else
		bgRGB = colorSettings_chat_buddybg_color.name();

	// Add to the logs.
	if (chatSettings_chat_log == true){
		if (chatSettings->chat_log_inHtml == true){
			if (chatSettings_chat_log_time == true)
				logStream << TimeMessage << "<br>\n";
			else
				logStream << Message << "<br>\n";
		}
		else{
			// Write correct buffer
			if ( chatSettings_chat_log_time == true)
				logStream << parseAndProcessALL(TimeMessage) << "\n";
			else
				logStream << parseAndProcessALL(Message) << "\n";
		}
		logFile.flush();
	}


	Message.replace( QRegExp("\n"), "<br/>" );
	TimeMessage.replace( QRegExp("\n"), "<br/>" );

	// now add the message to the buffer
	conversationBuffer += Message;
	conversationTimeBuffer += TimeMessage;
	if (chatSettings->chat_log_inHtml == true){
		conversationBuffer += "<br/>\n";
		conversationTimeBuffer += "<br/>\n";
	}
	//printf("bgRGB = %s\n",bgRGB.latin1());

	// Always add a background so there will be a return.
	//if (bgRGB != "#ffffff"){
		Message = QString("<table bgcolor=" + bgRGB + " border=0 cellpadding=0 cellspacing=0><tr><td>") + Message + "</td></tr></table><br/>";
		TimeMessage = QString("<table bgcolor=" + bgRGB + " border=0 cellpadding=0 cellspacing=0><tr><td>") + TimeMessage + "</td></tr></table><br/>";
	//}

	if(chatSettings_chat_show_time == true){
		if (postNumber == 0)
			chatWindow->setText(TimeMessage);
		else
			chatWindow->append(TimeMessage);
	}
	else{
		// NO TIME
		if (postNumber == 0)
			chatWindow->setText(Message);
		else
			chatWindow->append(Message);
	}

	// Incriment the post numbers
	postNumber++;
	if (postNumber == 1){
		if (( soundSettings_chat_sound == true ) &&
			(soundSettings->chat_sound_beepInitial == true) &&
			soundSettings->chat_sound_playFile == false){
			sound->beep();
		}
		else{
			if ((soundSettings_chat_sound == true ) &&
			(soundSettings->chat_sound_beepInitial == true) &&
			(soundSettings->chat_sound_playFile == true)){
				sound->playFile(soundSettings->chat_sound_fileInitial);
			}
		}
	}

	// scroll to the new text
	chatWindow->ensureVisible(0, chatWindow->contentsHeight());
	// This should not be a hard coded value like this!!!
	chatWindow->repaintContents(0,0, 10000, 29000, true);

	// if conversationLength is getting too long, cut the top out
	if (chatSettings->chat_line_limit == true)
		if(postNumber > chatSettings->chat_line_limit_number){
			int spos = conversationBuffer.find("<B>");
			conversationBuffer.remove(spos, 4);
			spos = conversationBuffer.find("<B>");
			conversationBuffer.remove(0, spos);
			postNumber--;
			chatWindow->setText( conversationBuffer, chatWindow->context());
		}

	// reset buddy colors
	colorSettings_chat_buddyText_color = temp_BuddyTextColor;
	colorSettings_chat_buddybg_color = temp_BuddyBgColor;

}

/***************************************************************************
 * convert smilies to images and add img tag
 ***************************************************************************/
QString Chat::updateHTMLSmilyPic(QString message){

#define FACE(x) \
	QString("<img width=\"19\" height=\"19\" src=\"" + QString(DATADIR) + "/pics/face_" + QString(x) + ".png\">")

	/* This first if is to check if a smiley is contained in the message.  It
	 * allows us to skip the big mess of message.replace's if there are no
	 * smilies, resulting in (a little) faster performance.  All the smilies
	 * contain either a '-' (nose) or a ':' (eyes) or a ')' (mouth)
	*/
	if((message.contains('-') != 0) ||    //find a nose
		(message.contains(')') != 0) ||     //or a mouth
		(message.contains(':') != 0)) {     //or some eyes.

		// tokenize odd combos that might be mistaken for smilies
		// see untokenize below
		message.replace(QRegExp("&gt;)"), "&gt;%29"); // when user types >)

		message.replace(QRegExp("=-[Oo]"), FACE("scream") );
		message.replace(QRegExp("&gt;:[Oo]"), FACE("yell") );
		message.replace(QRegExp("[Oo]:-)"), FACE("angel") );
		message.replace(QRegExp("C:-)"), FACE("luke") );

		message.replace(QRegExp(":-?)"), FACE("smile") ); // :-) :)

		message.replace(QRegExp(":-?("), FACE("sad") ); // :-( :(
		message.replace(QRegExp(";-?)"), FACE("wink") ); // ;-) ;)
		message.replace(QRegExp(":-?P"), FACE("tongue") ); // :-P :P

		message.replace(QRegExp(":-\\*"), FACE("kiss") );
		message.replace(QRegExp("8-)"), FACE("glasses") );

		message.replace(QRegExp("[Oo]-)"), FACE("oneeye") );

		message.replace(QRegExp(":-\\$"), FACE("moneymouth") );
		message.replace(QRegExp(":-!"), FACE("burp") );
		message.replace(QRegExp(":-\\["), FACE("embarrassed") );

		message.replace(QRegExp(":-\\"), FACE("think") );
		message.replace(QRegExp(":-/"), FACE("think") );
		message.replace(QRegExp(":'("), FACE("cry") );
		message.replace(QRegExp(":-X"), FACE("crossedlips") );
		message.replace(QRegExp(":-?D"), FACE("bigsmile") ); // :-D :D

		// UNtokenize odd combos that might be mistaken for smilies
		message.replace(QRegExp("&gt;%29"), "&gt;)"); // when user types >)
	}
	return message;
#undef FACE
}

/***************************************************************************
 * Parses the message
 ***************************************************************************/
#define SKIP_TO_GT {while(newstr[++i] != '>' && i < newstr.length());}

#define KILL_LT { newstr.replace(i, 1, "&lt;"); i += 3; }

#define SKIP_TO_GT_CHECK_QUOTE {int quotecount = 0;\
					while(newstr[++i] != '>' && i < newstr.length()){\
						if(newstr[i] == '"') quotecount++;}\
					if(quotecount % 2 == 1){\
						newstr.replace(i, 1, "\">");\
						i++;}}

QString Chat::parseAndProcessALL(QString &newstr){
	QString returnVal = "";
	unsigned int beg = 0;
	int openTag = 1;
	while (openTag == 1)
	for(unsigned i = 0; i <= newstr.length(); i++){
		if (i == 0)
			openTag = 0;
		if(newstr[i] == '<'){
			beg = i;
			SKIP_TO_GT
			unsigned int dif = i-beg;
			newstr.remove(beg,dif+1);
			openTag = 1;
			returnVal = "";
			i = newstr.length();
		}
		else returnVal += newstr[i];
	}
	return returnVal;
}

/***************************************************************************
 * Parses the message
 ***************************************************************************/
void Chat::parseAndProcess(QString &newstr){
	//make this more modular to allow for easier additions in the future.
	newstr = parseForHTML(newstr);
	//TODO: IF selected in options dialog
	//newstr = parseForSpelling(newstr);
	//newstr = parseForAutoReplace(newstr);
}

QString Chat::parseForHTML(QString &newstr){
	bool bodyUsed = false;
	bool divUsed = false;
	bool pUsed = false;

	for(unsigned i = 0; i < newstr.length(); i++)
	{
		if(newstr[i] == '>')
		{
			newstr.replace(i, 1, "&gt;");
			i += 3;
		}

		else if(newstr[i] == '<')
		{
			if(newstr.mid(i, 3).upper() == "<A ") SKIP_TO_GT_CHECK_QUOTE
			else if(newstr.mid(i, 3).upper() == "<B>") i += 2;
			else if(newstr.mid(i, 5).upper() == "<BIG>") i += 4;
			else if(newstr.mid(i, 4).upper() == "<BR>") i += 3;
			else if(newstr.mid(i, 6).upper() == "<CODE>") i += 5;
			else if(newstr.mid(i, 4).upper() == "<EM>") i += 3;
			else if(newstr.mid(i, 5).upper() == "<FONT") SKIP_TO_GT_CHECK_QUOTE
			else if(newstr.mid(i, 3).upper() == "<I>") i += 2;
			else if(newstr.mid(i, 7).upper() == "<SMALL>") i += 6;
			else if(newstr.mid(i, 4).upper() == "<TT>") i += 3;
			else if(newstr.mid(i, 3).upper() == "<U>") i += 2;
			else if(!divUsed && newstr.mid(i, 4).upper() == "<DIV")
		{
			divUsed = true;
			SKIP_TO_GT_CHECK_QUOTE
		}
		else if(!pUsed && newstr.mid(i, 2).upper() == "<P")
		{
			pUsed = true;
			SKIP_TO_GT_CHECK_QUOTE
		}
		else if(!bodyUsed && newstr.mid(i, 5).upper() == "<BODY")
		{
			bodyUsed = true;
			SKIP_TO_GT_CHECK_QUOTE
		}
		else if(newstr.mid(i, 7).upper() == "</HTML>") KILL_LT
		else if(newstr.mid(i, 7).upper() == "</DIV>") KILL_LT
		else if(newstr.mid(i, 7).upper() == "</BODY>") KILL_LT
		else if(newstr.mid(i, 2).upper() == "</") SKIP_TO_GT
		else KILL_LT;
		}
	}
	return QString::null;
}

/*******************************************************************
 *  Allow user to run message through spell checker before send if desired
 ********************************************************************/
QString Chat::parseForSpelling(QString &newstr){
	//Run message through a spell checker automatically if desired in options
	return newstr;
}

/********************************************************************
 * Automatically replace abbreviations, acronyms, etc. before sending
 ********************************************************************/
QString Chat::parseForAutoReplace(QString &newstr){
	return newstr;
}

/***************************************************************************
 * Strip the tags from string
 ***************************************************************************/
QString Chat::stripTags(const QString &oldstr){
	//printf("StripTags First product: %s\n", oldstr.latin1());

	QString newstr = oldstr;
	int bodyPos;

	// 1) cut first <html> , last </html> tags
	bodyPos = newstr.find( QRegExp("<html>", false) );
	if(bodyPos != -1){
		newstr.replace(bodyPos, 6, "");
		bodyPos = newstr.findRev( QRegExp("</html>", false) );
		if(bodyPos != -1)
			newstr.replace(bodyPos, 7, "");
	}
	// AIM Sometimes sends two
	bodyPos = newstr.find( QRegExp("<HTML>", false) );
	if(bodyPos != -1){
		newstr.replace(bodyPos, 6, "");
		bodyPos = newstr.findRev( QRegExp("</HTML>", false) );
		if(bodyPos != -1)
			newstr.replace(bodyPos, 7, "");
	}


	// set Font sizes
	bodyPos = newstr.find( QRegExp("<font size=", false) );
	while (bodyPos != -1){
		bool end = false;
		signed int value = bodyPos+13;
		// Find the end
		while (end == false){
			if ((int) newstr.length() <= value){
				end = true;
				value = -1;
			}
			if (newstr.at(value) == '"')
	end = true;
			value++;
		}
		//printf("here1%s\n",newstr.latin1() );
		if (value == 0)
			bodyPos = -1;
		if (value-bodyPos > 14){
			QString number = QString(newstr.at(bodyPos+12));
			if ( number == "-"){
	newstr.replace(bodyPos+12, value-bodyPos-13, QString("%1").arg( 3 ));
			}
			else{
	newstr.replace(bodyPos+12, value-bodyPos-13, QString("%1").arg(7));
			}
		}
		//printf("here2%s\n",newstr.latin1() );
		if (value-bodyPos == 14){
			if (newstr.at(bodyPos+12) != '"')
				QString number = QString(newstr.at(bodyPos+12));
			} else {
				QString number = QString(newstr.at(bodyPos+13));
			//printf("size:%s\n",number.latin1());
			// This should be removed
			if ( 7 > atoi(number.latin1()))
				newstr.replace(bodyPos+12, 1, QString("%1").arg( 3 ));
		}
		//printf("bod%i\n",bodyPos);
		signed int num = bodyPos;
		if (bodyPos != -1)
			bodyPos = newstr.find("<font size=", (bodyPos+1), false);
		if (num == bodyPos)
			bodyPos = -1;
	}


	// 2) cut <p> tags
	newstr.replace( QRegExp("<p>", false), "" );
	// 2b) replace </p> with <br>
	newstr.replace( QRegExp("</p>", false), "<br>" );
        // 2c) cut <pre> tags
	newstr.replace( QRegExp("<pre>", false), "" );
        // 2d) cut </pre> tags
	newstr.replace( QRegExp("</pre>", false), "" );
	// 3) replace <body> with <div>, inserting a STYLE= value to apply text and
	// background colors
	bodyPos = newstr.find("<BODY BGCOLOR=");
	if(bodyPos != -1){
		temp_BuddyBgColor = colorSettings_chat_buddybg_color;
		QString BGCOLOR = newstr.mid(bodyPos+16,8);
		if (newstr.mid(bodyPos+16,6) != "ffffff") {
		colorSettings_chat_buddybg_color.setRgb(
			((BGCOLOR.mid(0,2)).toLong(0,16)),
			((BGCOLOR.mid(2,2)).toLong(0,16)),
			((BGCOLOR.mid(4,2)).toLong(0,16))
			);
		}
		// Get rid of the BODY BGCOLOR TAG :)
		bool end = false;
		signed int value = bodyPos;
		// Find the end
		while (end == false){
			if ((int) newstr.length() <= value){
				end = true;
				value = -1;
			}
			if (newstr.at(value) == '>')
	end = true;
			value++;
		}
		// Remove it.
		//printf("\nstring old: %s\n", newstr.latin1());
		if (value != 0){
			newstr.replace(bodyPos, value-bodyPos, "");
		}
		//newstr.replace( QRegExp("</BODY>", false), "" );
	}
	//printf("After removing body: %s\n", newstr.latin1());

	// parse for AOL's weird BACK tag for bgRGB
	bodyPos = newstr.find(QRegExp("BACK=\"#......\">"), 0);
	if (bodyPos != -1) {
		QString BACK = newstr.mid(bodyPos+7, 6);
		colorSettings_chat_buddybg_color.setRgb(
			((BACK.mid(0,2)).toLong(0,16)),
			((BACK.mid(2,2)).toLong(0,16)),
			((BACK.mid(4,2)).toLong(0,16))
			);
	 }
	// BACK tag can be combined with FONT COLOR (next) so not removing :)

	bodyPos = newstr.find("<FONT COLOR=");
	if(bodyPos != -1){
		temp_BuddyTextColor = colorSettings_chat_buddyText_color;
		QString COLOR = newstr.mid(bodyPos+14,8);
		colorSettings_chat_buddyText_color.setRgb(
			((COLOR.mid(0,2)).toLong(0,16)),
			((COLOR.mid(2,2)).toLong(0,16)),
			((COLOR.mid(4,2)).toLong(0,16))
			);
		// Get rid of the FONT TAG :)
		bool end = false;
		signed int value = bodyPos;
		// ditto...see uvalue comment 2 above...
		unsigned int uvalue = bodyPos;
		while (end == false){
			if (newstr.length() <= uvalue){
				end = true;
				value = -1;
			}
			if (newstr.at(value) == '>')
	end = true;
			uvalue++;
			value++;
		}
		//printf("\nstring old: %s\n", newstr.latin1());
		if (value != -1){
			newstr.replace(bodyPos, value-bodyPos, "");
		}

		// Find the end tag
		end = false;
		value = bodyPos;
		uvalue = bodyPos;
		while (end == false){
			if (newstr.length() <= uvalue){
				end = true;
				value = -1;
			}
			if (value != -1 && newstr.at(value) == '<'){
				if (uvalue+6 < newstr.length())
					if ((newstr.at(value+2) == 'f' || newstr.at(value+2) == 'F')  && newstr.at(value+6) == '>')
					  end = true;
			}
			uvalue++;
			value++;
		}
		//printf("string new: %s\n", newstr.latin1());
		// Remove it
		if (value != 0)
			newstr.replace(value-1, 7, "");
		//printf("string final: %s\n", newstr.latin1());
		//printf("string new: %s\n", newstr.latin1());
	}
	// 3b) remove </body>
	newstr.replace( QRegExp("</body>", false), "" );
	// 4) make sure the allowed tags are balanced, inserting a </tag> at the end of
	// the message to balance if needed.
	#define CLOSE_TAG(a) \
 	if(tagIsOpen(newstr, a)) \
	 	newstr += "</" a ">";
	CLOSE_TAG("a");
	CLOSE_TAG("b");
	CLOSE_TAG("big");
	CLOSE_TAG("code");
	CLOSE_TAG("em");
	CLOSE_TAG("font");
	CLOSE_TAG("i");
	CLOSE_TAG("small");
	CLOSE_TAG("tt");
	CLOSE_TAG("u");
	#undef CLOSE_TAG
	// 4b) check allowed tags, make sure quotes are balanced within them
	// 5) replace any "<" or ">" that's not part of an allowed tag with &lt; or &gt;

        // 6) Weirdness from winAIM.  Sometimes <B> or <I> is immediately followed by </FONT> and this
        //    breaks Textview...which is weird itself in some ways :-)
        //    note: winaim always seems to send combos as <B><I>
        newstr.replace( QRegExp("<B></FONT>"), "</FONT><B>");
        newstr.replace( QRegExp("<I></FONT>"), "</FONT><I>");
        newstr.replace( QRegExp("<B><I></FONT>"), "</FONT><B><I>");
        // 6a) Weirdness in TextView. Doesn't like </B></FONT> etc.
        //     apparently </FONT> is enough and it breaks otherwise.
        newstr.replace( QRegExp("</B></FONT>"), "</FONT>");
        newstr.replace( QRegExp("</I></FONT>"), "</FONT>");
        newstr.replace( QRegExp("</B></I></FONT>"), "</FONT>");


	//printf("StripTags Final product: %s\n", newstr.latin1());

	parseForHTML(newstr);

	//printf("StripTags Final product: %s\n", newstr.latin1());
	return (newstr);
}

/***************************************************************************
 * Opens a log file
 ***************************************************************************/
void Chat::openLogFile(void){
	//qDebug("chat::openLogFile\n");
	if(!chatSettings_chat_log)
		chatSettings_chat_log = true;

	QString fileNamePath;
	QString normedName = tocNormalize( buddyName );

	QString chatroom = "";
	if (room > 0)
		chatroom = "chatroom_";

	if (chatSettings->chat_log_singleFile == true){
		fileNamePath = QDir::homeDirPath() + "/." + QString(APP_LOWERCASE_NAME) + "/logs/"
			 	+ chatroom + normedName + "/" + normedName + ".log";
		logFile.setName(fileNamePath);
	}
	else{
		// Each chat gets it's own file.
		QString endingTag;
		if (chatSettings->chat_log_inHtml == true)
			endingTag = ".html";
		else
			endingTag = ".txt";
		QString date = ((QDate::currentDate ()).toString());
		date.replace( QRegExp(" "), "" );
		date = date.mid(3,date.length()-3);
		QString month_day = date.left(date.length()-4);
		QString year = date.right(4);
		date = month_day + "-" + year;

		QString logFolder = QDir::homeDirPath() + "/." + QString(APP_LOWERCASE_NAME) + "/logs/" + chatroom + normedName + "/";
		QString fileNamePath = logFolder + normedName + "-" + date + endingTag;


		logFile.setName(fileNamePath);
		int logNumber = 2;
		QString logNumberString;
		while (logFile.exists() == true){
			logNumberString.setNum(logNumber);
			fileNamePath = logFolder + normedName + "-" + date + "-" + logNumberString + endingTag;
			logFile.setName(fileNamePath);
			logNumber++;
		}
	}

	QDir newDir("/dev/null");
	//Make Dir
	QString d = QDir::homeDirPath() + "/." + QString(APP_LOWERCASE_NAME);
	if( !QFile::exists(d) )
		newDir.mkdir(d, true);
	d = QDir::homeDirPath() + "/." + QString(APP_LOWERCASE_NAME) + "/logs/";
	if( !QFile::exists(d) )
		newDir.mkdir(d, true);
	d = QDir::homeDirPath() + "/." + QString(APP_LOWERCASE_NAME) + "/logs/" +
	normedName;
	if( !QFile::exists(d) )
		newDir.mkdir(d, true);
	d = QDir::homeDirPath() + "/." + QString(APP_LOWERCASE_NAME) + "/logs/" + chatroom + normedName;
	if( !QFile::exists(d) )
		newDir.mkdir(d, true);

	if (logFile.open( IO_WriteOnly | IO_Append ) == false){
			QMessageBox::critical(0, APP_NAME, QString("Unable to open ") + fileNamePath + " for appending.", "OK");
			chatSettings_chat_log = false;
			fileMenu->setItemChecked(ID_FILE_LOG, false );
			if (toolBarSettings_chat_log == true && chatLogButton != 0)
				fileToolbar->setButton(ID_LOG_BUTTON, false );
	} else{
			logStream.setDevice(&logFile);
			if (chatSettings->chat_log_inHtml == true){
				logStream << "<HTML>\n<HEAD>\n<TITLE>Conversations with ";
				logStream << buddyName;
				logStream << "</TITLE>\n</HEAD>\n<BODY BGCOLOR=\"#FFFFFF\">\n";
				logStream << "<HR><BR><H3 Align=Center> ---- New Conversation @ ";
	      logStream << QDate::currentDate().toString().latin1();
	      logStream << " ----</H3><BR>";
			}
			else{
				logStream << "Conversations with " << buddyName << "\n";
				logStream << " at " << QDate::currentDate().toString().latin1() << "\n";
			}
	}


	if (chatSettings->chat_log_inHtml == true){
		if (( chatSettings_chat_log_time == true) && ( chatSettings_chat_log == true))
			logStream << conversationTimeBuffer;
		else
			logStream << conversationBuffer;
	}
	else {
	if (( chatSettings_chat_log_time == true) && (
							chatSettings_chat_log == true))
			logStream << parseAndProcessALL(conversationTimeBuffer);
		else
			logStream << parseAndProcessALL(conversationBuffer);
	}

	// Flush everything we have so far.
	logFile.flush();
}

/***************************************************************************
 * Resizes the window
 * Occurs when the window size is changed.
 ***************************************************************************/
void Chat::resizeEvent ( QResizeEvent * ){
	// scroll to the current text
	chatWindow->ensureVisible(0, chatWindow->contentsHeight()+100);

	// Until this function is needed....

	/*
	int toolBarHeight = 0;
	int toolBarWidth = 0;
	// Get the Toolbar's Height
	toolBarHeight = fileToolbar->height();
	// If the tool bar is mimimized
	if (toolBarHeight <= 1)
	  toolBarHeight = 10;
	// If the toolbar is up on left or right
	if ((fileToolbar->orientation()) == Vertical){
		toolBarHeight = 0;
	  toolBarWidth = fileToolbar->width();
	}

	//Toolbar on top
	if (fileToolbar->y() == this->height()-toolBarHeight)
		spliter->setGeometry(toolBarWidth, 30,
	   this->width()-toolBarWidth, this->height()-toolBarHeight-30);
	// Toolbar on bottom
	if (fileToolbar->y() == this->height()-toolBarHeight-spliter->y())
		spliter->setGeometry(toolBarWidth, 30+toolBarHeight,
	   this->width()-toolBarWidth, this->height()-toolBarHeight-30);
	*/
}

/***************************************************************************
 * Sends the message wehn shift-enter is hit.
 * The return key itself will add a line so it is removed
 ***************************************************************************/
void Chat::enterKeyPressed(){
	if((shiftIsPressed == true) && (chatSettings->chat_return_send == true)){
		//inputWindow->append("\n");
	}
	else
	if((shiftIsPressed == true && (chatSettings->chat_sreturn_send == true))
	 ||(chatSettings->chat_return_send == true)){
		if (currentMessageOut.length() > 2000){
			QMessageBox::information(0, APP_NAME, "Your message has more than 2000 letters.  It is too long and can not be sent, make it shorter.", "OK");
			return;
		}
		// Repace the text with what was just there before the return. :)
    inputWindow->setText(currentMessageOut);
    lastMessage = currentMessageOut;
    slotBuddySendMessage();
    currentMessageOut = QString("");
  }
}

/***************************************************************************
 * Saves what is in the input window.
 * Occurs when the text in the input window changes.
 ***************************************************************************/
void Chat::inputTextChanged(){
  //if ((inputWindow->text()).length() != 0)
    currentMessageOut = inputWindow->text();
}

/***************************************************************************
 * Sets shiftIsPressed = true
 * Occurs when the shift key is pressed.
 ***************************************************************************/
void Chat::keyPressEvent(QKeyEvent *e){
	if(e->key() == Key_Shift){
		shiftIsPressed = true;
	}
}

/***************************************************************************
 * Sets shiftIsPressed = false
 * Occurs when the shift key is released .
 ***************************************************************************/
void Chat::keyReleaseEvent(QKeyEvent *e){
	if(e->key() == Key_Shift){
		shiftIsPressed = false;
	}
}

/***************************************************************************
 * Turns an icon on and off untill screen has focus.
 ***************************************************************************/
void Chat::flashIcon(){
	if (this->isActiveWindow() == true){
		flashWindow = false;
		this->setIcon(SmallIcon("kinkatta"));
	}
	if (flashWindow == true){
		QTimer::singleShot( 500, this, SLOT(flashIcon()));
		if (flashNumber == false){
			this->setIcon(SmallIcon("kinkatta"));
			flashNumber = true;
		}
		else{
			flashNumber = false;
			this->setIcon(SmallIcon("kinkatta_small_blink"));
		}
		//swap icons
	}
}

/**************************************************************************
	* converts point font to html font
	*************************************************************************/
int Chat::ptsizetohtml(int pointsize){
	int htmlsize = 3;
	htmlsize = int(pointsize/2) - 3;
	return htmlsize;
}

/**************************************************************************
	* return HTML fontTag
	*************************************************************************/
QString Chat::fontTagHTML(QString face, QString color, int size){
	QString fontTag;
	QString fontSizeTag;
	QString fontFaceTag;
	QString fontColorTag;

		// Add font current size
		if (fontSize != 3) {
	fontSizeTag.setNum(size);
		}

		// Add font face tag
		if (!default_yourFont) {
	fontFaceTag = face;
		};

		// Add color
		if (color != "#000000") {
			 fontColorTag = color;
		}

		// Build tag
		if(!fontSizeTag.isEmpty()){
	fontTag += " SIZE=\"" + fontSizeTag + "\"";
		}
		if(!fontFaceTag.isEmpty()){
	fontTag += " FACE=\"" + fontFaceTag + "\"";
		}
		if(!fontColorTag.isEmpty()){
				fontTag += " COLOR=\"" + fontColorTag + "\"";
		}

	return fontTag;
}

/**************************************************************************
	* return message with HTML fixed for winAim smilie rendering
	*************************************************************************/
QString Chat::fontFixSmilies(QString message, QString fontTag){
	//If we dont have an already open fontTag, then we dont need to send the
	//close font tag before enclosing the smiley in its own font tags.
	QString preTag = fontTag.isEmpty() ? "" : "</FONT>";

#define FONTTAG(x) \
	QString(preTag + "<FONT SIZE=\"3\">" + QString(x) + "</FONT>" + fontTag)

	 // plug in fix so that aol users get smiles in font size 3 (so that it matches what we see)
	 // please do not remove the extra fontag--winaim won't render reliably w/o it ;-)
	 if( (message.contains('-') != 0) ||     //find a nose
		 (message.contains(')') != 0) ||       //or a mouth
		 (message.contains(':') != 0) ){       //or some eyes.

				message.replace(QRegExp("=-[Oo]"), FONTTAG("=-O") );
				message.replace(QRegExp("&gt;:[Oo]"), FONTTAG(">:O") );
				message.replace(QRegExp("[Oo]:-)"), FONTTAG("O:-)") );
				message.replace(QRegExp("C:-)"), FONTTAG("C:-)") );

				// the "not" character gets counted in replace function..so it eats the one b4
				// message.replace(QRegExp("[^COo]:-?)"), FONTTAG(":-)") ); // :-) :)

				// wrap FONTTAG around smily w/o messing up the variations...
				int i = 0;
				while((i = message.find( QRegExp("[^COo]:-)"), i )) > 0)  {
					message.replace(i+1, 3, FONTTAG(":-)") );
					i = i + 29; // min length of FONTAG string macro
				}
				i = 0;
				while((i = message.find( QRegExp("[^COo]:)"), i )) > 0)  {
					message.replace(i+1, 2, FONTTAG(":)") );
					i = i + 29; // min length of FONTAG string macro
				}
				message.replace(QRegExp(":-?("), FONTTAG(":-(") ); // :-( :(
				message.replace(QRegExp(";-?)"), FONTTAG(";-)") ); // ;-) ;)
				message.replace(QRegExp(":-?P"), FONTTAG(":-P") ); // :-P :P

				message.replace(QRegExp(":-\\*"), FONTTAG(":-*") );
				message.replace(QRegExp("8-)"), FONTTAG("8-)") );
			
				message.replace(QRegExp("[Oo]-)"), FONTTAG("O-)") );
			
				message.replace(QRegExp(":-\\$"), FONTTAG(":-$") );
				message.replace(QRegExp(":-!"), FONTTAG(":-!") );
				message.replace(QRegExp(":-\\["), FONTTAG(":-[") );
			
				message.replace(QRegExp(":-\\"), FONTTAG(":-/") );
				message.replace(QRegExp(":-/"), FONTTAG(":-/") );
				message.replace(QRegExp(":'("), FONTTAG(":'(") );
				message.replace(QRegExp(":-X"), FONTTAG(":-X") );
				message.replace(QRegExp(":-?D"), FONTTAG(":-D") ); // :-D :D
	}

	return message;
#undef FONTTAG
}


// chat.cpp


























