/***************************************************************************
                              buddylistwindow.h
                             -------------------
    begin                : Sun Feb 13 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 * The main window that displays the buddies.  Edit/IM etc.
 ***************************************************************************/

#ifndef BUDDYLISTWINDOW_H
#define BUDDYLISTWINDOW_H

#include <qwidget.h>

#include "kinkattaviewlist.h"
#include <qdict.h>

#include "setup.h"
#include "awaymessage.h"
#include "newawaymessage.h"
#include "tbuddylist.h"
#include "taim.h"
#include "newpounceimp.h"
#include <kaboutkde.h>

class KHelpMenu;
class KMenuBar;
class KPopupMenu;
class QPushButton;
class KAboutKDE;
class QTextStream;
class QFile;

class ChatRoom;
class ChatWindow;
class Browser;
class Sound;

/**
  * @author Benjamin Meyer
  */

class BuddyListWindowItem; 

class BuddyListWindow : public QWidget  {
  Q_OBJECT

  signals:
    void quit();
    void logOff();
    void showOptions();
    void set_window(int, int);
    void saveSettings();
    void savePounce();
    void checkForNewRelease();
	
    void updateIfIsBuddy(QString, bool);
    void updateChatSettings();

    void updateChatColorSettings();
    void updateChatFontSettings();
    void updateChatSoundSettings();
    void updateChatToolBarSettings();
    void updateChatRoomToolBarSettings();

    //this is mainly so that the dock widget can be notified when we go
    //away/come back
    void statusChanged(int);

  public:
    BuddyListWindow(QWidget *parent=0, const char *name=0, TAim *i_connection=0 );
    ~BuddyListWindow();
    void closeExistingChatwindows();
    void resizeEvent ( QResizeEvent *e );
    void startMutePeriod();
    bool awayRightNow;
    QValueList<QString *> signedOff;
    QValueList<QString *> signedOn;
    QValueList<QString *> awayMessageSent;
    QValueList<QString> awayMessageGetting;
    void clearPostConnections(void);
    Browser *browser;
    Sound *sound;
    toolTipData AmIATip(const QPoint & p);
    KPopupMenu *_AwayMenu;

  private:
    // The Log Data's
    bool logOpen;
    QFile logFile;
    QTextStream logStream;
    
    // internal vars
    settings_t *i_aimSettings;
    TAim *connection;
    bool viewAll;
    bool autoResizing;
    bool sendingPounce;	
    bool muteSound;  //whether or not to play sounds.  used at signon.
    bool loadingTheList;
    int empty1;
    int empty2;

    // ChatRoom handling 
    ChatRoom *getAChatRoom(const int number, QString name);
    bool chatRoom_isThereARoom(const int roomNumber);
    QDict<ChatRoom> chatRooms;

    // Away status
    QString awayMessage;
		
    // internal functions
    void addTreeBuddy(TBuddy *buddy, QString folder, int folder_size);

    void initWindow();
    void initMenuBar();
    void initAwayList();
    void initViewAllSetting();
    void loadTreeBuddy(TBuddy *buddyInfo);
    void autoResize();
			 	
    KPopupMenu *_FileMenu;
    KPopupMenu *_ToolsMenu;
    KPopupMenu *_ViewMenu;
    KPopupMenu *_PounceMenu;
    KPopupMenu *_PounceDelete;
    KPopupMenu *_importMenu;
    KPopupMenu *_BuddyMenu;
    int id_buddyList;
    KPopupMenu *_FolderMenu;
    int id_folderEdit;
    int id_folderRemove;
    int id_buddyAway;
    KMenuBar *_menuBar;
    KHelpMenu *_helpMenu;
    KAboutKDE *_kdeAbout;
    KPopupMenu *_TreeMenu; 
    void loadSettings();
    
    // ChatWindow handling
    ChatWindow *messageWindow(const QString &name);
    QDict<ChatWindow> messageWindows;

    void importConfig(QString fileName);
    void importXmlConfig(QString fileName);
    void importConfigAlias(QString fileName);

    QDict<pounce> pounceMessages;

  protected:
    void mouseReleaseEvent(QMouseEvent* event);
    void closeEvent(QCloseEvent *);
    QPixmap *createBuddyPixmapWithIcon(QPixmap, int, QColor, QColor, QString);
		
    KinkattaListView *treeList;
    QPushButton *chatButton;
    QPushButton *infoButton;
    QPushButton *awayButton;

    AwayMessage *awayWidget;

  public slots:
    void rightClickInTree(QListViewItem *item, const QPoint &point, int);
    void buddyChanged(int number);
    void settingsChanged();
    void initOptions();
    void endMutePeriod();
    void loadList();

    void away_BackForReal();

    void receivedIM(QString name, QString message, bool isAuto);
    void initChatSettings();
    void chatWindow_ToolbarUpdated();
    void chatRoom_ToolbarUpdated();

    void loadRecurringPounces();

  private slots:
    void postBuddySignoff();
    void postBuddySignon();
    void moveBuddy(QListViewItem* buddy, QListViewItem* folder);
    void aboutToShowFileMenu();
    void DoubleClicked();
    void TreeSelected(QListViewItem* selected);
    void folderExpanded(QListViewItem*item);
    void folderCollapsed(QListViewItem*item);

    void changePassword();
    void MenuSlotAboutKinkatta();
    void MenuSlotOpenWebSite();
    void slotAddBuddy();
    void slotAddBuddy(QString buddy);
    void slotRemoveBuddy();
    void slotAddFolder();
    void slotRemoveFolder();
    void slotRemoveFolder(QString group);
    void slotOpenLogs();
    void slotEditBuddy();
    void slotEditAlias();
    void changeBuddyName();
    void buddySignedOn(QString buddy);
    void viewLastOn();
    void viewIdle();
		void ChangeViewAllSetting();
    void slotRemoveBuddy(QString name);

    void slotGetBuddyInfo();
    void slotGetBuddyInfo(QString name);
    void slotBuddyInfoRecieved(QString);

    void editSoundConfig();
    void setSoundConfig(pounce newPounce);

    void postAwayMessageSent();
    void getBuddyAwayMessage();
    void remove_getBuddyAwayMessage();
    bool checkIfGotBuddyAwayMessage(QString buddy);
    void away_ShowAwayList();
    void away_SetAutoAway();
    void away_AddAwayMessage();
    void away_makeAwayNow(QString name);
    void away_Update(QString text);
    void away_GoAway(int);
    void away_Back();

    void chat_sendImOut(QString target, QString message, int room);

    void sendAutoIM(QString target, QString message);
    void chatWindow_ChatWithBuddy(QString buddyName);
    void chatWindow_ChatWithBuddy();
    void chatWindow_RemoveWindow(QString name, int);
    void chatWindow_BlockBuddy(QString name);
    void chatWindow_WarnBuddy(QString name);
    void chatWindow_SendWarning(QString name, bool isAnonymous);
    void chatWindow_saveSize(int, int, int);

    void chatRoom_JoinButton();
    void chatRoom_Joined(int room, QString);
    void chatRoom_In(int room, QString, bool, QString);
    void chatRoom_UpdateBuddy(int room, bool, QString);
    void chatRoom_Invite(QString, int room, QString, QString);
    void chatRoom_ShowInvite(int room);
    void chatRoom_Left(int room );
    void chatRoom_RemoveWindow(QString name, int room);
    void chatRoom_SaveSize(int x, int y, int s1, int s2);

    void slotImportFromGaim();
    void slotImportFromKinkatta();
    void slotImportFromTik();
    void slotImportFromAim();
    void slotImportFromKit();
    void slotExportBuddyList();

    void pounce_SlotAddDialog();
    void pounce_SlotAddDialogWithBuddy();
    void pounce_SlotAddDialogWithBuddyName(QString);
    void pounce_Edit(int menuId);
    void pounce_SlotAdd(pounce newPounce);
    void pounce_DeleteMenuAboutToShow();
    void pounce_CheckSignOn(QString buddyName);
    void pounce_CheckReturnAway(QString buddyName);
    void pounce_CheckReturnIdle(QString buddyName);
    void pounce_Activate(QString buddyName);
    void pounce_SlotRemove(int deleteMenuNumber);
    void pounce_UpdateMenu();

};

#endif

// buddylistwindow.h







