/***************************************************************************
                             buddylistwindow.cpp
                             -------------------
    begin                : Sun Feb 13 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : ben@meyerhome.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "buddylistwindow.h"
#include "kitpasswordchanger.h"
#include "chatroominviteimp.h"
#include "soundconfigureimp.h"
#include "browser.h"
#include "sound.h"
#include "info.h"
#include "chatwindow.h"
#include "chatroom.h"
#include <qfile.h>
#include <qtextstream.h>
#include <qdict.h>
#include <qtooltip.h>
#include <kfiledialog.h>
#include <qtooltip.h>
#include <qmessagebox.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qlineedit.h>
#include <qinputdialog.h>
#include <qheader.h>
#include <qpushbutton.h>
#include <kpopupmenu.h>
#include <kmenubar.h>
#include <khelpmenu.h>

#include "kinkattadock.h"

#define SOUND_MUTE_ON_LOGIN_TIME 20

#define DEFAULT_AWAYWIDGET_HEIGHT 170

//These delays are in seconds!!
#define POST_BUDDY_SIGNOFF_DELAY 10
#define POST_BUDDY_SIGNON_DELAY 10
#define POST_AWAY_MESSAGE_SENT_DELAY 300
#define POST_GET_AWAY_MESSAGE 3

#define NEW_AWAY_MESSAGE_MENU_ID 99

#define TWINDOW_AIM_SANITY_CHECK if(connection->getStatus() == TAIM_OFFLINE) {\
                                   QMessageBox::critical(0, QString("Kinkatta"), QString("You are not online."));\
                                   return; }

/***************************************************************************
 * Constructor
 ***************************************************************************/
BuddyListWindow::BuddyListWindow(QWidget *parent, const char *name, TAim *i_connection ) : QWidget(parent,name){
  viewAll = true;
  empty1 = -1;
  sendingPounce = false;
  autoResizing = false;
  awayRightNow = false;
  muteSound = false;

  i_aimSettings = setup::settings();
  
connection = i_connection;
  sound = new Sound();
	loadingTheList = false;
	pounceMessages.setAutoDelete( TRUE );

  connect(connection, SIGNAL(userInfoReceived(QString)), this, SLOT(slotBuddyInfoRecieved(QString)));
  connect(connection, SIGNAL(IMReceived(QString, QString, bool)), this, SLOT(receivedIM(QString, QString, bool)));
  connect(connection, SIGNAL(buddyChanged(int)), this, SLOT(buddyChanged(int)));
  connect(connection, SIGNAL(userSignedOn(QString)), this, SLOT(buddySignedOn(QString)));
  connect(connection, SIGNAL(userNotAway(QString)), this, SLOT(pounce_CheckReturnAway(QString)));
  connect(connection, SIGNAL(userNotIdle(QString)), this, SLOT(pounce_CheckReturnIdle(QString)));
  connect(connection, SIGNAL(idleTimeReached()), this, SLOT(away_SetAutoAway()));

  connect(connection, SIGNAL(chat_joined(int, QString)), this, SLOT(chatRoom_Joined(int, QString)));

  connect(connection, SIGNAL(chat_in(int, QString, bool, QString)), this, SLOT(chatRoom_In(int, QString, bool, QString)));
  connect(connection, SIGNAL(chat_updateBuddy(int, bool, QString)), this, SLOT(chatRoom_UpdateBuddy(int, bool, QString)));
  connect(connection, SIGNAL(chat_invite(QString, int, QString, QString)), this, SLOT(chatRoom_Invite(QString, int, QString, QString)));
  connect(connection, SIGNAL(chat_left(int)), this, SLOT( chatRoom_Left(int)));

  // Create the menu
  _FileMenu = new KPopupMenu(this, "FileMenu");
  _ToolsMenu = new KPopupMenu(this, "ToolsMenu");
  _AwayMenu = new KPopupMenu(this, "AwayMenu");
  _ViewMenu = new KPopupMenu(this, "ViewMenu");
  _PounceMenu = new KPopupMenu(this, "PounceMenu");
  _PounceDelete = new KPopupMenu(this, "PounceDelete");
  connect(_PounceMenu, SIGNAL(aboutToShow()), this, SLOT(pounce_DeleteMenuAboutToShow()));
  _BuddyMenu = new KPopupMenu(this, "Buddy");
  _FolderMenu = new KPopupMenu(this, "Folder");
  _helpMenu = new KHelpMenu(this, (QString)"Kinkatta " + i_aimSettings->Version + " (" + i_aimSettings->ReleaseDate +")\n"
  "(c) 2001 Benjamin Meyer\n"
  "ben@meyerhome.net\n"
  "\n"
  "Developers:\n"
  " Benjamin Meyer <ben@meyerhome.net>\n"
  " Dimi Shahbaz <dshahbaz@ucla.edu>\n"
  " Jim Wilson <jimw@kelcomaine.com>\n"
  "\n"
  "Contributions:\n"
  " Neil Stevens <multivac@fcmail.com>\n"
  " David Johnson <david@usermode.org>\n"
  " Bob Herrmann <bob@jadn.com>\n"
  "\n"
  "Kinkatta is a AOL instant messenger for KDE2.x\n"
  "If you have any suggestions/comments/bugs \n"
  "please contact the Kinkatta team.\n"
  "\n"
  "For more information you can visit the Kinkatta\n"
  "webpage at \"http://kinkatta.sourceforge.net/\".\n"
  "\n"
  "This program is dual licensed under the GPL\n"
  "and LGPL license. For more information\n"
  "goto \"http://www.gnu.org\".");
  _importMenu = new KPopupMenu(this, "ImportMenu");
  // The menu bar for the menus
  _menuBar= new KMenuBar(this, "NoName");

  initMenuBar();
  initWindow();
  connect(_AwayMenu, SIGNAL(activated(int)), this, SLOT(away_GoAway(int)));
  connect(treeList->buddyEdit, SIGNAL(returnPressed()), this, SLOT(changeBuddyName()));
  connect(treeList, SIGNAL(removeBuddy(QString)), this, SLOT(slotRemoveBuddy(QString)));
  connect(treeList, SIGNAL(removeFolder(QString)), this, SLOT(slotRemoveFolder(QString)));

  messageWindows.setAutoDelete(false);
  this->setMinimumSize(150,200);
  _TreeMenu = new KPopupMenu(this, "NoName");
  logOpen = false;
}

/***************************************************************************
 * Deconstructor
 ***************************************************************************/
BuddyListWindow::~BuddyListWindow(){
  if ( logOpen )
    logFile.close();
}

/******************************************************************************
 * Init anything in the main window that would change.
 ******************************************************************************/
void BuddyListWindow::initOptions(){
  // Check Away status
  if(awayRightNow == true){
    away_Back();
  }


  if (i_aimSettings->main_log_on_off == true && logOpen == false){
    QString fileNamePath = QDir::homeDirPath() + "/.kinkatta/logs/sign_on_off.log";
    logFile.setName(fileNamePath);

    QDir newDir("/dev/null");
    QString d = QDir::homeDirPath() + "/.kinkatta";
    if( !QFile::exists(d) )
      newDir.mkdir(d, true);
    d = QDir::homeDirPath() + "/.kinkatta/logs/";
    if( !QFile::exists(d) )
      newDir.mkdir(d, true);
    if( QFile::exists(d) ){
      if (logFile.open( IO_WriteOnly | IO_Append ) == true){
        logOpen = true;
       	logStream.setDevice(&logFile);
      }
      else
	QMessageBox::critical(0, "Kinkatta", QString("Unable to open ") + fileNamePath + " for appending.", "OK");
    }
  }
  else{
    if (logOpen){
      logOpen = false;
      logFile.close();
    }
  }
 
  // No Icons option
  if (i_aimSettings->main_noIcons == true){
    if (chatButton->isHidden() == false){
      chatButton->hide();
      awayButton->hide();
      infoButton->hide();
      emit(set_window(this->width(), this->height()-1));
    }
  }
  else{
    if (chatButton->isHidden() == true){
      chatButton->show();
      awayButton->show();
      infoButton->show();
      emit(set_window(this->width(), this->height()-1));
    }
  }

  // Browser option
  //if (i_aimSettings->main_browser != "netscape"){
  // Netscape and X4?
  browser->otherBrowser = i_aimSettings->main_browser;
  browser->setBrowser(2);
 	//}
  //else{
  //  browser->setBrowser(1);
  //}
  // Sound option
  sound->playCommand = i_aimSettings->sound_file_command;

  // Idle format option
  if (i_aimSettings->main_idleLayout == 1)
    connection->idleStringWColon = true;
  else
    connection->idleStringWColon = false;
  // X11 autoaway idle options
  connection->useX11forIdle = i_aimSettings->main_useX11ForIdle;
  connection->idleTimeBeforeSignal = i_aimSettings->away_auto_delay_minutes;

  // update buddylist Online font
  QFont tempFont;
  tempFont = i_aimSettings->buddylistFontSettings->buddylist_OnlineFont;
  treeList->setFont(tempFont);

  // Reload list for any other changes.
  loadList();
}

/***************************************************************************
 * init for the main objects, button, tree
 ***************************************************************************/
void BuddyListWindow::initWindow(){
  treeList= new KinkattaListView(this,"NoName");
  treeList->setGeometry(5,100,130,210);

  // set buddy list font to the default "Online" font as selected by the user.
  QFont tempFont;
  tempFont = i_aimSettings->buddylistFontSettings->buddylist_OnlineFont;
  treeList->setFont(tempFont);

  treeList->addColumn("Screen Name", -1);
  //treeList->setBackgroundPixmap(QPixmap("/home/ben/background.gif"));
  connect( treeList, SIGNAL(moveItem(QListViewItem *, QListViewItem *)), this, SLOT(moveBuddy(QListViewItem *, QListViewItem *)));
  connect( treeList, SIGNAL(expanded (QListViewItem *)), this, SLOT(folderExpanded (QListViewItem *)));
  connect( treeList, SIGNAL(collapsed(QListViewItem *)), this, SLOT(folderCollapsed(QListViewItem *)));

  connect( treeList, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT(TreeSelected(QListViewItem *)) );
  connect( treeList, SIGNAL(returnPressed(QListViewItem *)), this, SLOT(TreeSelected(QListViewItem *)) );
  connect( treeList, SIGNAL(rightButtonClicked(QListViewItem *, const QPoint &, int)), this, SLOT(rightClickInTree(QListViewItem *, const QPoint &, int)) );

  chatButton= new QPushButton(this,"NoName");
  chatButton->setGeometry(5,315,40,40);
  chatButton->setPixmap(BarIcon("chat_big"));
  QToolTip::add(chatButton,"Chat");

  infoButton= new QPushButton(this,"NoName");
  infoButton->setGeometry(95,315,40,40);
  infoButton->setPixmap(BarIcon("info_big"));

  QToolTip::add(infoButton,"Get Buddy Info");

  awayButton= new QPushButton(this,"NoName");
  awayButton->setGeometry(50,315,40,40);
  awayButton->setPixmap(BarIcon("away_big"));
  QToolTip::add(awayButton,"Away");

  connect(_PounceDelete, SIGNAL(activated(int)), this, SLOT(pounce_SlotRemove(int)));
  connect(_PounceMenu, SIGNAL(activated(int)), this, SLOT(pounce_Edit(int)));
  // The Three Button Connections.
  connect(chatButton, SIGNAL(clicked()), this, SLOT(chatWindow_ChatWithBuddy()));
  connect(awayButton, SIGNAL(pressed()), this, SLOT(away_ShowAwayList()));
  connect(infoButton, SIGNAL(clicked()), this, SLOT(slotGetBuddyInfo()));

  awayWidget = new AwayMessage(this, "AwayDialogBox");
  connect(awayWidget, SIGNAL(backClicked()), this, SLOT(away_BackForReal()));
  connect(awayWidget, SIGNAL(update(QString)), this, SLOT(away_Update(QString)));
  awayWidget->hide();
}

/***************************************************************************
 * Builds the menu bars
 ***************************************************************************/
void BuddyListWindow::initMenuBar(){
  _FileMenu->clear();
  id_buddyList = _FileMenu->insertItem(SmallIcon("buddy_oscar"), "&Buddy", _BuddyMenu);
    _BuddyMenu->clear();
    _BuddyMenu->insertItem(SmallIcon("buddy_info"), "&Get Buddy Info", this, SLOT(slotGetBuddyInfo()), CTRL+Key_I);
    id_buddyAway = _BuddyMenu->insertItem(SmallIcon("kinkatta_getaway"), "Get Away &Message", this, SLOT(getBuddyAwayMessage()));
    _BuddyMenu->insertItem(SmallIcon("kinkatta_buddy_remove"), "&Remove Buddy...", this, SLOT(slotRemoveBuddy()));
    _BuddyMenu->insertItem(SmallIcon("edit"), "&Edit Name", this, SLOT(slotEditBuddy()));
    _BuddyMenu->insertItem(SmallIcon("edit"), "Edit &Alias", this, SLOT(slotEditAlias()));
    _BuddyMenu->insertItem(SmallIcon("history"),"&Open Logs folder", this, SLOT(slotOpenLogs()));
  	_BuddyMenu->insertItem(SmallIcon("kinkatta_bell"), "Edit &Sound", this, SLOT(editSoundConfig()));

  _FileMenu->insertItem(SmallIcon("kinkatta_folder_open"), "&Folder", _FolderMenu);
    _FolderMenu->clear();
    _FolderMenu->insertItem(SmallIcon("kinkatta_buddy_add"), "&Add Buddy...", this, SLOT(slotAddBuddy()));
    _FolderMenu->insertSeparator();
    _FolderMenu->insertItem(SmallIcon("kinkatta_folder_create"), "Add &Folder", this, SLOT(slotAddFolder()));
    id_folderRemove = _FolderMenu->insertItem(SmallIcon("kinkatta_folder_remove"), "&Remove Folder...", this, SLOT(slotRemoveFolder()));
    _FolderMenu->insertSeparator();
    id_folderEdit = _FolderMenu->insertItem(SmallIcon("edit"), "&Edit Name", this, SLOT(slotEditBuddy()));

  _FileMenu->insertItem(SmallIcon("next"), "&Import/Export", _importMenu);
    _importMenu->clear();
    _importMenu->insertItem(SmallIcon("icon_gaim"), "&Gaim...", this, SLOT(slotImportFromGaim()));
		_importMenu->insertItem(SmallIcon("icon_kit"), "&Kit...", this, SLOT(slotImportFromKit()));
    _importMenu->insertItem(SmallIcon("icon_tik"), "&Tik...", this, SLOT(slotImportFromTik()));
		_importMenu->insertItem(SmallIcon("icon_tik"), "&Aim...", this, SLOT(slotImportFromAim()));
    _importMenu->insertItem(SmallIcon("kinkatta"), "K&inkatta...", this, SLOT(slotImportFromKinkatta()));

    _importMenu->insertSeparator();
    _importMenu->insertItem(SmallIcon("previous"), "&Export...", this, SLOT(slotExportBuddyList()), CTRL+Key_E);

  _FileMenu->insertSeparator();
  _FileMenu->insertItem(SmallIcon("chat"), "&New Instant Message...", this, SLOT(chatWindow_ChatWithBuddy()), CTRL+Key_N);
  _FileMenu->insertItem(SmallIcon("chatroom"), "&Join Chat Room...", this, SLOT(chatRoom_JoinButton()), CTRL+Key_J);

  _FileMenu->insertSeparator();
  _FileMenu->insertItem(SmallIcon("configure"),"&Options", this, SIGNAL(showOptions()), CTRL+Key_O);
  _FileMenu->insertSeparator();
  _FileMenu->insertItem(SmallIcon("connect_no"), "&Log Off", this, SIGNAL(logOff()), CTRL+Key_L);
  _FileMenu->insertItem(SmallIcon("exit"),"&Quit", this, SIGNAL(quit()), CTRL+Key_Q);
  connect(_FileMenu, SIGNAL(aboutToShow()), this, SLOT(aboutToShowFileMenu()));

  _ToolsMenu->insertItem(SmallIcon("buddy_away"), "&Away", _AwayMenu);
    initAwayList();
  _ToolsMenu->insertItem(SmallIcon("transform"), "&View", _ViewMenu);
    initViewAllSetting();
  _ToolsMenu->insertItem(SmallIcon("bottom"), "&Pounce", _PounceMenu);
    _PounceMenu->clear();
     _PounceMenu->insertItem("&Add pounce...", this, SLOT(pounce_SlotAddDialog()), CTRL+Key_A);
    _PounceMenu->insertItem("&Remove pounce", _PounceDelete);
    _PounceMenu->insertSeparator();
  _ToolsMenu->insertSeparator();
  _ToolsMenu->insertItem(SmallIcon("kinkatta_changepassword"), "&Change Password", this, SLOT(changePassword()));

  _menuBar->clear();
  _menuBar->insertItem("&Program", _FileMenu);
  _menuBar->insertItem("&Tools", _ToolsMenu);
  _menuBar->insertItem("&Help", _helpMenu->menu());
  _helpMenu->menu()->insertSeparator();
  _helpMenu->menu()->insertItem(SmallIcon("gohome"), "&Open Kinkatta Web Site", this, SLOT(MenuSlotOpenWebSite()));
  _helpMenu->menu()->insertItem(SmallIcon("wizard"), "Check For &New Release", this, SIGNAL(checkForNewRelease()));

}

/******************************************************************************
 * Close out the client.
 ******************************************************************************/
void BuddyListWindow::closeEvent(QCloseEvent *) {
  // Close window
  emit quit();
}

/***************************************************************************
 * A buddy has been moved from one folder to another.  Move it. :)
 ***************************************************************************/
void BuddyListWindow::moveBuddy(QListViewItem* buddy, QListViewItem* folder){
	if (buddy != NULL && folder != NULL){
	  TBuddyList list = connection->buddyList();
		int folderNumber = list.getNumGroup(((BuddyListWindowItem*)folder)->name);
		list.setGroup(list.getNum(((BuddyListWindowItem*)buddy)->name),folderNumber);
		connection->setBuddyList(list);
		loadList();
	}
}

/***************************************************************************
 * Loads the ViewAll settings.
 ***************************************************************************/
void BuddyListWindow::initViewAllSetting(){
  _ViewMenu->clear();
  _ViewMenu->setCheckable(true);
  if (viewAll == true){
    viewAll = false;
    _ViewMenu->insertItem("&All Buddies", this, SLOT(ChangeViewAllSetting()),0,1);
  }
  else{
    viewAll = true;
    _ViewMenu->insertItem("&On-Line Buddies", this, SLOT(ChangeViewAllSetting()),0,1);
  }
  _ViewMenu->insertItem("&LastOn", this, SLOT(viewLastOn()),0,2);
  _ViewMenu->insertItem("&Idle", this, SLOT(viewIdle()),0,3);
  _ViewMenu->setItemChecked(2,i_aimSettings->main_showLastOn);
  _ViewMenu->setItemChecked(3,i_aimSettings->main_showIdle);
}

/***************************************************************************
 * Changes the ViewAll setting and updates the list
 ***************************************************************************/
void BuddyListWindow::ChangeViewAllSetting(){
  initViewAllSetting();
  loadList();
}

/***************************************************************************
 * Turn on/off the LastOn colume
 ***************************************************************************/
void BuddyListWindow::viewLastOn(){
  if (i_aimSettings->main_showLastOn == true)
    i_aimSettings->main_showLastOn = false;
  else
    i_aimSettings->main_showLastOn = true;
  _ViewMenu->setItemChecked(2,i_aimSettings->main_showLastOn);
  loadList();
}

/***************************************************************************
 * Turn on/off the idle colume
 ***************************************************************************/
void BuddyListWindow::viewIdle(){
  if (i_aimSettings->main_showIdle == true)
    i_aimSettings->main_showIdle = false;
  else
    i_aimSettings->main_showIdle = true;
  _ViewMenu->setItemChecked(3,i_aimSettings->main_showIdle);
  loadList();
}

/***************************************************************************
 * The tooltip from the kinkattaviewlist calls this function to see if it should
 * display a tooltip or not.
 ***************************************************************************/
toolTipData BuddyListWindow::AmIATip(const QPoint & p){

  QPoint cur = p;
	QListViewItem * item  = treeList->itemAt ( cur );
 	if (!item  || treeList->checkIfFolder(item) == true){
	  toolTipData r;
	  r.cords = QRect(0,0,-1,-1);
  	return r;
	}
	toolTipData r;

	const QString name = ((BuddyListWindowItem*)item)->name;
	TBuddyList list = connection->buddyList();
  TBuddy *buddy = list.getByNum(list.getNum(name));

  QDateTime dateTime;
  dateTime.setTime_t( buddy->signonTime );
  QDateTime current = QDateTime::currentDateTime();
  int diff = dateTime.secsTo(current);

  int days = 0;
  int minutes = 0;
  int hours = 0;

  if (diff > 60)
    minutes = diff/60;

  if (minutes > 60){
    hours = minutes/60;
    minutes = minutes%60;
  }
  if (hours > 24){
    days = hours/24;
    hours = hours%24;
  }
  QString onlineTime;
  if (days > 0)
    onlineTime = QString("%1 days %2 hours %3 minutes").arg(days).arg(hours).arg(minutes);
  else
    if (hours > 0)
      onlineTime = QString("%1 hours %2 minutes").arg(hours).arg(minutes);
	else{
    if (minutes > 1)
      onlineTime = QString("%2 minutes").arg(minutes);
    else
      onlineTime = "< 1 minute.";
  }
	if (buddy->status != TAIM_ONLINE){
	  onlineTime = "Signed Off";
	}

	QString idleTime = buddy->idleTimeString;
	if (idleTime.length() == 0)
			idleTime = "0";
	r.tip = QString("Name: ") + buddy->name + "\n" +
			            "Alias: " + buddy->alias + "\n" +
			            "Idle Time: " + idleTime + "\n" +
									"Online Time: " + onlineTime + "\n" +
								  "Last On: " + buddy->lastOnString;
	r.cords = treeList->itemRect(item);
	return r;
}

/***************************************************************************
 * The function will parse through all the names and put them up on the Tree
 ***************************************************************************/
void BuddyListWindow::loadList() {
  if(connection->getStatus() == TAIM_OFFLINE)
    return;

  //if ( loadingTheList == true)
  // return;

	loadingTheList = true;

	treeList->clear();

  // remove all columns
  while((treeList->header())->count() > 1)
    treeList->removeColumn(1);

  if(connection->getStatus() == TAIM_OFFLINE) return;
  // we're online, so get going...

  // add columns as necessary, and headers
  if ((i_aimSettings->main_showIdle) == true)
    treeList->addColumn("Idle", -1);
  if ((i_aimSettings->main_showLastOn) == true)
    treeList->addColumn("Last On", -1);

	if (i_aimSettings->main_noHeader == true)
	  (treeList->header())->hide();
	else
		(treeList->header())->show();

  // get list to use...
  TBuddyList list = connection->buddyList();
  // Set the user list to be the same as

  // Add the groups
  QString groupName = "";
	for (int i=0; i < list.getCountGroup(); i++) {
		groupName = list.getNameGroup(i);
    BuddyListWindowItem *groupItem = new BuddyListWindowItem (treeList, groupName + "(0/0)");
    groupItem->name = groupName;
    groupItem->setPixmap(0, SmallIcon("kinkatta_folder_open"));
    groupItem->setExpandable(true);
    // Add all the buddies in this group
    for (int i2=0; i2 < list.getCount(); i2++) {
      TBuddy *tempBuddy = list.getByNum(i2);
      if (tempBuddy != NULL){
        // Go through the budies seeing if they are in the group.
        if (tempBuddy->group == i){
          if (tempBuddy->status == TAIM_ONLINE || viewAll == true){
						const TBuddyGroup *gc = list.getByNumG(tempBuddy->group);
					  if(gc) addTreeBuddy(tempBuddy, groupName, gc->size);
					}
				}
			}
    }
    if (groupItem->childCount() == 0){
      const TBuddyGroup *gc = list.getByNumG(i);
      QString size = QString("%1/%2").arg(groupItem->childCount()).arg(gc->size);
      groupItem->setText(0,groupItem->name + " (" + size + ")");
    }
    groupItem->setOpen(true);
  }
  if (list.getCountGroup() == 0){
    list.addGroup(QString("Buddies"));
    // Update server & local list
    connection->setBuddyList(list);
    //connection->setServerBuddyList(list);
    viewAll = true;
    initViewAllSetting();
    // Add the folder to the gui and bring up the edit box on it.
    BuddyListWindowItem *groupItem = new BuddyListWindowItem (treeList, "Buddies (0/0)");
    groupItem->name = "Buddies";
    groupItem->setPixmap(0, SmallIcon("kinkatta_folder_open"));
    groupItem->setExpandable(true);
    //treeList->setCurrentItem(groupItem);
  }
  if (treeList->currentItem() == 0)
    treeList->setCurrentItem(treeList->firstChild());
  autoResize();
  loadingTheList = false;
}

/***************************************************************************
 * This function will add a buddy to a folder.
 ***************************************************************************/
void BuddyListWindow::addTreeBuddy(TBuddy *buddy, QString folder, int folder_size){
  BuddyListWindowItem *parent = (BuddyListWindowItem*)(treeList->firstChild());
	// Find the buddy in the tree
  while( parent != 0 ){
    if( ((BuddyListWindowItem*)(parent))->name == folder ){
	    QString alias = buddy->alias;
      QString buddyName = buddy->name;
	  	if (alias.length() == 0)
	    	alias = buddyName;
			BuddyListWindowItem *buddyItem = new BuddyListWindowItem(parent, QString(""));
			if (alias != buddyName)
			  buddyItem->setText(0, QString("@") + alias);
			else
			  buddyItem->setText(0, buddyName);
			buddyItem->name = buddyName;
			loadTreeBuddy(buddy);

			// Add number to group.
			QString size = QString("%1/%2").arg(parent->childCount()).arg(folder_size);
			parent->setText(0,parent->name + " (" + size + ")");
			break;
		}
  	parent = (BuddyListWindowItem*)(parent->nextSibling());
  }
}

/***************************************************************************
 * This function will fill the tree from the current buddy
 ***************************************************************************/
void BuddyListWindow::loadTreeBuddy(TBuddy *buddyInfo){
  if(connection->getStatus() == TAIM_OFFLINE)
    return;

  BuddyListWindowItem *parent = (BuddyListWindowItem*)(treeList->firstChild());
  BuddyListWindowItem *item = 0;
  BuddyListWindowItem *item2 = 0;

  // Check if it is a folder.
  if(parent == 0)
    return;

  // Find the buddy in the tree
  while( parent != 0 ){
    item = (BuddyListWindowItem*)parent->firstChild();
    while( item != 0 ){
      if( ((BuddyListWindowItem*)(item))->name == buddyInfo->name ){
	      item2 = (BuddyListWindowItem*)item;
  	    break;
      }
      item = (BuddyListWindowItem*)(item->nextSibling());
    }
    parent = (BuddyListWindowItem*)(parent->nextSibling());
  }

  if (item2 == 0 ){
    // The buddy must have just signed on.
    if (buddyInfo->status != TAIM_ONLINE && viewAll == false)
		  return;

		TBuddyList list = connection->buddyList();
		const TBuddyGroup *gc = list.getByNumG(buddyInfo->group);
    if(gc) addTreeBuddy(buddyInfo, list.getNameGroup(buddyInfo->group), gc->size);
    // Check to see if there is a sound configure on this buddy.
	  pounce *p = pounceMessages[ QString("*sc") + buddyInfo->name ];
    if(p){
      if (p->ignoreSettings || (i_aimSettings->SoundMode == 0) &&
      (i_aimSettings->sound_enable_login == true) ){
        sound->playFile(p->signOnSound);
				return;
			}
    }
    if((i_aimSettings->SoundMode == 1) &&
      (i_aimSettings->sound_enable_login == true) && !muteSound){
     	sound->beep();
    }
    if((i_aimSettings->SoundMode == 0) &&
      (i_aimSettings->sound_enable_login == true) && !muteSound){
       sound->playFile(i_aimSettings->sound_file_login);
    }
    return;
  }

  // We have a buddy
  if (i_aimSettings->main_showIdle == true){
    if (treeList->columnText(1) == "Idle")
 	    item2->setText(1,buddyInfo->idleTimeString);
    if (treeList->columnText(2) == "Idle")
	    item2->setText(2,buddyInfo->idleTimeString);
  }
  if (i_aimSettings->main_showLastOn == true){
    if (treeList->columnText(2) == "Last On")
      item2->setText(2,buddyInfo->lastOnString);
    if (treeList->columnText(1) == "Last On")
      item2->setText(1,buddyInfo->lastOnString);
  }

	// Set the icon
	QPixmap icon;
	if (buddyInfo->status !=  TAIM_ONLINE){
    ((BuddyListWindowItem *)item2)->setDecoration(BuddyListWindowItem::Offline);
    icon = SmallIcon("connect_no");
  }
  else{
    if (buddyInfo->signedOn == 1){
      icon =  SmallIcon("connect_established");
      ((BuddyListWindowItem *)item2)->setDecoration(BuddyListWindowItem::SignOn);
    }
		else{
			switch(buddyInfo->userClass){
        case TOC_USER_ADMIN:
          icon = SmallIcon("buddy_admin");
          break;
        case TOC_USER_AOL:
          icon = SmallIcon("buddy_aol");
          break;
        case TOC_USER_UNCONFIRMED:
          icon = SmallIcon("buddy_unknown");
          break;
        case TOC_USER_NORMAL:
          icon = SmallIcon("buddy_oscar");
          break;
        case TOC_USER_AWAY:
          icon = SmallIcon("buddy_away");
          break;
        default:
          icon = SmallIcon("buddy_unknown");
          break;
      }
			((BuddyListWindowItem *)item2)->setDecoration(BuddyListWindowItem::Online);
    }
  }
	QString buddyName = tocNormalize(buddyInfo->name);
  const pounce *pounceStruct = pounceMessages[ buddyName ];
	if(pounceStruct){
		// Create pixmap that has the same qualities as the current icon.
		QPixmap iconPounce(16,16,-1);
		iconPounce.setMask(*(icon.mask()));
		bitBlt(&iconPounce, 0,0, &icon,0,0,16,16,Qt::CopyROP, false);

		// get top mask
		QBitmap iconMask(16,16,-1);
		const QBitmap *CiconMask = iconPounce.mask();
		bitBlt(&iconMask, 0,0, CiconMask,0,0,16,16,Qt::CopyROP, false);

		// Get bottom mask
		QPixmap pounceIcon = SmallIcon("list_pounce");
		const QBitmap *pounceIconMask = pounceIcon.mask();
		bitBlt(&iconMask, 0,0, pounceIconMask, 0,0,16,16,Qt::OrROP, false);

		// Set new mask onto the new icon
		const QBitmap fm = iconMask;
		iconPounce.setMask(fm);

		// Copy new icon onto old icon.
		bitBlt(&iconPounce, 0,0, &pounceIcon, 0,0,16,16,Qt::CopyROP, false);

		item2->setPixmap(0, iconPounce);
	}
	else{
		item2->setPixmap(0, icon);
	}
}

/***************************************************************************
 * This will close all the existing open chatwindows.
 ***************************************************************************/
void BuddyListWindow::closeExistingChatwindows(){
  QDictIterator<ChatWindow> it( messageWindows );
  ChatWindow *cw;

  while( it.current() ){
    cw = messageWindows[ it.currentKey() ];
    if(cw)
      delete cw;
    messageWindows.remove( it.currentKey() );
    ++it;
  }
}

/***************************************************************************
 * This will clean up all the connections to the post* slots, and the
 * QValueLists
 ***************************************************************************/
void BuddyListWindow::clearPostConnections(void){
	QValueList<QString *>::Iterator it;

	for(it = signedOff.begin(); it != signedOff.end(); ++it){
		delete (*it);
	}
	signedOff.clear();

	for(it = signedOn.begin(); it != signedOn.end(); ++it){
		delete (*it);
	}
	signedOn.clear();

	for(it = awayMessageSent.begin(); it != awayMessageSent.end(); ++it){
		delete (*it);
	}
	awayMessageSent.clear();

	//disconnect the signals. does this disconnect the singleShots too??
	disconnect( this, SLOT(postBuddySignoff()) );
	disconnect( this, SLOT(postBuddySignon()) );
}

/***************************************************************************
 * Removes a buddy from the tree.  Called a little bit after they sign off.
 ***************************************************************************/
void BuddyListWindow::postBuddySignoff( ){
  QString *bud = 0;
	if( signedOff.count() != 0)
	 bud = signedOff.first();

  if(!bud)
    return;

	// If the buddy is actually on then don't remove him.
	TBuddyList list = connection->buddyList();
  int num = list.getNum(*bud);
  if (num == -1)
    return;
  TBuddy *buddy = list.getByNum(num);
  // Only remove him if he is not online right now
	if (buddy->status != TAIM_ONLINE){
	  if(!viewAll){ //remove the item from view only if we're not in view-All mode
	    QListViewItemIterator it( treeList );
	    for ( ; it.current(); it++ ){
				QString cName = ((BuddyListWindowItem*)it.current())->name;
	      if( cName == *bud ){
	        if(it.current()->parent()){

						TBuddy *b = list.getByNum( list.getNum(cName));
						if (b != NULL){
						  const TBuddyGroup *gc = list.getByNumG(b->group);
						  // Remove a number to group.
						  QString size = QString("%1/%2").arg( it.current()->parent()->childCount()-1 ) .arg(gc->size);
							it.current()->parent()->setText(0,((BuddyListWindowItem*)it.current()->parent())->name + " (" + size + ")");
						}
						else
							qDebug("Can't find buddy");

						it.current()->parent()->removeItem( it.current() );

	        }
	        break;
	      }
	    }
  	}
	}

  if (signedOff.isEmpty() != true){
    signedOff.remove( signedOff.begin() );
  }

  //dont leak memory:
  if(bud){
    delete bud;
  }
}

/***************************************************************************
 * Changes the icon of a buddy from just signed on to something else.
 ***************************************************************************/
void BuddyListWindow::postBuddySignon( ){
  QString *bud = 0;
	if( signedOn.count() != 0)
	  bud = signedOn.first();

  if(!bud)
    return;

	TBuddyList list = connection->buddyList();
  int num = list.getNum(*bud);
  if (num == -1)
    return;

  TBuddy *buddy = list.getByNum(num);
  if (buddy){
		buddy->signedOn = 0;
	  loadTreeBuddy(buddy);
		connection->setBuddyList(list);
	}
	if (signedOn.isEmpty() != true){
    signedOn.remove( signedOn.begin() );
  }

	//dont leak memory:
  if(bud){
    delete bud;
  }
}

/***************************************************************************
 * When a folder is expanded give it the open icon
 ***************************************************************************/
void BuddyListWindow::folderExpanded ( QListViewItem* item ){
  item->setPixmap(0, SmallIcon("kinkatta_folder_open"));
}

/***************************************************************************
 * When a folder is closed give it the closed icon
 ***************************************************************************/
void BuddyListWindow::folderCollapsed ( QListViewItem* item ){
  item->setPixmap(0, SmallIcon("kinkatta_folder_closed"));
}

/***************************************************************************
 * The server will update a buddy
 ***************************************************************************/
void BuddyListWindow::buddyChanged(int number){
  TBuddyList list = connection->buddyList();
  TBuddy *bud = list.getByNum(number);
  loadTreeBuddy(bud);
  // If signed off tell chat window and play sound if needed
  if (bud->status !=  TAIM_ONLINE){

    // Check to see if there is a sound configure on this buddy.
    pounce *p = pounceMessages[ QString("*sc") + bud->name ];
    bool playedSound = false;
    if(p){
      if (p->ignoreSettings || (i_aimSettings->SoundMode == 0) &&
      (i_aimSettings->sound_enable_logout == true) ){
        sound->playFile(p->signOffSound);
        playedSound = true;
      }
    }
    if (playedSound == false) {
			if((i_aimSettings->SoundMode == 1) &&
       	(i_aimSettings->sound_enable_logout == true) && !muteSound){
      	sound->beep();
    	}
    	if((i_aimSettings->SoundMode == 0) &&
       	(i_aimSettings->sound_enable_logout == true) && !muteSound){
      	 sound->playFile(i_aimSettings->sound_file_logout);
      }
    }
    QString ChatWindowName = i_aimSettings->login_name + tocNormalize(bud->name);
    ChatWindow *targetWindow = messageWindows[ ChatWindowName ];
    if(targetWindow)
      targetWindow->buddySignedOff();

    //add to the signedOff users list
    signedOff += new QString(bud->name);
    // Timer to remove item
    QTimer::singleShot( POST_BUDDY_SIGNOFF_DELAY *1000, this, SLOT(postBuddySignoff()));
 
    QString date = ((QDate::currentDate ()).toString());
    QString CurrentTime = QTime::currentTime().toString();
    if (logOpen){
      logStream << date << " " << CurrentTime << " : " << tocNormalize(bud->name) << " Signed Off." << endl;
    logFile.flush();
  }

  }
  autoResize();
}

/***************************************************************************
 * Buddy Just signed on tell any chat window that need to know
 ***************************************************************************/
void BuddyListWindow::buddySignedOn(QString buddy){
  QString ChatWindowName = i_aimSettings->login_name + tocNormalize(buddy);
  ChatWindow *targetWindow = messageWindows[ ChatWindowName ];
  if(targetWindow)
    targetWindow->buddySignedOn();

  TBuddyList list = connection->buddyList();
  TBuddy *bud = list.getByNum(list.getNum(buddy));
  if (bud){
    bud->signedOn = 1;
    loadTreeBuddy(bud);
    signedOn += new QString(buddy);
    QTimer::singleShot( POST_BUDDY_SIGNON_DELAY *1000, this, SLOT(postBuddySignon()));
    connection->setBuddyList(list);
  }
  pounce_CheckSignOn(buddy);

  QString date = ((QDate::currentDate ()).toString());
  QString CurrentTime = QTime::currentTime().toString();
  if ( true == logOpen ){
    logStream << date << " " << CurrentTime << " : " << tocNormalize(buddy) << " Signed On." << endl;
    logFile.flush();
  }
}

/***************************************************************************
 * Item in tree was selected/double clicked.  Open chat window
 ***************************************************************************/
void BuddyListWindow::DoubleClicked(){
  if (treeList->currentItem() == 0)
    treeList->setCurrentItem(treeList->firstChild());
  TreeSelected(treeList->selectedItem());
}

/***************************************************************************
 * Item in tree was selected/double clicked.  Open chat window
 ***************************************************************************/
void BuddyListWindow::TreeSelected(QListViewItem* selected){
  //qDebug("TreeSelected Called.");
  
  // If somehow we got a NULL just return
  if (selected == NULL)
     return;
  bool oldwindow = false;
  // If not a folder
  if (treeList->checkIfFolder(selected) == false){
    const QString buddyName = ((BuddyListWindowItem*)selected)->name;
    // check for window already exists
    if (messageWindows [i_aimSettings->login_name + tocNormalize(buddyName)] != NULL) {
	oldwindow = true;
    };
    ChatWindow *targetWindow = messageWindow(buddyName);
    // if this window was already there...then bring it up...
    if (oldwindow) {
        QRect thisGeometry = targetWindow->frameGeometry();
	targetWindow->hide();
        targetWindow->setGeometry(thisGeometry.x(), thisGeometry.y(), targetWindow->width(), targetWindow->height());
        targetWindow->show();
    };
    if (targetWindow != 0)
      targetWindow->show();
  } else {
    // if it is a folder...
    // KListView is not automatically doing this on double-click...
    if (selected->isOpen())
	selected->setOpen(false);
    else
	selected->setOpen(true);
  }
}

/***************************************************************************
 * Settings changed tell things to update
 ***************************************************************************/
void BuddyListWindow::settingsChanged(){
  if(connection->getStatus() == TAIM_OFFLINE)
    return;

  initOptions();
  emit (updateChatSettings());
  emit (updateChatColorSettings());
  emit (updateChatFontSettings());
  emit (updateChatSoundSettings());
  initAwayList();
}

/***************************************************************************
 * Add a buddy to the list
 ***************************************************************************/
void BuddyListWindow::slotAddBuddy(){
  //Make sure a folder exists and is selected
  if (treeList->currentItem() == 0)
    treeList->setCurrentItem(treeList->firstChild());
  if(!treeList->selectedItem())
  {
    QMessageBox::warning( 0, "Kinkatta - Add Buddy",
      "Please select a folder",
      "OK", /*"Quit",*/ 0,
      0, 1 );
    return;
  }
  QString name;
  bool ok = FALSE;
  QString text = QInputDialog::getText( tr( "Kinkatta - Enter Buddy's Name" ), tr( "Please enter the buddy's name" ), QString::null, &ok, this );
  if ( ok && !text.isEmpty() )
    slotAddBuddy(text);// user entered something and pressed ok
  else
    return	;// user entered nothing or pressed cancel
  emit (saveSettings());
}

/***************************************************************************
 * Add a buddy to the list (buddyName)
 ***************************************************************************/
void BuddyListWindow::slotAddBuddy(QString buddyName){
  TBuddyList list = connection->buddyList();
  int groupNumber = 0;
  BuddyListWindowItem *cItem = (BuddyListWindowItem*)(treeList->selectedItem());
  // If window is highlighted get group number.
  if ( cItem != NULL){
    if (treeList->checkIfFolder(cItem) == true){
      groupNumber = list.getNumGroup(cItem->name);
    }
    else{
      //get parent
      BuddyListWindowItem *parent = (BuddyListWindowItem*)(cItem->parent());
      groupNumber = list.getNumGroup(parent->name);
    }
  }

  // Update server
  TBuddy *edited = new TBuddy();
  edited->name = buddyName;
  edited->group = groupNumber;
  edited->status = TAIM_OFFLINE;
  edited->userClass = 0;
  edited->signonTime = 0;
  edited->evil = 0;

  list.add(edited);
  connection->setBuddyList(list);
  //connection->tocaddBuddy(list, buddyName);
  loadList();
  delete edited;

  emit updateIfIsBuddy(buddyName, true);
}

/***************************************************************************
 * Removes a buddy from the list
 * Gets currently selected buddy and calls slotRemoveBuddy(name)
 ***************************************************************************/
void BuddyListWindow::slotRemoveBuddy(){
  QString name = treeList->currentName();
  slotRemoveBuddy(name);
  emit (saveSettings());
}

/******************************************************************************
 * Remove the buddy from the current list
 * @Peram name - Name of the buddy that is to be removed
 *****************************************************************************/
void BuddyListWindow::slotRemoveBuddy(QString name){
  int answer = QMessageBox::warning(0, "Kinkatta - Remove Buddy",
    "Do you wish to remove this buddy from your buddylist?",
    "Yes", "Cancel", 0,1);
  if (!answer){
    TBuddyList list = connection->buddyList();
    list.del(list.getNum(name));
    connection->setBuddyList(list);
    //connection->tocremoveBuddy(list, name);
    //connection->setServerBuddyList(list);
    loadList();
    emit updateIfIsBuddy(name, false);
  }
}

/***************************************************************************
 * Add a new folder to the list.
 ***************************************************************************/
void BuddyListWindow::slotAddFolder(){
  // Get current list
  TBuddyList list = connection->buddyList();
  list.addGroup(QString("NewFolder"));
  // Update server list
  connection->setBuddyList(list);
  //connection->setServerBuddyList(list);
  viewAll = true;
  initViewAllSetting();
  // Add the folder to the gui and bring up the edit box on it.
  BuddyListWindowItem *groupItem = new BuddyListWindowItem (treeList, "NewFolder (0/0)");
  groupItem->setPixmap(0, SmallIcon("kinkatta_folder_open"));
  groupItem->name = "NewFolder";
	treeList->setCurrentItem(groupItem);
  slotEditBuddy();
  treeList->setSorting(0,1);
  treeList->sort();
  emit (saveSettings());
}

/***************************************************************************
 * Remove the current selected folder
 ***************************************************************************/
void BuddyListWindow::slotRemoveFolder(){
	if( treeList->currentItem() )
		slotRemoveFolder( treeList->currentName() );
}

/***************************************************************************
 * Remove the passed folder
 ***************************************************************************/
void BuddyListWindow::slotRemoveFolder(QString group){
  int answer = QMessageBox::warning(this, "Kinkatta - Remove Folder",
    "Do you wish to remove this folder from your buddylist?\nAll buddies in the folder will be lost.",
    "Yes", "Cancel", 0,1);
  if (!answer){
    TBuddyList list = connection->buddyList();
    list.delGroup(list.getNumGroup( group ));
    connection->setBuddyList(list);
    //connection->setServerBuddyList(list);
    loadList();
  }
  emit (saveSettings());
}

/***************************************************************************
 * Get information button clicked, get current highlighted name and get info
 ***************************************************************************/
void BuddyListWindow::slotGetBuddyInfo(){
  if (treeList->currentItem() == 0)
    treeList->setCurrentItem(treeList->firstChild());
  const QString name = treeList->currentName();
  if (treeList->checkIfFolder(treeList->currentItem()) == false){
    slotGetBuddyInfo( name );
  }
  else{
    bool ok = FALSE;
    QString text = QInputDialog::getText( tr( "Enter Buddy's Name" ), tr( "Please enter the buddy's name" ), QString::null, &ok, this );
    if ( ok && !text.isEmpty() )
      slotGetBuddyInfo( text );
  }
}

/***************************************************************************
 * Get Information on a user
 ***************************************************************************/
void BuddyListWindow::slotGetBuddyInfo(QString name){
  TWINDOW_AIM_SANITY_CHECK;
  if(awayRightNow == true)
    away_Back();
  connection->requestUserInfo( name );
}

/***************************************************************************
 * Info has been recieved
 * @Peram string - The info that was recieved
 ***************************************************************************/
void BuddyListWindow::slotBuddyInfoRecieved(QString string){
  Info *infoBox = new Info(0, "infoBox");
  infoBox->user = i_aimSettings->login_name;
  infoBox->addToWindow(string);
  infoBox->setCaption("Kinkatta - Information");
  infoBox->setIcon(SmallIcon("kinkatta"));
  infoBox->browser = browser;
  infoBox->show();
}

/***************************************************************************
 * Bring up the edit box on the currently selected user.
 ***************************************************************************/
void BuddyListWindow::slotEditBuddy(){
  QString name = "";
  BuddyListWindowItem *cItem = treeList->currentItem();
  name = cItem->name;

  treeList->buddyEdit->setText("");
  treeList->buddyEdit->setText(name);

  QRect r = treeList->itemRect(cItem);
  int x = r.x()+35;
  if (treeList->checkIfFolder(cItem) == true)
    x = x - 19;
  int y = r.y();
  int width = treeList->columnWidth(0)-x;
  int height = r.height();

  treeList->buddyEdit->setGeometry(x,y,width,height);
  treeList->moveChild(treeList->buddyEdit,x,y);
  treeList->buddyEdit->setMinimumSize(width,height);
  treeList->buddyEdit->setMaximumSize(width,height);

  // Showing it will give it focus
  treeList->buddyEdit->focus = 0;
  treeList->buddyEdit->alias = false;
  treeList->buddyEdit->show();
  treeList->buddyEdit->setFocus();
  treeList->buddyEdit->setSelection(0,treeList->buddyEdit->maxLength());
}

/***************************************************************************
 * Bring up the edit box on the currently selected user.
 ***************************************************************************/
void BuddyListWindow::slotEditAlias(){
  QString name = "";
  BuddyListWindowItem *cItem = treeList->currentItem();
  if (treeList->checkIfFolder(cItem)){
    // Folders don't have aliases
    return;
  }
  name = cItem->text(0);
  // Remove @
  if (name != cItem->name)
    name = name.mid(1, name.length()-1);

  treeList->buddyEdit->setText("");
  treeList->buddyEdit->setText(name);

  QRect r = treeList->itemRect(cItem);
  int x = r.x()+35;
  int y = r.y();
  int width = treeList->columnWidth(0)-x;
  int height = r.height();

  treeList->buddyEdit->setGeometry(x,y,width,height);
  treeList->moveChild(treeList->buddyEdit,x,y);
  treeList->buddyEdit->setMinimumSize(width,height);
  treeList->buddyEdit->setMaximumSize(width,height);

  // Showing it will give it focus
  treeList->buddyEdit->focus = 0;
  treeList->buddyEdit->alias = true;
  treeList->buddyEdit->show();
  treeList->buddyEdit->setFocus();
  treeList->buddyEdit->setSelection(0,treeList->buddyEdit->maxLength());
}

/***************************************************************************
 * Once the edit window is gone update the name
 ***************************************************************************/
void BuddyListWindow::changeBuddyName(){
  BuddyListWindowItem *cItem = treeList->currentItem();
  QString oldName = "";
  QString realName = "";

  if ( cItem == NULL)
    return;
  
  realName = cItem->name;
  if (treeList->buddyEdit->alias == true){
    oldName = cItem->text(0);
    if (oldName != realName)
      oldName = oldName.mid(1, oldName.length()-1);
  }
  else
    oldName = realName;

  QString newName = treeList->buddyEdit->text();

  // Update List
  TBuddyList list = connection->buddyList();
  if (treeList->checkIfFolder(cItem) == true){
    list.renameGroup( oldName, newName );
    connection->setBuddyList(list);
    loadList();
  }
  else{
    TBuddy *edited = list.getByNum(list.getNum(realName));
    if (edited){
      if (treeList->buddyEdit->alias == true)
        edited->alias = newName;
      else
        edited->name = newName;
        connection->setBuddyList(list);
        loadList();
      }
  }
  
  treeList->buddyEdit->hide();
  emit (saveSettings());
}

/***************************************************************************
 * The tree was clicked with the right mouse button, open  the menu.
 ***************************************************************************/
void BuddyListWindow::rightClickInTree(QListViewItem *, const QPoint &pos, int){
  _TreeMenu->clear();
  if (treeList->currentItem() == 0)
    treeList->setCurrentItem(treeList->firstChild());
  if(treeList->currentItem() != NULL)	{
    QString buddyName = treeList->currentName();
    // Check for folder
    QListViewItem *selected = treeList->currentItem();
    if (treeList->checkIfFolder(selected) == true){
      _TreeMenu->insertItem(SmallIcon("kinkatta_buddy_add"), "&Add Buddy...", this, SLOT(slotAddBuddy()));
      _TreeMenu->insertSeparator();
      _TreeMenu->insertItem(SmallIcon("kinkatta_folder_create"), "Add &Folder", this, SLOT(slotAddFolder()));
      _TreeMenu->insertItem(SmallIcon("kinkatta_folder_remove"), "&Remove Folder...", this, SLOT(slotRemoveFolder()));
      _TreeMenu->insertSeparator();
      _TreeMenu->insertItem(SmallIcon("edit"), "&Edit Folder", this, SLOT(slotEditBuddy()));
    }
    else {
      _TreeMenu->insertItem(SmallIcon("chat"), "&New Instant Message", this, SLOT(DoubleClicked()));
      _TreeMenu->insertItem(SmallIcon("buddy_info"), "&Get Buddy Info", this, SLOT(slotGetBuddyInfo()));
      int getAway = _TreeMenu->insertItem(SmallIcon("kinkatta_getaway"), "Get Away &Message", this, SLOT(getBuddyAwayMessage()));
      _TreeMenu->insertItem(SmallIcon("kinkatta_buddy_remove"), "&Remove Buddy...", this, SLOT(slotRemoveBuddy()));
      _TreeMenu->insertItem(SmallIcon("history"), "&Open Logs Folder", this, SLOT(slotOpenLogs()));
      _TreeMenu->insertItem(SmallIcon("bottom"),"&Pounce...", this, SLOT(pounce_SlotAddDialogWithBuddy()));
      _TreeMenu->insertItem(SmallIcon("edit"), "&Edit Buddy", this, SLOT(slotEditBuddy()));
      _TreeMenu->insertItem(SmallIcon("edit"), "Edit &Alias", this, SLOT(slotEditAlias()));
			_TreeMenu->insertItem(SmallIcon("kinkatta_bell"), "Edit &Sound", this, SLOT(editSoundConfig()));
      // Check if the buddy is online or not.
      TBuddyList list = connection->buddyList();
      TBuddy *bud = list.getByNum(list.getNum(buddyName));
      if (bud->userClass != TOC_USER_AWAY)
        _TreeMenu->setItemEnabled(getAway, FALSE);
    }
  }
  _TreeMenu->insertSeparator();
  _TreeMenu->insertItem(SmallIcon("transform"), "&View", _ViewMenu);
  _TreeMenu->exec(pos);
}

/***************************************************************************
 * Open buddies logs in netscape
 ***************************************************************************/
void BuddyListWindow::slotOpenLogs(){
  QString buddy = treeList->currentName();
  buddy = tocNormalize(buddy);
  QDir newDir("/dev/null");
  // Make sure the dir is there
  newDir.mkdir(QDir::homeDirPath() + "/." + QString(APP_LOWERCASE_NAME), true);
  newDir.mkdir(QDir::homeDirPath() + "/." + QString(APP_LOWERCASE_NAME) + "/logs/", true);
  QString logDirStr = QDir::homeDirPath() + "/." + APP_LOWERCASE_NAME + "/logs/" + buddy + "/";

  newDir.mkdir(logDirStr,true);

  QDir logDir(logDirStr);

  // If there is only 1 log file and its [buddy].log, I bet they want that
  if ( (logDir.count() == 3 ) && QFile( logDirStr + buddy + ".log" ).exists() )
    logDirStr += buddy + ".log";

  browser->openURL( logDirStr );
}

/***************************************************************************
 * We're about to show the file menu, so set the appropriate items in the buddy
 * popup menu and the folder popup menu activated or inactivated.
 ***************************************************************************/
void BuddyListWindow::aboutToShowFileMenu(){
  QListViewItem *selected = treeList->selectedItem();
  if(!selected){
    _FolderMenu->setItemEnabled(id_folderEdit, FALSE);
    _FolderMenu->setItemEnabled(id_folderRemove, FALSE);
    _FileMenu->setItemEnabled(id_buddyList, FALSE);
    return;
  }

  if( treeList->checkIfFolder(selected) ){
    _FolderMenu->setItemEnabled(id_folderEdit, TRUE);
    _FolderMenu->setItemEnabled(id_folderRemove, TRUE);
    _FileMenu->setItemEnabled(id_buddyList, FALSE);
  } else { //not a folder
    _FolderMenu->setItemEnabled(id_folderEdit, FALSE);
    _FolderMenu->setItemEnabled(id_folderRemove, FALSE);
    _FileMenu->setItemEnabled(id_buddyList, TRUE);

    // Check if the buddy is online or not.
    QString buddyName = treeList->currentName();
    TBuddyList list = connection->buddyList();
    TBuddy *bud = list.getByNum(list.getNum(buddyName));
    if (bud->userClass != TOC_USER_AWAY)
      _BuddyMenu->setItemEnabled(id_buddyAway, false);
    else
      _BuddyMenu->setItemEnabled(id_buddyAway, true);
  }
}

/***************************************************************************
 * About - Displays the about box
 ***************************************************************************/
void BuddyListWindow::MenuSlotAboutKinkatta(){
  QMessageBox *about= new QMessageBox(0, "About Kinkatta");
  about->setCaption("About Kinkatta...");
  about->setText(
  (QString)"Kinkatta " + i_aimSettings->Version + " (" + i_aimSettings->ReleaseDate +")\n"
  "(c) 2001 Benjamin Meyer\n"
  "ben@meyerhome.net\n"
  "\n"
  "Developers:\n"
  " Benjamin Meyer <ben@meyerhome.net>\n"
  " Dimi Shahbaz <dshahbaz@ucla.edu>\n"
  " Jim Wilson <jimw@kelcomaine.com>\n"
  "\n"
  "Contributions:\n"
  " Neil Stevens <multivac@fcmail.com>\n"
  " David Johnson <david@usermode.org>\n"
  " Bob Herrmann <bob@jadn.com>\n"
  "\n"
  "Kinkatta is a AOL instant messenger for QT2.x\n"
  "If you have any suggestions/comments/bugs \n"
  "please contact the Kinkatta team.\n"
  "\n"
  "For more information you can visit the Kinkatta\n"
  "webpage at \"http://kinkatta.sourceforge.net/\".\n"
  "\n"
  "This program is dual licensed under the GPL\n"
  "and LGPL license. For more information\n"
  "goto \"http://www.gnu.org\".");
  about->setIconPixmap(DesktopIcon("kinkatta"));
  //about->setIcon(QMessageBox::Information);
  about->setIcon(SmallIcon("kinkatta"));
  about->show();
}


/***************************************************************************
 * Using the current broswer (selected in options) opens the kinkatta web site.
 ***************************************************************************/
void BuddyListWindow::MenuSlotOpenWebSite(){
  browser->openURL("http://kinkatta.sourceforge.net/");
}

/***************************************************************************
 * Brings up the Menu when the right mouse is clicked.
 ***************************************************************************/
void BuddyListWindow::mouseReleaseEvent(QMouseEvent* event){
  if (event->button() == RightButton){
    _AwayMenu->hide();
  }
}

/***************************************************************************
 * Bring up the dialog to change the users password, connect to network
 ***************************************************************************/
void BuddyListWindow::changePassword(){
  KitPasswordChanger dlg;
	dlg.setOldPassword(i_aimSettings->login_password);
 	dlg.setIcon(SmallIcon("kinkatta"));
  if(dlg.exec()) {
		connection->changePassword(dlg.oldPassword(), dlg.newPassword());
	  // newPassword = dlg.newPassword();
	}
}


/***************************************************************************
 * When we sign on, start this timer so that the sign-on sound is not played
 * repeatedly for all the already online buddies.
 ***************************************************************************/
void BuddyListWindow::startMutePeriod(){
	muteSound = TRUE;
	QTimer::singleShot( SOUND_MUTE_ON_LOGIN_TIME*1000, this, SLOT(endMutePeriod()));
}

/***************************************************************************
 * When signed on the option to turn off the sound would call a 10 second
 * timer that would in turn call this to turn it back on.
 ***************************************************************************/
void BuddyListWindow::endMutePeriod(){
	muteSound = FALSE;
}

/***************************************************************************
 * Resizes the object in the window, when the window is resized.
 ***************************************************************************/
void BuddyListWindow::resizeEvent ( QResizeEvent* ) {
  autoResizing = true;
  int mid = this->width()/2;

  if(awayRightNow == false){
    if (i_aimSettings->main_noIcons == true){
       treeList->setGeometry (5, _menuBar->height(), this->width()-10, this->height()-28);
    }
    else{
      treeList->setGeometry (5, _menuBar->height(), this->width()-10, this->height()-75);
      chatButton->setGeometry (mid-65, this->height()-45, 40, 40);
      awayButton->setGeometry (mid-20, this->height()-45, 40, 40);
      infoButton->setGeometry (mid+25, this->height()-45, 40, 40);
    }
  }
  else { //awayRightNow == true
    if (i_aimSettings->main_noIcons == true){
      treeList->setGeometry (5, _menuBar->height(), this->width()-10, this->height()-28-DEFAULT_AWAYWIDGET_HEIGHT);
      awayWidget->setGeometry(0, this->height()-DEFAULT_AWAYWIDGET_HEIGHT, treeList->width(), DEFAULT_AWAYWIDGET_HEIGHT);
    }
    else{
     treeList->setGeometry (5, _menuBar->height(), this->width()-10, (this->height()-75-DEFAULT_AWAYWIDGET_HEIGHT));
     chatButton->setGeometry (mid-65, this->height()-45-DEFAULT_AWAYWIDGET_HEIGHT, 40, 40);
     awayButton->setGeometry (mid-20, this->height()-45-DEFAULT_AWAYWIDGET_HEIGHT, 40, 40);
     infoButton->setGeometry (mid+25, this->height()-45-DEFAULT_AWAYWIDGET_HEIGHT, 40, 40);
     awayWidget->setGeometry (0, this->height()-DEFAULT_AWAYWIDGET_HEIGHT, this->width(), DEFAULT_AWAYWIDGET_HEIGHT);
    }
  }
  autoResizing = false;
}


/***************************************************************************
 * Resizes the object in the window.
 ***************************************************************************/
void BuddyListWindow::autoResize(){
  if (autoResizing == true)
    return;
  autoResizing = true;

  // If it is off then we are still in this loop and exit.
  if (treeList->vScrollBarMode() == QScrollView::AlwaysOff ||
      treeList->vScrollBarMode() == QScrollView::AlwaysOff ){
    return;
  }

  if (treeList->vScrollBarMode() == QScrollView::Auto &&
      treeList->vScrollBarMode() == QScrollView::Auto ){
    treeList->setVScrollBarMode(QScrollView::AlwaysOff);
    treeList->setHScrollBarMode(QScrollView::AlwaysOff);
    qApp->processEvents();
  }
  else
    return;

  bool greaterThenMaxHeight = false;

  if (i_aimSettings->main_resizeHeight == true){
    int newHeight;
    //if (treeList->contentsWidth() != treeList->visibleWidth()){
       //newHeight += treeList->horizontalScrollBar()->height();
    //}
    newHeight = this->height()+(treeList->contentsHeight() - treeList->visibleHeight());
    int diff =  newHeight-(treeList->height());
    if (diff > -9){
      if (newHeight > i_aimSettings->main_resizeHeightMin && newHeight < i_aimSettings->main_resizeHeightMax)
        emit(set_window(this->width(), newHeight+6));
      else
        greaterThenMaxHeight = true;
    }
  }

  if (i_aimSettings->main_resizeWidth == true){
    int width = 10;
    //if (treeList->contentsHeight() != treeList->visibleHeight()){
    if (greaterThenMaxHeight == true){
      width += 15; //treeList->verticalScrollBar()->width();
    }
    //}
    int numberOfHeaders = (treeList->header())->count();
    for (int i = numberOfHeaders; i > 0; i--)
      width += treeList->columnWidth(i-1);
    // Add frame boarder
    width += treeList->lineWidth()*2+2;
    if ( width != treeList->width() ){
    	//int diff = width-(treeList->height());
    	//if (diff > -1){
				if (width > i_aimSettings->main_resizeWidthMin && width < i_aimSettings->main_resizeWidthMax)
        	emit(set_window(width, this->height()));
  		//}
		}
	}

  if (treeList->vScrollBarMode() != QScrollView::Auto &&
      treeList->vScrollBarMode() != QScrollView::Auto ){
    treeList->setVScrollBarMode(QScrollView::Auto);
    treeList->setHScrollBarMode(QScrollView::Auto);
  }
  autoResizing = false;
}


/***************************************************************************
 * Edit the currently selected buddy's sound config.  If they already have
 * one then it should be loaded.
 ***************************************************************************/
void BuddyListWindow::editSoundConfig(){
  if (!treeList->currentName())
    treeList->setCurrentItem(treeList->firstChild());

  const QString name = treeList->currentName();
  if (treeList->checkIfFolder(treeList->currentItem()) == true){
    return;
  }

  SoundConfigureImp *sc = new SoundConfigureImp(this, "SoundConfigure");
	connect(sc, SIGNAL(updateOrAddPounce(pounce)), this, SLOT(setSoundConfig(pounce)));

	pounce p;
  p.buddyName = name;
	p.signOnSound = i_aimSettings->sound_file_login;
	p.signOffSound = i_aimSettings->sound_file_logout;
  p.ignoreSettings = false;
  sc->setDefault(&p);
  sc->setPounce(&p);

  // If there is already a Pounce you want to edit it.
  QString buddyName = tocNormalize(name);
  pounce *pounceStruct = pounceMessages[ QString("*sc") + buddyName ];
  if (pounceStruct){
    //qDebug("Foudn old pounce");
    sc->setPounce(pounceStruct);
  }
	sc->show();
}

/***************************************************************************
 * update a buddy's sound config.  If the sound config it == to the default
 * then it should be removed.
 ***************************************************************************/
void BuddyListWindow::setSoundConfig(pounce newPounce){
  QString BuddyName = newPounce.buddyName;
  QString realName = BuddyName;
  BuddyName = tocNormalize(BuddyName);

  if (newPounce.signOnSound == i_aimSettings->sound_file_login &&
	newPounce.signOffSound == i_aimSettings->sound_file_logout &&
  newPounce.ignoreSettings == false){
    pounce *newPounceStruct = pounceMessages[  QString("*sc") + BuddyName ];
    if(newPounceStruct)
      pounceMessages.remove( QString("*sc") + BuddyName);
    //qDebug("Removed Pounces");
    i_aimSettings->pounces = pounceMessages;
		setup::instance()->savePounces(i_aimSettings->login_name,i_aimSettings->pounces);
		return;
  }
	pounce *newPounceStruct = pounceMessages[ QString("*sc") + BuddyName ];
  if(!newPounceStruct){
    pounce *p = new pounce();
		p->buddyName = newPounce.buddyName;
 	  p->hidden = true;
		p->doNotRemove = true;
    p->signOn = false;
		p->returnAway = false;
		p->returnIdle = false;
		p->openChat = false;
		p->sendMessage = false;
		p->execCommand = false;
		p->command = "";
		p->message = "";
		p->signOnSound = newPounce.signOnSound;
	  p->signOffSound = newPounce.signOffSound;
		p->ignoreSettings = newPounce.ignoreSettings;
    pounceMessages.insert( QString("*sc") + BuddyName, p);
    i_aimSettings->pounces = pounceMessages;
		setup::instance()->savePounces(i_aimSettings->login_name,i_aimSettings->pounces);
	}
  else{
		newPounceStruct->signOnSound = newPounce.signOnSound;
		newPounceStruct->signOffSound = newPounce.signOffSound;
		newPounceStruct->ignoreSettings = newPounce.ignoreSettings;
    i_aimSettings->pounces = pounceMessages;
		setup::instance()->savePounces(i_aimSettings->login_name,i_aimSettings->pounces);
  }
  //qDebug("New Pouncesc/update!");
}



/**
 *
 *
 * The away Functions.
 *
 *
 */

/***************************************************************************
 * We want someone's away message, send the Automated Message.
 ***************************************************************************/
void BuddyListWindow::getBuddyAwayMessage(){
  QString autoMessage(">>>Automated Message: Getting Away Message<<<");

  if (treeList->currentItem() == 0)
    treeList->setCurrentItem(treeList->firstChild());
  const QString buddyName = treeList->currentName();

  bool isAuto = false;
  bool endIdleness = true;
  awayMessageGetting += tocNormalize(buddyName);
  connection->sendIM(autoMessage,buddyName, isAuto, endIdleness);
  QTimer::singleShot( POST_GET_AWAY_MESSAGE *1000, this, SLOT(remove_getBuddyAwayMessage()));
}

/***************************************************************************
 * If we don't get a response in less then 2 seconds kill the getAway.
 ***************************************************************************/
void BuddyListWindow::remove_getBuddyAwayMessage(){
  if (awayMessageGetting.begin() != awayMessageGetting.end())
    awayMessageGetting.remove(awayMessageGetting.begin());
}

/***************************************************************************
 * When a message comes in, the buddy is send here to make sure that we
 * didn't request it less then 2 seconds ago.
 ***************************************************************************/
bool BuddyListWindow::checkIfGotBuddyAwayMessage(QString buddyName){
  QValueList<QString>::Iterator t;
  t = awayMessageGetting.find(tocNormalize(buddyName));
  if ( t == awayMessageGetting.end() ){
    return false;
  }
  else{
    awayMessageGetting.remove(t);
    return true;
  }
}

/***************************************************************************
 * 5 minutes after a away message is sent the send away message again is
 * turned back on.
 ***************************************************************************/
void BuddyListWindow::postAwayMessageSent( ){
	QString *bud = 0;
	if( awayMessageSent.count() != 0)
  	bud = awayMessageSent.first();

  if(!bud)
    return;
  QString normedName = tocNormalize(*bud);
  QString ChatWindowName = (i_aimSettings->login_name) + normedName;
  ChatWindow *targetWindow = messageWindows[ChatWindowName];
  if(targetWindow){
    targetWindow->sentAwayMessageToBuddy = false;
  }

  if (awayMessageSent.isEmpty() != true){
		awayMessageSent.remove( awayMessageSent.begin() );
	}

	//dont leak memory:
  if(bud){
    delete bud;
  }
}

/***************************************************************************
 * Loads the Awaylist under the list.
 ***************************************************************************/
void BuddyListWindow::initAwayList(){
  _AwayMenu->clear();
	QMap <QString, QString>::Iterator it;
	int count = 1;
	for(it = i_aimSettings->mapAwayMessages->begin();
			it != i_aimSettings->mapAwayMessages->end(); ++it){
		_AwayMenu->insertItem(it.key(), count++);
	}
	_AwayMenu->insertSeparator();
  _AwayMenu->insertItem("&New Message...", this, SLOT(away_AddAwayMessage()),
						0, NEW_AWAY_MESSAGE_MENU_ID);

}

/***************************************************************************
 * The away button was clicked show the list there.
 ***************************************************************************/
void BuddyListWindow::away_ShowAwayList(){
  initAwayList();
  QPoint temp(this->parentWidget()->x()+awayButton->x()+20,this->parentWidget()->y()+awayButton->y()+50);
  _AwayMenu->exec(temp);
  awayButton->setDown(false);
}

/***************************************************************************
 * The auto away timer has signaled, set user as away.
 ***************************************************************************/
void BuddyListWindow::away_SetAutoAway(){
  //set the autoAway to the correct away message as specified by the user
  if (i_aimSettings->away_enable_auto == true){
    if (awayRightNow == false)
      away_makeAwayNow(i_aimSettings->away_auto_default_message);
  }
}

/***************************************************************************
 * Add a new away message.
 ***************************************************************************/
void BuddyListWindow::away_AddAwayMessage(){
//  QMessageBox::information(this, "Away Messages","Use program/options to add away\nmessages for the time being.", QMessageBox::Ok);
  NewAwayMessage *newMessage = new NewAwayMessage(this, "newAwayMessage");
  newMessage->setCaption("Kinkatta - New Away Message");

  connect(newMessage, SIGNAL(makeAwayNow(QString)), this, SLOT(away_makeAwayNow(QString)));
	connect(newMessage, SIGNAL(saveSettings()), this, SIGNAL(saveSettings()));
  newMessage->show();
}

/***************************************************************************
 * Find out what number name is in the list and call away(int)
 ***************************************************************************/
void BuddyListWindow::away_makeAwayNow(QString name){
  int count = 1;
  int choice = -1;
	QMap <QString, QString>::Iterator it;
	for(it = i_aimSettings->mapAwayMessages->begin();
			it != i_aimSettings->mapAwayMessages->end(); ++it){
		if(it.key() == name){
			choice = count;
		}
		count++;
	}
  if (choice != -1){
    away_GoAway(choice);
  }
}

/***************************************************************************
 * Set the away message to text
 ***************************************************************************/
void BuddyListWindow::away_Update(QString text){
  //connection->setAwayMessage(text);
	awayMessage = text;
}

/***************************************************************************
 * Set Kinkatta to away mode.
 ***************************************************************************/
void BuddyListWindow::away_GoAway(int num){
  if(num == NEW_AWAY_MESSAGE_MENU_ID)
    return;
  
  sound->muteSound(i_aimSettings->away_disable_sound);

  QMap <QString, QString>::Iterator it;
  int count = 1;
  emit statusChanged(TAIM_AWAY);
  
  for(it = i_aimSettings->mapAwayMessages->begin();
    it != i_aimSettings->mapAwayMessages->end(); ++it){
      if(count == num){
			awayWidget->setText(it.data());
			awayMessage = it.data();
			if( awayRightNow == false){
				QString message = it.data();
				if (message.length() > 1000){
				  message = message.mid(0, 950);
				  message = message + "... Im me for the rest of this away message.";
				}
				connection->setAwayMessage(message);
			}
			break;
		} else {
			count++;
		}
	}
  if ((num != 0) && (num == count)){
    awayWidget->show();
    if (awayRightNow == false){
      awayRightNow = true;
      if ((i_aimSettings->main_resizeHeight == true && i_aimSettings->main_resizeHeightMax < this->height() + DEFAULT_AWAYWIDGET_HEIGHT) || i_aimSettings->main_resizeHeight == false)
      emit(set_window(this->width(), this->height() + DEFAULT_AWAYWIDGET_HEIGHT) );
	else
		emit(set_window(this->width(), this->height()-1) );

      autoResize();
    }
  }
}

/***************************************************************************
 * Set away = false.  Kinkatta autoresponds.
 ***************************************************************************/
void BuddyListWindow::away_Back(){
  if (i_aimSettings->away_comeBackOnlyOnBackClick == false){
    away_BackForReal();
  }
}

/***************************************************************************
 * Set away = false.  Kinkatta autoresponds.
 ***************************************************************************/
void BuddyListWindow::away_BackForReal(){
  sound->muteSound(false);
  awayRightNow = false;
  awayWidget->hide();
  connection->setAwayMessage(QString(""));
  emit(set_window(this->width(), this->height() - DEFAULT_AWAYWIDGET_HEIGHT) );
	emit statusChanged(TAIM_ONLINE);
  this->resizeEvent(0);
}





/**
 *
 *
 * The chat Functions. (used by both chatroom and chatwindow.
 *
 *
 */

/***************************************************************************
 * Send an IM message.  If the room is not equal to 0 then you want to send
 * to a chatroom.
 ***************************************************************************/
void BuddyListWindow::chat_sendImOut(QString message, QString target, int room){
  TWINDOW_AIM_SANITY_CHECK;
  if (room != 0){
    connection->chatSend(room,message);
    return;
  }

  if (sendingPounce == false){
    if(awayRightNow == true)
      away_Back();
    connection->sendIM(message, target, false, true);
  }
  else{
    connection->sendIM(message, target, false, false);
  }
}


/**
 *
 *
 * The chatWindow Functions.
 *
 *
 */

/***************************************************************************
 * A message came in. Open window and send massage
 ***************************************************************************/
void BuddyListWindow::receivedIM(QString name, QString message, bool isAuto){
  if (i_aimSettings->ignore_automated_get_away == true){
    if (message == QString(">>>Automated Message: Getting Away Message<<<")){
      if (awayRightNow == true){
        sendAutoIM(awayMessage, name);
	return;
      }
    }
  }
  if (checkIfGotBuddyAwayMessage(name) == true){
    if (message.length() < 100)
    	QMessageBox::information(0, "Kinkatta - Away Message",name + ("'s away message is:\n" + message), QMessageBox::Ok);
    else{
			Info *infoBox = new Info(0, "infoBox");
		  QString text ="<qt>" + name + ("'s away message is:<br/><br/>" + message);
			infoBox->Information->setText(text);
 			infoBox->setCaption("Kinkatta - Away Message");
	  	infoBox->setIcon(SmallIcon("kinkatta"));
 			infoBox->browser = browser;
			infoBox->show();
		}
		return;
  }

  //printf("messageIn: %s\n", message.data());
  ChatWindow *targetWindow = messageWindow(name);
  targetWindow->show();
  // Slot autoin
  if (isAuto){
    message = QString("<B>Auto Response: </B>") + message;
  }
  targetWindow->updateBuddyName(name);
  targetWindow->messageIn(message);
  if (awayRightNow == true){
    if (targetWindow->sentAwayMessageToBuddy == false){

      QString outMessage = awayMessage;
      QString currentDate = QDate::currentDate().toString();
      QString currentTime = QTime::currentTime().toString();
      outMessage.replace( QRegExp("%d"), currentDate );
      outMessage.replace( QRegExp("%t"), currentTime );
      outMessage.replace( QRegExp("%n"), name );

      targetWindow->awayMessage(outMessage);
      sendAutoIM(awayMessage, name);
      targetWindow->sentAwayMessageToBuddy = true;

      awayMessageSent += new QString(name);
      QTimer::singleShot( POST_AWAY_MESSAGE_SENT_DELAY *1000, this, SLOT(postAwayMessageSent()));
    }
  }
}

/***************************************************************************
 * Send an auto IM message
 ***************************************************************************/
void BuddyListWindow::sendAutoIM(QString target, QString message){
  TWINDOW_AIM_SANITY_CHECK;
  connection->sendIM(target, message, true, true);
}

/***************************************************************************
 * Open a chat window with buddyName
 ***************************************************************************/
void BuddyListWindow::chatWindow_ChatWithBuddy(QString buddyName){
  ChatWindow *targetWindow = messageWindow(buddyName);
  if (targetWindow){
    targetWindow->show();
    targetWindow->raise();
  }
}

/***************************************************************************
 * init the global chat window settings.  Then set up them.
 ***************************************************************************/
void BuddyListWindow::initChatSettings(){
  emit( updateChatSettings() );
  emit( updateChatColorSettings() );
  emit( updateChatFontSettings() );
  emit( updateChatSoundSettings() );
	// Does not set the toolbars!
}

/***************************************************************************
 * Check what name is wanted to chat with
 ***************************************************************************/
void BuddyListWindow::chatWindow_ChatWithBuddy(){
  if (treeList->currentItem() == 0)
    treeList->setCurrentItem(treeList->firstChild());
  QString name = "";
  QListViewItem  *cItem = treeList->currentItem();
  if ( cItem != NULL)
    name = treeList->currentName();
  if (treeList->checkIfFolder(cItem) == true)
    name = "";

	bool ok = false;
	QString text = QInputDialog::getText( tr( "Kinkatta - New Instant Message" ), tr( "Please enter the buddy's name" ), name, &ok, this );
    if ( ok && !text.isEmpty() )
      chatWindow_ChatWithBuddy( text );
}

/***************************************************************************
 * Toolbar Settings changed tell things to update
 ***************************************************************************/
void BuddyListWindow::chatWindow_ToolbarUpdated(){
	//qDebug("BuddyListWindow::chatWindow_ToolbarUpdated\n");
  emit updateChatToolBarSettings();
}

/***************************************************************************
 * Get a Chat Window
 ***************************************************************************/
ChatWindow *BuddyListWindow::messageWindow(const QString &name){
  QString ChatWindowName = i_aimSettings->login_name + tocNormalize(name);
  ChatWindow *targetWindow = messageWindows[ ChatWindowName ];
  if(targetWindow == NULL){
    TBuddyList list = connection->buddyList();
    if (list.getNum(name) == -1){
      targetWindow = new ChatWindow(i_aimSettings->login_name, name, false);
    }
    else{
      TBuddy *edited = list.getByNum(list.getNum(name));
      QString alias = "";
      if (edited)
        alias = edited->alias;
      if (alias == name)
        alias = "";

      targetWindow = new ChatWindow(i_aimSettings->login_name, name, true,0,alias);
      
    }
    messageWindows.insert(ChatWindowName, targetWindow);
    connect(targetWindow, SIGNAL(messageOut(QString, QString,int)), this, SLOT(chat_sendImOut(QString, QString,int)) );
    messageWindows.setAutoDelete(false);
    targetWindow->browser = browser;
		targetWindow->sound = sound;
    targetWindow->setSize(i_aimSettings->chatWindowXSize, i_aimSettings->chatWindowYSize, i_aimSettings->chatWindowSplitterHeight);
    targetWindow->updateChatSettings();
    targetWindow->updateChatColorSettings();
    targetWindow->updateChatSoundSettings();
    targetWindow->updateChatToolBarSettings();
    targetWindow->updateChatFontSettings();
		targetWindow->show();
    // Signals out from ChatWindow
    connect(targetWindow, SIGNAL(addBuddy(QString)), this, SLOT(slotAddBuddy(QString)));
    connect(targetWindow, SIGNAL(removeBuddy(QString)), this, SLOT(slotRemoveBuddy(QString)));
    connect(targetWindow, SIGNAL(blockBuddy(QString)), this, SLOT(chatWindow_BlockBuddy(QString)));
    connect(targetWindow, SIGNAL(warningOut(QString)), this, SLOT(chatWindow_WarnBuddy(QString)) );
    connect(targetWindow, SIGNAL(getInfo(QString)), this, SLOT(slotGetBuddyInfo(QString)) );
    connect(targetWindow, SIGNAL(openHomePage()), this, SLOT(MenuSlotOpenWebSite()));
    connect(targetWindow, SIGNAL(showAbout()), this, SLOT(MenuSlotAboutKinkatta()));
		connect(targetWindow, SIGNAL(pounce(QString)), this, SLOT(pounce_SlotAddDialogWithBuddyName(QString)));
    // Update Singles to Chat Window
    connect(this, SIGNAL(updateChatSettings()), targetWindow, SLOT(updateChatSettings()));
    connect(this, SIGNAL(updateChatColorSettings()), targetWindow, SLOT(updateChatColorSettings()));
    connect(this, SIGNAL(updateChatFontSettings()), targetWindow, SLOT(updateChatFontSettings()));
    connect(this, SIGNAL(updateChatSoundSettings()), targetWindow, SLOT(updateChatSoundSettings()));
    connect(this, SIGNAL(updateChatToolBarSettings()), targetWindow, SLOT(updateChatToolBarSettings()));
    connect(this, SIGNAL(updateIfIsBuddy(QString,bool)), targetWindow, SLOT(setIfIsBuddy(QString, bool)));

    // Quit signal from Chat Window
    connect(targetWindow, SIGNAL(quiting(QString, int)), this, SLOT(chatWindow_RemoveWindow(QString, int)));
		connect(targetWindow, SIGNAL(saveNewSize(int, int, int)), this, SLOT(chatWindow_saveSize(int, int, int)));
  }

  return targetWindow;
}

/***************************************************************************
 * When a buddy window dies it is removed
 ***************************************************************************/
void BuddyListWindow::chatWindow_RemoveWindow(QString name, int){
  QString normedName = i_aimSettings->login_name + tocNormalize(name);
  ChatWindow *targetWindow = NULL;
  targetWindow = messageWindows[ normedName ];
  if (targetWindow != NULL)
  {
    messageWindows.remove(normedName);
    delete targetWindow;
  }
}

/******************************************************************************
 * block buddy "name"
 * @Peram name - Name of the buddy that is to be Blocked
 *****************************************************************************/
void BuddyListWindow::chatWindow_BlockBuddy(QString name){
  QString buddyName = "";
  int answer = QMessageBox::warning(0, "Kinkatta - Block Buddy",
    "Do you wish to block this buddy from your buddylist?",
    "Yes", "Cancel", 0,1);
  if (!answer){
    TBuddyList list = connection->denyList();
    TBuddy *edited = new TBuddy();
    edited->name = name;
    edited->group = 0;
    edited->status = TAIM_OFFLINE;
    edited->userClass = 0;
    edited->signonTime = 0;
    edited->evil = 0;
    list.add(edited);
    delete edited;
    connection->setDenyList(list);
    //connection->setServerBuddyList(list);
    //loadList();
    if(connection->permissions() != 4)
      connection->setPermissions(4);
  }
}

/******************************************************************************
 * Prompt if you really want to warn "name"
 * Prompt if you want to do in anon or not
 * @Peram name - Name of the buddy that is to be Warned
 ******************************************************************************/
void BuddyListWindow::chatWindow_WarnBuddy(QString name){
  QString buddyName = "";
  int answer = QMessageBox::warning(0, "Kinkatta - Warn",
    QString("Do you wish to warn ") + name + "?",
    "Yes", "Cancel", 0,1);
  if (!answer){
    int anon = QMessageBox::warning(this, "Kinkatta - Message",
     "Do you wish to warn anonymously?",
     "Yes", "No", 0,1);
    if (!anon)
      chatWindow_SendWarning(name, true);
    else
      chatWindow_SendWarning(name, false);
  }
}

/******************************************************************************
 * Send an IM warning against name
 * @Peram name - Name of the buddy
 * @Peram isAnonymouse - warn anonymouse or not.
 ******************************************************************************/
void BuddyListWindow::chatWindow_SendWarning(QString name, bool isAnonymous){
  TWINDOW_AIM_SANITY_CHECK;
  connection->sendWarning(name, isAnonymous);
}

/***************************************************************************
 * Save the chat window size/vertical bar
 ***************************************************************************/
void BuddyListWindow::chatWindow_saveSize(int x, int y, int s){
  i_aimSettings->chatWindowXSize = x;
	i_aimSettings->chatWindowYSize = y;
	i_aimSettings->chatWindowSplitterHeight = s;
  QMessageBox::information(0, QString("Kinkatta - Message"), QString("Your sizes have been saved."));
}







/**
 *
 *
 * The Chat room Functions.
 *
 *
 */

/***************************************************************************
 * Toolbar Settings changed tell things to update
 ***************************************************************************/
void BuddyListWindow::chatRoom_ToolbarUpdated(){
	//qDebug("BuddyListWindow::chatRoom_ToolbarUpdated\n");
  emit (updateChatRoomToolBarSettings());
}

/***************************************************************************
 * The user has decided to join a chat, Ask them for the name of the room
 * that they would like to join and tell the server.
 ***************************************************************************/
void BuddyListWindow::chatRoom_JoinButton(){
  bool ok = false;
  QString text = QInputDialog::getText( tr( "Enter a chat room name you wish to join/start." ), tr( "Please enter the room name you wish to join/start." ), QString::null, &ok, this );
  if ( ok && !text.isEmpty() ){
    int answer = QMessageBox::information(0, "Kinkatta - Join Chat Room",
    "Aim Private or AOL Community Public", "Public", "Private", 0,1);
    if (!answer)
      connection->chatJoin(text, 5);
    else{
			connection->chatJoin(text, 4);
		}
  }
}

/***************************************************************************
 * You have just joined a chatroom.  Get the room and set up anything that
 * is needed.
 ***************************************************************************/
void BuddyListWindow::chatRoom_Joined(int room, QString name){
  ChatRoom *chatRoom = getAChatRoom(room, name);
  if (chatRoom != NULL){
    chatRoom->setCaption(name +" - Kinkatta chat room");
  }
}

/***************************************************************************
 * A message has come in for a Chat room.  Find the room and pass it in.
 ***************************************************************************/
void BuddyListWindow::chatRoom_In(int room, QString buddy, bool wisper, QString message){
  ChatRoom *chatRoom = getAChatRoom(room, QString(""));
  if (chatRoom != NULL){
    chatRoom->messageInParse(buddy, wisper, message);
  }
}

/***************************************************************************
 * A buddy in a chatroom has been updated,
 ***************************************************************************/
void BuddyListWindow::chatRoom_UpdateBuddy(int room, bool stat, QString buddy){
  ChatRoom *chatRoom = getAChatRoom(room, QString(""));
  if (chatRoom != NULL){
    chatRoom->updateBuddy(buddy, stat);
  }
}

/***************************************************************************
 * Someone has invited you into a chat room.  Simply ask if the user accpts
 * the invitation and if so send back the chatAccept.
 ***************************************************************************/
void BuddyListWindow::chatRoom_Invite(QString roomName, int room, QString sender, QString message){
  QString theMessage = sender + ": " + message;
  if (message.length() == 0)
    theMessage = "";
  int answer = QMessageBox::information(0, "Kinkatta - Join Chat Room",
  QString("You have been invited to a chat room \"") + roomName +"\" by " + sender + "\n" + theMessage,
    "Yes", "No Thanks", 0,1);
  if (!answer){
    connection->chatAccept(room);
  }
}

/***************************************************************************
 * Someone has invited you into a chat room.  Simply ask if the user accpts
 * the invitation and if so send back the chatAccept.
 ***************************************************************************/
void BuddyListWindow::chatRoom_ShowInvite(int room){
  ChatRoomInviteImp *cri = new ChatRoomInviteImp(this, "ChatRoomInvite");
  cri->room = room;
  connect(cri, SIGNAL(inviteBuddy(int,QString,QString)), connection, SLOT(chatInvite(int, QString, QString)));
	TBuddyList list = connection->buddyList();
  int numberOfBuddies = list.getCount();
	for(int i = 0; i < numberOfBuddies; i++){
	  if (list.getName(i) != i_aimSettings->login_name)
		  cri->buddyList->insertItem(list.getName(i), -1);
	}
  cri->show();
}

/***************************************************************************
 * You have left a chat room, If the chat room exists tell it.
 ***************************************************************************/
void BuddyListWindow::chatRoom_Left(int room){
  if (chatRoom_isThereARoom(room) == true){
    ChatRoom *chatRoom = getAChatRoom(room, QString(""));
    if (chatRoom != NULL){
      chatRoom->leftRoom();
    }
  }
}

/***************************************************************************
 * Simply see if there is a chat room.
 ***************************************************************************/
bool BuddyListWindow::chatRoom_isThereARoom(const int roomNumber){
  QString Number = QString("%1").arg(roomNumber);
  ChatRoom *targetWindow = chatRooms[Number];
  if (targetWindow == NULL){
    return false;
  }
  return true;
}

/***************************************************************************
 * Get a Chat Room
 * - if a chat room can not be found create one.
 ***************************************************************************/
ChatRoom *BuddyListWindow::getAChatRoom(const int room, QString name){
  QString Number = QString("%1").arg(room);
  ChatRoom *targetWindow = chatRooms[Number];
  if (targetWindow == NULL){
    if (name.length() == 0)
      return NULL;
    targetWindow = new ChatRoom(i_aimSettings->login_name, name, 0);
    targetWindow->room = room;
    chatRooms.insert(Number, targetWindow);
    chatRooms.setAutoDelete(false);
    connect(targetWindow, SIGNAL(messageOut(QString, QString, int)), this, SLOT(chat_sendImOut(QString, QString, int)));
    connect(targetWindow, SIGNAL(getInfo(QString)), this, SLOT(slotGetBuddyInfo(QString)));
    connect(targetWindow, SIGNAL(im(QString)), this, SLOT(chatWindow_ChatWithBuddy(QString)));
    connect(targetWindow, SIGNAL(showInviteWidget(int)), this, SLOT(chatRoom_ShowInvite(int)));

    targetWindow->browser = browser;
		targetWindow->sound = sound;
    targetWindow->updateChatSettings();
    targetWindow->updateChatColorSettings();
    targetWindow->updateChatSoundSettings();
    targetWindow->updateChatToolBarSettings();
    targetWindow->updateChatFontSettings();

    // ROOM

    // Update Singles to Chat Window
    connect(this, SIGNAL(updateChatSettings()),
			 targetWindow, SLOT(updateChatSettings()));
    connect(this, SIGNAL(updateChatColorSettings()),
			 targetWindow, SLOT(updateChatColorSettings()));
    connect(this, SIGNAL(updateChatFontSettings()),
			 targetWindow, SLOT(updateChatFontSettings()));
    connect(this, SIGNAL(updateChatSoundSettings()),
			 targetWindow, SLOT(updateChatSoundSettings()));
    connect(this, SIGNAL(updateChatRoomToolBarSettings()),
			 targetWindow, SLOT(updateChatToolBarSettings()));

    // Quit signal from Chat Window
    connect(targetWindow, SIGNAL(quiting(QString,int)), this, SLOT(chatRoom_RemoveWindow(QString,int)));

    connect(targetWindow, SIGNAL(openHomePage()), this, SLOT(MenuSlotOpenWebSite()));
    connect(targetWindow, SIGNAL(showAbout()), this, SLOT(MenuSlotAboutKinkatta()));
    targetWindow->setSize(i_aimSettings->chatRoomXSize, i_aimSettings->chatRoomYSize, i_aimSettings->chatRoomSplitterHeight, i_aimSettings->chatRoomSplitter2Width);
		connect(targetWindow, SIGNAL(saveNewSize(int, int, int, int)), this, SLOT(chatRoom_SaveSize(int, int, int, int)));
    targetWindow->show();
  }
  return targetWindow;
}

/***************************************************************************
 * The save settings menu item has been selected from the chatroom menu.
 * The size as given should be saved.
 ***************************************************************************/
void BuddyListWindow::chatRoom_SaveSize(int x, int y, int s1, int s2){
	i_aimSettings->chatRoomXSize = x;
	i_aimSettings->chatRoomYSize = y;
	i_aimSettings->chatRoomSplitterHeight = s1;
	i_aimSettings->chatRoomSplitter2Width = s2;
  QMessageBox::information(0, QString("Kinkatta - Message"), QString("Your sizes have been saved."));
}

/***************************************************************************
 * Close a Chat Room
 * - Remove the room from the map
 * - Delete the memory
 * - Send out left room signal
 ***************************************************************************/
void BuddyListWindow::chatRoom_RemoveWindow(QString, int room){
  connection->chatLeave(room);
  ChatRoom *chatRoom = getAChatRoom(room, QString(""));
  if (chatRoom != NULL){
    // Clean up everything else.
    QString Number = QString("%1").arg(room);
    chatRooms.remove(Number);
    delete chatRoom;
  }
}







/**
 *
 *
 * The Import/Export Functions.
 *
 *
 */

/***************************************************************************
 * Import buddy list from a buddy list within a kinkatta xml file.
 ***************************************************************************/
void BuddyListWindow::importXmlConfig(QString fileName){
  qApp->setOverrideCursor(Qt::waitCursor);
  QString config = setup::instance()->buddyListFileToString(fileName);
  config = QString("Config:\n") + config;
  // Got config from file, parse out lists
  TBuddyList buddyList = connection->buddyList();
  TBuddyList permitList = connection->permitList();
  TBuddyList denyList = connection->denyList();
  int permitStatus = connection->getStatus();
  tocParseConfigAlias(config, &buddyList, &permitList, &denyList, &permitStatus);
  connection->setBuddyList(buddyList);
  connection->setPermitList(permitList);
  connection->setDenyList(denyList);
  emit ( saveSettings());
  qApp->restoreOverrideCursor();
}

/***************************************************************************
 * Import buddy list from a buddy list.
 ***************************************************************************/
void BuddyListWindow::importConfig(QString fileName){
  qApp->setOverrideCursor(Qt::waitCursor);
  // Got a file, open and parse.
  QFile file(fileName);
  QString config;
  if (file.open(IO_ReadWrite)){
    config += "CONFIG:";
    QTextStream stream(&file);
    while(!stream.eof()){
      config += stream.readLine();
      config += "\n";
    }
    file.close();
  }
  else
    QMessageBox::information(this, "Kinkatta - Error","Unable to open file.", QMessageBox::Ok);
  // Got config from file, parse out lists
  TBuddyList buddyList = connection->buddyList();
  TBuddyList permitList = connection->permitList();
  TBuddyList denyList = connection->denyList();
  int permitStatus = connection->getStatus();
  tocParseConfigAlias(config, &buddyList, &permitList, &denyList, &permitStatus);

  connection->setBuddyList(buddyList);
  connection->setPermitList(permitList);
  connection->setDenyList(denyList);
  emit ( saveSettings());
  qApp->restoreOverrideCursor();
}

/***************************************************************************
 * Import buddy list from a buddy list.
 ***************************************************************************/
void BuddyListWindow::importConfigAlias(QString fileName){
  qApp->setOverrideCursor(Qt::waitCursor);
  // Got a file, open and parse.
  QFile file(fileName);
  QString config;
  if (file.open(IO_ReadWrite)){
    config += "CONFIG:";
    QTextStream stream(&file);
    while(!stream.eof()){
      config += stream.readLine();
      config += "\n";
    }
    file.close();
  }
  else
    QMessageBox::information(this, "Kinkatta - Error","Unable to open file.", QMessageBox::Ok);
  
  // Got config from file, parse out lists
  TBuddyList buddyList = connection->buddyList();
  TBuddyList permitList = connection->permitList();
  TBuddyList denyList = connection->denyList();
  int permitStatus = connection->getStatus();
  tocParseConfigAlias(config, &buddyList, &permitList, &denyList, &permitStatus);
  connection->setBuddyList(buddyList);
  connection->setPermitList(permitList);
  connection->setDenyList(denyList);
  emit ( saveSettings());
  qApp->restoreOverrideCursor();
}

/***************************************************************************
 * Import buddy list from a gaim buddy list.
 ***************************************************************************/
void BuddyListWindow::slotImportFromGaim(){
  QString buddyFile = QDir::homeDirPath();
  buddyFile += "/.gaim";
  QString s( KFileDialog::getOpenFileName(buddyFile,QString("*.blist"),this, "Gaim Buddy List (*.blist)") );
  if ( s.isEmpty() == true)
  return;
  importConfigAlias(s);
  loadList();
}

/***************************************************************************
 * Import buddy list from a kinkatta buddy list.
 ***************************************************************************/
void BuddyListWindow::slotImportFromKinkatta(){
  QString buddyFile =  QDir::homeDirPath();
  buddyFile += "/.kde/share/apps/kinkatta/";
  QString s( KFileDialog::getOpenFileName(buddyFile,QString("*.xml *.buddyList"),this, "Kinkatta Buddy List (*.buddyList)") );
  if ( s.isEmpty() == true)
    return;

  if (s.length() > 3 && s.mid(s.length()-3,3) == "xml")
    importXmlConfig(s);
  else
    importConfigAlias(s);
  loadList();
}

/***************************************************************************
 * Import buddy list from a tik buddy list.
 ***************************************************************************/
void BuddyListWindow::slotImportFromTik(){
  QString buddyFile = QDir::homeDirPath();
  buddyFile += "/.tic";
  QString s( KFileDialog::getOpenFileName(buddyFile,QString("*.config"),this, "Tik Buddy List (*.config)") );
  if ( s.isEmpty() == true)
    return;
  importConfig(s);
  loadList();
}

/***************************************************************************
 * Import buddy list from a windows buddy list.
 ***************************************************************************/
void BuddyListWindow::slotImportFromAim(){
  QString buddyFile = QDir::homeDirPath();
  QString s( KFileDialog::getOpenFileName(buddyFile,QString("*.*"),this, "Official Aim Buddy List (*.*)") );
  if ( s.isEmpty() == true)
  	return;

	qApp->setOverrideCursor(Qt::waitCursor);
  // Got a file, open and parse.
  QFile file(s);
  QString config;
  bool file_Buddy = false;
  bool file_list = false;
  QString group = "";
  QString unknown = "";
  QString subunknown = QString("");
  int sub = 0;
  if (file.open(IO_ReadWrite)){
    config += "CONFIG:";
    QTextStream stream(&file);
    while(!stream.eof()){
      QString line = stream.readLine();
      if ( file_Buddy == true && file_list == true && group.length() != 0 && subunknown.length() == 0){
      	line.replace(QRegExp("\t"), "");
        line.replace(QRegExp("\""), "");
        line.replace(QRegExp(" "), "");
        if (line.find("}", false) == -1 && (line.find("{", false) == -1) ){
          config += "b " + line;
          config += "\n";
        }
      } 

      // Entering a group
      if (line.find("{", false) != -1){
        if (line.find("Buddy {", false) != -1){
					file_Buddy = true;
				}
				else{
					if (line.find("list {", false) != -1){
						if (file_Buddy == true){
							file_list = true;
						}
					}
					else{
						if ( file_Buddy == true && file_list == true && group.length() == 0){
							line = line.mid(0, line.length()-2);
				  		line.replace(QRegExp("\t"), "");
							line.replace(QRegExp("\""), "");
							line.replace(QRegExp(" "), "");
							config += "g " + line;
	     	  		config += "\n";
							group = line;
						}
						else{
							if (file_Buddy == true && file_list == true ){
								if (sub == 0){
									line = line.mid(0, line.length()-2);
						  		line.replace(QRegExp("\t"), "");
									line.replace(QRegExp("\""), "");
									line.replace(QRegExp(" "), "");
				  				config += "b " + line;
	     	  				config += "\n";
									subunknown = line;
								}
								sub++;
							}
							else unknown = line;
						}
					}
				}
			}
			// Leaving a group
			if (line.find("}", false) != -1){
			  if (subunknown.length() !=0){
					if (sub == 1)
						subunknown = "";
					sub--;
				}
				else{
				if (group.length() != 0)
					group = "";
				else{
					if (file_list == true){
						file_list = false;
					}
					else {
						if (file_list == false && file_Buddy == true && unknown.length() == 0)
							file_Buddy = false;
						else
							unknown = "";
					}
				}
				}
			}
    }
    file.close();
  }
  else
    QMessageBox::information(this, "Kinkatta - Error","Unable to open file.", QMessageBox::Ok);

  if (config == "CONFIG:")
    QMessageBox::information(this, "Kinkatta - Error","Unable to import official aim client list.\nDid you use aim's export?  Do you have the latest aim?", QMessageBox::Ok);

  // Got config from file, parse out lists
  TBuddyList buddyList = connection->buddyList();
  TBuddyList permitList = connection->permitList();
  TBuddyList denyList = connection->denyList();
  int permitStatus = connection->getStatus();
  tocParseConfigAlias(config, &buddyList, &permitList, &denyList, &permitStatus);

	connection->setBuddyList(buddyList);
  connection->setPermitList(permitList);
  connection->setDenyList(denyList);
  emit ( saveSettings());
  qApp->restoreOverrideCursor();
  loadList();
}

/***************************************************************************
 * Import buddy list from a kit buddy list.
 ***************************************************************************/
void BuddyListWindow::slotImportFromKit(){
QString buddyFile = QDir::homeDirPath();
  buddyFile += "/.kde/share/config/";
  //kitprofilerc

  QString fileName( KFileDialog::getOpenFileName(buddyFile,QString("kit*"),this, "Kit profile (*)") );
  if ( fileName.isEmpty() == true)
    return;

  // Got a file, open and parse.
  QFile file(fileName);
  QString config;
  QString name;
  bool import = false;
  bool endimport = false;
  QString temp;
  if (file.open(IO_ReadWrite)){
    QTextStream stream(&file);
    while(!stream.eof() && endimport == false ){
      temp =  stream.readLine();
      if (temp.mid(0,1) == QString("[")){
        QString buddy = temp.mid(1, temp.length()-2);
        int answer = QMessageBox::information(0, "Kinkatta - Import",
          QString("Found """) + buddy +""" in profile, import" + buddy +"""?",
          "Yes", "No, see if there is another.", 0,1);
        if (!answer){
          import = true;
        }
      }
      if (temp.mid(0,14) == QString("Configuration=")){
        if ( import == true ){
          config += temp.mid(14,temp.length()-14);
          endimport = true;
        }
      }
    }
    file.close();
  }
  else
    QMessageBox::information(this, "Kinkatta - Error","Unable to open file.", QMessageBox::Ok);

  if (import == false){
    QMessageBox::information(this, "Kinkatta - Error","No more possible users to import.\nImport canceled.", QMessageBox::Ok);
    return;
  }
  qApp->setOverrideCursor(Qt::waitCursor);

  // Got config from file, parse out lists
  TBuddyList buddyList = connection->buddyList();
  TBuddyList permitList = connection->permitList();
  TBuddyList denyList = connection->denyList();
  int permitStatus = connection->getStatus();
  tocParseConfigAlias(config, &buddyList, &permitList, &denyList, &permitStatus);

  connection->setBuddyList(buddyList);
  connection->setPermitList(permitList);
  connection->setDenyList(denyList);
  emit ( saveSettings());
  qApp->restoreOverrideCursor();
  loadList();
}

/***************************************************************************
 * Export the buddylist to a file.
 ***************************************************************************/
void BuddyListWindow::slotExportBuddyList(){
  QString saveAsThisFile( KFileDialog::getSaveFileName( QString(""),QString("*.buddylist"),this, "buddyList (*.buddylist)") );

  if ( saveAsThisFile.isEmpty())
    return;
  QFileInfo fi(saveAsThisFile);
  if( fi.extension( FALSE ).isEmpty() )
    saveAsThisFile.append( ".buddylist" );

  qApp->setOverrideCursor(Qt::waitCursor);
  QFile file(saveAsThisFile);
  if (file.open(IO_ReadWrite))
  {
    QString config = setup::instance()->buddyListToString(i_aimSettings->login_name);
    QTextStream stream(&file);
    stream << config << "\n";
    file.close();
  }
  else
    QMessageBox::critical(this, "Kinkatta - Message",("Could not export buddy list."));
  qApp->restoreOverrideCursor();
}



/**
 *
 *
 * The Pounce Functions.
 *
 *
 */

/***************************************************************************
 * load the saved recurring pounces.
 ***************************************************************************/
void BuddyListWindow::loadRecurringPounces() {
	i_aimSettings->pounces.clear();
	i_aimSettings->pounces = setup::instance()->readPounces(i_aimSettings->login_name);

	QDict<pounce> savedPounces = i_aimSettings->pounces;
	QDictIterator<pounce> it(savedPounces);
	pounce *p;
	if (!savedPounces.isEmpty()) {
		while( it.current() != NULL ){
			p = it.current();
			if (p->buddyName.length() == 0)
				break;
			QString BuddyName = tocNormalize(p->buddyName);
			pounce *newPounceStruct = pounceMessages[ BuddyName ];
	  	if(!newPounceStruct){
				if (p->hidden == false)
          pounce_SlotAdd(*p);
				else
          setSoundConfig(*p);
			}
			it += 1;
		}
	}
}

/***************************************************************************
 * Open a pounce dialog for a new pounce to be added.
 ***************************************************************************/
void BuddyListWindow::pounce_SlotAddDialog(){
  NewPounceImp *pounceDialog = new NewPounceImp(this, "AddPounceDialog", "");
  connect(pounceDialog, SIGNAL(addPounce(pounce)), this, SLOT(pounce_SlotAdd(pounce)));
  TBuddyList list = connection->buddyList();
  int numberOfBuddies = list.getCount();
	for (int i = 0; i < numberOfBuddies; i++){
		pounceDialog->buddyName->insertItem(list.getName(i), -1);
	}
  pounceDialog->show();
}

/***************************************************************************
 * Bring up the pounce dialog with the current selected buddy name
 ***************************************************************************/
void BuddyListWindow::pounce_SlotAddDialogWithBuddy(){
  if (treeList->currentItem() == 0)
    treeList->setCurrentItem(treeList->firstChild());
  const QString name = treeList->currentName();
  if (treeList->checkIfFolder(treeList->currentItem()) == false){
    pounce_SlotAddDialogWithBuddyName(name);
  }
}

/***************************************************************************
 * Bring up the pounce dialog with the current selected buddy name
 ***************************************************************************/
void BuddyListWindow::pounce_SlotAddDialogWithBuddyName(QString name){
  NewPounceImp *pounceDialog = new NewPounceImp(this, "AddPounceDialog", name);
  connect(pounceDialog, SIGNAL(addPounce(pounce)), this, SLOT(pounce_SlotAdd(pounce)));

  // If there is already a Pounce you want to edit it.
  QString buddyName = tocNormalize(buddyName);
  pounce *pounceStruct = pounceMessages[ buddyName ];
  if (pounceStruct)
    pounceDialog->setPounce(pounceStruct);

  TBuddyList list = connection->buddyList();
  int numberOfBuddies = list.getCount();
  for (int i = 0; i < numberOfBuddies; i++){
    if (list.getName(i) != name)
      pounceDialog->buddyName->insertItem(list.getName(i), -1);
  }
  pounceDialog->show();
}


/***************************************************************************
 * Bring up the pounce dialog with the current pounce info.
 ***************************************************************************/
void BuddyListWindow::pounce_Edit(int menuId){
  QString buddyName = _PounceMenu->text(menuId);
  int cname = buddyName.find(":", false);
  if( cname != -1)
    buddyName = buddyName.left(cname);
  else
    buddyName = "";
  if (!buddyName.length() == 0){ //user didnt press Add Pounce, or Remove Pounce
    buddyName = tocNormalize(buddyName);
    pounce *pounceStruct = pounceMessages[ buddyName ];
    if(pounceStruct){
      NewPounceImp *pounceDialog = new NewPounceImp(this, "AddPounceDialog", "");
      connect(pounceDialog, SIGNAL(addPounce(pounce)), this, SLOT(pounce_SlotAdd(pounce)));
      pounceDialog->setPounce(pounceStruct);
      pounceDialog->show();
    }
    else
     QMessageBox::critical(this, "Kinkatta - Error",QString("Can't find pounce for: ") + buddyName, "Ok");
  }
}

/***************************************************************************
 * Add a pounce to the internal list of pounces.
 ***************************************************************************/
void BuddyListWindow::pounce_SlotAdd(pounce newPounce){
  QString BuddyName = newPounce.buddyName;
  QString realName = BuddyName;
  BuddyName = tocNormalize(BuddyName);
  pounce *newPounceStruct = pounceMessages[ BuddyName ];
  if(!newPounceStruct){
    newPounceStruct = new pounce();
    pounceMessages.insert(BuddyName, newPounceStruct);
    
    newPounceStruct->buddyName = BuddyName;
    newPounceStruct->signOn = newPounce.signOn;
    newPounceStruct->returnAway = newPounce.returnAway;
    newPounceStruct->returnIdle = newPounce.returnIdle;
    newPounceStruct->openChat = newPounce.openChat;
    newPounceStruct->sendMessage = newPounce.sendMessage;
    newPounceStruct->message = newPounce.message;
    newPounceStruct->execCommand = newPounce.execCommand;
    newPounceStruct->command = newPounce.command;
    newPounceStruct->doNotRemove = newPounce.doNotRemove;
    newPounceStruct->hidden = false;
    QString textInMenu = realName + ": ";
    if (newPounce.execCommand && newPounce.openChat){
      textInMenu = "Chat & Exec Command";
    }
    if (newPounce.execCommand){
      QString command =  newPounce.command;
      if (command.length() > 20){
        command = command.mid(0,16);
        command += "...";
      }
      if (command.length() > 0)
        textInMenu += command;
      else
        textInMenu += "Exec Command";
    }
    if (newPounce.openChat){
      QString message =  newPounce.message;
      if (message.length() > 20){
        message = message.mid(0,16);
        message += "...";
      }
      if (newPounceStruct->sendMessage && message.length() > 0)
        textInMenu += message;
      else
        textInMenu += "Open Chat Window";	
    }
    // Add pounce icon to buddy.
    TBuddyList list = connection->buddyList();
    TBuddy *bud = list.getByNum(list.getNum(realName));
    if (bud) {
      loadTreeBuddy(bud);
    }
    i_aimSettings->pounces = pounceMessages;
    setup::instance()->savePounces(i_aimSettings->login_name,i_aimSettings->pounces);
    // Do these last.
    newPounceStruct->editMenuId = _PounceMenu->insertItem(textInMenu,-1);
    newPounceStruct->deleteMenuId = _PounceDelete->insertItem(newPounceStruct->buddyName, -1);
  }
  else{
    newPounceStruct->signOn = newPounce.signOn;
    newPounceStruct->returnAway = newPounce.returnAway;
    newPounceStruct->returnIdle = newPounce.returnIdle;
    newPounceStruct->openChat = newPounce.openChat;
    newPounceStruct->sendMessage = newPounce.sendMessage;
    newPounceStruct->message = newPounce.message;
    newPounceStruct->execCommand = newPounce.execCommand;
    newPounceStruct->command = newPounce.command;
    newPounceStruct->doNotRemove = newPounce.doNotRemove;
  }
}

/***************************************************************************
 * If the Pounce delete menu is empty, this inserts a disabled item "(Empty)"
 ***************************************************************************/
void BuddyListWindow::pounce_DeleteMenuAboutToShow(){
	// first update menu to remove disabled items
	pounce_UpdateMenu();
	if(_PounceDelete->count() < 1  && empty1 == -1){
		empty1 = _PounceDelete->insertItem("(Empty)", -1);
		_PounceDelete->setItemEnabled(empty1, false);
		empty2 = _PounceMenu->insertItem("(Empty)", -1);
		_PounceMenu->setItemEnabled(empty2, false);
	} 
	else {
		if (empty1 != -1)	{
		  if (_PounceDelete->count() != 1){
				_PounceDelete->removeItem(empty1);
		    _PounceMenu->removeItem(empty2);
				empty1 = -1;
			}
	  }
	}
}

/***************************************************************************
 * Check to see if the buddy buddyName has a pounce for signOn and if so
 * pounce that buddy.
 ***************************************************************************/
void BuddyListWindow::pounce_CheckSignOn(QString buddyName){
  buddyName = tocNormalize(buddyName);
  pounce *pounceStruct = pounceMessages[ buddyName ];
  if(pounceStruct){
    if (pounceStruct->signOn == true){
      pounce_Activate(buddyName);
    }
  }
}

/***************************************************************************
 * Check to see if the buddy buddyName has a pounce for returnAway and if so
 * pounce that buddy.
 ***************************************************************************/
void BuddyListWindow::pounce_CheckReturnAway(QString buddyName){
  buddyName = tocNormalize(buddyName);
  pounce *pounceStruct = pounceMessages[ buddyName ];
  if(pounceStruct){
    if (pounceStruct->returnAway == true){
      pounce_Activate(buddyName); 
    }
  }
}

/***************************************************************************
 * Check to see if the buddy buddyName has a pounce for returnIdle and if so
 * pounce that buddy.
 ***************************************************************************/
void BuddyListWindow::pounce_CheckReturnIdle(QString buddyName){
  buddyName = tocNormalize(buddyName);
  pounce *pounceStruct = pounceMessages[ buddyName ];
  if(pounceStruct){
    if (pounceStruct->returnIdle == true){
      pounce_Activate(buddyName);
    }  
  }
}

/***************************************************************************
 * When this function is called it will attempt to do whatever the pounce
 * for buddy buddyName wants.
 ***************************************************************************/
void BuddyListWindow::pounce_Activate(QString buddyName){
	pounce *pounceStruct = pounceMessages[ buddyName ];
  if(pounceStruct){
    if (pounceStruct->openChat == true){
      chatWindow_ChatWithBuddy(buddyName);
    }
    if (pounceStruct->openChat == false && pounceStruct->sendMessage == true){
      connection->sendIM(pounceStruct->message,buddyName, false, false);
    }
    if (pounceStruct->openChat == true && pounceStruct->sendMessage == true){
      ChatWindow *targetWindow = messageWindows[(i_aimSettings->login_name) + tocNormalize(buddyName) ];
      if(targetWindow){
        sendingPounce = true;
				targetWindow->pounceMessage(pounceStruct->message);
				sendingPounce = false;
      }
    }
		if (pounceStruct->execCommand == true){
		  system(QString(pounceStruct->command + " &").latin1());
		}
    // Find the menu id number and then remove the menu item.
    if (pounceStruct->doNotRemove == false){
		  pounce_SlotRemove(pounceStruct->deleteMenuId);
		}
  }
}

/***************************************************************************
 *  If you remove a pounce from the delete list it is removed here.
 ***************************************************************************/
void BuddyListWindow::pounce_SlotRemove(int deleteMenuNumber){
  QString realName = _PounceDelete->text(deleteMenuNumber);
	QString buddyName = tocNormalize(realName);
  pounce *pounceStruct = pounceMessages[ buddyName ];
  if (pounceStruct != NULL){
		// only disable not remove object of signal processing routine...can segfault
		_PounceDelete->setItemEnabled(pounceStruct->deleteMenuId, FALSE);
    _PounceMenu->setItemEnabled(pounceStruct->editMenuId, FALSE);
    pounceMessages.remove(buddyName);
    //delete pounceStruct; //dont need this, auto-deletion enabled
  }
  TBuddyList list = connection->buddyList();
  TBuddy *bud = list.getByNum(list.getNum(realName));
  if (bud) {
    loadTreeBuddy(bud);
  }
  i_aimSettings->pounces = pounceMessages;
  setup::instance()->savePounces(i_aimSettings->login_name,i_aimSettings->pounces);
}

/***************************************************************************
 *  Update pounce Menu just before it displays.  It removes any items in the
 * pounce menu that are disabled other then the "Empty" items.
 ***************************************************************************/
void BuddyListWindow::pounce_UpdateMenu(){
	int itP = _PounceMenu->count();
	int itD = _PounceDelete->count();
	int id = 0;
	// remove disabled items...
	while (itP > 3) {
		id = _PounceMenu->idAt(itP-1);
		if (!_PounceMenu->isItemEnabled(id)) {
			if (_PounceMenu->text(id) != "(Empty)") {
					_PounceMenu->removeItem(id);
			}
		}
		itP--;
	}
	// remove disabled items...
	while (itD > 0) {
		id = _PounceDelete->idAt(itD-1);
		if (!_PounceDelete->isItemEnabled(id)) {
			if (_PounceDelete->text(id) != "(Empty)") {
				_PounceDelete->removeItem(id);
			}
		}
		itD--;
	}
}

// BuddyListWindow


#include "buddylistwindow.moc"














