/***************************************************************************
                                awaymessage.h
                             -------------------
    begin                : Sun Feb 20 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 ***************************************************************************/

#ifndef AWAYMESSAGE_H
#define AWAYMESSAGE_H

//Generated area. DO NOT EDIT!!!(begin)
#include <qwidget.h>
#include <qmultilinedit.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcheckbox.h>
//Generated area. DO NOT EDIT!!!(end)

#include <qdialog.h>
#include <setup.h>

/**
 * Away message widget.
 * A simple Dialog box that tells the user that there they are currently set
 * to away and to click on the back button to be back.  While this window is
 * open auto response messages are sent.
 *@author Benjamin Meyer
 */

class AwayMessage : public QWidget {
  Q_OBJECT

  signals:
  
  /**
   * Emitted when the user hits the back button.
   */
  void backClicked();
  
  /**
   * Emitted when the user hits the update button.
   */
  void update(QString);	
      
  public:
  /**
   * Constructor.
   * @param parent the parent widget
   * @param name the name of the widget
   */
  AwayMessage(QWidget *parent=0, const char *name=0);

  /**
   * Destructor.
   */
  ~AwayMessage();

  /**
   * Sets the away message.
   * @param text the new away message
   * Sets the away message to text.
   */
  void setText(QString text);

  /**
   * Resize event handler.
   * @param e the resize event
   * Called when the widget should resize itself.
   */
  void resizeEvent ( QResizeEvent *e );

  /**
   * Creates the GUI.
   * Sets up and displays the widgets.
   */
  void initDialog();

    //Generated area. DO NOT EDIT!!!(begin)
    QMultiLineEdit *message;
    QPushButton *Back;
		QPushButton *Update;
    QLabel *text1;
    QLabel *text2;
    QCheckBox *no_sound;
    //Generated area. DO NOT EDIT!!!(end)

  private:
    int oldSoundSettings;
    settings_t *i_aimSettings;
	
  private slots:
    void toggle(bool on);
    void back();
    void updateClicked();
    void textChanged();

};

#endif

// awaymessage.h
