/***************************************************************************
                          keducaview.h  -  description
                             -------------------
    begin                : Thu May 24 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi_cms@terra.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KEDUCAVIEW_H
#define KEDUCAVIEW_H

#include "fileread.h"
#include "kquestion.h"
#include "kgroupeduca.h"

#include <kurl.h>

#include <qwidget.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qsplitter.h>
#include <qtextview.h>

/**Main view of keduca file (questions and answers)
  *@author Javier Campos
  */

class keducaview : public QWidget  {
   Q_OBJECT
public: 
	keducaview(QWidget *parent=0, const char *name=0);
	~keducaview();
  /** Open url */
  bool openURL( const KURL &url);
private: // Private methods
  /** Init graphical interface */
  void init();
  /** Show record, returns false if there is no record to show. */
  bool showRecord();
  /** Show results */
  void showResults( const QString &text );
  /** Set results */
  void setResults();
  /** Write settings */
  void configWrite();
  /** Read settings */
  void configRead();
private: // Private attributes
  /** Button next */
  QPushButton *ButtonNext;
  /** Group of answers. This is a frame an check or radio buttons. */
  KGroupEduca *ButtonGroup;
  /** KEDUCA file */
  FileRead *KEDUCA;
  /** A question text with pixmaps and movies support */
  KQuestion *question_text;
  /** A question text with pixmaps and movies support */
  QTextView *ViewResults;
  /** Current record */
  int KEDUCA_record;
  /** Current results */
  QString results;
  /** Num of correct answers */
  int Correct_Answer;
  /** Number of incorrect answers */
  int Incorrect_Answer;
  /** Main vbox */
  QVBoxLayout *vbox;
  /** Main splitt */
  QSplitter *split;
  /** Current results */
  QString currentResults;
  /** Show results when finish? */
  bool showResultFinish;
private slots: // Private slots
  /** Button Next action */
  void slot_ButtonNext();
};

#endif
