/***************************************************************************
                          keduca.h  -  description
                             -------------------
    begin                : mi may 23 20:36:15 CEST 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi_cms@terra.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KEDUCA_H
#define KEDUCA_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "keducaview.h"
#include "kcontroldoc.h"

#include <kapp.h>
#include <kmainwindow.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kurl.h>

/** Keduca is the base class of the porject */
class Keduca : public KMainWindow
{
  Q_OBJECT 
  public:
    /** construtor */
    Keduca(QWidget* parent=0, const char *name=0, WFlags f = WType_TopLevel | WDestructiveClose);
    /** destructor */
    ~Keduca();
  /** Open url */
  void openURL( const KURL &url );
private: // Private methods
  /** Init graphical interface */
  void init();
  /** Init menu bar settings */
  void initMenuBar();
  /** Write settings */
  void configWrite();
  /** Read settings */
  void configRead();
  /** Close the window */
  bool queryClose();
  /** Recent files */
  KRecentFilesAction *recentFiles;
  /** A KEDUCA file main view */
  keducaview *mainView;
private slots: // Private slots
  /** Open a file */
  void slotFileOpenURL( const KURL &url );
private slots: // Private slots
  /** Open new file */
  void slotFileOpen();
  /** Close actual document */
  void slotFileClose();
  /** Start control documents */
  void slotControlDoc();
  /** Configure toolbar */
  void slotConfigureToolbar();
  /** Configure keys */
  void slotConfigureKeys();
  /** Toggle toolbar */
  void slotToggleToolBar();
  /** Configure keduca */
  void slotConfigure();
};

#endif
