/***************************************************************************
                          keduca.cpp  -  description
                             -------------------
    begin                : mi may 23 20:36:15 CEST 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi_cms@terra.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "keduca.h"
#include "keduca.moc"

#include "keducaprefs.h"

#include <klocale.h>
#include <kstddirs.h>
#include <kfiledialog.h>
#include <kedittoolbar.h>
#include <kkeydialog.h>

#include <qwidget.h>
#include <qlayout.h>
#include <qlabel.h>

Keduca::Keduca( QWidget* parent, const char *name, WFlags f ) : KMainWindow(parent, name, f)
{
	init();
	initMenuBar();
	configRead();
}

Keduca::~Keduca()
{
	delete recentFiles;
}

/** Init graphical interface */
void Keduca::init()
{
	QWidget *mainview = new QWidget(this);
	mainview->setBackgroundColor( QColor::QColor(255,255,255));
	QBoxLayout* layout_1 = new QBoxLayout( mainview, QBoxLayout::TopToBottom, 5, 5, NULL );
	layout_1->addStrut( 0 );
	QLabel *mainLabel = new QLabel(mainview, "mainLabel");
	mainLabel->setGeometry(0, 0, 256, 156);
	mainLabel->setBackgroundColor( QColor::QColor(255,255,255));
	mainLabel->setAlignment( AlignHCenter|AlignVCenter );
	mainLabel->setPixmap( QPixmap( locate("appdata","pics/keduca_init.png") ) );
	layout_1->addWidget( mainLabel );
	mainview->show();

	this->setCentralWidget(mainview);
	this->setCaption( i18n("Main Window") );
}

/** Init menu bar settings */
void Keduca::initMenuBar()
{
	KStdAction::open							(this, SLOT( slotFileOpen() ), actionCollection());
	recentFiles = KStdAction::openRecent(this, SLOT ( slotFileOpenURL(const KURL &)), actionCollection());
//	KStdAction::print							(this, SLOT( slotMenuPrint() ), actionCollection());
	KStdAction::close							(this, SLOT( slotFileClose() ), actionCollection());
	KStdAction::quit							(this, SLOT( close() ), actionCollection());

	(void)new KAction(i18n("&Create/Modify..."), "keducacontrol", 0, this, SLOT( slotControlDoc() ), actionCollection(), "control_doc");

	KStdAction::showToolbar				(this, SLOT( slotToggleToolBar()), actionCollection());
	KStdAction::keyBindings				(this, SLOT( slotConfigureKeys() ), actionCollection());
	KStdAction::configureToolbars	(this, SLOT( slotConfigureToolbar() ), actionCollection());
	KStdAction::preferences				(this, SLOT( slotConfigure()), actionCollection());
  createGUI( "keducaui.rc" );
}

/** Open new file */
void Keduca::slotFileOpen()
{
  KURL url = KFileDialog::getOpenURL( QString::null, "*.edu|Educa "+i18n("file")+" (*.edu)", 0,  i18n("Open Educa file") );

  if( !url.isEmpty() )
     slotFileOpenURL( url );
}

/** Open a file */
void Keduca::slotFileOpenURL( const KURL &url )
{
	mainView = new keducaview(this);
	if( !mainView->openURL(url) ) { delete mainView; return; }
	recentFiles->addURL( url );
	this->setCentralWidget(mainView);
}

/** Close actual document */
void Keduca::slotFileClose()
{
	if( mainView ) delete mainView;
	init();
}

/** Start control documents */
void Keduca::slotControlDoc()
{
	kcontroldoc *pepe = new kcontroldoc();
	pepe->show();
}

/** Close the window */
bool Keduca::queryClose()
{
	configWrite();
	return( TRUE );
}
/** Read settings */
void Keduca::configRead()
{
	KConfig *config = KGlobal::config();

	config->setGroup( "keduca" );
	this->applyMainWindowSettings( config, "keduca" );
	recentFiles->loadEntries(config);
}

/** Write settings */
void Keduca::configWrite()
{
	KConfig *config = KGlobal::config();

	config->setGroup( "keduca" );
	this->saveMainWindowSettings( config, "keduca" );
	recentFiles->saveEntries(config);
	config->sync();
}

/** Toggle toolbar */
void Keduca::slotToggleToolBar()
{
	if(toolBar()->isVisible())
		toolBar()->hide();
		else
		toolBar()->show();
}

/** Configure keys */
void Keduca::slotConfigureKeys()
{
	KKeyDialog::configureKeys( actionCollection(), xmlFile() );
}

/** Configure toolbar */
void Keduca::slotConfigureToolbar()
{
	KEditToolbar edit( guiFactory(), this );
	if( edit.exec() )
	  createGUI( "keducaui.rc" );
}

/** Open url */
void Keduca::openURL( const KURL &url )
{
	slotFileOpenURL( url );
}

/** Configure keduca */
void Keduca::slotConfigure()
{
	keducaprefs pref;
	pref.exec();
}
