/***************************************************************************
                          kcontroladdedit.h  -  description
                             -------------------
    begin                : Sun May 27 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi_cms@terra.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCONTROLADDEDIT_H
#define KCONTROLADDEDIT_H

#include "fileread.h"

#include <qwidget.h>
#include <kwizard.h>

#include <kurlrequester.h>
#include <kcombobox.h>
#include <klistview.h>
#include <knuminput.h>

#include <qpushbutton.h>
#include <qmultilineedit.h>


/**Add or edit questions
  *@author Javier Campos
  */

class kcontroladdedit : public KWizard  {
   Q_OBJECT
public: 
	kcontroladdedit(QWidget *parent = 0, const char *name = 0, bool modal = true, WFlags f = 0);
	~kcontroladdedit();
  /** Init KEDUCA pointer and EditMode */
  void init(FileRead *KEDUCAPTR, bool editMode);
  /** show current Page */
  void showPage(QWidget *page);
private: // Private methods
  /** Init graphical interface */
//  void initGUI();
  /** Fill page of current record */
  void fillPage();
  /** Refresh klistview of answers */
  void refreshAnswer_list();
  /** Add question with form data */
  void addQuestion();
  /** Write config settings */
  void configWrite();
  /** Read config settings */
  void configRead();
  /** Set page question */
  void setPageQuestion();
  /** Set answer page */
  void setPageAnswer();
private: // Private attributes
  /** Question text */
  QMultiLineEdit *question_text;
  /** Picture browser */
  KURLRequester *question_picture;
  /** Question type */
  KComboBox *question_type;
  /** Question explain */
  QMultiLineEdit *question_explain;
  /** Question tip */
  QLineEdit *question_tip;
  /** Answer text */
  QMultiLineEdit *answer_text;
  /** Answer value */
  KComboBox *answer_value;
  /** Answer points */
  KIntNumInput *answer_points;
  /** Button insert answers */
  QPushButton *Button_insert;
  /** Answer list */
  KListView *List_answers;
  /** Button remove answer */
  QPushButton *Button_remove;
  /** Button down answer */
  QPushButton *Button_down;
  /** Button up answer */
  QPushButton *Button_up;
  /** Time */
  KIntNumInput *question_time;
	/** Copy of answers */
	struct tmpStruct	{	QString text; bool result; int points; };
	QValueList<tmpStruct> Answer_copy;
  /** Pointer to keduca of kcontrol page */
  FileRead *KEDUCA;
  /** Is a edit modify? */
  bool editMode;
  /** Preview image */
  QLabel *question_preview1;
  /** Preview image 2 */
  QLabel *question_preview2;
  /** Page question */
  QWidget *page_question;
  /** Page answer */
  QWidget *page_answer;
private slots: // Private slots
  /** Remove answer */
  void slot_ButtonRemove();
private slots: // Private slots
  /** Accept changes */
  void accept();
  /** Button insert */
  void slot_ButtonAdd();
  /** Button Down */
  void slot_ButtonDown();
  /** Button Up */
  void slot_ButtonUp();
  /** Question data changed */
  void slotDataChanged();
  /** Preview image */
  void slotPreview( const QString & );
};

#endif
