/***************************************************************************
 *   Copyright (C) 2004 by Samuele Catuzzi                                 *
 *   samuele_catuzzi@yahoo.it                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <math.h>
#include "graphicvector.h"

GraphicVector::GraphicVector(QCanvas * canvas):QCanvasLine(canvas)
{
 setPen( QPen( QColor(red), 1, SolidLine )  );
 len = 20; 
 setZ(6);
 startx=0;
 starty=0;
 endx=4;
 endy=4;
 setAnimated(true);
}


GraphicVector::~GraphicVector()
{
}


/*!
    \fn GraphicVector::setDirection(double,double,double,double)
 */
void GraphicVector::setDirection(double start_x,double start_y,double end_x,double end_y)
{
 double x,y,mod,cos,sin;
 if (( start_x == end_x )&&( start_y == end_y )) return;
 startx=start_x;
 starty=start_y;
 x=end_x - start_x;
 y=end_y - start_y;
 mod=sqrt(x*x + y*y);
 cos=mod/x ; sin=mod/y ;
 x=len/cos;
 y=len/sin;
 endx=start_x + x;
 endy=start_y + y;
}


/*!
    \fn GraphicVector::advance(int)
 */
void GraphicVector::advance(int)
{
     setPoints((int)round(startx),(int)round(starty),(int)round(endx),(int)round(endy));
}
