/***************************************************************************
                          edgeobject.h  -  description
                             -------------------
    begin                : Sat Jan 12 2002
    copyright            : (C) 2002 by Samuele Catuzzi
    email                : samuele_catuzzi@yahoo.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EDGEOBJECT_H
#define EDGEOBJECT_H

#include <qcanvas.h>
#include "ball.h"
#include "samuele.h"

/**
  *@author Samuele Catuzzi
  */
class Ball;

class EdgeObject : public  QCanvasSprite {
public:
     EdgeObject(int IDnum,QCanvasPixmapArray *,QCanvas *,int Z = 10 );
     ~EdgeObject();
  /** No descriptions */
  int rtti() const;
  /** No descriptions */
  void setLines(double A=0,double B=0,double C=0,double A1=0,double B1=0,double C1=0,double A2=0,double B2=0,double C2=0);
  /** Line that contain segment of bouncing is:  ax + by +c = 0
Lines delimiter area are:  a1x+b1y+c1 >= 0   ,    a2x+b2y+c2 >= 0

Input data: center of ball C(Cx,Cy) , radius, speed of ball: V(Vx,Vy)
Output: time left to impact or -1 if the ball not collide with this edge

 */
  double EdgeCPrediction(Ball * ball);
public: //  Public attributes
  /**  */
  QCanvasPixmapArray * images;
  /** direction vector */
  samuele::Vector vect_Dir;
  /**  */
  int edgenumber ;
  /**  */
  double a ;
  /**  */
  double b ;
  /**  */
  double c ;
  /**  */
  double a1 ;
  /**  */
  double b1 ;
  /**  */
  double c1 ;
  /**  */
  double a2 ;
  /**  */
  double b2 ;
  /**  */
  double c2 ;
  /**  */
  QString name;
  /**  */
  bool is_a_bouncer;
};

#endif
