/***************************************************************************
 *   Copyright (C) 2004 by Samuele Catuzzi                                 *
 *   samuele_catuzzi@yahoo.it                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "canvasview.h"

CanvasView::~CanvasView()
{
}

void CanvasView::contentsMousePressEvent( QMouseEvent *e )
{
     QCanvasItemList list = canvas()->collisions( e->pos() );

     for ( QCanvasItemList::iterator it = list.begin(); it != list.end(); ++it )
          if ( (*it)->rtti() == 4000 ) {
               m_movingBall = (Ball *)*it;
               m_pos = e->pos();
               return;
          }
          m_movingBall = 0;
}

void CanvasView::contentsMouseReleaseEvent ( QMouseEvent * e )
{
     /*
     if ( m_movingBall ) {

     }
     */
}

void CanvasView::contentsMouseMoveEvent( QMouseEvent *e )
{
     if ( m_movingBall ) {
          m_movingBall->DragTo(e->pos().x(), e->pos().y());
          canvas()->update();
     }
}

#include "canvasview.moc"
