/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004  Hidetaka Iwai
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_POPUP_TABLIST_H__
#define __KZ_POPUP_TABLIST_H__


#include <gtk/gtk.h>
#include "kz-bookmark.h"
#include "kz-window.h"

G_BEGIN_DECLS

#define KZ_TYPE_POPUP_TABLIST		        (kz_popup_tablist_get_type ())
#define KZ_POPUP_TABLIST(obj)		        (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_POPUP_TABLIST, KzPopupTablist))
#define KZ_POPUP_TABLIST_CLASS(klass)	        (G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_POPUP_TABLIST, KzPopupTablistClass))
#define KZ_IS_POPUP_TABLIST(obj)	        (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_POPUP_TABLIST))
#define KZ_IS_POPUP_TABLIST_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_POPUP_TABLIST))
#define KZ_POPUP_TABLIST_GET_CLASS(obj)	        (G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_POPUP_TABLIST, KzPopupTablistClass))

typedef struct _KzPopupTablistClass   KzPopupTablistClass;
typedef struct _KzPopupTablist        KzPopupTablist;

struct _KzPopupTablist
{
	GtkWindow parent;
};

struct _KzPopupTablistClass
{
	GtkWindowClass parent_class;
	void (*selected) (KzPopupTablist* popup,
			  KzBookmark *bookmark, 
			  gint index); 
};

GType           kz_popup_tablist_get_type      (void) G_GNUC_CONST;
GtkWidget      *kz_popup_tablist_new           (KzWindow *kz);

void            kz_popup_tablist_show          (KzPopupTablist *popup, KzBookmark *tabs);
void            kz_popup_tablist_hide          (KzPopupTablist *popup);

G_END_DECLS

#endif /* __KZ_POPUP_TABLIST_H__ */
