
// -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-

//
//  Copyright (C) 2004 Hiroyuki Ikezoe
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */

#include "kz-mozprintingpromptservice.h"

#include <errno.h>

#include <nsIDOMWindow.h>
#define MOZILLA_STRICT_API
#include <nsEmbedString.h>
#undef MOZILLA_STRICT_API

#include "kz-print-dialog.h"
#include "gtk-utils.h"
#include "kz-mozutils.h"
#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif

NS_IMPL_ISUPPORTS1 (KzMozPrintingPromptService, nsIPrintingPromptService)

KzMozPrintingPromptService::KzMozPrintingPromptService ()
{
  NS_INIT_ISUPPORTS();
}


KzMozPrintingPromptService::~KzMozPrintingPromptService ()
{
}

NS_IMETHODIMP
KzMozPrintingPromptService::ShowPrintDialog (nsIDOMWindow *parent, 
		       			     nsIWebBrowserPrint *webBrowserPrint,
					     nsIPrintSettings *printSettings)
{
	gint result;
	gboolean rerun;
	PrintInfo *info;
	GtkWidget *kz = GetGtkWindowForDOMWindow(parent);
	GtkWidget *dialog = kz_print_dialog_new(GTK_WINDOW(kz));

	do
	{
		rerun = FALSE;
		result = gtk_dialog_run(GTK_DIALOG(dialog));

		if (result != GTK_RESPONSE_ACCEPT)
		{
			gtk_widget_destroy(dialog);
			return NS_ERROR_ABORT;
		}

		info = kz_print_dialog_get_print_info(KZ_PRINT_DIALOG(dialog));

		PRBool ToFile = (info->to_file == TRUE);
		printSettings->SetPrintToFile(ToFile);
		if (ToFile)
		{
			/* check the existence and the permisson */
			gboolean exist;
			exist = g_file_test(info->filename, G_FILE_TEST_EXISTS);

			if (access(info->filename, W_OK) == EACCES ||
			    access(info->filename, W_OK) == EROFS)
			{
				gtk_widget_destroy(dialog);
				return NS_ERROR_ABORT;
			}
			if (exist)
			{
				gboolean ret;
				const gchar *filename = info->filename;
				GtkWindow *window = GTK_WINDOW(dialog);
				ret = gtkutil_confirm_file_replace(window,
								   filename);
				if (!ret)
				{
					rerun = TRUE;
					continue;
				}
			}
			nsEmbedString file;

			NS_CStringToUTF16(nsEmbedCString(info->filename),
					  NS_CSTRING_ENCODING_UTF8, file);
			printSettings->SetToFileName(file.get());
		}
	} while (rerun);

	switch (info->range)
	{
	case KZ_PRINT_RANGE_ALL_PAGES:
		printSettings->SetPrintRange(nsIPrintSettings::kRangeAllPages);
		break;
	case KZ_PRINT_RANGE_SPECIFIED_PAGES:
		printSettings->SetPrintRange(nsIPrintSettings::kRangeSpecifiedPageRange);
		printSettings->SetStartPageRange(info->from_page);
		printSettings->SetEndPageRange(info->to_page);
		break;
	case KZ_PRINT_RANGE_SELECTION:
		printSettings->SetPrintRange(nsIPrintSettings::kRangeSelection);
		break;
	default:
		break;
	}

	printSettings->SetPaperSize(nsIPrintSettings::kPaperSizeNativeData);
	
	nsEmbedString paper;
	NS_CStringToUTF16(nsEmbedCString("A4"),
			  NS_CSTRING_ENCODING_UTF8, paper);
	printSettings->SetPaperName(paper.get());

	printSettings->SetMarginTop(0.0);
	printSettings->SetMarginLeft(0.0);
	printSettings->SetMarginBottom(0.0);
	printSettings->SetMarginRight(0.0);
	
	nsEmbedString printer;
	NS_CStringToUTF16(nsEmbedCString(info->printer),
			  NS_CSTRING_ENCODING_UTF8, printer);
	printSettings->SetPrinterName(printer.get());

	nsEmbedString tmp;
	NS_CStringToUTF16(nsEmbedCString(""),
			  NS_CSTRING_ENCODING_UTF8, tmp);
	printSettings->SetHeaderStrLeft(tmp.get());
	printSettings->SetHeaderStrCenter(tmp.get());
	printSettings->SetHeaderStrRight(tmp.get());
	printSettings->SetFooterStrLeft(tmp.get());
	printSettings->SetFooterStrCenter(tmp.get());
	printSettings->SetFooterStrRight(tmp.get());

	printSettings->SetPrintInColor(PR_TRUE);
	printSettings->SetOrientation(nsIPrintSettings::kPortraitOrientation);
	printSettings->SetPrintBGImages(PR_TRUE);
	printSettings->SetPrintBGColors(PR_TRUE);
	printSettings->SetPrintFrameType(nsIPrintSettings::kFramesAsIs);
	printSettings->SetShowPrintProgress(PR_FALSE);
	printSettings->SetShrinkToFit(PR_TRUE);
	printSettings->SetNumCopies(1);
	printSettings->SetPrintSilent(PR_TRUE);

	gtk_widget_destroy(dialog);

	return NS_OK;
}

NS_IMETHODIMP
KzMozPrintingPromptService::ShowProgress (nsIDOMWindow *parent,
      					  nsIWebBrowserPrint *webBrowserPrint,
					  nsIPrintSettings *printSettings,
					  nsIObserver *openDialogObserver,
					  PRBool isForPrinting,
					  nsIWebProgressListener **webProgressListener,
					  nsIPrintProgressParams **printProgressParams,
					  PRBool *notifyOnOpen)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP
KzMozPrintingPromptService::ShowPageSetup (nsIDOMWindow *parent,
					   nsIPrintSettings *printSettings,
					   nsIObserver *printObserver)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}


NS_IMETHODIMP
KzMozPrintingPromptService::ShowPrinterProperties (nsIDOMWindow *parent,
						   const PRUnichar *printerName,
						   nsIPrintSettings *printSettings)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}


