/*
 * sender.h
 *
 * Copyright (C) 2003-2005 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef SENDER_H
#define SENDER_H

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

#include <qthread.h>
#include <qstring.h>



class BChannel
{

public:

	BChannel( const QString &n, unsigned int pv, unsigned int pa, char a, unsigned int spid, unsigned int pg, unsigned int an, unsigned int tp, const QString &lg );
	QString name;
	unsigned int pida, pidv;
	char ac3;
	unsigned int subpid, page, id, type;
	QString lang;
};



class Sender : public QThread
{

public:

	Sender();
	~Sender();
	void run();
	void stop();
	void go();

	int senderSocket;
	struct sockaddr_in senderAddr;

protected:

	bool makeSenderSocket( const QString &addr, int m_senderPort );
	void closeSender();

	bool isRunning;
	QPtrList<BChannel> bchan;

};

#endif /* SENDER_H */
