/*
 * dvbevents.h
 *
 * Copyright (C) 2003-2006 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef DVBEVENTS_H
#define DVBEVENTS_H

#include <sys/poll.h>

#include <qtimer.h>
#include <qmutex.h>

#include "dvbsection.h"
#include "channeldesc.h"



class EventTsidList
{
public:
	EventTsidList( unsigned short t );
	~EventTsidList();
	unsigned short tsid;
	QPtrList<EventDesc> events;
};



class EventSourceList
{
public:
	EventSourceList( QString src );
	~EventSourceList();
	QString source;
	QPtrList<EventTsidList> tsidList;
};



class DVBevents : public DVBsection
{
	Q_OBJECT

public:

	DVBevents( bool *ok, int anum, int tnum, const QString &charset );
	~DVBevents();
	bool go( QString src, bool all=false );
	void stop();
	void doClean( bool b );
	void dumpEvents();

	QPtrList<EventSourceList> srcList;
	EventSourceList *currentSrcList;
	QMutex mutex;

protected:

	virtual void run();
	bool tableEIT( unsigned char* buffer );
	bool shortEventDesc( unsigned char *buf, EventDesc *desc );
	bool extEventDesc( unsigned char *buf, EventDesc *desc );
	bool safeLen( unsigned char* buf );

	bool clean;
	QTimer cleanTimer;

private slots:

	void setClean();

private:

	unsigned char secbuf[4096];
	int readSize;
	bool demuxOpened;
	struct pollfd pf[1];
	QString source;

signals:

	void newEvent( EventDesc* );

};

#endif /* DVBEVENTS_H */
