/***************************************************************************
                           main.cpp
                             -------------------
    begin                : Don Apr 17 11:30:44 CEST 2003
    revision             : $Revision: 1.28 $
    last modified        : $Date: 2005/07/10 13:12:14 $ by $Author: juergenk $
    copyright            : (C) 2003-2005 by Jürgen Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "kaffeineapp.h"
#include "version.h"

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kdebug.h>

#include <X11/Xlib.h>

#include <stdlib.h>

static KCmdLineOptions options[] =
{
  { "p", 0, 0 },
  { "play", I18N_NOOP ("Start playing immediately"), 0 },
  { "f", 0, 0 },
  { "fullscreen", I18N_NOOP ("Start in fullscreen mode"), 0 },
  { "a", 0, 0 },
  { "audiodriver <argument>", I18N_NOOP ("Set audio driver"), "default" },
  { "x", 0, 0 },
  { "videodriver <argument>", I18N_NOOP ("Set video driver"), "default" },
  { "d", 0, 0 },
  { "device <argument>", I18N_NOOP ("Set Audio-CD/VCD/DVD device path."), "default"},
  { "", 0, 0 },
  { "verbose", I18N_NOOP ("Output xine debug messages"), 0 },
  { "w", 0, 0 },
  { "wizard", I18N_NOOP ("Run installation wizard"), 0 },
  { "+[file]", I18N_NOOP ("File(s) to play. Can be a local file, a URL, a directory or 'DVD', 'VCD', 'AudioCD'."), 0 },
  KCmdLineLastOption
};


int main(int argc, char *argv[])
{
  /*  XInitThreads() should always be the first call in multithreaded X programs -
   *  but because of a bug in some xfree versions that can freeze at startup,
   *  we also call XInitThreads() in kxinewidget.cpp
   *
   *  kaffeinepart & konqueror: We call XInitThreads() in kxinewidget.cpp, so the part is
   *  not stable with buggy X implementations.
   */

#ifndef XINIT_WKRND  // configure flag --with-xinit-workaround not set
  kdDebug() << "Main: XInitThreads()" << endl;
  kdDebug() << "[INFO] If Kaffeine hangs here run 'configure --with-xinit-workaround' and recompile/reinstall." << endl;
  XInitThreads();
#endif

  KAboutData aboutData( "kaffeine", I18N_NOOP("Kaffeine Player"),
    KAFFEINE_VERSION, I18N_NOOP("A media player for KDE 3. Can use multiple backends for playback, default (and recommended) is xine."),
    KAboutData::License_GPL,
    I18N_NOOP("(c) 2003-2005, The Kaffeine Authors"), 0, "http://kaffeine.sourceforge.net", /*bug reports to:*/ "kaffeine-user@lists.sourceforge.net");

  aboutData.addAuthor("Christophe Thommeret", I18N_NOOP("Current maintainer"), "hftom@free.fr");
  aboutData.addAuthor("Jürgen Kofler", I18N_NOOP("Original author"), "kaffeine@gmx.net");

  aboutData.addCredit("Christopher Martin", I18N_NOOP("Various valuable patches."), "christopher.martin@utoronto.ca");
  aboutData.addCredit("Ben Jackson", I18N_NOOP("DVB OSD browsing patch."), "benj@puremourning.co.uk");
  aboutData.addCredit("Rainer Wirtz", I18N_NOOP("DVB categories patches."), "rainer.wirtz@gmx.de");
  aboutData.addCredit("Dieter Zander", I18N_NOOP("Logo for Kaffeine 0.8 and other artwork."), "dieter-mz@online.de");
  aboutData.addCredit("Anders Ellenshøj Andersen", I18N_NOOP("Logo animation for Kaffeine 0.5"), "andersa@ellenshoej.dk");
  aboutData.addCredit("Assaf Gillat", I18N_NOOP("Alternate encoding for meta tags. Many patches."), "gillata@gmail.com");
  aboutData.addCredit("Miguel Freitas", I18N_NOOP("xine post plugin handling. Many patches."), "miguel@cetuc.puc-rio.br", "http://www.xinehq.de");
  aboutData.addCredit("Giorgos Gousios", I18N_NOOP("Subtitle file import."), "gousiosg@cs.man.ac.uk");
  aboutData.addCredit("Michael Rolf", I18N_NOOP("M3U import. Testing."), "mi.rolf@gmx.net");


  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options );

  if (!KaffeineApp::start())
  {
    exit (0);    /* can't start new instance */
  }

  KaffeineApp a;

  return a.exec();
}


