/*
 * Decompiled with CFR 0.152.
 */
package kaffe.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.Vector;
import kaffe.io.ObjectStreamClassImpl;

public class ObjectInputStreamImpl
extends DataInputStream {
    private static ObjectStreamClassImpl defaultClassDesc = new ObjectStreamClassImpl();
    private static int firstKey = 0x7E0000;
    private byte[] buffer = new byte[255];
    private int pos;
    private int len;
    private boolean buffering = false;
    private Vector objectReferences = new Vector();
    private ObjectInputStream parent;

    public boolean enableBuffering(boolean bl) {
        boolean bl2 = this.buffering;
        if (bl != bl2) {
            if (this.buffering) {
                this.len = 0;
                this.pos = 0;
            }
            this.buffering = bl;
        }
        return bl2;
    }

    public Object readObject() throws OptionalDataException, ClassNotFoundException, IOException {
        boolean bl = this.enableBuffering(false);
        Object object = null;
        int n = this.readUnsignedByte();
        switch (n) {
            case 112: {
                object = null;
                break;
            }
            case 116: {
                object = this.readUTF();
                this.makeObjectReference(object);
                break;
            }
            case 113: {
                object = this.getObjectFromReference(this.readInt());
                break;
            }
            case 114: {
                object = this.getStreamClass();
                break;
            }
            case 115: {
                object = this.getObject();
                break;
            }
            case 117: {
                object = this.getArray();
                break;
            }
            case 121: {
                this.resetObjectReferences();
                return this.readObject();
            }
            case 119: {
                int n2 = this.read();
                if (n2 == -1) {
                    throw new StreamCorruptedException("incomplete block count");
                }
                throw new OptionalDataException(n2);
            }
            case 122: {
                int n3 = this.read();
                int n4 = this.read();
                int n5 = this.read();
                int n6 = this.read();
                if (n3 == -1 || n4 == -1 || n5 == -1 || n6 == -1) {
                    throw new StreamCorruptedException("incomplete block count");
                }
                int n7 = n3 << 24 | n4 << 16 | n5 << 8 | n6;
                throw new OptionalDataException(n7);
            }
            default: {
                throw new StreamCorruptedException("unexpected token: " + n);
            }
        }
        this.enableBuffering(bl);
        return object;
    }

    public void defaultReadObject(Object object, ObjectStreamClass objectStreamClass) throws IOException, StreamCorruptedException {
        boolean bl = this.enableBuffering(false);
        objectStreamClass.defaultReadObject(object, this.parent);
        this.enableBuffering(bl);
    }

    public void readStreamHeader() throws IOException, StreamCorruptedException {
        short s = this.readShort();
        if (s != -21267) {
            throw new StreamCorruptedException("bad magic nr: " + s);
        }
        s = this.readShort();
        if (s != 5) {
            throw new StreamCorruptedException("bad version nr: " + s);
        }
    }

    private Object getObjectFromReference(int n) throws StreamCorruptedException {
        try {
            return this.objectReferences.elementAt(n - firstKey);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new StreamCorruptedException("reference to unknown object");
        }
    }

    public void makeObjectReference(Object object) {
        this.objectReferences.addElement(object);
    }

    private void resetObjectReferences() {
        this.objectReferences.removeAllElements();
    }

    private Object getObject() throws StreamCorruptedException, OptionalDataException, InvalidClassException {
        try {
            ObjectStreamClassImpl objectStreamClassImpl = (ObjectStreamClassImpl)this.parent.readObject();
            Object object = objectStreamClassImpl.getObject(this.parent, this);
            return object;
        }
        catch (InvalidClassException invalidClassException) {
            throw invalidClassException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StreamCorruptedException("error getting object: " + classNotFoundException);
        }
        catch (IOException iOException) {
            throw new StreamCorruptedException("error getting object: " + iOException);
        }
        catch (ClassCastException classCastException) {
            throw new StreamCorruptedException("error getting object: " + classCastException);
        }
    }

    private Object getStreamClass() throws StreamCorruptedException {
        try {
            Object object = defaultClassDesc.getClass(this.parent, this);
            return object;
        }
        catch (IOException iOException) {
            throw new StreamCorruptedException("error getting class: " + iOException);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            throw new StreamCorruptedException("error getting class: " + classCastException);
        }
    }

    private Object getArray() throws StreamCorruptedException {
        try {
            ObjectStreamClassImpl objectStreamClassImpl = (ObjectStreamClassImpl)this.parent.readObject();
            Object object = objectStreamClassImpl.getArray(this.parent, this);
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StreamCorruptedException("bad array: " + classNotFoundException);
        }
        catch (IOException iOException) {
            throw new StreamCorruptedException("bad array: " + iOException);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            throw new StreamCorruptedException("bad array: " + classCastException);
        }
    }

    static /* synthetic */ InputStream access$0(ObjectInputStreamImpl objectInputStreamImpl) {
        return objectInputStreamImpl.in;
    }

    public ObjectInputStreamImpl(InputStream inputStream, ObjectInputStream objectInputStream) {
        super(null);
        ObjectInputStreamImpl objectInputStreamImpl = this;
        if (objectInputStreamImpl == null) {
            throw null;
        }
        this.in = objectInputStreamImpl.new Input(inputStream);
        this.parent = objectInputStream;
    }

    class Input
    extends InputStream {
        private InputStream in;
        int leftinblock;

        public void close() throws IOException {
            this.in.close();
        }

        public int read() throws IOException {
            if (!ObjectInputStreamImpl.this.buffering) {
                int n = this.in.read();
                return n;
            }
            if (ObjectInputStreamImpl.this.pos < ObjectInputStreamImpl.this.len) {
                byte[] byArray = ObjectInputStreamImpl.this.buffer;
                ObjectInputStreamImpl objectInputStreamImpl = ObjectInputStreamImpl.this;
                int n = objectInputStreamImpl.pos;
                objectInputStreamImpl.pos = n + 1;
                return byArray[n] & 0xFF;
            }
            if (this.leftinblock > 0) {
                int n = ObjectInputStreamImpl.this.buffer.length;
                if (n > this.leftinblock) {
                    n = this.leftinblock;
                }
                ObjectInputStreamImpl.this.len = this.in.read(ObjectInputStreamImpl.this.buffer, 0, n);
                if (ObjectInputStreamImpl.this.len != n) {
                    throw new StreamCorruptedException("bad blockdata size, read " + ObjectInputStreamImpl.this.len + " expected " + n);
                }
                ObjectInputStreamImpl.this.pos = 1;
                this.leftinblock -= ObjectInputStreamImpl.this.len;
                return ObjectInputStreamImpl.this.buffer[0] & 0xFF;
            }
            int n = this.in.read();
            switch (n) {
                case 119: {
                    this.leftinblock = this.in.read();
                    return this.read();
                }
                case 122: {
                    int n2 = 0;
                    int n3 = 24;
                    while (n3 >= 0) {
                        n = this.in.read();
                        if (n == -1) {
                            throw new StreamCorruptedException("reached eof while reading block size");
                        }
                        n2 |= n << n3;
                        n3 -= 8;
                    }
                    this.leftinblock = n2;
                    return this.read();
                }
            }
            new Throwable().printStackTrace();
            throw new StreamCorruptedException("expected blockdata: " + n);
        }

        Input(InputStream inputStream) {
            this.in = inputStream;
        }
    }
}

