/*
 * Decompiled with CFR 0.152.
 */
package kaffe.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import kaffe.io.CharToByteDefault;
import kaffe.io.ConverterAlias;

public abstract class CharToByteConverter {
    private static String encodingRoot;
    private static String encodingDefault;
    private static Hashtable cache;
    private static Class noConverter;
    protected char[] buf;
    protected int blen;
    private static /* synthetic */ Class class$Ljava$lang$Object;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void carry(char[] cArray, int n, int n2) {
        int n3 = this.blen + n2;
        if (cArray == this.buf && n == 0) {
            return;
        }
        if (this.buf == null) {
            int n4 = n2 < 128 ? 128 : n2;
            this.buf = new char[n4];
        } else if (n3 > this.buf.length) {
            int n5 = this.buf.length * 2;
            while (n5 < n3) {
                n5 *= 2;
            }
            char[] cArray2 = new char[n5];
            System.arraycopy(this.buf, 0, cArray2, 0, this.blen);
            this.buf = cArray2;
        }
        System.arraycopy(cArray, n, this.buf, this.blen, n2);
        this.blen = n3;
    }

    public abstract int convert(char[] var1, int var2, int var3, byte[] var4, int var5, int var6);

    public int flush(byte[] byArray, int n, int n2) {
        if (this.blen == 0) {
            return 0;
        }
        int n3 = this.blen;
        this.blen = 0;
        return this.convert(this.buf, 0, n3, byArray, n, n2);
    }

    private static CharToByteConverter getConverterInternal(String string) {
        Class clazz = (Class)cache.get(string);
        if (clazz == noConverter) {
            return null;
        }
        try {
            if (clazz == null) {
                String string2 = encodingRoot + ".CharToByte" + ConverterAlias.alias(string);
                clazz = Class.forName(string2);
                cache.put(string, clazz);
            }
            return (CharToByteConverter)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                String string3 = encodingRoot + ".CharToByte" + ConverterAlias.alias(string);
                InputStream inputStream = ClassLoader.getSystemResourceAsStream(string3.replace('.', '/') + ".ser");
                if (inputStream != null) {
                    ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                    Object object = objectInputStream.readObject();
                    objectInputStream.close();
                    return (CharToByteConverter)object;
                }
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException2) {}
        }
        catch (ClassCastException classCastException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        cache.put(string, noConverter);
        return null;
    }

    public static CharToByteConverter getConverter(String string) throws UnsupportedEncodingException {
        CharToByteConverter charToByteConverter = CharToByteConverter.getConverterInternal(string);
        if (charToByteConverter == null) {
            throw new UnsupportedEncodingException(string);
        }
        return charToByteConverter;
    }

    public static CharToByteConverter getDefault() {
        CharToByteConverter charToByteConverter = CharToByteConverter.getConverterInternal(encodingDefault);
        if (charToByteConverter == null) {
            charToByteConverter = new CharToByteDefault();
        }
        return charToByteConverter;
    }

    public abstract int getNumberOfBytes(char[] var1, int var2, int var3);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        cache = new Hashtable();
        noConverter = class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = CharToByteConverter.class$("java.lang.Object"));
        encodingRoot = "kaffe.io";
        encodingDefault = System.getProperty("file.encoding");
    }
}

