/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import kaffe.util.UTF8;

public class ZipOutputStream
extends DeflaterOutputStream
implements ZipConstants {
    private static final int ZIPVER_1_0 = 10;
    private static final int ZIPVER_2_0 = 20;
    private int method = 8;
    private int level = -1;
    private ZipEntry curr;
    private Vector dir;
    private OutputStream strm;
    private int dout;
    private int eout;
    private CRC32 crc;

    public void close() throws IOException {
        this.finish();
        super.close();
    }

    public void closeEntry() throws IOException {
        if (this.curr == null) {
            return;
        }
        super.finish();
        int n = this.def.getTotalIn();
        int n2 = this.def.getTotalOut();
        long l = this.crc.getValue();
        this.def.reset();
        this.crc.reset();
        if (this.curr.csize != -1L && this.curr.csize != (long)n2) {
            throw new ZipException("compress size set incorrectly");
        }
        if (this.curr.size != -1L && this.curr.size != (long)n) {
            throw new ZipException("uncompress size set incorrectly");
        }
        if (this.curr.crc != -1L && this.curr.crc != l) {
            throw new ZipException("crc set incorrectly");
        }
        this.curr.csize = n2;
        this.curr.size = n;
        this.curr.crc = l;
        this.dout = (int)((long)this.dout + this.curr.csize);
        if (this.curr.flag == 8) {
            byte[] byArray = new byte[16];
            this.put32(byArray, 0, 134695760);
            this.put32(byArray, 4, (int)this.curr.crc);
            this.put32(byArray, 8, (int)this.curr.csize);
            this.put32(byArray, 12, (int)this.curr.size);
            this.strm.write(byArray);
            this.dout += 16;
        }
        this.curr = null;
    }

    public void finish() throws IOException {
        byte[] byArray = new byte[46];
        int n = 0;
        int n2 = 0;
        if (this.dir == null) {
            return;
        }
        this.closeEntry();
        Object object = this.dir.elements();
        while (object.hasMoreElements()) {
            ZipEntry zipEntry = (ZipEntry)object.nextElement();
            byte[] byArray2 = zipEntry.name != null ? UTF8.encode(zipEntry.name) : new byte[]{};
            this.put32(byArray, 0, 33639248);
            int n3 = zipEntry.method == 0 ? 10 : 20;
            this.put16(byArray, 4, n3);
            this.put16(byArray, 6, n3);
            this.put16(byArray, 8, zipEntry.flag);
            this.put16(byArray, 10, zipEntry.method);
            this.put32(byArray, 12, zipEntry.dosTime);
            this.put32(byArray, 16, (int)zipEntry.crc);
            this.put32(byArray, 20, (int)zipEntry.csize);
            this.put32(byArray, 24, (int)zipEntry.size);
            this.put16(byArray, 28, byArray2.length);
            this.put16(byArray, 30, zipEntry.extra == null ? 0 : zipEntry.extra.length);
            this.put16(byArray, 32, zipEntry.comment == null ? 0 : zipEntry.comment.length());
            this.put16(byArray, 34, 0);
            this.put16(byArray, 36, 0);
            this.put32(byArray, 38, 0);
            this.put32(byArray, 42, (int)zipEntry.offset);
            this.strm.write(byArray);
            n2 += 46;
            this.strm.write(byArray2);
            n2 += byArray2.length;
            if (zipEntry.extra != null) {
                this.strm.write(zipEntry.extra);
                n2 += zipEntry.extra.length;
            }
            ++n;
        }
        if (n == 0) {
            throw new ZipException("ZIP file must have at least one entry");
        }
        object = new byte[22];
        this.put32((byte[])object, 0, 101010256);
        this.put16((byte[])object, 4, 0);
        this.put16((byte[])object, 6, 0);
        this.put16((byte[])object, 8, n);
        this.put16((byte[])object, 10, n);
        this.put32((byte[])object, 12, n2);
        this.put32((byte[])object, 16, this.dout);
        this.put16((byte[])object, 20, 0);
        this.strm.write((byte[])object);
        this.dir = null;
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        this.closeEntry();
        if (zipEntry.method == -1) {
            zipEntry.method = this.method;
        }
        if (zipEntry.method == 0) {
            if (zipEntry.size == -1L) {
                throw new ZipException("size not set in stored entry");
            }
            zipEntry.csize = zipEntry.size;
            if (zipEntry.crc == -1L) {
                throw new ZipException("crc not set in stored entry");
            }
            zipEntry.flag = 0;
        } else {
            zipEntry.flag = 8;
        }
        if (this.curr == null || this.curr.method != zipEntry.method) {
            if (zipEntry.method == 0) {
                ZipOutputStream zipOutputStream = this;
                if (zipOutputStream == null) {
                    throw null;
                }
                this.def = zipOutputStream.new Storer();
            } else {
                this.def = new Deflater(this.level, true);
            }
        }
        byte[] byArray = zipEntry.name != null ? UTF8.encode(zipEntry.name) : new byte[]{};
        byte[] byArray2 = new byte[30];
        this.put32(byArray2, 0, 67324752);
        this.put16(byArray2, 4, zipEntry.method == 0 ? 10 : 20);
        this.put16(byArray2, 6, zipEntry.flag);
        this.put16(byArray2, 8, zipEntry.method);
        this.put32(byArray2, 10, zipEntry.dosTime);
        if (zipEntry.method == 0) {
            this.put32(byArray2, 14, (int)zipEntry.crc);
            this.put32(byArray2, 18, (int)zipEntry.csize);
            this.put32(byArray2, 22, (int)zipEntry.size);
        } else {
            this.put32(byArray2, 14, 0);
            this.put32(byArray2, 18, 0);
            this.put32(byArray2, 22, 0);
        }
        this.put16(byArray2, 26, byArray.length);
        this.put16(byArray2, 28, zipEntry.extra == null ? 0 : zipEntry.extra.length);
        this.strm.write(byArray2);
        zipEntry.offset = this.dout;
        this.dout += 30;
        this.strm.write(byArray);
        this.dout += byArray.length;
        if (zipEntry.extra != null) {
            this.strm.write(zipEntry.extra);
            this.dout += zipEntry.extra.length;
        }
        this.dir.addElement(zipEntry);
        this.curr = zipEntry;
    }

    public void setComment(String string) {
    }

    public void setLevel(int n) {
        if ((n < 0 || n > 9) && n != -1) {
            throw new IllegalArgumentException("bad compression level");
        }
        this.level = n;
    }

    public void setMethod(int n) {
        if (n != 8 && n != 0) {
            throw new IllegalArgumentException("bad compression method");
        }
        this.method = n;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.crc.update(byArray, n, n2);
    }

    private void put16(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)n2;
        byArray[n + 1] = (byte)(n2 >>> 8);
    }

    private void put32(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)n2;
        byArray[n + 1] = (byte)(n2 >>> 8);
        byArray[n + 2] = (byte)(n2 >>> 16);
        byArray[n + 3] = (byte)(n2 >>> 24);
    }

    public ZipOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.strm = outputStream;
        this.curr = null;
        this.dir = new Vector();
        this.dout = 0;
        this.crc = new CRC32();
    }

    class Storer
    extends Deflater {
        private int total = 0;
        private byte[] buf;
        private int off = 0;
        private int len = 0;

        public int deflate(byte[] byArray, int n, int n2) {
            if (n2 >= this.len) {
                n2 = this.len;
            }
            System.arraycopy(this.buf, this.off, byArray, n, n2);
            this.total += n2;
            this.off += n2;
            this.len -= n2;
            return n2;
        }

        public synchronized void setInput(byte[] byArray, int n, int n2) {
            this.buf = byArray;
            this.off = n;
            this.len = n2;
        }

        public boolean needsInput() {
            return this.len <= 0;
        }

        public boolean finished() {
            return this.len <= 0;
        }

        public int getTotalIn() {
            return this.total;
        }

        public int getTotalOut() {
            return this.total;
        }

        public void reset() {
        }

        Storer() {
        }
    }
}

