/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SimpleTimeZone;
import kaffe.util.UNIXTimeZone;

public abstract class TimeZone
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3581463369166924961L;
    private static TimeZone defaultTimeZone = null;
    private static HashMap zones = new HashMap();
    private static boolean zonesLoaded = false;
    private static String[] zoneDirs = new String[]{"/usr/share/zoneinfo", "/usr/share/lib/zoneinfo"};
    private String timezoneID = null;

    private static void loadTimeZones() {
        TimeZone.addSimple(-39600000, "MIT");
        TimeZone.addSimple(-36000000, "HST");
        TimeZone.addSimple(-32400000, "AST");
        TimeZone.addSimple(-28800000, "PST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        TimeZone.addSimple(-28800000, "PDT", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        TimeZone.addSimple(-25200000, "PNT");
        TimeZone.addSimple(-25200000, "MST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        TimeZone.addSimple(-25200000, "MDT", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        TimeZone.addSimple(-21600000, "CST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        TimeZone.addSimple(-21600000, "CDT", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        TimeZone.addSimple(-18000000, "EST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        TimeZone.addSimple(-18000000, "EDT", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        TimeZone.addSimple(-18000000, "IET");
        TimeZone.addSimple(-14400000, "PRT");
        TimeZone.addSimple(-12600000, "CNT");
        TimeZone.addSimple(-10800000, "AGT");
        TimeZone.addSimple(-3600000, "CAT");
        TimeZone.addSimple(0, "GMT");
        TimeZone.addSimple(3600000, "ECT");
        TimeZone.addSimple(3600000, "EET");
        TimeZone.addSimple(0x6DDD00, "ART");
        TimeZone.addSimple(10800000, "EAT");
        TimeZone.addSimple(12600000, "MET");
        TimeZone.addSimple(14400000, "NET");
        TimeZone.addSimple(18000000, "PLT");
        TimeZone.addSimple(19800000, "IST");
        TimeZone.addSimple(21600000, "BST");
        TimeZone.addSimple(25200000, "VST");
        TimeZone.addSimple(28800000, "CTT");
        TimeZone.addSimple(32400000, "JST");
        TimeZone.addSimple(34200000, "ACT");
        TimeZone.addSimple(36000000, "AET");
        TimeZone.addSimple(39600000, "SST");
        TimeZone.addSimple(43200000, "NST");
        int n = 0;
        while (n < zoneDirs.length) {
            File file = new File(zoneDirs[n]);
            if (file.isDirectory()) {
                TimeZone.addZoneFiles(null, file);
            }
            ++n;
        }
        zonesLoaded = true;
    }

    private static void addSimple(int n, String string) {
        zones.put(string, new SimpleTimeZone(n, string));
    }

    private static void addSimple(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        zones.put(string, new SimpleTimeZone(n, string, n2, n3, n4, n5, n6, n7, n8, n9));
    }

    private static void addZoneFiles(String string, File file) {
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            String string2;
            File file2 = new File(file, stringArray[n]);
            String string3 = string2 = string == null ? stringArray[n] : string + "/" + stringArray[n];
            if (file2.isFile()) {
                try {
                    zones.put(string2, new UNIXTimeZone(string2, file2));
                }
                catch (IOException iOException) {}
            } else if (file2.isDirectory()) {
                TimeZone.addZoneFiles(string2, file2);
            }
            ++n;
        }
    }

    public Object clone() {
        try {
            return (TimeZone)super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static synchronized String[] getAvailableIDs() {
        if (!zonesLoaded) {
            TimeZone.loadTimeZones();
        }
        return (String[])zones.keySet().toArray(new String[zones.size()]);
    }

    public static synchronized String[] getAvailableIDs(int n) {
        if (!zonesLoaded) {
            TimeZone.loadTimeZones();
        }
        HashSet hashSet = new HashSet();
        Iterator iterator = zones.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            TimeZone timeZone = (TimeZone)entry.getValue();
            if (timeZone.getRawOffset() != n) continue;
            hashSet.add(entry.getKey());
        }
        return (String[])hashSet.toArray(new String[hashSet.size()]);
    }

    public static synchronized TimeZone getDefault() {
        if (defaultTimeZone == null) {
            String string = System.getProperty("user.timezone", "GMT");
            defaultTimeZone = TimeZone.getTimeZone(string);
            if (defaultTimeZone == null) {
                defaultTimeZone = TimeZone.getTimeZone("GMT");
            }
            if (defaultTimeZone == null) {
                throw new InternalError("Cannot intialize timezone. GMT & " + string + " zones are undefined.");
            }
        }
        return defaultTimeZone;
    }

    public String getID() {
        return this.timezoneID;
    }

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract int getRawOffset();

    public static synchronized TimeZone getTimeZone(String string) {
        if (!zonesLoaded) {
            TimeZone.loadTimeZones();
        }
        return (TimeZone)zones.get(string);
    }

    public abstract boolean inDaylightTime(Date var1);

    public static synchronized void setDefault(TimeZone timeZone) {
        defaultTimeZone = timeZone;
    }

    public void setID(String string) {
        this.timezoneID = string;
    }

    public abstract void setRawOffset(int var1);

    public String toString() {
        return this.timezoneID;
    }

    public abstract boolean useDaylightTime();
}

