/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;

public final class StringCharacterIterator
implements CharacterIterator {
    private String text;
    private int pos;
    private int begin;
    private int end;

    void setText(String string) {
        this.text = string;
        this.pos = 0;
        this.begin = 0;
        this.end = string.length();
    }

    public Object clone() {
        return new StringCharacterIterator(this.text, this.begin, this.end, this.pos);
    }

    public char current() {
        if (this.pos < this.begin || this.pos >= this.end) {
            return '\uffff';
        }
        return this.text.charAt(this.pos);
    }

    public boolean equals(Object object) {
        if (object instanceof StringCharacterIterator) {
            StringCharacterIterator stringCharacterIterator = (StringCharacterIterator)object;
            if (this.text.equals(stringCharacterIterator.text) && this.pos == stringCharacterIterator.pos && this.begin == stringCharacterIterator.begin && this.end == stringCharacterIterator.end) {
                return true;
            }
        }
        return false;
    }

    public char first() {
        this.pos = this.begin;
        return this.text.charAt(this.pos);
    }

    public char last() {
        this.pos = this.end - 1;
        return this.text.charAt(this.pos);
    }

    public int getBeginIndex() {
        return this.begin;
    }

    public int getEndIndex() {
        return this.end;
    }

    public int getIndex() {
        return this.pos;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public char next() {
        if (this.pos < this.end) {
            return this.text.charAt(this.pos++);
        }
        return '\uffff';
    }

    public char previous() {
        if (this.pos > this.begin) {
            return this.text.charAt(--this.pos);
        }
        return '\uffff';
    }

    public char setIndex(int n) {
        if (n < this.begin || n > this.end) {
            throw new IllegalArgumentException("Invalid index: " + n);
        }
        this.pos = n;
        return n == this.end ? (char)'\uffff' : this.text.charAt(n);
    }

    public StringCharacterIterator(String string) {
        this(string, 0, string.length(), 0);
    }

    public StringCharacterIterator(String string, int n) {
        this(string, 0, string.length(), n);
    }

    public StringCharacterIterator(String string, int n, int n2, int n3) {
        if (n < 0 || n2 > string.length() || n > n2 || n3 < n || n3 > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        this.text = string;
        this.pos = n3;
        this.begin = n;
        this.end = n2;
    }
}

