/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import kaffe.io.StdErrorStream;
import kaffe.io.StdInputStream;
import kaffe.io.StdOutputStream;

public final class System {
    static final SecurityManager defaultSecurityManager;
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;
    private static Properties props;
    private static SecurityManager security;

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    private static void checkPropertyAccess() {
        System.getSecurityManager().checkPropertiesAccess();
    }

    public static native long currentTimeMillis();

    public static void exit(int n) {
        Runtime.getRuntime().exit(n);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static Properties getProperties() {
        System.checkPropertyAccess();
        return props;
    }

    public static String getProperty(String string) {
        System.checkPropertyAccess();
        return props.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        System.checkPropertyAccess();
        return props.getProperty(string, string2);
    }

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static String getenv(String string) {
        throw new Error("System.getenv no longer supported");
    }

    public static native int identityHashCode(Object var0);

    private static native Properties initProperties(Properties var0);

    public static void load(String string) {
        Runtime.getRuntime().load(string, Class.getStackClass(1).getClassLoader());
    }

    public static void loadLibrary(String string) {
        Runtime.getRuntime().loadLibrary(string, Class.getStackClass(1).getClassLoader());
    }

    public static String mapLibraryName(String string) {
        return NativeLibrary.getLibPrefix() + string + NativeLibrary.getLibSuffix();
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    public static void runFinalizersOnExit(boolean bl) {
        Runtime.getRuntime();
        Runtime.runFinalizersOnExit(bl);
    }

    public static void setErr(PrintStream printStream) {
        System.setErr0(printStream);
    }

    private static native void setErr0(PrintStream var0);

    public static void setIn(InputStream inputStream) {
        System.setIn0(inputStream);
    }

    private static native void setIn0(InputStream var0);

    public static void setOut(PrintStream printStream) {
        System.setOut0(printStream);
    }

    private static native void setOut0(PrintStream var0);

    public static void setProperties(Properties properties) {
        System.checkPropertyAccess();
        props = properties;
    }

    public static void setSecurityManager(SecurityManager securityManager) {
        if (security != defaultSecurityManager) {
            throw new SecurityException();
        }
        if (securityManager != null) {
            security = securityManager;
        }
    }

    private System() {
    }

    /*
     * Loose catch block
     */
    static {
        block13: {
            security = defaultSecurityManager = new NullSecurityManager();
            props = System.initProperties(new Properties());
            InputStream inputStream = ClassLoader.getSystemResourceAsStream("system.properties");
            if (inputStream != null) {
                props.load(inputStream);
                Object var2_1 = null;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                break block13;
                {
                    catch (IOException iOException) {
                        Object var2_2 = null;
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        if (props.getProperty("kaffe.embedded", "false").equals("false")) {
            in = new BufferedInputStream(new FileInputStream(FileDescriptor.in), 128);
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out), 128), true);
            err = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.err), 128), true);
        } else {
            in = new BufferedInputStream(new StdInputStream(), 128);
            out = new PrintStream(new BufferedOutputStream(new StdOutputStream(), 128), true);
            err = new PrintStream(new BufferedOutputStream(new StdErrorStream(), 128), true);
        }
        try {
            Class.forName("kaffe.lang.SystemClassLoader");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

