/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

class TextCanvas
extends Canvas
implements MouseMotionListener,
MouseListener,
ComponentListener,
AdjustmentListener,
KeyListener,
FocusListener {
    public final int NOACTION = 0;
    private final int EDGE = 10;
    private Scrollbar horiz;
    private Scrollbar vert;
    private boolean eactive;
    private boolean hactive;
    private boolean dirty;
    private boolean mouseDown;
    private int sx;
    private int sy;
    private int ny;
    private int line;
    private int column;
    private int pix;
    private int eline;
    private int ecolumn;
    private int epix;
    private int widest;
    private int wpix;
    private int oldlines;
    private int fontHeight;
    private int fontDescent;
    private int tabSize = 4;
    private String lineSeparator;
    private Font font;
    private FontMetrics fontMetrics;
    private Frame parent;
    private TextCursor textCursor;
    private EditMan editMan;
    private Dimension dimension;
    private Vector lines;
    private TextJournal journal;
    private TextScroller textScroller;
    private boolean gotFocus = false;
    private int opix;
    private int oepix;
    private int oline;
    private int oeline;
    private int hpix;
    private int hepix;
    private int hline;
    private int heline;
    private int hcolumn;
    private int hecolumn;
    private int lastx;
    private int lasty;
    private int cline;
    private int ccolumn;
    private int cpix;
    private final int myMask = 14;
    private final int SLOW_READ = 2000;
    private final int SLOW_WRITE = 10000;

    public TextCanvas(Frame frame, Scrollbar scrollbar, Scrollbar scrollbar2) {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.parent = frame;
        this.lineSeparator = System.getProperty("line.separator");
        this.horiz = scrollbar;
        this.horiz.addAdjustmentListener(this);
        this.horiz.addKeyListener(this);
        this.vert = scrollbar2;
        this.vert.addAdjustmentListener(this);
        this.vert.addKeyListener(this);
        this.lines = new Vector();
        this.journal = new TextJournal(this, this.lines, this.lineSeparator);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.clear();
        this.validate();
        this.requestFocus();
        this.textCursor = new TextCursor(this);
        this.textCursor.start();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.gotFocus = true;
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.release_cursor(true);
        }
    }

    private void release_cursor() {
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.release_cursor(true);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.pause_cursor(true);
        }
        this.gotFocus = false;
    }

    private void pause_cursor() {
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.pause_cursor(true);
        }
    }

    public void setEditMan(EditMan editMan) {
        this.editMan = editMan;
    }

    public void clear() {
        this.clear_area(null);
        this.dirty = false;
        this.eactive = false;
        this.hactive = false;
        if (this.editMan != null) {
            this.editMan.updateCopyItems(false);
            this.editMan.updateUndoItems(false, false);
        }
        this.sy = 0;
        this.sx = 0;
        this.column = 0;
        this.line = 0;
        this.widest = 0;
        this.wpix = 0;
        this.oldlines = 0;
        this.pix = 10;
        this.horiz.setValue(0);
        this.vert.setValue(0);
        this.lines.removeAllElements();
        this.journal.clear();
    }

    public void validate() {
        if (this.lines.size() == 0) {
            this.appendLine(new String(""));
        }
        this.redoControls(this.horiz.getValue(), this.vert.getValue(), false);
    }

    public void setFont(String string, int n) {
        this.font = new Font(string, 0, n);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.clear_area(graphics);
            this.updateFonts(graphics);
            this.resizeLines();
            this.redoControls(this.horiz.getValue(), this.vert.getValue(), false);
            this.repaint();
            graphics.dispose();
            return;
        }
        this.fontMetrics = null;
    }

    private void clear_area(Graphics graphics) {
        boolean bl = false;
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.pause_cursor(true);
        }
        if (this.dimension == null) {
            return;
        }
        if (graphics == null) {
            graphics = this.getGraphics();
            bl = true;
        }
        if (graphics != null) {
            graphics.clearRect(0, 0, this.dimension.width, this.dimension.height);
        }
        if (bl && graphics != null) {
            graphics.dispose();
        }
    }

    public void setTab(int n) {
        this.clear_area(null);
        this.tabSize = n;
        this.resizeLines();
        this.repaint();
    }

    public void undo(boolean bl) {
        TextPosition textPosition;
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.pause_cursor(true);
        }
        if ((textPosition = bl ? this.journal.undo() : this.journal.redo()) == null) {
            if (this.textCursor != null && !this.eactive && this.gotFocus) {
                this.textCursor.release_cursor(true);
                return;
            }
        } else {
            this.eactive = false;
            this.hactive = false;
            this.line = this.eline = textPosition.line;
            this.column = this.ecolumn = textPosition.column;
            this.pix = this.epix = this.pix_at(this.line, this.column);
            this.shiftVert(this.line);
            this.shiftHoriz(this.pix);
            this.repaint();
        }
    }

    public void updateUndoItems(boolean bl, boolean bl2) {
        if (this.editMan != null) {
            this.editMan.updateUndoItems(bl, bl2);
        }
    }

    private void updateFonts(Graphics graphics) {
        boolean bl = false;
        if (graphics == null) {
            graphics = this.getGraphics();
            bl = true;
        }
        if (graphics != null) {
            graphics.setFont(this.font);
            this.fontMetrics = graphics.getFontMetrics(this.font);
            this.fontHeight = this.fontMetrics.getHeight();
            this.fontDescent = this.fontMetrics.getDescent();
            if (bl) {
                graphics.dispose();
            }
        }
    }

    public void print(String string) {
        PrintMan printMan = new PrintMan(this.parent, string, this.lines, this.font, this.tabSize);
        if (printMan != null) {
            printMan.start();
        }
    }

    public boolean find(String string) {
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.pause_cursor(true);
        }
        int n = this.lines.size();
        int n2 = this.line;
        int n3 = 0;
        while (n3++ <= n) {
            String string2 = (String)this.lines.elementAt(n2);
            int n4 = n2 == this.line && n3 == 1 ? (this.eactive ? this.column + 1 : this.column) : 0;
            int n5 = string2.indexOf(string, n4);
            if (n5 >= 0) {
                this.line = this.eline = n2;
                this.column = n5;
                String string3 = string2.substring(0, this.column);
                this.pix = (this.fontMetrics == null ? -1 : this.fontMetrics.stringWidth(this.detabbed(string3))) + 10;
                this.ecolumn = n5 + string.length();
                string3 = string2.substring(0, this.ecolumn);
                this.epix = (this.fontMetrics == null ? -1 : this.fontMetrics.stringWidth(this.detabbed(string3))) + 10;
                this.eactive = true;
                this.setup_h();
                this.save_h();
                if (this.editMan != null) {
                    this.editMan.updateCopyItems(this.eactive);
                }
                this.shiftVert(this.line);
                this.shiftHoriz(this.pix);
                this.shiftHoriz(this.epix);
                this.repaint();
                return true;
            }
            if (++n2 < n) continue;
            n2 = 0;
        }
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.release_cursor(true);
        }
        return false;
    }

    public synchronized void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        if (this.mouseDown) {
            return;
        }
        this.mouseDown = true;
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.pause_cursor(true);
        }
        Graphics graphics = this.getGraphics();
        this.updateFonts(graphics);
        this.clickPosition(mouseEvent.getX(), mouseEvent.getY());
        if (this.cline < 0 || this.cline >= this.lines.size()) {
            return;
        }
        this.eline = this.cline;
        this.ecolumn = this.ccolumn;
        this.epix = this.cpix;
        int n = mouseEvent.getClickCount();
        if (n == 3) {
            this.eline = this.line = this.cline;
            this.column = 0;
            this.pix = 10;
            String string = (String)this.lines.elementAt(this.cline);
            this.ecolumn = string.length();
            this.epix = (this.fontMetrics == null ? -1 : this.fontMetrics.stringWidth(this.detabbed(string))) + 10;
            this.eactive = true;
            this.setup_h();
            this.save_h();
            if (this.editMan != null) {
                this.editMan.updateCopyItems(this.eactive);
            }
            this.repaint();
        } else if (n == 2) {
            this.eline = this.line = this.cline;
            String string = (String)this.lines.elementAt(this.cline);
            this.column = this.ecolumn = this.ccolumn;
            while (this.column != 0 && Character.isLetterOrDigit(string.charAt(this.column - 1))) {
                --this.column;
            }
            String string2 = string.substring(0, this.column);
            this.pix = (this.fontMetrics == null ? -1 : this.fontMetrics.stringWidth(this.detabbed(string2))) + 10;
            int n2 = string.length();
            while (this.ecolumn < n2 && Character.isLetterOrDigit(string.charAt(this.ecolumn))) {
                ++this.ecolumn;
            }
            String string3 = string.substring(0, this.ecolumn);
            this.epix = (this.fontMetrics == null ? -1 : this.fontMetrics.stringWidth(this.detabbed(string3))) + 10;
            this.eactive = true;
            this.setup_h();
            this.save_h();
            if (this.editMan != null) {
                this.editMan.updateCopyItems(this.eactive);
            }
            this.repaint();
        } else if (mouseEvent.isShiftDown()) {
            this.eline = this.cline;
            this.ecolumn = this.ccolumn;
            this.epix = this.cpix;
            this.eactive = true;
            this.setup_h();
            this.save_h();
            if (this.editMan != null) {
                this.editMan.updateCopyItems(this.eactive);
            }
            this.repaint();
        } else {
            if (this.hactive) {
                this.flip_h(graphics, this.oline, this.opix, this.oeline, this.oepix);
            }
            this.eline = this.line = this.cline;
            this.ecolumn = this.column = this.ccolumn;
            this.epix = this.pix = this.cpix;
            this.hactive = false;
            this.eactive = true;
            if (this.editMan != null) {
                this.editMan.updateCopyItems(this.eactive);
            }
            this.addMouseMotionListener(this);
        }
        graphics.dispose();
    }

    public synchronized void mouseDragged(MouseEvent mouseEvent) {
        Graphics graphics = this.getGraphics();
        this.updateFonts(graphics);
        if (mouseEvent != null) {
            this.lastx = mouseEvent.getX();
            this.lasty = mouseEvent.getY();
        }
        this.clickPosition(this.lastx, this.lasty);
        this.eline = this.cline;
        this.ecolumn = this.ccolumn;
        this.epix = this.cpix;
        boolean bl = this.eactive = this.eline != this.line || this.ecolumn != this.column;
        if (this.eactive || this.hactive) {
            this.setup_h();
            if (this.eline < this.sy || this.eline >= this.sy + this.ny || this.epix < this.sx || this.epix >= this.dimension.width) {
                if (this.textScroller == null) {
                    this.textScroller = new TextScroller(this);
                    this.textScroller.start();
                }
                this.shiftVert(this.eline);
                this.shiftHoriz(this.epix);
                this.setup_h();
                this.save_h();
                int n = 0;
                while (n < this.ny) {
                    this.drawLine(graphics, this.sy + n);
                    ++n;
                }
            } else {
                if (this.textScroller != null) {
                    this.textScroller.stop();
                    this.textScroller = null;
                }
                if (this.hactive) {
                    if (this.hline < this.oline || this.hline == this.oline && this.hpix < this.opix) {
                        this.flip_h(graphics, this.hline, this.hpix, this.oline, this.opix);
                    }
                    if (this.hline > this.oline || this.hline == this.oline && this.hpix > this.opix) {
                        this.flip_h(graphics, this.oline, this.opix, this.hline, this.hpix);
                    }
                    if (this.heline < this.oeline || this.heline == this.oeline && this.hepix < this.oepix) {
                        this.flip_h(graphics, this.heline, this.hepix, this.oeline, this.oepix);
                    }
                    if (this.heline > this.oeline || this.heline == this.oeline && this.hepix > this.oepix) {
                        this.flip_h(graphics, this.oeline, this.oepix, this.heline, this.hepix);
                    }
                } else {
                    this.flip_h(graphics, this.hline, this.hpix, this.heline, this.hepix);
                }
                this.hactive = this.eactive;
                this.save_h();
            }
        }
        graphics.dispose();
    }

    void clickPosition(int n, int n2) {
        this.cline = n2 / this.fontHeight + this.sy;
        if (this.cline < 0) {
            this.cpix = 0;
            this.ccolumn = 0;
            this.cline = 0;
            return;
        }
        if (this.cline >= this.lines.size()) {
            this.cline = this.lines.size() - 1;
            String string = (String)this.lines.elementAt(this.cline);
            this.ccolumn = string.length();
            this.cpix = (this.fontMetrics == null ? -1 : this.fontMetrics.stringWidth(this.detabbed(string))) + 10;
            return;
        }
        this.ccolumn = 0;
        this.cpix = 0;
        if ((n += this.sx) > 10) {
            String string = (String)this.lines.elementAt(this.cline);
            this.ccolumn = string.length();
            if (this.ccolumn > 0 && n < (this.cpix = (this.fontMetrics == null ? -1 : this.fontMetrics.stringWidth(this.detabbed(string))) + 10)) {
                if (this.ccolumn > 10) {
                    String string2;
                    int n3 = this.ccolumn / 5;
                    do {
                        this.ccolumn -= n3;
                        if (this.ccolumn < 0) {
                            this.ccolumn = 0;
                            string2 = null;
                            continue;
                        }
                        string2 = string.substring(0, this.ccolumn);
                    } while (this.ccolumn > 0 && n < (this.cpix = (this.fontMetrics == null ? -1 : this.fontMetrics.stringWidth(this.detabbed(string2))) + 10));
                    this.ccolumn += n3;
                }
                while (this.ccolumn > 0 && n < (this.cpix = (this.fontMetrics == null ? -1 : this.fontMetrics.stringWidth(this.detabbed(string))) + 10)) {
                    string = string.substring(0, --this.ccolumn);
                }
            }
        }
    }

    private void flip_h(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setXORMode(Color.white);
        if (n3 >= this.sy + this.ny) {
            n3 = this.sy + this.ny - 1;
            n4 = 5000;
        }
        int n5 = n;
        while (n5 <= n3) {
            int n6 = (n5 - this.sy) * this.fontHeight;
            int n7 = 0;
            int n8 = 5000;
            if (n5 == n) {
                n7 = n2 - this.sx;
            }
            if (n5 == n3) {
                n8 = n4 - this.sx;
                if (n == n3) {
                    n8 -= n7;
                }
            }
            graphics.fillRect(n7, n6, n8, this.fontHeight);
            ++n5;
        }
    }

    private void setup_h() {
        if (this.line < this.eline || this.line == this.eline && this.column <= this.ecolumn) {
            this.hline = this.line;
            this.hcolumn = this.column;
            this.hpix = this.pix;
            this.heline = this.eline;
            this.hecolumn = this.ecolumn;
            this.hepix = this.epix;
            return;
        }
        this.hline = this.eline;
        this.hcolumn = this.ecolumn;
        this.hpix = this.epix;
        this.heline = this.line;
        this.hecolumn = this.column;
        this.hepix = this.pix;
    }

    private void save_h() {
        this.opix = this.hpix;
        this.oepix = this.hepix;
        this.oline = this.hline;
        this.oeline = this.heline;
        this.hactive = this.eactive;
    }

    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        if (!this.mouseDown) {
            return;
        }
        this.mouseDown = false;
        if (this.textScroller != null) {
            this.textScroller.stop();
            this.textScroller = null;
        }
        this.removeMouseMotionListener(this);
        boolean bl = this.eactive = this.eline != this.line || this.ecolumn != this.column;
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.release_cursor(true);
        }
        if (this.editMan != null) {
            this.editMan.updateCopyItems(this.eactive);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (!this.gotFocus) {
            return;
        }
        if ((keyEvent.getModifiers() & 0xE) != 0) {
            return;
        }
        if (n == 38 && this.line == 0) {
            return;
        }
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.pause_cursor(true);
        }
        switch (n) {
            case 38: {
                --this.line;
                this.cursorAdjust();
                return;
            }
            case 40: {
                ++this.line;
                this.cursorAdjust();
                return;
            }
            case 39: {
                ++this.column;
                this.cursorAdjust();
                return;
            }
            case 37: {
                --this.column;
                this.cursorAdjust();
                return;
            }
        }
        char c = keyEvent.getKeyChar();
        if (c != '\u0000') {
            if (n == 10) {
                if (this.hactive) {
                    this.copy(true);
                }
                this.journal.split_line(this.line, this.column);
                this.shiftVert(++this.line);
                this.column = 0;
                this.pix = 10;
                this.shiftHoriz(0);
                this.dirty = true;
                this.repaint();
                return;
            }
            if (n == 8) {
                if (this.hactive) {
                    this.copy(true);
                    return;
                }
                if (this.column > 0) {
                    this.journal.delete_prev_char(this.line, this.column);
                    --this.column;
                    this.redoLine(this.line, this.column + 1);
                    return;
                }
                if (this.line > 0) {
                    --this.line;
                    String string = (String)this.lines.elementAt(this.line);
                    this.column = string.length();
                    this.shiftHoriz((this.fontMetrics == null ? -1 : this.fontMetrics.stringWidth(this.detabbed(string))) + 10);
                    this.journal.join_line(this.line, this.column);
                    this.shiftVert(this.line);
                    this.dirty = true;
                    this.repaint();
                    return;
                }
            } else if (n == 127) {
                if (this.hactive) {
                    this.copy(true);
                    return;
                }
                String string = (String)this.lines.elementAt(this.line);
                int n2 = string.length();
                if (this.column < n2) {
                    this.journal.delete_next_char(this.line, this.column);
                    this.redoLine(this.line, this.column + 1);
                    return;
                }
                if (this.line + 1 < this.lines.size()) {
                    this.journal.join_line(this.line, this.column);
                    this.dirty = true;
                    this.repaint();
                    return;
                }
            } else if (n != 27 && c != '\n' && c != '\b') {
                if (this.hactive) {
                    this.copy(true);
                }
                this.journal.insert_char(this.line, this.column, c);
                ++this.column;
                this.redoLine(this.line, this.column);
                if (this.textCursor != null && !this.eactive && this.gotFocus) {
                    this.textCursor.release_cursor(true);
                }
                return;
            }
        }
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.release_cursor(true);
        }
    }

    public void paste(String string) {
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.pause_cursor(true);
        }
        if (this.hactive) {
            this.copy(true);
        }
        int n = this.line;
        int n2 = this.column;
        TextPosition textPosition = this.journal.insert_section(this.line, this.column, string);
        this.line = textPosition.line;
        this.column = textPosition.column;
        this.pix = this.pix_at(this.line, this.column);
        this.shiftVert(this.line);
        this.shiftHoriz(this.pix);
        if (n != this.line) {
            this.repaint();
        } else {
            this.redoLine(n, n2 + 1);
        }
        this.dirty = true;
    }

    int pix_at(int n, int n2) {
        if (n2 == 0) {
            return 10;
        }
        String string = ((String)this.lines.elementAt(n)).substring(0, n2);
        return (this.fontMetrics == null ? -1 : this.fontMetrics.stringWidth(this.detabbed(string))) + 10;
    }

    public String copy(boolean bl) {
        boolean bl2 = false;
        if (!this.hactive) {
            return null;
        }
        if (this.hline == this.heline) {
            int n = this.hline;
            int n2 = this.hcolumn;
        } else {
            bl2 = true;
        }
        String string = this.journal.delete_section(this.hline, this.hcolumn, this.heline, this.hecolumn, bl);
        if (bl) {
            this.dirty = true;
            this.line = this.hline;
            this.column = this.hcolumn;
            this.eactive = false;
            this.hactive = false;
            if (this.shiftVert(this.line)) {
                bl2 = true;
            }
            this.pix = this.pix_at(this.line, this.column);
            if (this.shiftHoriz(this.pix)) {
                bl2 = true;
            }
            if (bl2) {
                this.repaint();
            } else {
                this.redoLine(this.line, this.column + 1);
            }
            if (this.editMan != null) {
                this.editMan.updateCopyItems(this.eactive);
            }
        }
        return string;
    }

    private void cursorAdjust() {
        int n;
        boolean bl = false;
        if (this.eactive) {
            bl = true;
            this.eactive = false;
            this.hactive = false;
            if (this.editMan != null) {
                this.editMan.updateCopyItems(this.eactive);
            }
        }
        if (this.line < 0) {
            this.line = 0;
        } else {
            n = this.lines.size();
            if (this.line >= n) {
                this.line = n - 1;
            }
        }
        if (this.column < 0) {
            this.column = 0;
        } else {
            n = ((String)this.lines.elementAt(this.line)).length();
            if (this.column > n) {
                this.column = n;
            }
        }
        if (this.shiftVert(this.line)) {
            bl = true;
        }
        String string = ((String)this.lines.elementAt(this.line)).substring(0, this.column);
        if (this.shiftHoriz((this.fontMetrics == null ? -1 : this.fontMetrics.stringWidth(this.detabbed(string))) + 10)) {
            bl = true;
        }
        if (bl) {
            this.repaint();
            return;
        }
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.release_cursor(true);
        }
    }

    private boolean shiftVert(int n) {
        if (n < this.sy) {
            this.sy = n;
            if (this.sy < 0) {
                this.sy = 0;
            }
            this.vert.setValue(this.sy);
            return true;
        }
        if (n >= this.sy + this.ny) {
            this.sy = n - this.ny + 1;
            this.vert.setValue(this.sy);
            return true;
        }
        return false;
    }

    private boolean shiftHoriz(int n) {
        if (n <= this.sx) {
            this.sx = n - this.dimension.width / 5;
            if (this.sx < 0) {
                this.sx = 0;
            }
            this.horiz.setValue(this.sx);
            return true;
        }
        if (n >= this.sx + this.dimension.width) {
            this.sx = n - this.dimension.width + this.dimension.width / 5;
            this.horiz.setValue(this.sx);
            return true;
        }
        return false;
    }

    private void redoLine(int n, int n2) {
        String string = (String)this.lines.elementAt(n);
        if (this.longest(string, n)) {
            this.redoControls(this.horiz.getValue(), this.vert.getValue(), false);
        }
        this.dirty = true;
        this.updateFonts(null);
        int n3 = this.fontHeight;
        int n4 = (n - this.sy) * n3;
        String string2 = string.substring(0, n2 - 1);
        int n5 = (this.fontMetrics == null ? -1 : this.fontMetrics.stringWidth(this.detabbed(string2))) + 10;
        if (this.shiftHoriz(n5)) {
            this.repaint();
            return;
        }
        n5 = n5 - this.sx - 10;
        int n6 = this.dimension.width - n5;
        this.repaint(10L, n5, n4, n6, n3);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.redoControls(this.horiz.getValue(), this.vert.getValue(), true);
    }

    private void redoCanvas() {
        this.redoControls(this.horiz.getValue(), this.vert.getValue(), false);
    }

    private void redoControls(int n, int n2, boolean bl) {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        this.updateFonts(graphics);
        if (graphics != null) {
            int n3;
            int n4;
            this.dimension = this.getSize();
            if (bl) {
                this.clear_area(graphics);
            }
            if ((n4 = this.dimension.width) > (n3 = this.wpix)) {
                n3 = n4;
            }
            if (n > n3) {
                n = n3;
            }
            if (n3 > 0) {
                n3 += 12;
            }
            this.horiz.setValues(n, n4, 0, n3);
            int n5 = this.lines.size();
            if (n5 <= 0) {
                n5 = 10;
            }
            if ((n4 = (this.ny = this.dimension.height / this.fontHeight)) > n5) {
                n4 = n5;
            }
            if (n2 > n5) {
                n2 = n5;
            }
            this.vert.setValues(n2, n4, 0, n5);
            this.repaint();
            graphics.dispose();
        }
    }

    private void appendLine(String string) {
        int n = this.lines.size();
        this.lines.insertElementAt(string, n);
        this.longest(string, n);
    }

    private boolean longest(String string, int n) {
        int n2;
        int n3 = n2 = this.fontMetrics == null ? -1 : this.fontMetrics.stringWidth(this.detabbed(string));
        if (n2 > this.wpix) {
            this.wpix = n2 * 5 / 4;
            this.widest = n;
            return true;
        }
        return false;
    }

    private void resizeLines() {
        if (this.widest < this.lines.size()) {
            int n;
            String string = (String)this.lines.elementAt(this.widest);
            int n2 = n = this.fontMetrics == null ? -1 : this.fontMetrics.stringWidth(this.detabbed(string));
            if (n > this.wpix) {
                this.wpix = n;
                this.redoControls(this.horiz.getValue(), this.vert.getValue(), false);
            }
        }
        if (this.hline >= 0 && this.hline < this.lines.size()) {
            this.opix = this.hpix = this.pix_at(this.hline, this.hcolumn);
        }
        if (this.heline >= 0 && this.heline < this.lines.size()) {
            this.oepix = this.hepix = this.pix_at(this.heline, this.hecolumn);
        }
    }

    private int stringLength(String string) {
        if (this.fontMetrics == null) {
            return -1;
        }
        return this.fontMetrics.stringWidth(this.detabbed(string));
    }

    private String detabbed(String string) {
        if (string.indexOf(9) < 0) {
            return string;
        }
        String string2 = new String("");
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c == '\t') {
                int n4 = this.tabSize - n % this.tabSize;
                n += n4;
                while (n4-- > 0) {
                    string2 = String.valueOf(string2) + ' ';
                }
            } else {
                string2 = String.valueOf(string2) + c;
                ++n;
            }
            ++n3;
        }
        return string2;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void getCursorPos(Graphics graphics, Rectangle rectangle) {
        this.updateFonts(graphics);
        rectangle.width = 2;
        rectangle.height = this.fontHeight;
        rectangle.y = (this.line - this.sy) * rectangle.height;
        if (this.column > 0) {
            String string = ((String)this.lines.elementAt(this.line)).substring(0, this.column);
            rectangle.x = (this.fontMetrics == null ? -1 : this.fontMetrics.stringWidth(this.detabbed(string))) + 10 - this.sx;
            return;
        }
        rectangle.x = 10 - this.sx;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.pause_cursor(true);
        }
        if (adjustmentEvent.getSource() == this.horiz) {
            this.sx = adjustmentEvent.getValue();
            this.horiz.setValue(this.sx);
        } else if (adjustmentEvent.getSource() == this.vert) {
            this.sy = adjustmentEvent.getValue();
            this.vert.setValue(this.sy);
        }
        this.repaint();
    }

    public void read(File file) {
        boolean bl;
        Dialog dialog = null;
        long l = file.length();
        long l2 = l / 10L;
        long l3 = 0L;
        long l4 = 0L;
        boolean bl2 = bl = l > 2000L;
        if (bl) {
            if (dialog == null) {
                dialog = new Progress(this.parent, "Reading file ... ");
            }
            dialog.show();
        }
        this.clear();
        try {
            String string;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string = bufferedReader.readLine()) != null) {
                if (bl && (l4 += (long)string.length()) > l2) {
                    ((Progress)dialog).update((int)(100L * (l3 += l4) / l));
                    l4 = 0L;
                }
                this.appendLine(string);
            }
            bufferedReader.close();
            fileReader.close();
        }
        catch (IOException iOException) {
            this.notify("Error - could not read file", 0);
        }
        if (dialog != null) {
            dialog.dispose();
        }
    }

    public void write(File file) {
        boolean bl;
        Dialog dialog = null;
        long l = this.lines.size();
        long l2 = l / 10L;
        long l3 = 0L;
        long l4 = 0L;
        boolean bl2 = bl = l > 10000L;
        if (bl) {
            if (dialog == null) {
                dialog = new Progress(this.parent, "Writing file ... ");
            }
            dialog.show();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            int n = 0;
            while ((long)n < l) {
                String string = (String)this.lines.elementAt(n);
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
                if (bl && ++l4 > l2) {
                    ((Progress)dialog).update((int)(100L * (l3 += l4) / l));
                    l4 = 0L;
                }
                ++n;
            }
            bufferedWriter.close();
            fileWriter.close();
            this.dirty = false;
        }
        catch (IOException iOException) {
            this.notify("Error - could not write file", 0);
        }
        if (dialog != null) {
            dialog.dispose();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        new Rectangle();
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.pause_cursor(true);
        }
        graphics.setPaintMode();
        this.updateFonts(graphics);
        int n = this.lines.size();
        if (this.oldlines != n) {
            this.oldlines = n;
            this.redoControls(this.horiz.getValue(), this.vert.getValue(), true);
        }
        if (this.dimension == null) {
            this.dimension = this.getSize();
        }
        Rectangle rectangle = graphics.getClipBounds();
        n = rectangle.y / this.fontHeight;
        if (rectangle.height / this.fontHeight == 1) {
            this.drawLine(graphics, this.sy + n);
        } else {
            n = 0;
            while (n < this.ny) {
                this.drawLine(graphics, this.sy + n);
                ++n;
            }
        }
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.release_cursor(true);
        }
    }

    private synchronized void drawLine(Graphics graphics, int n) {
        graphics.setPaintMode();
        graphics.setColor(Color.black);
        int n2 = 10 - this.sx;
        int n3 = (n - this.sy + 1) * this.fontHeight;
        int n4 = this.fontHeight;
        if (this.hactive && n > this.oline && n < this.oeline) {
            graphics.fillRect(0, n3 - this.fontHeight, this.dimension.width, n4);
        } else {
            graphics.clearRect(0, n3 - this.fontHeight, this.dimension.width, n4);
        }
        if (n >= this.lines.size()) {
            return;
        }
        String string = this.detabbed((String)this.lines.elementAt(n));
        if (this.hactive && n > this.oline && n < this.oeline) {
            graphics.setColor(Color.white);
            graphics.drawString(string, n2, n3 - this.fontDescent);
            graphics.setColor(Color.black);
        } else {
            graphics.drawString(string, n2, n3 - this.fontDescent);
        }
        if (this.hactive && (n == this.oline || n == this.oeline)) {
            graphics.setXORMode(Color.white);
            int n5 = 0;
            int n6 = 5000;
            if (n == this.oline) {
                n5 = this.opix - this.sx;
            }
            if (n == this.oeline) {
                n6 = this.oepix - this.sx;
                if (this.oline == this.oeline) {
                    n6 -= n5;
                }
            }
            graphics.fillRect(n5, n3 - this.fontHeight, n6, n4);
        }
    }

    private void notify(String string, int n) {
        Note note = new Note(this.parent, string, n);
        ((Component)note).setVisible(true);
    }
}

