/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.util.Vector;

public class PrintMan
extends Thread {
    private PrintJob pjob;
    private Vector spool;
    private Font font;
    private Frame parent;
    private String jobName;
    private int tabsize;
    private final int PRINT_PROGRESS = 10000;

    public PrintMan(Frame frame, String string, Vector vector, Font font, int n) {
        this.parent = frame;
        this.jobName = string;
        this.font = font;
        this.tabsize = n;
        int n2 = vector.size();
        this.spool = new Vector(n2);
        int n3 = n2 / 10;
        int n4 = 0;
        Progress progress = null;
        if (n2 > 10000) {
            progress = new Progress(this.parent, "Saving print copy ... ");
            progress.show();
        }
        int n5 = 0;
        while (n5 < n2) {
            this.spool.addElement(new String((String)vector.elementAt(n5)));
            if (n2 > 10000) {
                ++n4;
            }
            if (n4 > n3) {
                progress.update(100 * n5 / n2);
                n4 = 0;
            }
            ++n5;
        }
        if (progress != null) {
            progress.dispose();
        }
    }

    public void run() {
        this.pjob = this.parent.getToolkit().getPrintJob(this.parent, this.jobName, null);
        if (this.pjob == null) {
            return;
        }
        Graphics graphics = this.pjob.getGraphics();
        if (graphics != null) {
            int n = this.pjob.getPageDimension().height;
            graphics.setFont(this.font);
            FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
            int n2 = fontMetrics.getHeight();
            int n3 = fontMetrics.getDescent();
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.spool.size()) {
                if ((n4 += n2) > n) {
                    graphics.dispose();
                    graphics = this.pjob.getGraphics();
                    if (graphics == null) {
                        return;
                    }
                    graphics.setFont(this.font);
                    n4 = n2;
                }
                String string = this.detabbed((String)this.spool.elementAt(n5), this.tabsize);
                graphics.drawString(string, 0, n4 - n3);
                ++n5;
            }
            graphics.dispose();
        }
        this.pjob.end();
    }

    private String detabbed(String string, int n) {
        if (string.indexOf(9) < 0) {
            return string;
        }
        String string2 = new String("");
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            char c = string.charAt(n4);
            if (c == '\t') {
                int n5 = n - n2 % n;
                n2 += n5;
                while (n5-- > 0) {
                    string2 = String.valueOf(string2) + ' ';
                }
            } else {
                string2 = String.valueOf(string2) + c;
                ++n2;
            }
            ++n4;
        }
        return string2;
    }
}

