/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.DepFindVisitor;
import com.tonicsystems.jarjar.DepHandler;
import com.tonicsystems.jarjar.IoUtils;
import com.tonicsystems.jarjar.ext_util.ClassHeaderReader;
import com.tonicsystems.jarjar.ext_util.ClassPathIterator;
import com.tonicsystems.jarjar.ext_util.RuntimeIOException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class DepFind {
    private File curDir = new File(System.getProperty("user.dir"));

    public void setCurrentDirectory(File curDir) {
        this.curDir = curDir;
    }

    public void run(String from, String to, DepHandler handler) throws IOException {
        try {
            Object cls;
            ClassHeaderReader header = new ClassHeaderReader();
            HashMap<String, Object> classes = new HashMap<String, Object>();
            ClassPathIterator cp = new ClassPathIterator(this.curDir, to, null);
            while (cp.hasNext()) {
                cls = cp.next();
                try {
                    header.read(cp.getInputStream(cls));
                    classes.put(header.getClassName(), cp.getSource(cls));
                }
                catch (ClassFormatError e) {}
            }
            cp.close();
            handler.handleStart();
            cp = new ClassPathIterator(this.curDir, from, null);
            while (cp.hasNext()) {
                cls = cp.next();
                Object source = cp.getSource(cls);
                try {
                    IoUtils.readClass(cp.getInputStream(cls)).accept(new DepFindVisitor(classes, source, handler), 2);
                }
                catch (ClassFormatError e) {}
            }
            cp.close();
            handler.handleEnd();
        }
        catch (RuntimeIOException e) {
            throw (IOException)e.getCause();
        }
    }
}

