#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>
#ifdef HAVE_SIGNAL_H
#include <signal.h>
#else
#include <sys/signal.h>
#endif
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/wait.h>

#include "sftp.h"

extern sftp_channel *channel[MAXCHANNEL];

static int sock = 1;

typedef struct {
	int fd, child, aborted;
} exec_data;

int exec_accept_data(sftp_channel_t c, message m);
int exec_send_data(sftp_channel_t c);
void exec_close(sftp_channel_t c);

sftp_channel_t
new_exec_channel(char *command, int len) {
	sftp_channel_t c;
	exec_data *data;
	int s[2], i, j;

	for (c = 1; c < MAXCHANNEL; c++)
		if (channel[c] == NULL)
			break;
	if (c == MAXCHANNEL)
		return -1;

	channel[c] = new_channel();
	channel[c]->accept_data = exec_accept_data;
	channel[c]->send_data = exec_send_data;
	channel[c]->close = exec_close;
	channel[c]->data = malloc(sizeof(exec_data));
	memset (channel[c]->data, 0, sizeof(exec_data));
	data = channel[c]->data;

	if (socketpair(PF_UNIX, SOCK_STREAM, 0, s) < 0)
		return -1;
	if ((data->child = fork())) {
		close(s[1]);
		data->fd = s[0];
		send_message(sock, _data_message(c, STREAM, NULL, 0));
		channel[c]->waiting_to_send = 1;
	}
	else {
		char *newcommand = malloc(len * 2);
		int handled = 0;

		close(s[0]);
		close(0);
		dup2(s[1], 1);
		dup2(s[1], 2);
		if (strcmp(command, "SIZE") == 0) {
			struct stat st;
			int ret;

			ret = lstat(command + strlen("SIZE") + 1, &st);
			if (ret == 0) {
				if (S_ISREG(st.st_mode)) {
					printf("%d\n", (unsigned int) st.st_size);
				} else {
					printf("Not a regular file\n");
				}
			} else {
				printf("%s", strerror(errno));
			}
			handled = 1;
		}
		if (strcmp(command, "mkdir") == 0) {
			int ret = mkdir(command + strlen("mkdir") + 1, 
					S_IRWXU | S_IRWXG | S_IRWXO);
			if (ret) {
				printf("%s", strerror(errno));
			}
			handled = 1;
		}
		if (strcmp(command, "rmdir") == 0) {
			int ret = rmdir(command + strlen("rmdir") + 1);
			if (ret) {
				printf("%s", strerror(errno));
			}
			handled = 1;
		}
		if (!handled) {
			for (i = 0, j = 0; i < len; i++, j++) {
				if (command[i] == 0 && i != len - 1)
					newcommand[j] = ' ';
				else if (command[i] == ' ') {
					newcommand[j++] = '\\';
					newcommand[j] = ' ';
				}
				else
					newcommand[j] = command[i];
			}
			newcommand[j] = 0;
			system(newcommand);
			free(newcommand);
		}
		close(s[1]);
		exit(0);
	}
	return c;
}

int
exec_accept_data(sftp_channel_t c, message m) {
	exec_data *data = channel[c]->data;
	switch (m.command) {
		case CANCEL:
			data->aborted = 1;
			return 0;
		default:
			return -1;
	}
}

int
exec_send_data(sftp_channel_t c) {
	int n = 0;
	char buf[BUFSIZE];
	exec_data *data = channel[c]->data;
	
	if (!data->aborted)
		n = read(data->fd, buf, BUFSIZE);
	if (n > 0)
		send_message(sock, _data_message(c, DATA, buf, n));
	else if (n < 0) {
		return -1;
	}
	else {
		data->child = 0;
		close(data->fd);
		send_message(sock, _data_message(c, ENDDATA, NULL, 0));
		channel[c]->waiting_to_send = 0;
		return -1;
	}
	return 0;
}

void
exec_close(sftp_channel_t c) {
	free(channel[c]->data);
	free(channel[c]);
	channel[c] = NULL;
}
