#include "jftpgw.h"
#include "cmds.h"

/* these two functions reside in cmds.c */
int getuserdest(char*, struct clientinfo*);
int getpasswd(char*, struct clientinfo*);


/* the portcmd variable keeps track of the issued port */
extern char* portcmd;

int std_quit(char* args, struct conn_info_st* conn_info) {

	int ss = conn_info->clntinfo->serversocket;
	int cs = conn_info->clntinfo->clientsocket;
	
	/* Are we already connected to a server? */
	if (ss != -1) {
		char* response;
		say(ss, "QUIT\r\n");
		response = passall(ss, cs);
		conn_info->li->respcode = respcode(response);
		free(response);
	}
	else {
		/* Generate an own goodbye message if we are
		 * not yet connected */
		say(cs, "221 Goodbye...\r\n");
	}			
	return CMD_QUIT;
}


int std_user(char* args, struct conn_info_st* conn_info) {

	int ss = conn_info->clntinfo->serversocket;
	int cs = conn_info->clntinfo->clientsocket;
	
	/* USER specified though logged in already */
	if (ss != -1) {
		say(cs, "503 You are already logged in!\r\n");
		conn_info->li->respcode = 503;
		return CMD_HANDLED;
	}

	if (getuserdest(args, conn_info->clntinfo) == 0) {
		char* sendbuf = 0;
		const char* passreq =
			"331 Password required for %s.\r\n";
		conn_info->usergiven = 1;
		sendbuf = (char*) malloc(strlen(passreq) 
				+ strlen(conn_info->lsforward->fwuser) + 1);
		enough_mem(sendbuf);
		sprintf(sendbuf, passreq,
			conn_info->lsforward->fwuser);
		say(cs, sendbuf);
		free(sendbuf);
		sendbuf = 0;
		conn_info->li->respcode = 331;
	}
	return CMD_HANDLED;
}

int std_pass(char* args, struct conn_info_st* conn_info) {
	
	int ss = conn_info->clntinfo->serversocket;
	int cs = conn_info->clntinfo->clientsocket;
	int usergiven = conn_info->usergiven;
	int ret;
	
	/* PASS specified though logged in already */
	if (ss != -1) {
		say(cs, "503 You are already logged in!\r\n");
		conn_info->li->respcode = 503;
		return CMD_HANDLED;
	}
	
	/* The client sent a PASS before a USER cmd!  */
	if (ss == -1 && !usergiven) {
		say(cs, "530 Please login with USER and PASS.\r\n");
		conn_info->li->respcode = 530;
		return CMD_HANDLED;
	}
	
	if (ss == -1 && usergiven) {
		if (!getpasswd(args, conn_info->clntinfo)) {
			ret = login(conn_info->clntinfo);
			if (!ret) {
				/* The login was successful */
				ss = conn_info->clntinfo->serversocket;
				free_loginst();
			}
			if (ret == -1) {
				/* perror reason */
				char* sendbuf = 0;
				const char* errmsg = 
					"500 Error connecting: %s\r\n";
				int err = errno;
				sendbuf = (char*) malloc(strlen(errmsg)
					+ strlen(strerror(err)) + 1);
				enough_mem(sendbuf);
				sprintf(sendbuf, errmsg, strerror(err));
				say(cs, sendbuf);
				free(sendbuf);
				sendbuf = 0;
				conn_info->li->respcode = 500;
				return CMD_HANDLED;
			}
			if (ret < 0) {
				/* login failed */
				conn_info->usergiven = 0;
				conn_info->clntinfo->serversocket = ss = -1;
			}
		}
	}
	return CMD_HANDLED;
}


int std_pasv(char* args, struct conn_info_st* conn_info) {
	char* answer = 0;
	int ret;

	if (conn_info->clntinfo->servermode == PASSIVE || 
	    conn_info->clntinfo->servermode == ASCLIENT) {
		ret = pasvserver(conn_info->clntinfo);
	} else {
		ret = activeserver(&answer, conn_info->clntinfo);
		conn_info->li->respcode = respcode(answer);
		free(answer);
	}
		
	ret |= pasvclient(conn_info->clntinfo);
	
	if (ret) {
		/* go on */
	}
	return CMD_HANDLED;
}


int std_port(char* args, struct conn_info_st* conn_info) {
	int ret = 0;
	int cs = conn_info->clntinfo->clientsocket;
	char *answer = 0;
	char *sendbuf = 0;

	portcmd = (char*) malloc(strlen(args) + 1);

	strcpy(portcmd, args);
	if (conn_info->clntinfo->servermode == ACTIVE ||
	    conn_info->clntinfo->servermode == ASCLIENT) {
		ret = activeserver(&answer, conn_info->clntinfo);
		if (ret < 0) {
			free(answer);
			return CMD_HANDLED;
		}
		/* Repeat the answer of the server */
		sendbuf = (char*) malloc(strlen(answer) + 3);
		enough_mem(sendbuf);
		strcpy(sendbuf, answer);
		strcat(sendbuf, "\r\n");
		say(cs, sendbuf);
		conn_info->li->respcode = respcode(sendbuf);
		free(sendbuf);
		free(answer);
	} else {
		ret |= pasvserver(conn_info->clntinfo);
		if (!ret) {
			conn_info->li->respcode = 200;
			say(cs, "200 PORT command successful.\r\n");
		}

	}
	return CMD_HANDLED;
}


int std_stor(char* args, struct conn_info_st* conn_info) {

	conn_info->clntinfo->mode = STOR;
	return CMD_PASS;

}


