#include "support/sftp-0.9.4/sftp.h"

extern int volatile cancelled;
int do_cancel(void);

/* this function is used from the standard command set */
int std_user(char*, struct conn_info_st*);

int secsftp_user(char*, struct conn_info_st*);
int secsftp_pass(char*, struct conn_info_st*);
int secsftp_quit(char*, struct conn_info_st*);
int secsftp_noop(char*, struct conn_info_st*);
int secsftp_pwd (char*, struct conn_info_st*);
int secsftp_cwd (char*, struct conn_info_st*);
int secsftp_mkd (char*, struct conn_info_st*);
int secsftp_rmd (char*, struct conn_info_st*);
int secsftp_syst(char*, struct conn_info_st*);
int secsftp_cdup(char*, struct conn_info_st*);
int secsftp_pasv(char*, struct conn_info_st*);
int secsftp_port(char*, struct conn_info_st*);
int secsftp_retr(char*, struct conn_info_st*);
int secsftp_stor(char*, struct conn_info_st*);
int secsftp_type(char*, struct conn_info_st*);
int secsftp_size_mdtm(char*, struct conn_info_st*);
int secsftp_abor(char*, struct conn_info_st*);


struct cmdhandlerstruct secsftp_cmdhandler[] = {
	{ "USER" , std_user },
	{ "PASS" , secsftp_pass },
	{ "PWD"  , secsftp_pwd },
	{ "XPWD" , secsftp_pwd },
	{ "CWD"  , secsftp_cwd },
	{ "XCWD" , secsftp_cwd },
	{ "CDUP" , secsftp_cdup },
	{ "XCUP" , secsftp_cdup },
	{ "MKD"  , secsftp_mkd },
	{ "XMKD" , secsftp_mkd },
	{ "RMD"  , secsftp_rmd },
	{ "DELE" , secsftp_rmd },
	{ "XRMD" , secsftp_rmd },
	{ "SYST" , secsftp_syst },
	{ "TYPE" , secsftp_type },
	{ "PORT", secsftp_port },
	{ "PASV", secsftp_pasv },
	{ "SIZE", secsftp_size_mdtm },
	{ "MDTM", secsftp_size_mdtm },
	{ "LIST" , secsftp_retr },
	{ "NLST" , secsftp_retr },
	{ "RETR", secsftp_retr },
	{ "STOR", secsftp_stor },
	{ "NOOP", secsftp_noop },
	{ "ABOR", secsftp_abor },
	{ "QUIT", secsftp_quit },
	{ 0, 0 }
};

