#include "jftpgw.h"
#ifdef SFTP_SUPPORT
#include "cmds.h"
#include "support/sftp-0.9.4/sftp.h"
#include "sftp_client.h"
#include <ctype.h>

char* shell = "ssh";
extern char* sftp_out_buffer;
int data_fd, pipe_to_par, pipe_from_par;
#define ASCII	0
#define BINARY  1
int transfer_type;

struct arrlist_t {
	char** arr;
	int amount;
};

/* these two functions reside in cmds.c */
int getuserdest(char*, struct clientinfo*);
int getpasswd(char*, struct clientinfo*);

char* double_quote(const char*);
struct arrlist_t split_args(const char*);
int free_arrlist(struct arrlist_t);

/* the portcmd variable keeps track of the issued port */
extern char* portcmd;


int sftp_open(char** args, int nargs) {
	transfer_type = ASCII;
	return do_open(args, nargs);
}


int secsftp_quit(char* args, struct conn_info_st* conn_info) {
	do_close(NULL, 0);
	say(conn_info->clntinfo->clientsocket,
			"221 Goodbye...\r\n");
	conn_info->li->respcode = 221;
	return CMD_QUIT;
}


int secsftp_noop(char* args, struct conn_info_st* conn_info) {
	say(conn_info->clntinfo->clientsocket,
			"200 NOOP command successful\r\n");
	conn_info->li->respcode = 200;
	return CMD_HANDLED;
}


int secsftp_syst(char* args, struct conn_info_st* conn_info) {
	struct arrlist_t arrlist;
	arrlist = split_args(args);
	
	if (arrlist.amount != 1) {
		say(conn_info->clntinfo->clientsocket,
			"500 Command not understood\r\n");
		free_arrlist(arrlist);
		conn_info->li->respcode = 500;
		return CMD_HANDLED;
	}
	say(conn_info->clntinfo->clientsocket,
			"215 UNIX Type: L8\r\n");
	conn_info->li->respcode = 215;
	free_arrlist(arrlist);
	return CMD_HANDLED;
}

int secsftp_type(char* args, struct conn_info_st* conn_info) {
	struct arrlist_t arrlist;

	arrlist = split_args(args);
	if (arrlist.amount != 2) {
		say(conn_info->clntinfo->clientsocket,
			"500 Command not understood\r\n");
		conn_info->li->respcode = 500;
		free_arrlist(arrlist);
		return CMD_HANDLED;
	}

	if (strcasecmp(arrlist.arr[1], "A") == 0) {
		transfer_type = ASCII;
		say(conn_info->clntinfo->clientsocket,
			"200 Type set to A.\r\n");
		conn_info->li->respcode = 200;
	} else if (strcasecmp(arrlist.arr[1], "I") == 0) {
		transfer_type = BINARY;
		say(conn_info->clntinfo->clientsocket,
			"200 Type set to I.\r\n");
		conn_info->li->respcode = 200;
	} else {
		say(conn_info->clntinfo->clientsocket,
			"500 TYPE argument is invalid (use A or I).\r\n");
		conn_info->li->respcode = 500;
	}
	free_arrlist(arrlist);
	return CMD_HANDLED;
}

		


int secsftp_pwd(char* args, struct conn_info_st* conn_info) {
	struct arrlist_t arrlist;

	arrlist = split_args(args);
	if (arrlist.amount != 1) {
		say(conn_info->clntinfo->clientsocket,
			"500 Command not understood\r\n");
		conn_info->li->respcode = 500;
	} else {
		char* out =0;
		char* msg =0; 
		char* sendbuf =0;
		int ret;
		ret = do_pwd(arrlist.arr, arrlist.amount);
		switch (ret) {
			case 0:
				msg = "257 \"%s\" is current directory.\r\n";
				conn_info->li->respcode = 257;
				break;
			default:
				msg = "500 Error: %s\r\n";
				conn_info->li->respcode = 500;
		}
		out = double_quote(sftp_out_buffer);
		sendbuf = (char*) malloc(strlen(msg) + strlen(out) + 1);
		sprintf(sendbuf, msg, out);
		say(conn_info->clntinfo->clientsocket, sendbuf);
		free(sendbuf);
	}
	free_arrlist(arrlist);
	return CMD_HANDLED;
}


int secsftp_cwd(char* args, struct conn_info_st* conn_info) {
	struct arrlist_t arrlist;
	int ret;
	char* msg =0, *sendbuf =0;
	
	arrlist = split_args(args);
	if (arrlist.amount != 2) {
		say(conn_info->clntinfo->clientsocket,
			"500 Command not understood\r\n");
		conn_info->li->respcode = 500;
		free_arrlist(arrlist);
		return CMD_HANDLED;
	}

	ret = do_cd(arrlist.arr, arrlist.amount);
	switch (ret) {
		case 0:
			msg = "250 CWD command successful.\r\n";
			sendbuf = msg;
			conn_info->li->respcode = 250;
			break;
		default:
			msg = "550 %s: %s\r\n";
			sendbuf = (char*) malloc(strlen(msg) 
					+ strlen(sftp_out_buffer)
					+ strlen(arrlist.arr[1]) + 1);
			sprintf(sendbuf, msg, arrlist.arr[1], sftp_out_buffer);
			conn_info->li->respcode = 550;
	}
	say(conn_info->clntinfo->clientsocket, sendbuf);
	return CMD_HANDLED;
}


int secsftp_cdup(char* args, struct conn_info_st* conn_info) {
	struct arrlist_t arrlist;

	arrlist = split_args(args);
	if (arrlist.amount != 1) {
		say(conn_info->clntinfo->clientsocket,
			"500 Command not understood\r\n");
		conn_info->li->respcode = 500;
		free_arrlist(arrlist);
		return CMD_HANDLED;
	}
	free_arrlist(arrlist);
	return secsftp_cwd("CWD ..", conn_info);
}



#define HANDLED		2
#define READY		1
#define NOTREADY	0

int pipe_command(const char* replace, struct arrlist_t arrlist,
		int fd[2], struct conn_info_st* conn_info) {
	FILE* file =0;
	int ret;
	fd_set fset;
	struct timeval tv = { 0, 0 };

	if (pipe(fd) < 0) {
		log(2, "Error creating a pipe: %s", strerror(errno));
		say(conn_info->clntinfo->clientsocket,
			"500 Error creating a pipe\r\n");
		conn_info->li->respcode = 500;
		free_arrlist(arrlist);
		return HANDLED;
	}

	/* replace the FTP command with the Unix command, use a malloc()
	 * like routine in order to be able to use free_arrlist() */
	arrlist.arr[0] = (char*) realloc(arrlist.arr[0], strlen(replace) + 1);
	enough_mem(arrlist.arr[0]);
	strcpy(arrlist.arr[0], replace);

	file = fdopen(fd[1], "w");
	ret = do_command(arrlist.arr, arrlist.amount, file);
	if (ret) {
		log(3, "do_command failed");
		say(conn_info->clntinfo->clientsocket,
			"500 do_command failed\r\n");
		conn_info->li->respcode = 500;
		free_arrlist(arrlist);
		return HANDLED;
	}
	
	fflush(file);
	FD_ZERO(&fset);
	FD_SET(fd[0], &fset);
	ret = select(fd[0] + 1, &fset, (fd_set*) 0, &fset, &tv);
	
	if (ret) {
		ret = READY;
	} else {
		ret = NOTREADY;
	}
	
	fclose(file);

	/* if reading from the fd[0] descriptor would block, we consider
	 * the command to report no problems, i.e. the directory has been
	 * successfully created. If not, we read the error message from
	 * fd[0] */
	
	return ret;
}

	
int secsftp_mkd(char* args, struct conn_info_st* conn_info) {
	struct arrlist_t arrlist;
	int fd[2];
	int rb, ret;
	char buffer[4096];
	char* sendbuf =0;

	arrlist = split_args(args);
	if (arrlist.amount != 2) {
		say(conn_info->clntinfo->clientsocket,
			"500 Command not understood\r\n");
		conn_info->li->respcode = 500;
		free_arrlist(arrlist);
		return CMD_HANDLED;
	}

	ret = pipe_command("mkdir", arrlist, fd, conn_info);
	if (ret == HANDLED) {
		return CMD_HANDLED;
	}

	if (ret == READY) {
		/* An error occurred */
		char* msg = "550 %s: %s\r\n";
		conn_info->li->respcode = 550;
		if ((rb = read(fd[0], buffer, sizeof(buffer))) < 0) {
			log(2, "Error reading from the pipe: %s", strerror(errno));
			say(conn_info->clntinfo->clientsocket,
				"500 Error reading from the pipe\r\n");
			conn_info->li->respcode = 500;
			free_arrlist(arrlist);
			return CMD_HANDLED;
		}
		buffer[rb] = '\0';
		/* chop the tailing newline character */
		if (rb > 0 && buffer[rb-1] == '\n') {
			buffer[rb-1] = '\0';
		}
		sendbuf = (char*) malloc(strlen(buffer)
					+ strlen(msg)
					+ strlen(arrlist.arr[1])
					+ 1);
		enough_mem(sendbuf);
		sprintf(sendbuf, msg, arrlist.arr[1], buffer);
	} else {
		/* successful */
		char* tmp = 0;
		char* newdir = 0;
		char* arr[2] = { "CWD", arrlist.arr[1] };
		char* msg = "257 \"%s\" - successfully created.\r\n";
		conn_info->li->respcode = 257;

		ret = do_pwd(NULL, 0);
		tmp = strdup(sftp_out_buffer);
		enough_mem(tmp);
		/* if MKD did not fail, CWD hopefully does not fail, as well
		 * */
		ret = do_cd(arr, 2);
		ret = do_pwd(NULL, 0);
		newdir = strdup(sftp_out_buffer);
		enough_mem(newdir);
		
		arr[0] = "CWD";
		arr[1] = tmp;
		tmp = (char*) 0;
		ret = do_cd(arr, 2);

		free(arr[1]);
		tmp = double_quote(newdir);
		sendbuf = (char*) malloc(strlen(msg)
					+ strlen(newdir)
					+ 1);
		enough_mem(sendbuf);
		sprintf(sendbuf, msg, newdir);
	}

	say(conn_info->clntinfo->clientsocket, sendbuf);
	free(sendbuf);
	sendbuf =0;

	close(fd[0]); close(fd[1]);
	
	free_arrlist(arrlist);
	return CMD_HANDLED;
}


int secsftp_rmd(char* args, struct conn_info_st* conn_info) {
	struct arrlist_t arrlist;
	int fd[2];
	int rb, ret;
	char buffer[4096];
	char* sendbuf =0;

	arrlist = split_args(args);
	if (arrlist.amount != 2) {
		say(conn_info->clntinfo->clientsocket,
			"500 Command not understood\r\n");
		conn_info->li->respcode = 500;
		free_arrlist(arrlist);
		return CMD_HANDLED;
	}

	if (strcasecmp(arrlist.arr[0], "RMD") == 0) {
		ret = pipe_command("rmdir", arrlist, fd, conn_info);
	} else {
		ret = pipe_command("unlink", arrlist, fd, conn_info);
	}
	if (ret == HANDLED) {
		return CMD_HANDLED;
	}

	if (ret == READY) {
		/* An error occurred */
		char* msg = "550 %s: %s\r\n";
		conn_info->li->respcode = 550;
		if ((rb = read(fd[0], buffer, sizeof(buffer))) < 0) {
			log(2, "Error reading from the pipe: %s", strerror(errno));
		 	say(conn_info->clntinfo->clientsocket,
				"500 Error reading from the pipe\r\n");
			conn_info->li->respcode = 500;
			free_arrlist(arrlist);
			return CMD_HANDLED;
		}
		buffer[rb] = '\0';
		log(8, "read buffer %s", buffer);
		/* chop the tailing newline character */
		if (rb > 0 && buffer[rb-1] == '\n') {
			buffer[rb-1] = '\0';
		}
		sendbuf = (char*) malloc(strlen(buffer)
					+ strlen(msg)
					+ strlen(arrlist.arr[1])
					+ 1);
		enough_mem(sendbuf);
		sprintf(sendbuf, msg, arrlist.arr[1], buffer);
	} else {
		/* successful */
		conn_info->li->respcode = 250;
		if (strcasecmp(arrlist.arr[0], "unlink") == 0) {
			sendbuf = strdup("250 DELE command successful.\r\n");
		} else {
			sendbuf = strdup("250 RMD command successful.\r\n");
		}
		
		enough_mem(sendbuf);
	}

	say(conn_info->clntinfo->clientsocket, sendbuf);
	free(sendbuf);
	sendbuf =0;

	close(fd[0]); close(fd[1]);
	
	free_arrlist(arrlist);
	return CMD_HANDLED;
}


int secsftp_size_mdtm(char* args, struct conn_info_st* conn_info) {
	struct arrlist_t arrlist;
	int fd[2];
	int rb, ret;
	char buffer[4096];
	char* sendbuf =0;

	arrlist = split_args(args);
	if (arrlist.amount != 2) {
		say(conn_info->clntinfo->clientsocket,
			"500 Command not understood\r\n");
		conn_info->li->respcode = 500;
		free_arrlist(arrlist);
		return CMD_HANDLED;
	}
	
	if (strcasecmp(arrlist.arr[0], "SIZE") == 0) {
		ret = pipe_command("SIZE", arrlist, fd, conn_info);
	} else {
		ret = pipe_command("MDTM", arrlist, fd, conn_info);
	}
	if (ret == HANDLED) {
		return CMD_HANDLED;
	}

	if (ret == READY) {
		/* We got a response */
		char* msg = "213 %s\r\n";
		conn_info->li->respcode = 213;
		if ((rb = read(fd[0], buffer, sizeof(buffer))) < 0) {
			log(2, "Error reading from the pipe: %s", strerror(errno));
		 	say(conn_info->clntinfo->clientsocket,
				"500 Error reading from the pipe\r\n");
			conn_info->li->respcode = 500;
			free_arrlist(arrlist);
			return CMD_HANDLED;
		}
		buffer[rb] = '\0';
		/* chop the tailing newline character */
		if (rb > 0 && buffer[rb-1] == '\n') {
			buffer[rb-1] = '\0';
		}
		if (*buffer != '-') {
			/* Okay, we got a valid response */
			sendbuf = (char*) malloc(strlen(msg)
						+ strlen(buffer)
						+ 1);
			enough_mem(sendbuf);
			sprintf(sendbuf, msg, buffer);
		} else {
			/* Possibly an error message */
			msg = "550: %s: %s\r\n";
			conn_info->li->respcode = 550;
			sendbuf = (char*) malloc(strlen(msg)
						+ strlen(buffer+1)
						+ strlen(arrlist.arr[1])
						+ 1);
			enough_mem(sendbuf);
			sprintf(sendbuf, msg, arrlist.arr[1], buffer+1);
		}
	} else {
		/* No response */
		conn_info->li->respcode = 550;
		if (strcasecmp(arrlist.arr[0], "SIZE") == 0) {
			sendbuf = strdup("550 No response from SIZE command\r\n");
		} else {
			sendbuf = strdup("550 No response from MDTM command\r\n");
		}
		enough_mem(sendbuf);
	}

	say(conn_info->clntinfo->clientsocket, sendbuf);
	free(sendbuf);
	sendbuf =0;

	close(fd[0]); close(fd[1]);
	
	free_arrlist(arrlist);
	return CMD_HANDLED;
}



int secsftp_pass(char* args, struct conn_info_st* conn_info) {
	
	int ss = conn_info->clntinfo->serversocket;
	int cs = conn_info->clntinfo->clientsocket;

	/* PASS specified though logged in already */
	if (ss != -1) {
		say(cs, "503 You are already logged in!\r\n");
		conn_info->li->respcode = 503;
		return CMD_HANDLED;
	}
	
	/* The client sent a PASS before a USER cmd!  */
	if (ss == -1 && !conn_info->usergiven) {
		say(cs, "530 Please login with USER and PASS.\r\n");
		conn_info->li->respcode = 530;
		return CMD_HANDLED;
	}

	if (ss == -1 && conn_info->usergiven) {
		if (!getpasswd(args, conn_info->clntinfo)) {
			int ret;
			/* log in to the server */
			ret = login(conn_info->clntinfo);
			if (ret) {
				conn_info->usergiven = 0;
/*				return CMD_QUIT;  */
				return CMD_HANDLED;
			} else {
				char* succ_msg = "230 User %s logged in.\r\n";
				char* msg = (char*) malloc(strlen(succ_msg) +
					strlen(conn_info->lsforward->fwuser));
				conn_info->li->respcode = 230;
				enough_mem(msg);
				sprintf(msg, succ_msg,
						conn_info->lsforward->fwuser);
				say(cs, msg);
				free(msg);
				msg = 0;
				conn_info->clntinfo->serversocket = 0xff;
				free_loginst();

				return CMD_HANDLED;
			}
		}
	}
	return CMD_HANDLED;
}


int secsftp_retr(char* args, struct conn_info_st* conn_info) {
	struct arrlist_t arrlist;
	int ret;
	int error =0;
	int childpid;
	int s[2], chldpar[2], parchld[2];

	arrlist = split_args(args);
	if (!((arrlist.amount == 1 || arrlist.amount == 2)
			&& ((strcasecmp(arrlist.arr[0], "LIST") == 0)
			|| strcasecmp(arrlist.arr[0], "NLST") == 0))) {
		if (arrlist.amount != 2) {
			say(conn_info->clntinfo->clientsocket,
				"500 Command not understood\r\n");
			conn_info->li->respcode = 500;
			free_arrlist(arrlist);
			return CMD_HANDLED;
		}
	}

	if (conn_info->clntinfo->dataclientsock == -1) {
		say(conn_info->clntinfo->clientsocket,
			"425 Could not establish data connection.\r\n");
		conn_info->li->respcode = 425;
		free_arrlist(arrlist);
		return CMD_HANDLED;
	}
	
	/* a socketpair for the data channel */
	if (socketpair(PF_UNIX, SOCK_STREAM, 0, s) < 0) {
		log(1, "Error: socketpair: %s", strerror(errno));
		return CMD_QUIT;
	}

	/* a pipe from the child to the parent to tell the name and the size
	 * */
	if (pipe(chldpar) < 0) {
		log(1, "pipe error - chldpar: %s", strerror(errno));
	}
	
	/* and one pipe from the parent to the child to tell him that the
	 * connection from the client was accept()ed */
	if (pipe(parchld) < 0) {
		log(1, "pipe error - parchld: %s", strerror(errno));
	}

	if ((childpid = fork()) < 0) {
		log(1, "fork error");
		return CMD_QUIT;
	}
	if (childpid == 0) {
		/* the child */
		close(chldpar[0]);
		close(parchld[1]);
		close(s[1]);
		data_fd = s[0];
		pipe_to_par = chldpar[1];
		pipe_from_par = parchld[0];
		ret = do_get(arrlist.arr, arrlist.amount);
		exit(ret);
	} else {
		char* size;
		char* name;
		char* msg = "150 Opening %s mode data connection for "
				"%s (%s bytes).\r\n";
		char* msglist = "150 Opening ASCII mode data connection for file list\r\n";
		char* sendbuf;
		conn_info->li->respcode = 150;
		close(chldpar[1]);
		close(parchld[0]);
		close(s[0]);
		conn_info->clntinfo->dataserversock = s[1];
		size = ftp_readline(chldpar[0]);
		log(9, "size: %s", size);
		name = ftp_readline(chldpar[0]);
		log(9, "name: %s", name);

		if (strcmp(size, "-2") == 0) {
			error = 1;
			/* This is the code for an error, the error can be
			 * obtained from name */
			msg = "550: %s: %s\r\n";
			conn_info->li->respcode = 550;
                        sendbuf = (char*) malloc(strlen(msg)
					+ strlen(arrlist.arr[1])
					+ strlen(name)
				       	+ 1);
		       	enough_mem(sendbuf);
		       	sprintf(sendbuf, msg, arrlist.arr[1], name);
		       	say(conn_info->clntinfo->clientsocket, sendbuf);
			free(sendbuf); sendbuf =0;
		} else {
			/* Everything went fine */
			ret = initiate_transfer(conn_info->clntinfo);
			if (size[0] == '-') {
				say(conn_info->clntinfo->clientsocket, msglist);
				sendbuf = 0;
			} else {
				sendbuf = (char*)malloc(strlen(msg) 
							/* "ASCII" is shorter
							 * than "binary" */
							+ strlen("binary")
							+ strlen(name)
							+ strlen(size)
							+ 1);
				enough_mem(sendbuf);
				sprintf(sendbuf, msg,
						transfer_type == BINARY ?
							"binary" : "ASCII",
						name, size);
				say(conn_info->clntinfo->clientsocket, sendbuf);
			}
		}
		
		say(parchld[1], "accepted\r\n");
		
		free(name);
		free(size);
		free(sendbuf);
		close(chldpar[0]);
		close(parchld[1]);
		if (!error) {
			if (transfer_type == ASCII 
				|| strcasecmp(arrlist.arr[0], "LIST") == 0) {

				conn_info->clntinfo->havetoconvert
					= CONV_TOASCII;
			}
			ret = transmitfile(conn_info->clntinfo);
			if (ret == 0) {
				say(conn_info->clntinfo->clientsocket,
					"226 Transfer complete.\r\n");
				conn_info->li->respcode = 226;
			}
			if (ret == 1) {
				char* err = strerror(errno);
				log(3, "Error in transmitfile: %s", err);
				say(conn_info->clntinfo->clientsocket,
					"500 Error in transmitfile.\r\n");
				conn_info->li->respcode = 500;
			}
		}
	}
	free_arrlist(arrlist);
	return CMD_HANDLED;
}


int secsftp_stor(char* args, struct conn_info_st* conn_info) {
	struct arrlist_t arrlist;
	int ret;
	char* msg =0, *sendbuf =0;
	int childpid;
	int s[2], p[2];

	arrlist = split_args(args);
	if (arrlist.amount != 2) {
		say(conn_info->clntinfo->clientsocket,
			"500 Command not understood\r\n");
		conn_info->li->respcode = 500;
		free_arrlist(arrlist);
		return CMD_HANDLED;
	}

	if (conn_info->clntinfo->dataclientsock == -1) {
		say(conn_info->clntinfo->clientsocket,
			"425 Could not establish data connection.\r\n");
		conn_info->li->respcode = 425;
		free_arrlist(arrlist);
		return CMD_HANDLED;
	}
	
	if (transfer_type == ASCII) {
		conn_info->clntinfo->havetoconvert = CONV_FRMASCII;
	}
	
	/* a socketpair for the data channel */
	if (socketpair(PF_UNIX, SOCK_STREAM, 0, s) < 0) {
		log(1, "Error: socketpair: %s", strerror(errno));
		free_arrlist(arrlist);
		return CMD_QUIT;
	}

	/* a pipe for the child to say that the file has been successfully
	 * created */

	if (pipe(p) < 0) {
		log(1, "Error: pipe: %s", strerror(errno));
	}

	if ((childpid = fork()) < 0) {
		log(1, "fork error");
		free_arrlist(arrlist);
		return CMD_QUIT;
	}
	
	if (childpid == 0) {
		/* the child */
		char* putargs[] = { "STOR", arrlist.arr[1] };
		data_fd = s[1];
		close(s[0]);
		close(p[0]);
		pipe_to_par = p[1];
		ret = do_put(putargs, 2);
		exit(ret);
	} else {
		char buffer[4096];
		close(s[1]);
		close(p[1]);
		conn_info->clntinfo->dataserversock = s[0];
		ret = read(p[0], buffer, sizeof(buffer) - 1);
		close(p[0]);
		if (ret < 0) {
			log(2, "Error reading from the pipe of the client: %s",
					strerror(errno));
			say(conn_info->clntinfo->clientsocket,
					"500 Could not read from a pipe\r\n");
			conn_info->li->respcode = 500;
			free_arrlist(arrlist);
			return CMD_HANDLED;
		}
		buffer[ret] = '\0';
		if (strcmp(buffer, "OK") != 0) {
			/* An error has occurred */
			msg = "550 %s: %s\r\n";
			conn_info->li->respcode = 550;
			sendbuf = (char*) malloc(strlen(msg)
						+ strlen(arrlist.arr[1])
						+ strlen(buffer)
						+ 1);
			sprintf(sendbuf, msg, arrlist.arr[1], buffer);
			say(conn_info->clntinfo->clientsocket, sendbuf);
			free(sendbuf);
			free_arrlist(arrlist);
			return CMD_HANDLED;
		}
		/* Wait for the client to connect */
		conn_info->clntinfo->mode = STOR;

		ret = initiate_transfer(conn_info->clntinfo);
		if (ret) {
			log(2, "Error initiating the transfer");
			free_arrlist(arrlist);
			return CMD_HANDLED;
		}

		msg = "150 Opening %s mode data connection for %s\r\n";
		conn_info->li->respcode = 150;
		sendbuf = (char*)malloc(strlen(msg) 
				/* "ASCII" is shorter than "binary" */
				+ strlen("binary")
				+ strlen(arrlist.arr[1])
				+ 1);
		enough_mem(sendbuf);
		sprintf(sendbuf, msg, transfer_type == BINARY ?  "binary" 
				: "ASCII", arrlist.arr[1]);
		say(conn_info->clntinfo->clientsocket, sendbuf);

		ret = transmitfile(conn_info->clntinfo);
		if (ret == 0) {
			say(conn_info->clntinfo->clientsocket,
				"226 Transfer complete.\r\n");
			conn_info->li->respcode = 226;
		}
		if (ret == 1) {
			char* err = strerror(errno);
			log(2, "Error in transmitfile: %s", err);
			say(conn_info->clntinfo->clientsocket,
				"500 Error in transmitfile.\r\n");
			conn_info->li->respcode = 550;
		}
		data_fd = -1;
	}

	free_arrlist(arrlist);
	return CMD_HANDLED;
}

	
int secsftp_pasv(char* args, struct conn_info_st* conn_info) {
	struct arrlist_t arrlist;
	
	arrlist = split_args(args);
	if (arrlist.amount != 1) {
		say(conn_info->clntinfo->clientsocket,
			"500 Command not understood\r\n");
		conn_info->li->respcode = 500;
		free_arrlist(arrlist);
		return CMD_HANDLED;
	}
	free_arrlist(arrlist);
		
	pasvclient(conn_info->clntinfo);

	return CMD_HANDLED;
}


int secsftp_port(char* args, struct conn_info_st* conn_info) {
	struct arrlist_t arrlist;
	
	arrlist = split_args(args);
	if (arrlist.amount != 2) {
		say(conn_info->clntinfo->clientsocket,
			"500 Command not understood\r\n");
		conn_info->li->respcode = 500;
		free_arrlist(arrlist);
		return CMD_HANDLED;
	}
	free_arrlist(arrlist);

	activeclient(args, conn_info->clntinfo);
	if (conn_info->clntinfo->dataclientsock != -1) {
		say(conn_info->clntinfo->clientsocket,
			"200 PORT command successful.\r\n");
		conn_info->li->respcode = 200;
	}

	return CMD_HANDLED;
}


int secsftp_abor(char* args, struct conn_info_st* conn_info) {
	
	/* The abort command is handled internally in cmds.c */

	say(conn_info->clntinfo->clientsocket,
			"500 No command to abort.\r\n");
	conn_info->li->respcode = 500;

	return CMD_HANDLED;
	
}



struct arrlist_t split_args(const char* args) {
	struct arrlist_t result;
	char* sp = strchr(args, ' ');
	
	if (sp == NULL) {
		/* no space */
		result.amount = 1;
		result.arr = (char**) malloc(sizeof(char*));
		enough_mem(result.arr);
		result.arr[0] = strdup(args);
		enough_mem(result.arr[0]);
		return result;
	}
	/* there was a space, we have one command and an argument */
	result.amount = 2;
	result.arr = (char**) malloc(sizeof(char*)*2);
	enough_mem(result.arr);
	result.arr[0] = (char*) malloc(sp - args + 1);
	enough_mem(result.arr[0]);
	strncpy(result.arr[0], args, sp - args);
	result.arr[0][sp - args] = '\0';

	/* we need (strlen(args) - sp - 1) + 1 bytes */
	result.arr[1] = (char*) malloc(strlen(args) - (sp - args));
	enough_mem(result.arr[1]);
	strncpy(result.arr[1], sp + 1, strlen(args) - (sp - args) - 1);
	result.arr[1][strlen(args) - (sp - args) - 1] = '\0';
	
	return result;
}


int free_arrlist(struct arrlist_t arr) {
	int i;
	for (i=0; i < arr.amount; i++) {
		free(arr.arr[i]);
	}
	free(arr.arr);
	return 0;
}

char* double_quote(const char* s) {
	/* s is in this format (incl. quotation marks): "/home/joe"  */
	
	int amount = 0;
	const char* b = s;
	char* c =0;
	char* dq =0;

	while (*b) {
		if (*b == '"') {
			amount++;
		}
		b++;
	}

	/* we have amount quotation marks in s,
	 * so we need another amount extra bytes to escape them */

	dq = (char*) malloc(strlen(s) + amount + 1);
	enough_mem(dq);
	b = s;
	c = dq;
	
	while (*b) {
		if (*b == '"') {
			*c = '"';
			c++;
		}
		*c = *b;
		b++; c++;
	}
	*c = '\0';
	
	return dq;
}
#endif  /* SFTP_SUPPORT */
