/* Copyright (c) 1992, 1998 John E. Davis
 * This file is part of JED editor library source.
 *
 * You may distribute this file under the terms the GNU General Public
 * License.  See the file COPYING for more information.
 */
#ifndef __JED_INDENT_H_
#define __JED_INDENT_H_

#if JED_HAS_DFA_SYNTAX
typedef struct Highlight Highlight;    /* opaque to all but dfasyntx.c */
extern void define_highlight_rule (char *, char *, char *);
extern void build_highlight_table (char *);
extern void enable_highlight_cache (char *, char *);
extern void jed_set_dfa_cache_dir (void);
#endif

typedef struct Syntax_Table_Type
{
   unsigned char string_char;	       /* character for string delim */
   unsigned char char_char;	       /* char for char delim */
   unsigned int flags;
#define SYNTAX_NOT_CASE_SENSITIVE 	0x1
#define FORTRAN_TYPE 			0x2
#define C_COMMENT_TYPE			0x4
/* means if non-digit in first column, it is a comment */
#define TEX_LIKE_KEYWORDS 		0x8
#define COMMENT_IS_WORD			0x10
#define PREPROCESS_COLOR_WHOLE_LINE	0x20
#define PREPROCESS_IGNORE_WHITESPACE	0x40

   /* Comments.  Each mode can have at most 2 comment styles: one for 
    * multiline comments, and one for single line comments.
    * A single line comments ends at the end of the line.  Since some 
    * comments must be followed by whitespace or a word delimeter, an 
    * flag will be set for them.  For example, in BASIC, 'rem' denotes
    * a comment but 'remote' does not.  Sigh.
    * 
    * Languages such as m4 are especially problematic.  m4 uses 'dnl' to 
    * start an end-of-line comment.  However, it must occur as an isolated
    * word such that
    *    dnlsilly is not a comment
    *    and sillydnl is not a comment
    */
   char *comment_start;
   unsigned int comment_start_len;
   
   unsigned int comment_stop_len;
   char *comment_stop;

   char *eol_comment_start;
   unsigned int eol_comment_len;

   unsigned char quote_char;	       /* used for quoting in strings */
   unsigned char preprocess;	       /* start preprocessor lines */
   unsigned short char_syntax[256];     /* syntax type for characters */
   unsigned char matching_delim[256];  /* matching pairs */
   char name[16];		       /* name of this table */
#define MAX_KEYWORD_LEN 32
#define MAX_KEYWORD_TABLES 3
   char *keywords[MAX_KEYWORD_TABLES][MAX_KEYWORD_LEN];
   struct Syntax_Table_Type *next;     /* pointer to next table */
#if JED_HAS_DFA_SYNTAX
   Highlight *hilite;
#endif
   unsigned char fortran_comment_chars[256];
}
Syntax_Table_Type;


#define WORD_SYNTAX		0x001
#define NUMBER_SYNTAX		0x002
#define DELIM_SYNTAX		0x004

#define SYNTAX_MASK		0xFFF8
#define QUOTE_SYNTAX		0x008
#define STRING_SYNTAX		0x010
#define OPEN_DELIM_SYNTAX	0x020
#define CLOSE_DELIM_SYNTAX	0x040
#define COMMENT_SYNTAX		0x080
#define OP_SYNTAX		0x100
#define HTML_START_SYNTAX	0x200
#define HTML_END_SYNTAX		0x400

extern Syntax_Table_Type *Default_Syntax_Table;

extern int find_matching_delimiter (int *);
extern int parse_to_point (void);
extern void use_syntax_table (char *);
extern void create_syntax_table (char *);
extern void define_syntax (int *, char *);
extern void init_syntax_tables (void);
extern void blink_match(void);
extern int goto_match(void);
extern void set_syntax_flags (char *, int *);
extern void define_keywords (char *, char *, int *, int *);
extern Syntax_Table_Type *find_syntax_table (char *, int);
extern void jed_set_fortran_comment_style (char *, char *);

#if JED_HAS_LINE_ATTRIBUTES
extern void jed_syntax_parse_buffer (int);
#endif
extern int map_color_object_to_number (char *);

#endif /* __JED_INDENT_H_ */
