/*
 * @(#)java_md.h	1.5 98/08/24
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#ifndef JAVA_MD_H
#define JAVA_MD_H

#include <limits.h>

#define PATH_SEPARATOR		':'
#define FILE_SEPARATOR		'/'
#define MAXPATHLEN		PATH_MAX

#ifdef JAVA_ARGS
/*
 * ApplicationHome is prepended to each of these entries; the resulting
 * strings are concatenated (seperated by PATH_SEPARATOR) and used as the
 * value of -cp option to the launcher.
 */
#ifndef APP_CLASSPATH
#define APP_CLASSPATH        { "/lib/tools.jar", "/classes" }
#endif
#endif

#ifdef HAVE_GETHRTIME
/*
 * Support for doing cheap, accurate interval timing.
 */
#include <sys/time.h>
#define CounterGet()           	  (gethrtime()/1000)
#define Counter2Micros(counts) 	  (counts)
#else
#define CounterGet()		  (0)
#define Counter2Micros(counts)	  (1)
#endif /* HAVE_GETHRTIME */

#endif
