/*
 * @(#)Permission.java	1.8 98/09/21
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 * 
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package java.security.acl;


/**
 * This interface represents a permission, such as that used to grant
 * a particular type of access to a resource.
 *
 * @author Satish Dharmaraj
 */
public interface Permission {

    /**
     * Returns true if the object passed matches the permission represented 
     * in this interface.
     * 
     * @param another the Permission object to compare with.
     * 
     * @return true if the Permission objects are equal, false otherwise
     */
    public boolean equals(Object another);
    
    /**
     * Prints a string representation of this permission.
     * 
     * @return the string representation of the permission.
     */
    public String toString();

}
