/*
 * @(#)SkeletonMismatchException.java	1.7 98/09/21
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 * 
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package java.rmi.server;

import java.rmi.RemoteException;

/**
 * This exception is thrown when a call is received that does not
 * match the available skeleton.  It indicates either that the
 * remote method names or signatures in this interface have changed or
 * that the stub class used to make the call and the skeleton
 * receiving the call were not generated by the same version of
 * the stub compiler (<code>rmic</code>).
 *
 * @version 1.7, 09/21/98
 * @author  Roger Riggs
 * @since   JDK1.1
 * @deprecated no replacement.  Skeletons are no longer required for remote
 * method calls in JDK1.2 and greater.
 */
public class SkeletonMismatchException extends RemoteException {

    /* indicate compatibility with JDK 1.1.x version of class */
    private static final long serialVersionUID = -7780460454818859281L;

    /**
     * Constructs a new <code>SkeletonMismatchException</code> with
     * a specified detail message.
     *
     * @param s the detail message
     * @since JDK1.1
     * @deprecated no replacement
     */
    public SkeletonMismatchException(String s) {
	super(s);
    }

}
