/*
 * @(#)Skeleton.java	1.9 98/09/21
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 * 
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
package java.rmi.server;

import java.rmi.Remote;

/**
 * The <code>Skeleton</code> interface is used solely by the RMI
 * implementation.
 *
 * <p> Every version 1.1 (and version 1.1 compatible skeletons generated in
 * 1.2 using <code>rmic -vcompat</code>) skeleton class generated by the rmic
 * stub compiler implements this interface. A skeleton for a remote object is
 * a server-side entity that dispatches calls to the actual remote object
 * implementation.
 *
 * @version 1.9, 09/21/98
 * @author  Ann Wollrath
 * @since   JDK1.1
 * @deprecated no replacement.  Skeletons are no longer required for remote
 * method calls in JDK1.2 and greater.
 */
public interface Skeleton {
    /**
     * Unmarshals arguments, calls the actual remote object implementation,
     * and marshals the return value or any exception.
     *
     * @exception java.lang.Exception if a general exception occurs.
     * @since JDK1.1
     * @deprecated no replacement
     */
    void dispatch(Remote obj, RemoteCall theCall, int opnum, long hash)
	throws Exception;

    /**
     * Returns the operations supported by the skeleton.
     * @since JDK1.1
     * @deprecated no replacement
     */
    Operation[] getOperations();
}
