/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.LogStream;
import java.rmi.server.RMIFailureHandler;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.SocketSecurityException;
import java.rmi.server.UID;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCAckHandler;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.RMIThreadAction;
import sun.rmi.transport.StreamRemoteCall;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPConnection;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.security.action.GetPropertyAction;

public class TCPTransport
extends Transport
implements Runnable {
    static int logLevel = LogStream.parseLevel(TCPTransport.getLogLevel());
    private boolean listenNotAllowed = false;
    private boolean exportNotAllowed = false;
    private static int threadNum = 0;
    private static Hashtable clientConnections = new Hashtable(37);
    private TCPEndpoint endpoint;
    private ServerSocket server = null;
    private Hashtable channelTable = new Hashtable();
    static RMISocketFactory defaultSocketFactory = RMISocketFactory.getDefaultSocketFactory();

    TCPTransport(TCPEndpoint tCPEndpoint) {
        if (logLevel >= 10) {
            LogStream.log("tcp").println("TCPTransport.<init>: Version = 2, ep = " + tCPEndpoint);
        }
        this.endpoint = tCPEndpoint;
    }

    private static void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {}
    }

    public void exportObject(Target target) throws RemoteException {
        if (this.exportNotAllowed) {
            throw new ExportException("failed to create multiplex protocol connection");
        }
        if (this.listenNotAllowed && this.endpoint.equals(TCPEndpoint.getLocalEndpoint(0))) {
            return;
        }
        try {
            this.listen();
        }
        catch (SocketSecurityException socketSecurityException) {
            if (logLevel >= 10) {
                LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").exportObject: " + "listen failed with exception " + socketSecurityException.toString());
            }
            if (this.endpoint.getPort() != 0) {
                throw socketSecurityException;
            }
            this.multiplexChannels();
        }
        super.exportObject(target);
    }

    public Channel getChannel(Endpoint endpoint) {
        Channel channel = null;
        if (endpoint instanceof TCPEndpoint) {
            Hashtable hashtable = this.channelTable;
            synchronized (hashtable) {
                channel = (Channel)this.channelTable.get(endpoint);
                if (channel == null) {
                    channel = new TCPChannel(this, (TCPEndpoint)endpoint);
                    if (this.listenNotAllowed && !this.exportNotAllowed) {
                        try {
                            ((TCPChannel)channel).haveMultiplexer();
                        }
                        catch (RemoteException remoteException) {
                            if (logLevel >= 10) {
                                LogStream logStream;
                                LogStream logStream2 = logStream = LogStream.log("tcp");
                                synchronized (logStream2) {
                                    logStream.print("TCPTransport(" + this.endpoint.getPort() + ").getChannel: " + "failed to have multiplexed connection " + "on channel, exception: ");
                                    remoteException.printStackTrace(logStream);
                                }
                            }
                            this.exportNotAllowed = true;
                        }
                    }
                    this.channelTable.put(endpoint, channel);
                }
            }
        }
        return channel;
    }

    public static Channel getCurrentChannel() {
        Thread thread = Thread.currentThread();
        Object object = clientConnections.get(thread);
        if (object != null && object instanceof Connection) {
            Channel channel = ((Connection)object).getChannel();
            return channel;
        }
        return null;
    }

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.tcp.logLevel"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleMessages(Connection connection, boolean bl) {
        Thread thread;
        block17: {
            thread = Thread.currentThread();
            clientConnections.put(thread, connection);
            try {
                try {}
                catch (IOException iOException) {
                    if (logLevel >= 10) {
                        LogStream logStream = LogStream.log("tcp");
                        logStream.println("TCPTransport(" + this.endpoint.getPort() + ").handleMessages: exception: ");
                        iOException.printStackTrace(logStream);
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                Object var5_12 = null;
                clientConnections.remove(thread);
                try {
                    connection.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            block13: do {
                DataInputStream dataInputStream = new DataInputStream(connection.getInputStream());
                byte by = dataInputStream.readByte();
                if (logLevel >= 10) {
                    LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").handleMessages: op = " + by);
                }
                switch (by) {
                    case 80: {
                        StreamRemoteCall streamRemoteCall = new StreamRemoteCall(connection);
                        if (this.serviceCall(streamRemoteCall)) continue block13;
                        Object var5_10 = null;
                        clientConnections.remove(thread);
                        try {}
                        catch (IOException iOException) {}
                        connection.close();
                        return;
                    }
                    case 82: {
                        DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());
                        dataOutputStream.writeByte(83);
                        connection.releaseOutputStream();
                        break;
                    }
                    case 84: {
                        DGCAckHandler.received(UID.read(dataInputStream));
                        break;
                    }
                    default: {
                        throw new IOException("unknown transport op " + by);
                    }
                }
            } while (bl);
        }
        Object var5_11 = null;
        clientConnections.remove(thread);
        try {}
        catch (IOException iOException) {
            return;
        }
        connection.close();
    }

    private synchronized void listen() throws RemoteException {
        if (this.server == null) {
            int n = this.endpoint.getPort();
            if (logLevel >= 10) {
                LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").listen: " + "create socket, port = " + n);
            }
            try {
                this.server = this.endpoint.newServerSocket();
                this.newListener();
            }
            catch (SecurityException securityException) {
                throw new SocketSecurityException("Listen disallowed on port: " + n, securityException);
            }
            catch (BindException bindException) {
                throw new ExportException("Port already in use: " + n, bindException);
            }
            catch (IOException iOException) {
                throw new ExportException("Listen failed on port: " + n, iOException);
            }
        }
    }

    private void multiplexChannels() throws RemoteException {
        Hashtable hashtable = this.channelTable;
        synchronized (hashtable) {
            this.listenNotAllowed = true;
            Enumeration enumeration = this.channelTable.elements();
            while (enumeration.hasMoreElements()) {
                TCPChannel tCPChannel = (TCPChannel)enumeration.nextElement();
                try {
                    tCPChannel.haveMultiplexer();
                }
                catch (RemoteException remoteException) {
                    if (logLevel >= 10) {
                        LogStream logStream;
                        LogStream logStream2 = logStream = LogStream.log("tcp");
                        synchronized (logStream2) {
                            logStream.print("TCPTransport(" + this.endpoint.getPort() + ").exportObject: " + "failed to have multiplexed connection " + "on channel, exception: ");
                            remoteException.printStackTrace(logStream);
                        }
                    }
                    this.exportNotAllowed = true;
                    throw new ExportException("failed to create multiplex protocol connection");
                }
            }
            System.out.println("\n*** RMI unable to listen on socket: using multiplexed connections instead ***\n");
        }
    }

    private void newListener() {
        Thread thread = (Thread)AccessController.doPrivileged(new RMIThreadAction(this, "TCP Accept-" + ++threadNum, true));
        thread.start();
    }

    private synchronized boolean retryServerSocket() {
        while (true) {
            try {
                this.server = this.endpoint.newServerSocket();
                return true;
            }
            catch (IOException iOException) {
                RMIFailureHandler rMIFailureHandler = RMISocketFactory.getFailureHandler();
                if (rMIFailureHandler != null) {
                    if (rMIFailureHandler.failure(iOException)) continue;
                    this.server = null;
                    return false;
                }
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Throwable throwable;
        if (logLevel >= 10) {
            LogStream.log("tcp").println("TCPTransport.run: listening on port " + this.endpoint.getPort());
        }
        while (true) {
            Object var5_4;
            ServerSocket serverSocket;
            if ((serverSocket = this.server) == null) {
                return;
            }
            throwable = null;
            try {
                try {
                    Socket socket = serverSocket.accept();
                    int n = ++threadNum;
                    Thread thread = (Thread)AccessController.doPrivileged(new RMIThreadAction(new ConnectionHandler(socket), "TCP Connection(" + n + ")-" + socket.getInetAddress(), true));
                    thread.start();
                }
                catch (IOException iOException) {
                    throwable = iOException;
                }
                catch (RuntimeException runtimeException) {
                    throwable = runtimeException;
                }
                catch (Error error) {
                    throwable = error;
                }
                var5_4 = null;
                if (throwable == null) continue;
            }
            catch (Throwable throwable2) {
                var5_4 = null;
                if (throwable == null) throw throwable2;
                try {
                    this.server.close();
                }
                catch (IOException iOException) {}
                if (throwable instanceof IOException || throwable instanceof NoClassDefFoundError) {
                    if (this.retryServerSocket()) throw throwable2;
                    return;
                } else {
                    if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
                    throw (RuntimeException)throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            this.server.close();
            if (!(throwable instanceof IOException) && !(throwable instanceof NoClassDefFoundError)) break;
            if (!this.retryServerSocket()) return;
        }
        if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
        throw (RuntimeException)throwable;
    }

    public Endpoint thisEndpoint() {
        return this.endpoint;
    }

    private class ConnectionHandler
    implements Runnable {
        Socket socket;

        ConnectionHandler(Socket socket) {
            this.socket = socket;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block23: {
                block22: {
                    try {
                        this.socket.setTcpNoDelay(true);
                    }
                    catch (Exception exception) {}
                    try {
                        try {
                            InputStream inputStream = this.socket.getInputStream();
                            DataInputStream dataInputStream = new DataInputStream(inputStream);
                            OutputStream outputStream = this.socket.getOutputStream();
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                            DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
                            int n = dataInputStream.readInt();
                            short s = dataInputStream.readShort();
                            if (n != 1246907721 || s != 2) {
                                TCPTransport.closeSocket(this.socket);
                                Object var2_10 = null;
                                break block22;
                            }
                            InetAddress inetAddress = this.socket.getInetAddress();
                            String string = inetAddress != null ? inetAddress.getHostAddress() : "0.0.0.0";
                            int n2 = this.socket.getPort();
                            if (logLevel >= 10) {
                                LogStream.log("tcp").println("TCPTransport.run: accepted socket from [" + string + ":" + n2 + "]");
                            }
                            byte by = dataInputStream.readByte();
                            switch (by) {
                                case 76: {
                                    TCPEndpoint tCPEndpoint = new TCPEndpoint(string, this.socket.getLocalPort(), TCPTransport.this.endpoint.getClientSocketFactory(), TCPTransport.this.endpoint.getServerSocketFactory());
                                    TCPChannel tCPChannel = new TCPChannel(TCPTransport.this, tCPEndpoint);
                                    TCPConnection tCPConnection = new TCPConnection(tCPChannel, this.socket);
                                    TCPTransport.this.handleMessages(tCPConnection, false);
                                    break;
                                }
                                case 75: {
                                    dataOutputStream.writeByte(78);
                                    if (logLevel >= 20) {
                                        LogStream.log("tcp").println("TCPTransport(" + TCPTransport.this.endpoint.getPort() + ").run: " + "suggesting " + string + ":" + n2);
                                    }
                                    dataOutputStream.writeUTF(string);
                                    dataOutputStream.writeInt(n2);
                                    dataOutputStream.flush();
                                    String string2 = dataInputStream.readUTF();
                                    int n3 = dataInputStream.readInt();
                                    if (logLevel >= 20) {
                                        LogStream.log("tcp").println("TCPTransport(" + TCPTransport.this.endpoint.getPort() + ").run: " + "client using " + string2 + ":" + n3);
                                    }
                                    TCPEndpoint tCPEndpoint = new TCPEndpoint(string, this.socket.getLocalPort(), TCPTransport.this.endpoint.getClientSocketFactory(), TCPTransport.this.endpoint.getServerSocketFactory());
                                    TCPChannel tCPChannel = new TCPChannel(TCPTransport.this, tCPEndpoint);
                                    TCPConnection tCPConnection = new TCPConnection(tCPChannel, this.socket);
                                    TCPTransport.this.handleMessages(tCPConnection, true);
                                    break;
                                }
                                case 77: {
                                    ConnectionMultiplexer connectionMultiplexer;
                                    if (logLevel >= 20) {
                                        LogStream.log("tcp").println("TCPTransport(" + TCPTransport.this.endpoint.getPort() + ").run: " + "accepting multiplex protocol");
                                    }
                                    dataOutputStream.writeByte(78);
                                    if (logLevel >= 20) {
                                        LogStream.log("tcp").println("TCPTransport(" + TCPTransport.this.endpoint.getPort() + ").run: " + "suggesting " + string + ":" + n2);
                                    }
                                    dataOutputStream.writeUTF(string);
                                    dataOutputStream.writeInt(n2);
                                    dataOutputStream.flush();
                                    TCPEndpoint tCPEndpoint = new TCPEndpoint(dataInputStream.readUTF(), dataInputStream.readInt(), TCPTransport.this.endpoint.getClientSocketFactory(), TCPTransport.this.endpoint.getServerSocketFactory());
                                    if (logLevel >= 20) {
                                        LogStream.log("tcp").println("TCPTransport(" + TCPTransport.this.endpoint.getPort() + ").run: " + "client using " + tCPEndpoint.getHost() + ":" + tCPEndpoint.getPort());
                                    }
                                    Hashtable hashtable = TCPTransport.this.channelTable;
                                    synchronized (hashtable) {
                                        TCPChannel tCPChannel = (TCPChannel)TCPTransport.this.getChannel(tCPEndpoint);
                                        connectionMultiplexer = new ConnectionMultiplexer(tCPChannel, inputStream, outputStream, false);
                                        tCPChannel.useMultiplexer(connectionMultiplexer);
                                    }
                                    connectionMultiplexer.run();
                                    break;
                                }
                                default: {
                                    dataOutputStream.writeByte(79);
                                    dataOutputStream.flush();
                                    break;
                                }
                            }
                        }
                        catch (IOException iOException) {
                            if (logLevel >= 10) {
                                LogStream logStream = LogStream.log("tcp");
                                logStream.println("TCPTransport.run: terminated with exception:");
                                iOException.printStackTrace(logStream);
                            }
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var2_12 = null;
                        TCPTransport.closeSocket(this.socket);
                        throw throwable;
                    }
                }
                TCPTransport.closeSocket(this.socket);
                return;
            }
            Object var2_11 = null;
            TCPTransport.closeSocket(this.socket);
        }
    }
}

