/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.server.LogStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Vector;
import java.util.WeakHashMap;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.Notifiable;
import sun.rmi.transport.RMIThreadAction;
import sun.rmi.transport.tcp.ConnectionAcceptor;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.TCPConnection;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.rmi.transport.tcp.TCPTransport;
import sun.security.action.GetLongAction;

public class TCPChannel
implements Channel,
Runnable {
    private TCPEndpoint ep;
    private TCPTransport tr;
    private Vector notifyList = new Vector();
    private ArrayList freeList = new ArrayList();
    private Reaper reaper = null;
    private boolean usingMultiplexer = false;
    private ConnectionMultiplexer multiplexer = null;
    private ConnectionAcceptor acceptor;
    private AccessControlContext okContext;
    private WeakHashMap authcache;
    private SecurityManager cacheSecurityManager = null;
    private static long timeout;

    static {
        Long l = (Long)AccessController.doPrivileged(new GetLongAction("sun.rmi.transport.connectionTimeout", 15000L));
        timeout = l;
    }

    TCPChannel(TCPTransport tCPTransport, TCPEndpoint tCPEndpoint) {
        this.tr = tCPTransport;
        this.ep = tCPEndpoint;
    }

    void acceptMultiplexConnection(Connection connection) {
        if (this.acceptor == null) {
            this.acceptor = new ConnectionAcceptor(this.tr);
            this.acceptor.startNewAcceptor();
        }
        this.acceptor.accept(connection);
    }

    public void addNotifiable(Endpoint endpoint, Notifiable notifiable) {
        Vector vector = this.notifyList;
        synchronized (vector) {
            if (!this.notifyList.contains(notifiable)) {
                this.notifyList.addElement(notifiable);
            }
        }
    }

    private void checkConnectPermission() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        if (securityManager != this.cacheSecurityManager) {
            this.okContext = null;
            this.authcache = new WeakHashMap();
            this.cacheSecurityManager = securityManager;
        }
        AccessControlContext accessControlContext = AccessController.getContext();
        if (this.okContext == null || !this.okContext.equals(accessControlContext) && !this.authcache.containsKey(accessControlContext)) {
            securityManager.checkConnect(this.ep.getHost(), this.ep.getPort());
            this.authcache.put(accessControlContext, new SoftReference(accessControlContext));
        }
        this.okContext = accessControlContext;
    }

    private Connection createConnection() throws RemoteException {
        TCPConnection tCPConnection;
        if (TCPTransport.logLevel >= 10) {
            LogStream.log("tcp").println("TCPChannel.newConnection: create connection");
        }
        if (!this.usingMultiplexer) {
            Socket socket = this.ep.newSocket();
            tCPConnection = new TCPConnection(this, socket);
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(tCPConnection.getOutputStream());
                this.writeTransportHeader(dataOutputStream);
                if (!tCPConnection.isReusable()) {
                    dataOutputStream.writeByte(76);
                }
                dataOutputStream.writeByte(75);
                dataOutputStream.flush();
                DataInputStream dataInputStream = new DataInputStream(tCPConnection.getInputStream());
                byte by = dataInputStream.readByte();
                if (by != 78) {
                    throw new MarshalException("Transport protocol not supported by server");
                }
                String string = dataInputStream.readUTF();
                int n = dataInputStream.readInt();
                if (TCPTransport.logLevel >= 20) {
                    LogStream.log("tcp").println("TCPChannel.newConnection: server suggested " + string + ":" + n);
                }
                TCPEndpoint.setLocalHost(string);
                TCPEndpoint tCPEndpoint = TCPEndpoint.getLocalEndpoint(0, this.ep.getClientSocketFactory(), this.ep.getServerSocketFactory());
                dataOutputStream.writeUTF(tCPEndpoint.getHost());
                dataOutputStream.writeInt(tCPEndpoint.getPort());
                if (TCPTransport.logLevel >= 20) {
                    LogStream.log("tcp").println("TCPChannel.newConnection: using " + tCPEndpoint.getHost() + ":" + tCPEndpoint.getPort());
                }
                dataOutputStream.flush();
            }
            catch (IOException iOException) {
                if (iOException instanceof RemoteException) {
                    throw (RemoteException)iOException;
                }
                throw new MarshalException("Error marshaling transport header", iOException);
            }
        } else {
            try {
                tCPConnection = this.multiplexer.openConnection();
            }
            catch (IOException iOException) {
                TCPChannel tCPChannel = this;
                synchronized (tCPChannel) {
                    this.usingMultiplexer = false;
                    this.multiplexer = null;
                }
                throw new ConnectIOException("Error creating multiplexed connection", iOException);
            }
        }
        return tCPConnection;
    }

    public void free(Connection connection, boolean bl) {
        if (connection == null) {
            return;
        }
        if (bl && connection.isReusable()) {
            long l = System.currentTimeMillis();
            if (TCPTransport.logLevel >= 10) {
                LogStream.log("tcp").println("TCPChannel.free: reuse connection");
            }
            ArrayList arrayList = this.freeList;
            synchronized (arrayList) {
                this.freeList.add(connection);
                if (this.reaper == null) {
                    if (TCPTransport.logLevel >= 10) {
                        LogStream.log("tcp").println("TCPChannel.free: create reaper");
                    }
                    this.reaper = new Reaper();
                    Thread thread = (Thread)AccessController.doPrivileged(new RMIThreadAction(this.reaper, "ConnectionExpiration-" + this.ep.toString(), true));
                    thread.start();
                }
            }
            ((TCPConnection)connection).setLastUseTime(l);
            ((TCPConnection)connection).setExpiration(l + timeout);
        } else {
            if (TCPTransport.logLevel >= 10) {
                LogStream.log("tcp").println("TCPChannel.free: close connection");
            }
            try {
                connection.close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean freeCachedConnections() {
        ArrayList arrayList = this.freeList;
        synchronized (arrayList) {
            int n = this.freeList.size();
            if (n > 0) {
                long l = System.currentTimeMillis();
                ListIterator listIterator = this.freeList.listIterator(n);
                while (listIterator.hasPrevious()) {
                    TCPConnection tCPConnection = (TCPConnection)listIterator.previous();
                    if (!tCPConnection.expired(l)) continue;
                    if (TCPTransport.logLevel >= 20) {
                        LogStream.log("tcp").println("TCPChannel.freeCachedConnections: connection timeout expired");
                    }
                    try {
                        tCPConnection.close();
                    }
                    catch (IOException iOException) {}
                    listIterator.remove();
                }
            }
            if (this.freeList.isEmpty()) {
                this.reaper = null;
                boolean bl = false;
                Object var3_8 = null;
                return bl;
            }
            boolean bl = true;
            Object var3_9 = null;
            return bl;
        }
    }

    public Endpoint getEndpoint() {
        return this.ep;
    }

    void haveMultiplexer() throws RemoteException {
        if (this.multiplexer == null) {
            if (TCPTransport.logLevel >= 20) {
                LogStream.log("tcp").println("TCPChannel.haveMultiplexer(): attempting to open multiplex connection");
            }
            this.multiplexer = this.openMultiplexer();
            Thread thread = (Thread)AccessController.doPrivileged(new RMIThreadAction(this, "Multiplexer-" + this.ep.getHost() + ":" + this.ep.getPort(), true));
            thread.start();
        }
    }

    public Connection newConnection() throws RemoteException {
        TCPConnection tCPConnection;
        do {
            tCPConnection = null;
            ArrayList arrayList = this.freeList;
            synchronized (arrayList) {
                int n = this.freeList.size() - 1;
                if (n >= 0) {
                    this.checkConnectPermission();
                    tCPConnection = (TCPConnection)this.freeList.get(n);
                    this.freeList.remove(n);
                }
            }
            if (tCPConnection == null) continue;
            if (!tCPConnection.isDead()) {
                if (TCPTransport.logLevel >= 10) {
                    LogStream.log("tcp").println("TCPChannel.newConnection: reuse connection");
                }
                return tCPConnection;
            }
            this.free(tCPConnection, false);
        } while (tCPConnection != null);
        return this.createConnection();
    }

    private ConnectionMultiplexer openMultiplexer() throws RemoteException {
        ConnectionMultiplexer connectionMultiplexer;
        Socket socket = this.ep.newSocket();
        TCPConnection tCPConnection = new TCPConnection(this, socket);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(tCPConnection.getOutputStream());
            this.writeTransportHeader(dataOutputStream);
            if (!tCPConnection.isReusable()) {
                throw new ConnectIOException("Cannot open multiplexed connection to " + this.ep);
            }
            dataOutputStream.writeByte(77);
            dataOutputStream.flush();
            DataInputStream dataInputStream = new DataInputStream(tCPConnection.getInputStream());
            byte by = dataInputStream.readByte();
            if (by != 78) {
                throw new MarshalException("Transport protocol not supported by receiver");
            }
            String string = dataInputStream.readUTF();
            int n = dataInputStream.readInt();
            if (TCPTransport.logLevel >= 20) {
                LogStream.log("tcp").println("TCPChannel.openMultiplexer: server suggested " + string + ":" + n);
            }
            TCPEndpoint.setLocalHost(string);
            TCPEndpoint.setDefaultPort(n);
            TCPEndpoint tCPEndpoint = TCPEndpoint.getLocalEndpoint(0, this.ep.getClientSocketFactory(), this.ep.getServerSocketFactory());
            dataOutputStream.writeUTF(tCPEndpoint.getHost());
            dataOutputStream.writeInt(tCPEndpoint.getPort());
            if (TCPTransport.logLevel >= 20) {
                LogStream.log("tcp").println("TCPChannel.openMultiplexer: using " + tCPEndpoint.getHost() + ":" + tCPEndpoint.getPort());
            }
            dataOutputStream.flush();
            connectionMultiplexer = new ConnectionMultiplexer(this, tCPConnection.getInputStream(), tCPConnection.getOutputStream(), true);
        }
        catch (IOException iOException) {
            if (iOException instanceof RemoteException) {
                throw (RemoteException)iOException;
            }
            throw new MarshalException("Error marshaling transport header", iOException);
        }
        return connectionMultiplexer;
    }

    public void removeNotifiable(Endpoint endpoint, Notifiable notifiable) {
        this.notifyList.removeElement(notifiable);
    }

    public void run() {
        try {
            this.multiplexer.run();
        }
        catch (IOException iOException) {
            if (TCPTransport.logLevel >= 20) {
                LogStream logStream;
                LogStream logStream2 = logStream = LogStream.log("tcp");
                synchronized (logStream2) {
                    logStream.print("exception occurred in multiplexer: ");
                    iOException.printStackTrace(logStream);
                }
            }
            this.multiplexer = null;
            try {
                this.haveMultiplexer();
            }
            catch (RemoteException remoteException) {}
        }
    }

    public void shedCache() {
        ArrayList arrayList = this.freeList;
        synchronized (arrayList) {
            ListIterator listIterator = this.freeList.listIterator();
            while (listIterator.hasNext()) {
                Connection connection = (Connection)listIterator.next();
                try {
                    connection.close();
                }
                catch (IOException iOException) {}
            }
            this.freeList.clear();
        }
    }

    synchronized void useMultiplexer(ConnectionMultiplexer connectionMultiplexer) {
        this.multiplexer = connectionMultiplexer;
        this.usingMultiplexer = true;
    }

    private void writeTransportHeader(DataOutputStream dataOutputStream) throws RemoteException {
        try {
            DataOutputStream dataOutputStream2 = new DataOutputStream(dataOutputStream);
            dataOutputStream2.writeInt(1246907721);
            dataOutputStream2.writeShort(2);
        }
        catch (IOException iOException) {
            throw new MarshalException("Error marshaling transport header", iOException);
        }
    }

    private class Reaper
    implements Runnable {
        Reaper() {
        }

        public void run() {
            do {
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException interruptedException) {}
                if (TCPTransport.logLevel < 20) continue;
                LogStream.log("tcp").println("TCPChannel.Reaper: wake up");
            } while (TCPChannel.this.freeCachedConnections());
            if (TCPTransport.logLevel >= 20) {
                LogStream.log("tcp").println("TCPChannel.Reaper: exit");
            }
        }
    }
}

