/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.registry;

import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.misc.URLClassPath;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.server.UnicastServerRef2;
import sun.rmi.transport.LiveRef;

public class RegistryImpl
extends RemoteServer
implements Registry {
    private static final long serialVersionUID = 4666870661827494597L;
    private Hashtable bindings = new Hashtable(101);
    private static RegistryImpl registry;
    private static InetAddress[] localHosts;
    private static ObjID id;

    static {
        localHosts = null;
        id = new ObjID(0);
    }

    public RegistryImpl(int n) throws RemoteException {
        LiveRef liveRef = new LiveRef(id, n);
        this.setup(new UnicastServerRef(liveRef));
    }

    public RegistryImpl(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        LiveRef liveRef = new LiveRef(id, n, rMIClientSocketFactory, rMIServerSocketFactory);
        this.setup(new UnicastServerRef2(liveRef));
    }

    static /* synthetic */ InetAddress[] access$0() {
        return localHosts;
    }

    public void bind(String string, Remote remote) throws RemoteException, AlreadyBoundException, AccessException {
        RegistryImpl.checkAccess("Registry.bind");
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            Remote remote2 = (Remote)this.bindings.get(string);
            if (remote2 != null) {
                throw new AlreadyBoundException(string);
            }
            this.bindings.put(string, remote);
        }
    }

    public static void checkAccess(String string) throws AccessException {
        try {
            if (localHosts == null) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws UnknownHostException {
                            InetAddress inetAddress = InetAddress.getLocalHost();
                            String string = inetAddress.getHostName();
                            localHosts = InetAddress.getAllByName(string);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (UnknownHostException)privilegedActionException.getException();
                }
            }
            final String string2 = RemoteServer.getClientHost();
            InetAddress inetAddress = null;
            try {
                inetAddress = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws UnknownHostException {
                        return InetAddress.getByName(string2);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (UnknownHostException)privilegedActionException.getException();
            }
            int n = 0;
            while (n < localHosts.length) {
                if (inetAddress.equals(localHosts[n]) || string2.equals(localHosts[n].getHostName())) {
                    return;
                }
                ++n;
            }
            if (inetAddress.equals(InetAddress.getByName(null))) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(String.valueOf(string) + ": " + inetAddress + " not one of {");
            int n2 = 0;
            while (n2 < localHosts.length) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(localHosts[n2].toString());
                ++n2;
            }
            throw new AccessException(stringBuffer.append('}').toString());
        }
        catch (ServerNotActiveException serverNotActiveException) {
        }
        catch (UnknownHostException unknownHostException) {
            throw new AccessException(String.valueOf(string) + ": unknown host");
        }
    }

    public static ObjID getID() {
        return id;
    }

    public String[] list() throws RemoteException {
        String[] stringArray;
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            int n = this.bindings.size();
            stringArray = new String[n];
            Enumeration enumeration = this.bindings.keys();
            while (--n >= 0) {
                stringArray[n] = (String)enumeration.nextElement();
            }
        }
        return stringArray;
    }

    public Remote lookup(String string) throws RemoteException, NotBoundException {
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            Remote remote = (Remote)this.bindings.get(string);
            if (remote == null) {
                throw new NotBoundException(string);
            }
            Remote remote2 = remote;
            Object var4_5 = null;
            return remote2;
        }
    }

    public static void main(String[] stringArray) {
        System.setSecurityManager(new RMISecurityManager());
        try {
            String string = System.getProperty("env.class.path");
            if (string == null) {
                string = ".";
            }
            URL[] uRLArray = URLClassPath.pathToURLs(string);
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            Thread.currentThread().setContextClassLoader(uRLClassLoader);
            int n = 1099;
            if (stringArray.length >= 1) {
                n = Integer.parseInt(stringArray[0]);
            }
            registry = new RegistryImpl(n);
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(Long.MAX_VALUE);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Port is not a number.");
        }
        catch (Exception exception) {
            System.out.println("RegistryImpl.main: an exception occurred: " + exception.getMessage());
            exception.printStackTrace();
        }
        System.exit(1);
    }

    public void rebind(String string, Remote remote) throws RemoteException, AccessException {
        RegistryImpl.checkAccess("Registry.rebind");
        this.bindings.put(string, remote);
    }

    private void setup(UnicastServerRef unicastServerRef) throws RemoteException {
        this.ref = unicastServerRef;
        unicastServerRef.exportObject(this, null, true);
    }

    public void unbind(String string) throws RemoteException, NotBoundException, AccessException {
        RegistryImpl.checkAccess("Registry.unbind");
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            Remote remote = (Remote)this.bindings.get(string);
            if (remote == null) {
                throw new NotBoundException(string);
            }
            this.bindings.remove(string);
        }
    }
}

