/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.peer.MenuItemPeer;
import sun.awt.SunToolkit;
import sun.awt.motif.MMenuPeer;
import sun.awt.motif.MToolkit;

class MMenuItemPeer
implements MenuItemPeer {
    long pData;
    long jniGlobalRef;
    boolean isCheckbox = false;
    MenuItem target;
    boolean nativeCreated = false;
    private boolean disposed = false;

    static {
        MMenuItemPeer.initIDs();
    }

    protected MMenuItemPeer() {
    }

    MMenuItemPeer(MenuItem menuItem) {
        this.target = menuItem;
        MMenuPeer mMenuPeer = (MMenuPeer)MToolkit.targetToPeer(MMenuItemPeer.getParent_NoClientCode(menuItem));
        this.create(mMenuPeer);
    }

    public void action(long l, final int n) {
        SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            public void run() {
                this.postEvent(new ActionEvent(target, 1001, target.getActionCommand(), n));
            }
        });
    }

    void create(MMenuPeer mMenuPeer) {
        if (mMenuPeer.nativeCreated) {
            this.createMenuItem(mMenuPeer);
            this.nativeCreated = true;
            this.setEnabled(this.target.isEnabled());
        }
    }

    native void createMenuItem(MMenuPeer var1);

    void destroyNativeWidget() {
        this.destroyNativeWidgetImpl();
    }

    private void destroyNativeWidgetImpl() {
        if (this.nativeCreated) {
            this.pDispose();
            this.nativeCreated = false;
        }
    }

    public void disable() {
        if (!this.nativeCreated) {
            return;
        }
        this.pDisable();
    }

    public final void dispose() {
        boolean bl = false;
        if (!this.disposed) {
            MMenuItemPeer mMenuItemPeer = this;
            synchronized (mMenuItemPeer) {
                if (!this.disposed) {
                    bl = true;
                    this.disposed = true;
                }
            }
        }
        if (bl) {
            this.disposeImpl();
        }
    }

    protected void disposeImpl() {
        this.destroyNativeWidgetImpl();
        MToolkit.targetDisposedPeer(this.target, this);
    }

    public void enable() {
        if (!this.nativeCreated) {
            return;
        }
        this.pEnable();
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    static native MenuContainer getParent_NoClientCode(MenuComponent var0);

    private static native void initIDs();

    native void pDisable();

    native void pDispose();

    native void pEnable();

    native void pSetLabel(String var1);

    void postEvent(AWTEvent aWTEvent) {
        SunToolkit.postEvent(SunToolkit.targetToAppContext(this.target), aWTEvent);
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void setLabel(String string) {
        if (!this.nativeCreated) {
            return;
        }
        this.pSetLabel(string);
    }
}

