/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.peer.FramePeer;
import java.security.AccessController;
import java.util.Vector;
import sun.awt.im.InputMethodManager;
import sun.awt.image.ImageRepresentation;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MInputMethodControl;
import sun.awt.motif.MMenuBarPeer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.MToolkit;
import sun.awt.motif.X11Image;
import sun.awt.motif.X11InputMethod;
import sun.security.action.GetIntegerAction;

class MFramePeer
extends MPanelPeer
implements FramePeer,
MInputMethodControl {
    Insets insets = new Insets(0, 0, 0, 0);
    int iconWidth = -1;
    int iconHeight = -1;
    static Vector allFrames = new Vector();
    static Vector imList = new Vector();
    static Vector tcList = new Vector();
    static final int CROSSHAIR_INSET = 5;
    static final int BUTTON_Y = 6;
    static final int BUTTON_W = 17;
    static final int BUTTON_H = 17;
    static final int SYS_MENU_X = 6;
    static final int SYS_MENU_CONTAINED_X = 11;
    static final int SYS_MENU_CONTAINED_Y = 13;
    static final int SYS_MENU_CONTAINED_W = 8;
    static final int SYS_MENU_CONTAINED_H = 3;
    static final int MAXIMIZE_X_DIFF = 22;
    static final int MAXIMIZE_CONTAINED_X_DIFF = 17;
    static final int MAXIMIZE_CONTAINED_Y = 11;
    static final int MAXIMIZE_CONTAINED_W = 8;
    static final int MAXIMIZE_CONTAINED_H = 8;
    static final int MINIMIZE_X_DIFF = 39;
    static final int MINIMIZE_CONTAINED_X_DIFF = 32;
    static final int MINIMIZE_CONTAINED_Y = 13;
    static final int MINIMIZE_CONTAINED_W = 3;
    static final int MINIMIZE_CONTAINED_H = 3;
    static final int TITLE_X = 23;
    static final int TITLE_W_DIFF = 60;
    static final int TITLE_MID_Y = 14;
    static final int MENUBAR_X = 6;
    static final int MENUBAR_Y = 23;
    static final int HORIZ_RESIZE_INSET = 22;
    static final int VERT_RESIZE_INSET = 22;

    static {
        MFramePeer.initIDs();
    }

    MFramePeer(Frame frame) {
        Image image;
        Color color;
        Font font;
        this.init(frame, new Insets(MFramePeer.getInset("awt.frame.topInset", -1), MFramePeer.getInset("awt.frame.leftInset", -1), MFramePeer.getInset("awt.frame.bottomInset", -1), MFramePeer.getInset("awt.frame.rightInset", -1)));
        allFrames.addElement(this);
        InputMethodManager inputMethodManager = InputMethodManager.getInstance();
        String string = inputMethodManager.getTriggerMenuString();
        if (string != null) {
            this.pSetIMMOption(string);
        }
        if (frame.getTitle() != null) {
            this.pSetTitle(frame.getTitle());
        }
        if ((font = frame.getFont()) == null) {
            font = new Font("Dialog", 0, 12);
            frame.setFont(font);
            this.setFont(font);
        }
        if ((color = frame.getBackground()) == null) {
            frame.setBackground(SystemColor.window);
            this.setBackground(SystemColor.window);
        }
        if ((color = frame.getForeground()) == null) {
            frame.setForeground(SystemColor.windowText);
            this.setForeground(SystemColor.windowText);
        }
        if ((image = frame.getIconImage()) != null) {
            this.setIconImage(image);
        }
        this.setResizable(frame.isResizable());
    }

    public void addInputMethod(X11InputMethod x11InputMethod) {
        if (!imList.contains(x11InputMethod)) {
            imList.addElement(x11InputMethod);
        }
    }

    native void addTextComponent();

    public void addTextComponent(MComponentPeer mComponentPeer) {
        if (tcList.contains(mComponentPeer)) {
            return;
        }
        if (tcList.isEmpty()) {
            this.addTextComponentNative();
            if (!imList.isEmpty()) {
                int n = 0;
                while (n < imList.size()) {
                    ((X11InputMethod)imList.elementAt(n)).reconfigureXIC(this);
                    ++n;
                }
            }
        }
        tcList.addElement(mComponentPeer);
    }

    native void addTextComponentNative();

    native void create(MComponentPeer var1, Object var2);

    protected void disposeImpl() {
        allFrames.removeElement(this);
        super.disposeImpl();
    }

    private static int getInset(String string, int n) {
        Integer n2 = (Integer)AccessController.doPrivileged(new GetIntegerAction(string, n));
        return n2;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public native int getState();

    public void handleActivate() {
        this.postEvent(new WindowEvent((Window)this.target, 205));
    }

    public void handleDeactivate() {
        this.postEvent(new WindowEvent((Window)this.target, 206));
    }

    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    public int handleFocusTraversalEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 9 || keyEvent.getSource() instanceof TextArea) {
            return 0;
        }
        if ((keyEvent.getModifiers() & 0xFFFFFFFE) > 0) {
            return 0;
        }
        int n = keyEvent.getID();
        if (n == 402 || n == 400) {
            return 1;
        }
        if (keyEvent.isShiftDown()) {
            return 3;
        }
        return 2;
    }

    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    public void handleMoved(int n, int n2) {
        this.postEvent(new ComponentEvent(this.target, 100));
    }

    public void handleQuit() {
        this.postEvent(new WindowEvent((Window)this.target, 201));
    }

    public void handleResize(int n, int n2) {
        if (!tcList.isEmpty() && !imList.isEmpty()) {
            int n3 = 0;
            while (n3 < imList.size()) {
                ((X11InputMethod)imList.elementAt(n3)).configureStatus();
                ++n3;
            }
        }
        this.postEvent(new ComponentEvent(this.target, 101));
    }

    public native boolean hasTextComponents();

    private static native void initIDs();

    public Insets insets() {
        return this.getInsets();
    }

    void notifyIMMOptionChange() {
        InputMethodManager.getInstance().notifyChangeRequest(this.target);
    }

    native void pDispose();

    native boolean pGetIconSize(int var1, int var2);

    native void pHide();

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pSetIMMOption(String var1);

    native void pSetIconImage(byte[] var1, int[] var2, short[] var3, int var4, int var5);

    native void pSetMenuBar(MMenuBarPeer var1);

    native void pSetTitle(String var1);

    native void pShow();

    public void print(Graphics graphics) {
        MMenuBarPeer mMenuBarPeer;
        MenuBar menuBar;
        super.print(graphics);
        Frame frame = (Frame)this.target;
        Insets insets = frame.getInsets();
        Dimension dimension = frame.getSize();
        Color color = frame.getBackground();
        Color color2 = frame.getForeground();
        Color color3 = color.brighter();
        Color color4 = color.darker();
        if (color3.equals(Color.white)) {
            graphics.setColor(new Color(230, 230, 230));
        } else {
            graphics.setColor(color3);
        }
        graphics.drawLine(0, 0, dimension.width, 0);
        graphics.drawLine(0, 1, dimension.width - 1, 1);
        graphics.drawLine(0, 0, 0, dimension.height);
        graphics.drawLine(1, 0, 1, dimension.height - 1);
        graphics.setColor(color3);
        graphics.drawLine(6, dimension.height - 5, dimension.width - 5, dimension.height - 5);
        graphics.drawLine(dimension.width - 5, 6, dimension.width - 5, dimension.height - 5);
        graphics.setColor(color4);
        graphics.drawLine(1, dimension.height, dimension.width, dimension.height);
        graphics.drawLine(2, dimension.height - 1, dimension.width, dimension.height - 1);
        graphics.drawLine(dimension.width, 1, dimension.width, dimension.height);
        graphics.drawLine(dimension.width - 1, 2, dimension.width - 1, dimension.height);
        graphics.drawLine(5, 5, dimension.width - 5, 5);
        graphics.drawLine(5, 5, 5, dimension.height - 5);
        graphics.setColor(color);
        graphics.fill3DRect(6, 6, 17, 17, true);
        graphics.fill3DRect(11, 13, 8, 3, true);
        graphics.fill3DRect(23, 6, dimension.width - 60, 17, true);
        graphics.fill3DRect(dimension.width - 39, 6, 17, 17, true);
        graphics.fill3DRect(dimension.width - 32, 13, 3, 3, true);
        graphics.fill3DRect(dimension.width - 22, 6, 17, 17, true);
        graphics.fill3DRect(dimension.width - 17, 11, 8, 8, true);
        graphics.setColor(color2);
        Font font = new Font("SansSerif", 0, 10);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = frame.getTitle();
        graphics.drawString(string, (46 + dimension.width - 60) / 2 - fontMetrics.stringWidth(string) / 2, 14 + fontMetrics.getMaxDescent());
        if (frame.isResizable()) {
            graphics.setColor(color4);
            graphics.drawLine(1, 22, 5, 22);
            graphics.drawLine(22, 1, 22, 5);
            graphics.drawLine(dimension.width - 5 + 1, 22, dimension.width, 22);
            graphics.drawLine(dimension.width - 22 - 1, 2, dimension.width - 22 - 1, 6);
            graphics.drawLine(1, dimension.height - 22 - 1, 5, dimension.height - 22 - 1);
            graphics.drawLine(22, dimension.height - 5 + 1, 22, dimension.height);
            graphics.drawLine(dimension.width - 5 + 1, dimension.height - 22 - 1, dimension.width, dimension.height - 22 - 1);
            graphics.drawLine(dimension.width - 22 - 1, dimension.height - 5 + 1, dimension.width - 22 - 1, dimension.height);
            graphics.setColor(color3);
            graphics.drawLine(2, 23, 5, 23);
            graphics.drawLine(23, 2, 23, 5);
            graphics.drawLine(dimension.width - 5 + 1, 23, dimension.width - 1, 23);
            graphics.drawLine(dimension.width - 22, 2, dimension.width - 22, 5);
            graphics.drawLine(2, dimension.height - 22, 5, dimension.height - 22);
            graphics.drawLine(23, dimension.height - 5 + 1, 23, dimension.height - 1);
            graphics.drawLine(dimension.width - 5 + 1, dimension.height - 22, dimension.width - 1, dimension.height - 22);
            graphics.drawLine(dimension.width - 22, dimension.height - 5 + 1, dimension.width - 22, dimension.height - 1);
        }
        if ((menuBar = frame.getMenuBar()) != null && (mMenuBarPeer = (MMenuBarPeer)MToolkit.targetToPeer(menuBar)) != null) {
            Insets insets2 = this.insets();
            Graphics graphics2 = graphics.create();
            try {
                graphics2.translate(6, 23);
                mMenuBarPeer.print(graphics2);
            }
            finally {
                Object var17_16 = null;
                graphics2.dispose();
            }
        }
    }

    public void removeInputMethod(X11InputMethod x11InputMethod) {
        if (imList.contains(x11InputMethod)) {
            imList.removeElement(x11InputMethod);
        }
    }

    public void removeTextComponent(MComponentPeer mComponentPeer) {
        if (!tcList.contains(mComponentPeer)) {
            return;
        }
        tcList.removeElement(mComponentPeer);
        if (tcList.isEmpty()) {
            this.removeTextComponentNative();
            if (!imList.isEmpty()) {
                int n = 0;
                while (n < imList.size()) {
                    ((X11InputMethod)imList.elementAt(n)).reconfigureXIC(this);
                    ++n;
                }
            }
        }
    }

    native void removeTextComponentNative();

    public void setIconImage(Image image) {
        int n;
        int n2;
        Object object;
        if (image instanceof X11Image) {
            object = ((X11Image)image).getImageRep();
            ((ImageRepresentation)object).reconstruct(32);
            n2 = ((ImageRepresentation)object).getWidth();
            n = ((ImageRepresentation)object).getHeight();
        } else {
            n2 = image.getWidth(null);
            n = image.getHeight(null);
        }
        if (this.pGetIconSize(n2, n)) {
            object = this.createImage(this.iconWidth, this.iconHeight);
            Graphics graphics = ((Image)object).getGraphics();
            graphics.drawImage(image, 0, 0, this.iconWidth, this.iconHeight, null);
            DataBuffer dataBuffer = ((BufferedImage)object).getRaster().getDataBuffer();
            byte[] byArray = null;
            int[] nArray = null;
            short[] sArray = null;
            if (dataBuffer instanceof DataBufferByte) {
                byArray = ((DataBufferByte)dataBuffer).getData();
            } else if (dataBuffer instanceof DataBufferInt) {
                nArray = ((DataBufferInt)dataBuffer).getData();
            } else if (dataBuffer instanceof DataBufferUShort) {
                sArray = ((DataBufferUShort)dataBuffer).getData();
            }
            this.pSetIconImage(byArray, nArray, sArray, this.iconWidth, this.iconHeight);
        }
    }

    public void setMenuBar(MenuBar menuBar) {
        MMenuBarPeer mMenuBarPeer = (MMenuBarPeer)MToolkit.targetToPeer(menuBar);
        this.pSetMenuBar(mMenuBarPeer);
        Rectangle rectangle = this.target.bounds();
        this.pReshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.target.isVisible()) {
            this.target.validate();
        }
    }

    public native void setResizable(boolean var1);

    public native void setState(int var1);

    public void setTitle(String string) {
        this.pSetTitle(string);
    }

    public native void toBack();

    public void toFront() {
        this.pShow();
    }
}

