/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTPermission;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DropTargetContextPeer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.rmi.MarshalledObject;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MDropTargetContextPeerDispatcher;

final class MDropTargetContextPeer
implements DropTargetContextPeer,
Transferable {
    private static final Object _globalLock = new Object();
    private static Transferable currentJVMLocalSourceTransferable = null;
    private static AccessControlContext currentJVMLocalSourceACtxt = null;
    static final int STATUS_NONE = 0;
    static final int STATUS_WAIT = 1;
    static final int STATUS_ACCEPT = 2;
    static final int STATUS_REJECT = -1;
    private static MDropTargetContextPeerDispatcher listenerDispatcher = null;
    private Component currentC;
    private DropTarget currentDT;
    private DropTargetContext currentDTC;
    private String[] currentT;
    private int currentA;
    private int currentSA;
    private int currentDA;
    private long nativeDragContext;
    private Transferable local;
    private long nativeDropTransfer;
    int dropStatus = 0;
    boolean dropComplete = false;
    String nativeDataAvailable = null;
    Object nativeData = null;
    Object lock = new Object();
    boolean dropDispatched = false;
    Object dropLock = new Object();
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$lang$String;

    MDropTargetContextPeer() {
    }

    public void acceptDrag(int n) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentDT == null) {
                throw new InvalidDnDOperationException("No Drag pending");
            }
            if (this.currentDA != n) {
                this.currentDA = this.mapOperation(this.currentA & this.currentSA, n);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acceptDrop(int n) {
        Object object = this.lock;
        synchronized (object) {
            if (this.dropStatus == 0) {
                throw new InvalidDnDOperationException("No Drop pending");
            }
            if (this.currentDA != n) {
                this.currentDA = this.mapOperation(this.currentA & this.currentSA, n);
            }
            if (this.currentDA != 0) {
                this.dropStatus = 2;
                this.dropComplete = false;
            } else {
                this.dropStatus = -1;
                this.currentA = 0;
                this.dropComplete = true;
            }
        }
        listenerDispatcher.dispatched();
        object = this.dropLock;
        synchronized (object) {
            while (true) {
                if (this.dropDispatched) {
                    return;
                }
                try {
                    this.dropLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private native void addTransfer(long var1, String var3);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static MDropTargetContextPeer createMDropTargetContextPeer() {
        Object object = _globalLock;
        synchronized (object) {
            if (listenerDispatcher == null) {
                listenerDispatcher = new MDropTargetContextPeerDispatcher();
            }
        }
        return new MDropTargetContextPeer();
    }

    public void dropComplete(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            if (this.dropStatus == 0) {
                throw new InvalidDnDOperationException("No Drop pending");
            }
            if (this.currentDTC != null) {
                this.currentDTC.removeNotify();
            }
            this.currentC = null;
            this.currentDT = null;
            this.currentDTC = null;
            this.currentT = null;
            this.currentDA = 0;
            this.currentSA = 0;
            this.currentA = 0;
            Object object2 = _globalLock;
            synchronized (object2) {
                currentJVMLocalSourceTransferable = null;
                currentJVMLocalSourceACtxt = null;
            }
            this.dropDone(this.nativeDragContext, this.nativeDropTransfer, this.local != null, bl);
            this.local = null;
            this.dropComplete = true;
        }
    }

    private void dropDispatched() {
        Object object = this.dropLock;
        synchronized (object) {
            this.dropDispatched = true;
            this.dropLock.notify();
        }
    }

    private native void dropDone(long var1, long var3, boolean var5, boolean var6);

    int getDropStatus() {
        Object object = this.lock;
        synchronized (object) {
            int n = this.dropStatus;
            Object var3_3 = null;
            return n;
        }
    }

    public DropTarget getDropTarget() {
        return this.currentDT;
    }

    private static Transferable getJVMLocalSourceTransferable() {
        Transferable transferable = null;
        Object object = _globalLock;
        synchronized (object) {
            if (currentJVMLocalSourceTransferable != null && !currentJVMLocalSourceACtxt.equals(AccessController.getContext())) {
                AccessController.checkPermission(new AWTPermission("acceptDropBetweenAccessControlContexts"));
            }
            transferable = currentJVMLocalSourceTransferable;
        }
        return transferable;
    }

    private static List getList(Object[] objectArray) {
        return Arrays.asList(objectArray);
    }

    public int getTargetActions() {
        return this.currentA;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException, InvalidDnDOperationException {
        if (this.local != null) {
            return this.local.getTransferData(dataFlavor);
        }
        String string = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.dropStatus != 2) throw new InvalidDnDOperationException("No drop current");
            if (this.dropComplete) {
                throw new InvalidDnDOperationException("No drop current");
            }
            Map map = this.currentDT.getFlavorMap().getNativesForFlavors(new DataFlavor[]{dataFlavor});
            string = (String)map.get(dataFlavor);
            if (string == null) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            int n = 0;
            while (n < this.currentT.length) {
                if (this.currentT[n].equals(string)) break;
                ++n;
            }
            if (n == this.currentT.length) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            if (this.nativeDropTransfer == 0L) {
                this.nativeDropTransfer = this.startTransfer(this.nativeDragContext, string);
            } else {
                this.addTransfer(this.nativeDropTransfer, string);
            }
            this.nativeDataAvailable = null;
            while (!string.equals(this.nativeDataAvailable)) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.nativeData == null) {
                throw new IOException("no native data was transferred");
            }
            if (this.nativeData instanceof List) {
                return this.nativeData;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])this.nativeData);
            if (dataFlavor.isRepresentationClassInputStream()) {
                Class clazz;
                if ((class$java$io$InputStream != null ? class$java$io$InputStream : (class$java$io$InputStream = MDropTargetContextPeer.class$("java.io.InputStream"))).equals(clazz = dataFlavor.getRepresentationClass())) {
                    return byteArrayInputStream;
                }
                Constructor[] constructorArray = null;
                try {
                    constructorArray = (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return clazz.getConstructors();
                        }
                    });
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace();
                    throw new IOException(securityException.getMessage());
                }
                Constructor constructor = null;
                int n2 = 0;
                while (n2 < constructorArray.length) {
                    Class[] classArray;
                    if (Modifier.isPublic(constructorArray[n2].getModifiers()) && (classArray = constructorArray[n2].getParameterTypes()) != null && classArray.length == 1 && (class$java$io$InputStream != null ? class$java$io$InputStream : MDropTargetContextPeer.class$("java.io.InputStream")).equals(classArray[0])) {
                        constructor = constructorArray[n2];
                        break;
                    }
                    ++n2;
                }
                if (constructor == null) {
                    throw new InvalidDnDOperationException("cant find public <init>(Ljava/io/InputStream;)V for class: " + clazz.getName());
                }
                try {
                    return constructor.newInstance(new Object[]{byteArrayInputStream});
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new InvalidDnDOperationException(exception.getMessage());
                }
            }
            if (dataFlavor.isRepresentationClassRemote()) {
                if (this.currentDA != 0x40000000) {
                    throw new InvalidDnDOperationException("only ACTION_LINK is permissable for transfer java.rmi.Remote objects");
                }
                try {
                    return ((MarshalledObject)new ObjectInputStream(byteArrayInputStream).readObject()).get();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new InvalidDnDOperationException(exception.getMessage());
                }
            }
            if (dataFlavor.isRepresentationClassSerializable()) {
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    return objectInputStream.readObject();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new InvalidDnDOperationException(iOException.getMessage());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    throw new InvalidDnDOperationException(classNotFoundException.getMessage());
                }
            }
            if (!(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MDropTargetContextPeer.class$("java.lang.String"))).equals(dataFlavor.getRepresentationClass())) throw new IOException("getTransferData() failed");
            return new String((byte[])this.nativeData);
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray;
        if (this.local != null) {
            return this.local.getTransferDataFlavors();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.currentT == null) {
                dataFlavorArray = new DataFlavor[]{};
            } else {
                Object[] objectArray = this.currentDT.getFlavorMap().getFlavorsForNatives(this.currentT).values().toArray();
                dataFlavorArray = new DataFlavor[objectArray.length];
                System.arraycopy(objectArray, 0, dataFlavorArray, 0, objectArray.length);
            }
        }
        return dataFlavorArray;
    }

    public synchronized Transferable getTransferable() {
        return this;
    }

    private int handleDropMessage(Component component, int n, int n2, int n3, int n4, String[] stringArray, long l) {
        Component component2 = null;
        Point point = null;
        boolean bl = false;
        DropTarget dropTarget = null;
        this.nativeDragContext = l;
        this.currentT = stringArray;
        this.currentSA = n4;
        this.currentDA = n3;
        Object object = component.getTreeLock();
        synchronized (object) {
            try {
                component2 = ((Container)component).findComponentAt(n, n2);
            }
            catch (ClassCastException classCastException) {
                component2 = component.locate(n, n2);
            }
            boolean bl2 = bl = component2 != null && component2.isShowing() && (dropTarget = component2.getDropTarget()) != null && dropTarget.isActive();
            if (bl) {
                point = this.translate(component, n, n2, component2);
            }
        }
        if (bl) {
            this.currentC = component2;
            this.currentDT = dropTarget;
            object = dropTarget.getDropTargetContext();
            if (this.currentDTC != null) {
                this.currentDTC.removeNotify();
            }
            this.currentDTC = object;
            ((DropTargetContext)this.currentDTC).addNotify(this);
            this.dropStatus = 1;
            this.dropDispatched = false;
            this.currentA = this.currentDT.getDefaultActions();
            this.local = MDropTargetContextPeer.getJVMLocalSourceTransferable();
            if (this.local != null) {
                MDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(null);
            }
            if (n3 == 0) {
                this.currentDA = n3 = this.mapOperation(0x40000003, this.currentSA & this.currentA);
            }
            listenerDispatcher.dispatchDrop(this, this.currentDT, new DropTargetDropEvent(this.currentDTC, point, n3, n4, this.local != null), this.dropLock);
            if (this.dropStatus == -1) {
                if (this.currentDTC != null) {
                    this.currentDTC.removeNotify();
                }
                this.currentC = null;
                this.currentDT = null;
                this.currentDTC = null;
                this.currentT = null;
                this.currentA = 0;
                this.currentDA = 0;
            }
        } else {
            if (this.currentDTC != null) {
                this.currentDTC.removeNotify();
            }
            this.currentC = null;
            this.currentDT = null;
            this.currentDTC = null;
            this.currentT = null;
            this.currentA = 0;
            this.currentDA = 0;
        }
        this.currentSA = 0;
        return this.currentDA;
    }

    private synchronized int handleEnterMessage(Component component, int n, int n2, int n3, int n4, String[] stringArray, long l) {
        boolean bl;
        Component component2 = null;
        DropTarget dropTarget = null;
        Point point = null;
        this.nativeDragContext = l;
        this.currentT = stringArray;
        this.currentSA = n4;
        this.currentDA = n3;
        this.local = MDropTargetContextPeer.getJVMLocalSourceTransferable();
        Object object = component.getTreeLock();
        synchronized (object) {
            try {
                component2 = ((Container)component).findComponentAt(n, n2);
            }
            catch (ClassCastException classCastException) {
                component2 = component.locate(n, n2);
            }
            boolean bl2 = bl = component2 != null && component2.isShowing() && (dropTarget = component2.getDropTarget()) != null && dropTarget.isActive();
            if (bl) {
                point = this.translate(component, n, n2, component2);
            }
        }
        if (this.currentDTC != null) {
            this.currentDTC.removeNotify();
            this.currentDTC = null;
        }
        if (bl) {
            this.currentC = component2;
            this.currentDT = dropTarget;
            this.currentDTC = this.currentDT.getDropTargetContext();
            this.currentDTC.addNotify(this);
            this.currentA = dropTarget.getDefaultActions();
            if (this.currentDA == 0) {
                this.currentDA = n3 = this.mapOperation(0x40000003, this.currentA & this.currentSA);
            }
            listenerDispatcher.dispatchEnter(this, dropTarget, new DropTargetDragEvent(this.currentDTC, point, n3, n4));
            n3 = this.currentDA;
        } else {
            this.currentDT = null;
            this.currentDTC = null;
            this.currentDA = 0;
            this.currentSA = 0;
            this.currentA = 0;
        }
        return this.currentDA;
    }

    private synchronized void handleExitMessage(Component component, long l) {
        this.nativeDragContext = l;
        this.currentDA = 0;
        this.currentSA = 0;
        this.local = null;
        if (this.currentC != null) {
            DropTarget dropTarget = this.currentC.getDropTarget();
            if (dropTarget == null) {
                this.currentC = null;
                this.currentDT = null;
                this.currentT = null;
                this.currentA = 0;
                if (this.currentDTC != null) {
                    this.currentDTC.removeNotify();
                }
                this.currentDTC = null;
                return;
            }
            if (dropTarget != this.currentDT) {
                if (this.currentDTC != null) {
                    this.currentDTC.removeNotify();
                }
                this.currentDT = dropTarget;
                this.currentDTC = dropTarget.getDropTargetContext();
                this.currentDTC.addNotify(this);
            }
            if (this.currentDT.isActive()) {
                listenerDispatcher.dispatchExit(this, this.currentDT, new DropTargetEvent(this.currentDTC));
            }
            this.currentA = 0;
            this.currentDTC.removeNotify();
        }
        this.local = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized int handleMotionMessage(Component component, int n, int n2, int n3, boolean bl, int n4, String[] stringArray, long l) {
        DropTarget dropTarget;
        boolean bl2;
        Point point;
        Component component2;
        block29: {
            component2 = null;
            Point point2 = null;
            point = null;
            boolean bl3 = false;
            bl2 = false;
            DropTarget dropTarget2 = null;
            dropTarget = null;
            this.nativeDragContext = l;
            this.currentT = stringArray;
            this.currentSA = n4;
            this.currentDA = n3;
            if (this.currentC != null) {
                boolean bl4 = false;
                Object object = component.getTreeLock();
                synchronized (object) {
                    try {
                        component2 = ((Container)component).findComponentAt(n, n2);
                    }
                    catch (ClassCastException classCastException) {
                        component2 = component.locate(n, n2);
                    }
                    point2 = this.translate(component, n, n2, this.currentC);
                    bl4 = this.currentC.equals(component2);
                    if (!bl4 && component2 != null) {
                        point = this.translate(component, n, n2, component2);
                        boolean bl5 = bl2 = component2.isShowing() && (dropTarget = component2.getDropTarget()) != null && dropTarget.isActive();
                    }
                    if ((dropTarget2 = this.currentC.getDropTarget()) == null) {
                        this.currentDTC.removeNotify();
                        this.currentC = null;
                        this.currentDTC = null;
                        this.currentT = null;
                    } else {
                        DropTargetContext dropTargetContext;
                        if (this.currentDT != dropTarget2) {
                            if (this.currentDTC != null) {
                                this.currentDTC.removeNotify();
                            }
                            this.currentDT = dropTarget2;
                            this.currentDTC = null;
                        }
                        if ((dropTargetContext = this.currentDT.getDropTargetContext()) != this.currentDTC) {
                            if (this.currentDTC != null) {
                                this.currentDTC.removeNotify();
                            }
                            this.currentDTC = dropTargetContext;
                            this.currentDTC.addNotify(this);
                        }
                        bl3 = this.currentC.isShowing() && this.currentDT.isActive();
                    }
                }
                if (bl3) {
                    if (!bl4) {
                        listenerDispatcher.dispatchExit(this, this.currentDT, new DropTargetEvent(this.currentDTC));
                        this.currentDTC.removeNotify();
                        this.currentDTC = null;
                        this.currentC = null;
                        this.currentT = null;
                        this.currentDT = null;
                        this.currentA = 0;
                        break block29;
                    } else {
                        this.currentA = this.currentDT.getDefaultActions();
                        if (n3 == 0) {
                            this.currentDA = n3 = this.mapOperation(0x40000003, this.currentA & this.currentSA);
                        }
                        object = new DropTargetDragEvent(this.currentDTC, point2, n3, n4);
                        listenerDispatcher.dispatchOver(this, this.currentDT, (DropTargetEvent)object, bl);
                        return this.currentDA;
                    }
                }
                this.currentA = 0;
                this.currentDA = 0;
            }
        }
        if (component2 == null) {
            Object object = component.getTreeLock();
            synchronized (object) {
                try {
                    component2 = ((Container)component).findComponentAt(n, n2);
                }
                catch (ClassCastException classCastException) {
                    component2 = component.locate(n, n2);
                }
                boolean bl6 = bl2 = component2 != null && component2.isShowing() && (dropTarget = component2.getDropTarget()) != null && dropTarget.isActive();
                if (bl2) {
                    point = this.translate(component, n, n2, component2);
                }
            }
        }
        if (bl2) {
            this.currentC = component2;
            this.currentT = stringArray;
            this.currentDT = dropTarget;
            this.currentDTC = dropTarget.getDropTargetContext();
            this.currentDTC.addNotify(this);
            this.currentA = dropTarget.getDefaultActions();
            if (n3 == 0) {
                this.currentDA = n3 = this.mapOperation(0x40000003, this.currentA & this.currentSA);
            }
            listenerDispatcher.dispatchEnter(this, this.currentDT, new DropTargetDragEvent(this.currentDTC, point, n3, n4));
            return this.currentDA;
        }
        Object object = this.lock;
        synchronized (object) {
            this.currentC = null;
            this.currentDT = null;
            this.currentDTC = null;
            this.currentA = 0;
            this.currentDA = 0;
            return this.currentDA;
        }
    }

    private void heartbeat() {
        if (!this.dropComplete) {
            this.keepAlive(this.nativeDropTransfer);
        }
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        if (this.local != null) {
            return this.isDataFlavorSupported(dataFlavor);
        }
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (dataFlavor.equals(dataFlavorArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isTransferableJVMLocal() {
        return this.local != null || MDropTargetContextPeer.getJVMLocalSourceTransferable() != null;
    }

    private native void keepAlive(long var1);

    private int mapOperation(int n, int n2) {
        int[] nArray = new int[]{2, 1, 0x40000000};
        n2 &= n;
        int n3 = 0;
        while (n3 < nArray.length) {
            if ((n2 & nArray[n3]) == nArray[n3]) {
                return nArray[n3];
            }
            ++n3;
        }
        return 0;
    }

    private void newData(String string, String string2, byte[] byArray) {
        Object object = this.lock;
        synchronized (object) {
            this.nativeDataAvailable = string;
            this.nativeData = byArray;
            this.heartbeat();
            this.lock.notify();
        }
    }

    public void rejectDrag() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentDT == null) {
                throw new InvalidDnDOperationException("No Drag pending");
            }
            this.currentDA = 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rejectDrop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.dropStatus == 0) {
                throw new InvalidDnDOperationException("No Drop pending");
            }
            this.dropStatus = -1;
            this.currentDA = 0;
            this.dropComplete = true;
        }
        listenerDispatcher.dispatched();
        object = this.dropLock;
        synchronized (object) {
            while (true) {
                if (this.dropDispatched) {
                    return;
                }
                try {
                    this.dropLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    static void setCurrentJVMLocalSourceTransferable(Transferable transferable) throws InvalidDnDOperationException {
        Object object = _globalLock;
        synchronized (object) {
            if (transferable != null && currentJVMLocalSourceTransferable != null) {
                throw new InvalidDnDOperationException();
            }
            currentJVMLocalSourceTransferable = transferable;
            currentJVMLocalSourceACtxt = transferable != null ? AccessController.getContext() : null;
        }
    }

    public void setTargetActions(int n) {
        this.currentA = n & 0x40000003;
    }

    private native long startTransfer(long var1, String var3);

    private void transferFailed(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.nativeDataAvailable = string;
            this.nativeData = null;
            this.heartbeat();
            this.lock.notify();
        }
    }

    private Point translate(Component component, int n, int n2, Component component2) {
        Component component3 = component2;
        int n3 = 0;
        int n4 = 0;
        while (!component3.equals(component)) {
            Point point = component3.getLocation();
            n3 += point.x;
            n4 += point.y;
            component3 = MComponentPeer.getParent_NoClientCode(component3);
        }
        return new Point(n - n3, n2 - n4);
    }
}

