/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

final class MDragSourceContextPeerDispatcher
implements Runnable {
    private static final int NONE = 0;
    private static final int ENTER = 1;
    private static final int MOTION = 2;
    private static final int CHANGE = 3;
    private static final int EXIT = 4;
    private static final int FINISH = 5;
    DragSourceListener dsl;
    private int dispatchType = 0;
    private DragSourceEvent event;

    MDragSourceContextPeerDispatcher() {
    }

    synchronized void deliverDropFinish(DragSourceListener dragSourceListener, DragSourceDropEvent dragSourceDropEvent) {
        this.dsl = dragSourceListener;
        this.event = dragSourceDropEvent;
        this.dispatchType = 5;
        this.dispatch();
    }

    synchronized void deliverEnter(DragSourceListener dragSourceListener, DragSourceDragEvent dragSourceDragEvent) {
        this.dsl = dragSourceListener;
        this.event = dragSourceDragEvent;
        this.dispatchType = 1;
        this.dispatch();
    }

    synchronized void deliverExit(DragSourceListener dragSourceListener, DragSourceEvent dragSourceEvent) {
        this.dsl = dragSourceListener;
        this.event = dragSourceEvent;
        this.dispatchType = 4;
        this.dispatch();
    }

    synchronized void deliverGestureChanged(DragSourceListener dragSourceListener, DragSourceDragEvent dragSourceDragEvent) {
        this.dsl = dragSourceListener;
        this.event = dragSourceDragEvent;
        this.dispatchType = 3;
        this.dispatch();
    }

    synchronized void deliverMotion(DragSourceListener dragSourceListener, DragSourceDragEvent dragSourceDragEvent) {
        this.dsl = dragSourceListener;
        this.event = dragSourceDragEvent;
        this.dispatchType = 2;
        this.dispatch();
    }

    private void dispatch() {
        boolean bl = false;
        while (!bl) {
            try {
                SwingUtilities.invokeAndWait(this);
                bl = true;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
                bl = true;
            }
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                switch (this.dispatchType) {
                    case 1: {
                        this.dsl.dragEnter((DragSourceDragEvent)this.event);
                        return;
                    }
                    case 2: {
                        this.dsl.dragOver((DragSourceDragEvent)this.event);
                        return;
                    }
                    case 3: {
                        this.dsl.dropActionChanged((DragSourceDragEvent)this.event);
                        return;
                    }
                    case 4: {
                        this.dsl.dragExit(this.event);
                        return;
                    }
                    case 5: {
                        this.dsl.dragDropEnd((DragSourceDropEvent)this.event);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        finally {
            Object var2_2 = null;
            this.dsl = null;
            this.dispatchType = 0;
        }
    }
}

