/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.DialogPeer;
import java.security.AccessController;
import java.util.Vector;
import sun.awt.im.InputMethodManager;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MInputMethodControl;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.ModalThread;
import sun.awt.motif.X11InputMethod;
import sun.security.action.GetIntegerAction;

class MDialogPeer
extends MPanelPeer
implements DialogPeer,
MInputMethodControl {
    Insets insets = new Insets(0, 0, 0, 0);
    static Vector allDialogs = new Vector();
    static Vector imList = new Vector();
    static Vector tcList = new Vector();

    static {
        MDialogPeer.initIDs();
    }

    MDialogPeer(Dialog dialog) {
        Color color;
        String string;
        this.init(dialog, new Insets(MDialogPeer.getInset("awt.frame.topInset", -1), MDialogPeer.getInset("awt.frame.leftInset", -1), MDialogPeer.getInset("awt.frame.bottomInset", -1), MDialogPeer.getInset("awt.frame.rightInset", -1)));
        allDialogs.addElement(this);
        InputMethodManager inputMethodManager = InputMethodManager.getInstance();
        String string2 = inputMethodManager.getTriggerMenuString();
        if (string2 != null) {
            this.pSetIMMOption(string2);
        }
        this.pSetTitle((string = dialog.getTitle()) != null ? string : " ");
        Font font = dialog.getFont();
        if (font == null) {
            font = new Font("Dialog", 0, 12);
            dialog.setFont(font);
            this.setFont(font);
        }
        if ((color = dialog.getBackground()) == null) {
            dialog.setBackground(SystemColor.window);
            this.setBackground(SystemColor.window);
        }
        if ((color = dialog.getForeground()) == null) {
            dialog.setForeground(SystemColor.windowText);
            this.setForeground(SystemColor.windowText);
        }
        this.setResizable(dialog.isResizable());
    }

    public void addInputMethod(X11InputMethod x11InputMethod) {
        if (!imList.contains(x11InputMethod)) {
            imList.addElement(x11InputMethod);
        }
    }

    public void addTextComponent(MComponentPeer mComponentPeer) {
        if (tcList.contains(mComponentPeer)) {
            return;
        }
        if (tcList.isEmpty()) {
            this.addTextComponentNative();
            if (!imList.isEmpty()) {
                int n = 0;
                while (n < imList.size()) {
                    ((X11InputMethod)imList.elementAt(n)).reconfigureXIC(this);
                    ++n;
                }
            }
        }
        tcList.addElement(mComponentPeer);
    }

    native void addTextComponentNative();

    native void create(MComponentPeer var1, Object var2);

    protected void disposeImpl() {
        allDialogs.removeElement(this);
        super.disposeImpl();
    }

    private static int getInset(String string, int n) {
        Integer n2 = (Integer)AccessController.doPrivileged(new GetIntegerAction(string, n));
        return n2;
    }

    public void handleActivate() {
        this.postEvent(new WindowEvent((Window)this.target, 205));
    }

    public void handleDeactivate() {
        this.postEvent(new WindowEvent((Window)this.target, 206));
    }

    public int handleFocusTraversalEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 9 || keyEvent.getSource() instanceof TextArea) {
            return 0;
        }
        if ((keyEvent.getModifiers() & 0xFFFFFFFE) > 0) {
            return 0;
        }
        int n = keyEvent.getID();
        if (n == 402 || n == 400) {
            return 1;
        }
        if (keyEvent.isShiftDown()) {
            return 3;
        }
        return 2;
    }

    public void handleMoved(int n, int n2) {
        this.postEvent(new ComponentEvent(this.target, 100));
    }

    public void handleQuit() {
        this.postEvent(new WindowEvent((Window)this.target, 201));
    }

    public void handleResize(int n, int n2) {
        this.postEvent(new ComponentEvent(this.target, 101));
    }

    public native boolean hasTextComponents();

    private static native void initIDs();

    public Insets insets() {
        return this.insets;
    }

    void notifyIMMOptionChange() {
        InputMethodManager.getInstance().notifyChangeRequest(this.target);
    }

    native void pDispose();

    native void pHide();

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pSetIMMOption(String var1);

    native void pSetTitle(String var1);

    native void pShow();

    public void removeInputMethod(X11InputMethod x11InputMethod) {
        if (imList.contains(x11InputMethod)) {
            imList.removeElement(x11InputMethod);
        }
    }

    public void removeTextComponent(MComponentPeer mComponentPeer) {
        if (!tcList.contains(mComponentPeer)) {
            return;
        }
        tcList.removeElement(mComponentPeer);
        if (tcList.isEmpty()) {
            this.removeTextComponentNative();
            if (!imList.isEmpty()) {
                int n = 0;
                while (n < imList.size()) {
                    ((X11InputMethod)imList.elementAt(n)).reconfigureXIC(this);
                    ++n;
                }
            }
        }
    }

    native void removeTextComponentNative();

    public native void setResizable(boolean var1);

    public void setTitle(String string) {
        this.pSetTitle(string);
    }

    public void show() {
        if (((Dialog)this.target).isModal()) {
            ModalThread modalThread;
            ModalThread modalThread2 = modalThread = new ModalThread(this);
            synchronized (modalThread2) {
                try {
                    modalThread.start();
                    modalThread.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.target.hide();
        } else {
            this.pShow();
        }
    }

    public native void toBack();

    public void toFront() {
        this.pShow();
    }
}

