/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.util.Locale;
import sun.awt.SunToolkit;
import sun.awt.im.CompositionArea;
import sun.awt.im.InputMethod;
import sun.awt.im.InputMethodAdapter;
import sun.awt.im.InputMethodContext;
import sun.awt.im.InputMethodDescriptor;
import sun.awt.im.InputMethodManager;

public class InputContext
extends java.awt.im.InputContext {
    private InputMethod inputMethod;
    private boolean inputMethodCreationFailed;
    private Component previousClientComponent;
    private Component currentClientComponent;
    private Component compositionAreaComponent;
    private Character.Subset[] characterSubsets = null;
    private InputMethodDescriptor inputMethodDescriptor;

    protected InputContext() {
    }

    synchronized void activate(Component component) {
        if (this.inputMethod != null && this.previousClientComponent != null && this.previousClientComponent != component) {
            if (this.inputMethod instanceof InputMethodAdapter) {
                ((InputMethodAdapter)this.inputMethod).setClientComponent(this.previousClientComponent);
            }
            this.inputMethod.activate();
            this.endComposition();
            this.inputMethod.deactivate(false);
        }
        this.currentClientComponent = component;
        this.previousClientComponent = null;
        if (this.inputMethod != null) {
            if (this.inputMethod instanceof InputMethodAdapter) {
                ((InputMethodAdapter)this.inputMethod).setCompositionArea(this.compositionAreaComponent);
                ((InputMethodAdapter)this.inputMethod).setClientComponent(component);
            }
            this.inputMethod.activate();
        }
    }

    public synchronized void changeInputMethod(InputMethodDescriptor inputMethodDescriptor) {
        if (this.inputMethodDescriptor != null && this.inputMethodDescriptor.equals(inputMethodDescriptor)) {
            return;
        }
        if (this.inputMethod != null) {
            if (this.currentClientComponent != null) {
                this.endComposition();
                this.inputMethod.deactivate(false);
            }
            this.inputMethod.dispose();
            this.inputMethod = null;
            this.inputMethodCreationFailed = false;
        }
        this.inputMethodDescriptor = inputMethodDescriptor;
        this.inputMethod = this.getInputMethodInstance(this.inputMethodDescriptor);
        if (this.currentClientComponent != null) {
            this.activate(this.currentClientComponent);
        }
    }

    synchronized void deactivate(Component component, boolean bl) {
        if (this.currentClientComponent == null) {
            return;
        }
        if (this.inputMethod != null) {
            this.inputMethod.deactivate(bl);
        }
        this.previousClientComponent = component;
        this.currentClientComponent = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatchEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof InputMethodEvent) {
            return;
        }
        InputMethod inputMethod = this.getInputMethod();
        int n = aWTEvent.getID();
        switch (n) {
            case 1004: {
                Component component = (Component)aWTEvent.getSource();
                Object object = component.getTreeLock();
                synchronized (object) {
                    if (component instanceof CompositionArea) {
                        InputContext inputContext = this;
                        synchronized (inputContext) {
                            if (inputMethod != null) {
                                if (inputMethod instanceof InputMethodAdapter) {
                                    ((InputMethodAdapter)inputMethod).setCompositionArea(component);
                                    ((InputMethodAdapter)inputMethod).setClientComponent(this.previousClientComponent);
                                }
                                inputMethod.activate();
                            }
                            this.compositionAreaComponent = component;
                            return;
                        }
                    }
                    this.activate(component);
                }
                if (inputMethod == null) return;
                inputMethod.dispatchEvent(aWTEvent);
                return;
            }
            case 1005: {
                Component component = (Component)aWTEvent.getSource();
                if (component instanceof CompositionArea) {
                    if (((FocusEvent)aWTEvent).isTemporary()) return;
                    this.compositionAreaComponent = null;
                    return;
                }
                if (inputMethod != null) {
                    inputMethod.dispatchEvent(aWTEvent);
                }
                Object object = component.getTreeLock();
                synchronized (object) {
                    this.deactivate(component, ((FocusEvent)aWTEvent).isTemporary());
                    return;
                }
            }
            default: {
                if (inputMethod == null) return;
                inputMethod.dispatchEvent(aWTEvent);
            }
        }
    }

    public void dispose() {
        if (this.inputMethod != null) {
            this.inputMethod.dispose();
            this.inputMethod = null;
        }
        InputMethodManager.getInstance().remove(this);
    }

    public synchronized void endComposition() {
        if (this.inputMethod != null) {
            this.inputMethod.endComposition();
        }
    }

    Component getClientComponent() {
        if (this.currentClientComponent != null) {
            return this.currentClientComponent;
        }
        return this.previousClientComponent;
    }

    synchronized InputMethod getInputMethod() {
        if (this.inputMethod != null) {
            return this.inputMethod;
        }
        if (this.inputMethodCreationFailed) {
            return null;
        }
        this.inputMethod = this.getInputMethodInstance();
        return this.inputMethod;
    }

    public synchronized Object getInputMethodControlObject() {
        if (this.inputMethod != null) {
            return this.inputMethod.getControlObject();
        }
        return null;
    }

    InputMethod getInputMethodInstance() {
        InputMethodManager inputMethodManager = InputMethodManager.getInstance();
        this.inputMethodDescriptor = inputMethodManager.getCurrentInputMethod();
        return this.getInputMethodInstance(this.inputMethodDescriptor);
    }

    InputMethod getInputMethodInstance(InputMethodDescriptor inputMethodDescriptor) {
        InputMethod inputMethod;
        block7: {
            inputMethod = null;
            try {
                switch (inputMethodDescriptor.getType()) {
                    case 1: {
                        Toolkit toolkit = Toolkit.getDefaultToolkit();
                        inputMethod = ((SunToolkit)toolkit).getInputMethodAdapter();
                        break;
                    }
                    case 2: 
                    case 3: {
                        String string = inputMethodDescriptor.getClassName();
                        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                        if (classLoader != null) {
                            inputMethod = (InputMethod)classLoader.loadClass(string).newInstance();
                            break;
                        }
                        inputMethod = (InputMethod)Class.forName(string).newInstance();
                        break;
                    }
                }
                inputMethod.setLocale(inputMethodDescriptor.getLocale());
                inputMethod.setInputContext((InputMethodContext)this);
                inputMethod.setCharacterSubsets(this.characterSubsets);
            }
            catch (Exception exception) {
                this.inputMethodCreationFailed = true;
                if (inputMethod == null) break block7;
                inputMethod = null;
            }
        }
        return inputMethod;
    }

    public synchronized void removeNotify(Component component) {
        if (component == null) {
            throw new NullPointerException();
        }
        if (this.inputMethod == null) {
            return;
        }
        if (this.compositionAreaComponent != null && (component == this.previousClientComponent || component == this.currentClientComponent)) {
            InputMethodEvent inputMethodEvent = new InputMethodEvent(component, 1100, null, 0, null, null);
            ((CompositionArea)this.compositionAreaComponent).inputMethodTextChanged(inputMethodEvent);
            this.compositionAreaComponent = null;
        }
        if (component == this.previousClientComponent) {
            this.inputMethod.removeNotify();
            this.previousClientComponent = null;
            return;
        }
        if (component == this.currentClientComponent) {
            this.inputMethod.removeNotify();
            this.currentClientComponent = null;
        }
    }

    public boolean selectInputMethod(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        InputMethod inputMethod = this.getInputMethod();
        if (inputMethod == null) {
            return false;
        }
        return inputMethod.setLocale(locale);
    }

    public void setCharacterSubsets(Character.Subset[] subsetArray) {
        if (subsetArray == null) {
            this.characterSubsets = null;
        } else {
            this.characterSubsets = new Character.Subset[subsetArray.length];
            System.arraycopy(subsetArray, 0, this.characterSubsets, 0, this.characterSubsets.length);
        }
        if (this.inputMethod != null) {
            this.inputMethod.setCharacterSubsets(subsetArray);
        }
    }
}

