/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.awt.im.InputContext;
import sun.awt.im.InputMethodDescriptor;
import sun.awt.im.InputMethodManager;
import sun.awt.im.resources.InputMethodManagerResources;
import sun.security.action.GetPropertyAction;

class ExecutableInputMethodManager
extends InputMethodManager
implements Runnable,
ActionListener {
    private static final String TEST_INPUT_METHOD_FILE_NAME = "testinputmethod.jar";
    private static final String TEST_INPUT_METHOD_CLASS_NAME = "TestInputMethod";
    private static String METHOD_NAME_getAvailableLocales = "getAvailableLocales";
    static final String CLASS_NAME_IIIMP_ADAPTER = "sun.awt.im.iiimp.IIIMPAdapter";
    private Class iiimpAdapterClass;
    private Locale[] iiimpLocaleList;
    private Vector inputContextList = new Vector();
    private String triggerMenuString;
    private PopupMenu selectionMenu;
    private static String switchIMMenu = "Select Input Method";
    private static final String SWITCH_IM_MENU = "InputMethodManager.switchIMMenu";
    private String currentSelection;
    private InputMethodDescriptor currentInputMethod;
    private static String hostAdapterName = "System Input Method";
    private static final String HOST_ADAPTER_NAME = "InputMethodManager.hostAdapterName";
    private static String IIIMPName = "Network Input Method";
    public static final String IIIMP_NAME = "InputMethodManager.IIIMPName";
    private InputMethodDescriptor hostAdapterDescriptor;
    private Component requestComponent;
    private InputMethodManagerResources resources;

    ExecutableInputMethodManager() {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("java.ext.dirs", null));
        boolean bl = false;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                final File file = new File(String.valueOf(string2) + File.separator + TEST_INPUT_METHOD_FILE_NAME);
                Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Boolean(file.canRead());
                    }
                });
                if (!bl2.booleanValue()) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.currentInputMethod = new InputMethodDescriptor(3, Locale.getDefault(), TEST_INPUT_METHOD_CLASS_NAME);
            return;
        }
        this.currentInputMethod = this.hostAdapterDescriptor = new InputMethodDescriptor(1);
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.broadcastInputMethodChange(string);
    }

    void add(InputContext inputContext) {
        if (this.inputContextList.contains(inputContext)) {
            return;
        }
        this.inputContextList.addElement(inputContext);
    }

    private void broadcastInputMethodChange(String string) {
        InputMethodDescriptor inputMethodDescriptor = null;
        if (hostAdapterName.equals(string)) {
            inputMethodDescriptor = this.hostAdapterDescriptor;
        } else {
            int n = 0;
            while (n < this.iiimpLocaleList.length) {
                if (this.iiimpLocaleList[n].toString().equals(string)) {
                    inputMethodDescriptor = new InputMethodDescriptor(2, this.iiimpLocaleList[n], CLASS_NAME_IIIMP_ADAPTER);
                    break;
                }
                ++n;
            }
        }
        if (inputMethodDescriptor == null) {
            return;
        }
        this.currentSelection = string;
        this.currentInputMethod = inputMethodDescriptor;
        Vector vector = this.inputContextList;
        synchronized (vector) {
            Enumeration enumeration = this.inputContextList.elements();
            while (enumeration.hasMoreElements()) {
                InputContext inputContext = (InputContext)enumeration.nextElement();
                inputContext.changeInputMethod(inputMethodDescriptor);
            }
        }
    }

    static boolean canBeIIIMPUser() {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File file = null;
                String string = System.getProperty("user.home");
                String string2 = System.getProperty("java.home");
                file = new File(String.valueOf(string2) + File.separator + "lib" + File.separator + "iiimp.properties");
                if (file != null && file.canRead()) {
                    return new Boolean(true);
                }
                file = new File(String.valueOf(string) + File.separator + ".iiimp");
                return new Boolean(file != null && file.canRead());
            }
        });
        return bl;
    }

    public synchronized InputMethodDescriptor getCurrentInputMethod() {
        return this.currentInputMethod;
    }

    private void getInputMethodSelected() {
        Object object;
        if (this.iiimpLocaleList == null) {
            this.requestComponent = null;
            return;
        }
        this.selectionMenu.removeAll();
        this.selectionMenu.removeNotify();
        MenuItem menuItem = this.currentSelection.equals(hostAdapterName) ? new CheckboxMenuItem(hostAdapterName, true) : new MenuItem(hostAdapterName);
        menuItem.setActionCommand(hostAdapterName);
        menuItem.addActionListener(this);
        this.selectionMenu.add(menuItem);
        this.selectionMenu.addSeparator();
        if (this.iiimpLocaleList.length == 0) {
            menuItem = new MenuItem(IIIMPName);
            menuItem.setEnabled(false);
            this.selectionMenu.add(menuItem);
        } else {
            object = this.selectionMenu;
            if (this.iiimpLocaleList.length > 1) {
                object = new Menu(IIIMPName);
            }
            int n = 0;
            while (n < this.iiimpLocaleList.length) {
                Locale locale = this.iiimpLocaleList[n];
                String string = locale.toString();
                String string2 = this.resources.getLocaleName(locale);
                String string3 = this.iiimpLocaleList.length == 1 ? String.valueOf(IIIMPName) + " - " + string2 : string2;
                menuItem = this.currentSelection.equals(string) ? new CheckboxMenuItem(string3, true) : new MenuItem(string3);
                menuItem.setActionCommand(string);
                menuItem.addActionListener(this);
                ((Menu)object).add(menuItem);
                ++n;
            }
            if (object != this.selectionMenu) {
                this.selectionMenu.add((MenuItem)object);
            }
        }
        object = this;
        synchronized (object) {
            this.requestComponent.add(this.selectionMenu);
            this.selectionMenu.show(this.requestComponent, 60, 80);
            this.requestComponent = null;
        }
    }

    String getLocalizedString(String string) {
        String string2 = null;
        try {
            ExecutableInputMethodManager executableInputMethodManager = this;
            synchronized (executableInputMethodManager) {
                if (this.resources == null) {
                    this.resources = this.getResources();
                }
            }
            string2 = this.resources.getString(string);
        }
        catch (Exception exception) {}
        return string2;
    }

    private InputMethodManagerResources getResources() throws Exception {
        String string = String.valueOf(this.getClass().getPackage().getName()) + ".resources.InputMethodManagerResources";
        InputMethodManagerResources inputMethodManagerResources = (InputMethodManagerResources)ResourceBundle.getBundle(string);
        return inputMethodManagerResources;
    }

    private Locale[] getSupportedLocales(Class clazz) throws IOException {
        Locale[] localeArray;
        Method method;
        try {
            method = clazz.getMethod(METHOD_NAME_getAvailableLocales, null);
        }
        catch (Exception exception) {
            throw new IOException(String.valueOf(METHOD_NAME_getAvailableLocales) + this.resources.getString("InputMethodManager.error.NotFound"));
        }
        try {
            localeArray = (Locale[])method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            Throwable throwable;
            if (exception instanceof InvocationTargetException && (throwable = ((InvocationTargetException)exception).getTargetException()) instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException(String.valueOf(METHOD_NAME_getAvailableLocales) + this.resources.getString("InputMethodManager.error.InvocationError"));
        }
        if (localeArray == null) {
            localeArray = new Locale[]{};
        }
        return localeArray;
    }

    public String getTriggerMenuString() {
        return this.triggerMenuString;
    }

    synchronized void initialize() {
        try {
            this.resources = this.getResources();
            hostAdapterName = this.resources.getString(HOST_ADAPTER_NAME);
            IIIMPName = this.resources.getString(IIIMP_NAME);
            switchIMMenu = this.resources.getString(SWITCH_IM_MENU);
        }
        catch (Exception exception) {}
        this.currentSelection = hostAdapterName;
        try {
            this.iiimpAdapterClass = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    if (classLoader == null) {
                        return Class.forName(ExecutableInputMethodManager.CLASS_NAME_IIIMP_ADAPTER);
                    }
                    return classLoader.loadClass(ExecutableInputMethodManager.CLASS_NAME_IIIMP_ADAPTER);
                }
            });
            this.iiimpLocaleList = this.getSupportedLocales(this.iiimpAdapterClass);
            this.triggerMenuString = switchIMMenu;
        }
        catch (Exception exception) {
            this.iiimpAdapterClass = null;
        }
    }

    public synchronized void notifyChangeRequest(Component component) {
        if (!(component instanceof Frame) && !(component instanceof Dialog)) {
            return;
        }
        if (this.requestComponent != null) {
            return;
        }
        this.requestComponent = component;
        this.notify();
    }

    void remove(InputContext inputContext) {
        this.inputContextList.removeElement(inputContext);
    }

    public void run() {
        while (this.iiimpAdapterClass == null) {
            try {
                ExecutableInputMethodManager executableInputMethodManager = this;
                synchronized (executableInputMethodManager) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        this.selectionMenu = new PopupMenu(this.triggerMenuString);
        while (true) {
            this.waitForChangeRequest();
            try {
                this.iiimpLocaleList = this.getSupportedLocales(this.iiimpAdapterClass);
            }
            catch (IOException iOException) {
                this.iiimpLocaleList = null;
            }
            this.getInputMethodSelected();
        }
    }

    private synchronized void waitForChangeRequest() {
        try {
            while (this.requestComponent == null) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {}
    }
}

