/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GraphicAttribute;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import sun.awt.font.Bidi;
import sun.awt.font.TextLineComponent;

public final class GraphicComponent
extends TextLineComponent {
    public static final float GRAPHIC_LEADING = 2.0f;
    private GraphicAttribute graphic;
    private int graphicCount;
    private int[] charsLtoV;
    private Rectangle2D.Float visualBounds = null;
    private float graphicAdvance;

    public GraphicComponent(GraphicAttribute graphicAttribute, Map map, int[] nArray, byte[] byArray, int n, int n2) {
        super(map, new GraphicLineMetrics(graphicAttribute, n2 - n));
        this.graphic = graphicAttribute;
        this.graphicCount = n2 - n;
        this.charsLtoV = (int[])(nArray != null ? Bidi.getNormalizedOrder(nArray, byArray, n, n2) : null);
        this.graphicAdvance = graphicAttribute.getAdvance();
    }

    private void computeVisualBounds() {
        Rectangle2D rectangle2D = this.graphic.getBounds();
        float f = (float)rectangle2D.getWidth() + this.graphicAdvance * (float)(this.graphicCount - 1);
        this.visualBounds = new Rectangle2D.Float((float)rectangle2D.getX(), (float)rectangle2D.getY(), f, (float)rectangle2D.getHeight());
    }

    public float getAdvanceBetween(int n, int n2) {
        return this.graphicAdvance * (float)(n2 - n);
    }

    public float getCharAdvance(int n) {
        return this.graphicAdvance;
    }

    public float getCharX(int n) {
        int n2 = this.charsLtoV == null ? n : this.charsLtoV[n];
        return this.graphicAdvance * (float)n2;
    }

    public float getCharY(int n) {
        return 0.0f;
    }

    public float getItalicAngle() {
        return 0.0f;
    }

    public int getLineBreakIndex(int n, float f) {
        int n2 = (int)(f / this.graphicAdvance);
        if (n2 > this.graphicCount - n) {
            n2 = this.graphicCount - n;
        }
        return n2;
    }

    public Rectangle2D getLogicalBounds() {
        float f = this.graphicAdvance * (float)this.graphicCount;
        if (this.visualBounds == null) {
            this.computeVisualBounds();
        }
        float f2 = this.visualBounds.x;
        float f3 = this.visualBounds.y;
        float f4 = f;
        float f5 = this.visualBounds.height;
        return new Rectangle2D.Float(f2, f3, f4, f5);
    }

    public int getNumCharacters() {
        return this.graphicCount;
    }

    protected void handleDraw(Graphics2D graphics2D, float f, float f2) {
        int n = 0;
        while (n < this.graphicCount) {
            this.graphic.draw(graphics2D, f, f2);
            f += this.graphicAdvance;
            ++n;
        }
    }

    protected Rectangle2D handleGetCharVisualBounds(int n) {
        Rectangle2D rectangle2D = this.graphic.getBounds();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float_.setRect(rectangle2D);
        float_.x += this.graphicAdvance * (float)n;
        return float_;
    }

    protected Shape handleGetOutline(float f, float f2) {
        return this.getVisualBounds();
    }

    protected Rectangle2D handleGetVisualBounds() {
        if (this.visualBounds == null) {
            this.computeVisualBounds();
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        ((Rectangle2D)float_).setRect(this.visualBounds);
        return float_;
    }

    public String toString() {
        return "[Graphics:count=" + this.getNumCharacters() + "]";
    }

    private static final class GraphicLineMetrics
    extends LineMetrics {
        private GraphicAttribute graphic;
        private int graphicCount;

        GraphicLineMetrics(GraphicAttribute graphicAttribute, int n) {
            this.graphicCount = n;
            this.graphic = graphicAttribute;
        }

        public float getAscent() {
            return this.graphic.getAscent();
        }

        public int getBaselineIndex() {
            int n = this.graphic.getAlignment();
            if (n < 0) {
                return 0;
            }
            return n;
        }

        public float[] getBaselineOffsets() {
            float[] fArray = new float[3];
            fArray[1] = -7.0f;
            fArray[2] = -14.0f;
            return fArray;
        }

        public float getDescent() {
            return this.graphic.getDescent();
        }

        public float getHeight() {
            return this.getAscent() + this.getDescent() + this.getLeading();
        }

        public float getLeading() {
            return 2.0f;
        }

        public int getNumChars() {
            return this.graphicCount;
        }

        public float getStrikethroughOffset() {
            return -(this.getAscent() / 2.0f);
        }

        public float getStrikethroughThickness() {
            return this.getAscent() / 12.0f;
        }

        public float getUnderlineOffset() {
            return this.getDescent() / 3.0f;
        }

        public float getUnderlineThickness() {
            return this.getAscent() / 12.0f;
        }
    }
}

