/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsDevice;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.awt.X11GraphicsDevice;
import sun.awt.font.NativeFontWrapper;
import sun.awt.motif.PSPrinterJob;
import sun.java2d.SunGraphicsEnvironment;
import sun.security.action.LoadLibraryAction;

public class X11GraphicsEnvironment
extends SunGraphicsEnvironment {
    Map fontNameMap;
    Map xlfdMap;
    private Vector nativeFonts;

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        X11GraphicsEnvironment.initDisplay();
    }

    protected String getFileNameFromPlatformName(String string) {
        String string2 = null;
        String string3 = this.specificFontIDForName(string);
        this.initFontNameMap(this.fontPath);
        if (this.fontNameMap != null && string3 != null && (string2 = (String)this.fontNameMap.get(string3)) == null) {
            string3 = this.switchFontIDForName(string);
            string2 = (String)this.fontNameMap.get(string3);
        }
        return string2;
    }

    private String getFontField(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        while (--n > 0 && n2 >= 0) {
            n2 = string.indexOf("-", n2) + 1;
        }
        if (n2 == -1) {
            return "";
        }
        n3 = string.indexOf("-", n2);
        if (n3 == -1) {
            return string.substring(n2);
        }
        return string.substring(n2, n3);
    }

    protected String getFontPropertyFD(String string) {
        return string;
    }

    private native String[] getNativeFonts();

    protected native int getNumScreens();

    public PrinterJob getPrinterJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new PSPrinterJob();
    }

    protected String getPropString(String string) {
        if (this.xlfdMap == null) {
            return string;
        }
        String string2 = (String)this.xlfdMap.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    protected void initCompositeFonts() {
        super.initCompositeFonts();
    }

    private static synchronized native void initDisplay();

    private void initFontNameMap(String string) {
        if (this.fontNameMap != null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.registerFontPath(string2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
        this.initNativeFonts();
    }

    private void initNativeFonts() {
        if (this.nativeFonts != null) {
            return;
        }
        String[] stringArray = this.getNativeFonts();
        if (stringArray != null) {
            this.nativeFonts = new Vector();
            if (this.fontNameMap == null) {
                this.fontNameMap = new Hashtable();
            }
            if (this.xlfdMap == null) {
                this.xlfdMap = new Hashtable();
            }
            int n = 0;
            while (n < stringArray.length) {
                String string = this.specificFontIDForName(stringArray[n]);
                String string2 = (String)this.fontNameMap.get(string);
                if (string2 == null) {
                    this.nativeFonts.addElement(stringArray[n]);
                    this.fontNameMap.put(string, stringArray[n]);
                    this.xlfdMap.put(stringArray[n], stringArray[n]);
                }
                ++n;
            }
        }
    }

    protected GraphicsDevice makeScreenDevice(int n) {
        return new X11GraphicsDevice(n);
    }

    protected String parseFamilyNameProperty(String string) {
        String string2 = "default";
        String string3 = this.specificFontIDForName(string);
        if (this.fontNameMap != null && string3 != null) {
            String string4;
            String string5 = (String)this.fontNameMap.get(string3);
            if (string5 == null) {
                string3 = this.switchFontIDForName(string);
                string5 = (String)this.fontNameMap.get(string3);
            }
            if (string5 != null && (string4 = NativeFontWrapper.getFullNameByFileName(string5)) != null) {
                string2 = string4;
            }
        }
        return string2;
    }

    private void parseFontDir(File file) throws FileNotFoundException, IOException {
        String string = file.getParent();
        if (file.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            StreamTokenizer streamTokenizer = new StreamTokenizer(fileInputStream);
            streamTokenizer.eolIsSignificant(true);
            int n = streamTokenizer.nextToken();
            if (n == -2) {
                int n2 = (int)streamTokenizer.nval;
                n = streamTokenizer.nextToken();
                if (n == 10) {
                    if (this.fontNameMap == null) {
                        this.fontNameMap = new Hashtable();
                    }
                    if (this.xlfdMap == null) {
                        this.xlfdMap = new Hashtable();
                    }
                    streamTokenizer.resetSyntax();
                    streamTokenizer.wordChars(32, 127);
                    streamTokenizer.wordChars(160, 255);
                    streamTokenizer.whitespaceChars(0, 31);
                    int n3 = 0;
                    while (n3 < n2) {
                        int n4;
                        n = streamTokenizer.nextToken();
                        if (n == -1 || n != -3 || (n4 = streamTokenizer.sval.indexOf(" ")) <= 0) break;
                        String string2 = streamTokenizer.sval.substring(0, n4);
                        String string3 = streamTokenizer.sval.substring(n4 + 1);
                        String string4 = this.specificFontIDForName(string3);
                        String string5 = (String)this.fontNameMap.get(string4);
                        String string6 = String.valueOf(string) + File.separator + string2;
                        String string7 = (String)this.xlfdMap.get(string6);
                        if (string7 == null && string5 == null) {
                            this.fontNameMap.put(string4, string2);
                            this.xlfdMap.put(string6, string3);
                        }
                        if ((n = streamTokenizer.nextToken()) != 10) break;
                        ++n3;
                    }
                }
            }
        }
    }

    protected boolean platformReady() {
        return true;
    }

    protected void registerFontPath(String string) {
        final File file = new File(String.valueOf(string) + File.separator + "fonts.dir");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    this.parseFontDir(file);
                }
                catch (Exception exception) {}
                return null;
            }
        });
    }

    protected void registerNative(String string) {
        Vector vector = new Vector(5, 5);
        vector.addElement(string);
        this.registeredFonts.put(string, string);
        NativeFontWrapper.registerFonts(vector, vector.size(), vector, 5);
    }

    protected boolean registerNativeFonts() {
        if (this.nativeFonts != null) {
            Vector vector = new Vector(20, 10);
            int n = 0;
            while (n < this.nativeFonts.size()) {
                String string = (String)this.nativeFonts.elementAt(n);
                if (!this.registeredFonts.containsKey(string)) {
                    vector.addElement(string);
                    this.registeredFonts.put(string, string);
                }
                ++n;
            }
            NativeFontWrapper.registerFonts(vector, vector.size(), vector, 5);
            return true;
        }
        return false;
    }

    private String specificFontIDForName(String string) {
        String string2 = this.getFontField(string, 3);
        String string3 = this.getFontField(string, 4);
        String string4 = this.getFontField(string, 5);
        String string5 = this.getFontField(string, 6);
        String string6 = this.getFontField(string, 14);
        String string7 = this.getFontField(string, 15);
        String string8 = String.valueOf(string2) + "-" + string3 + "-" + string4 + "-" + string5 + "-" + string6 + "-" + string7;
        return string8.toLowerCase(Locale.ENGLISH);
    }

    private String switchFontIDForName(String string) {
        String string2 = this.getFontField(string, 3);
        String string3 = this.getFontField(string, 4);
        String string4 = this.getFontField(string, 5);
        String string5 = this.getFontField(string, 6);
        String string6 = this.getFontField(string, 14);
        String string7 = this.getFontField(string, 15);
        if (string4.equals("i")) {
            string4 = "o";
        } else if (string4.equals("o")) {
            string4 = "i";
        }
        String string8 = String.valueOf(string2) + "-" + string3 + "-" + string4 + "-" + string5 + "-" + string6 + "-" + string7;
        return string8.toLowerCase(Locale.ENGLISH);
    }

    private String vagueFontIDForName(String string) {
        String string2 = this.getFontField(string, 4);
        String string3 = this.getFontField(string, 5);
        String string4 = this.getFontField(string, 6);
        String string5 = this.getFontField(string, 7);
        String string6 = String.valueOf(string2) + "-" + string3 + "-" + string4 + "-" + string5;
        return string6.toLowerCase(Locale.ENGLISH);
    }
}

