/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import sun.awt.MostRecentKeyValue;
import sun.awt.MostRecentThreadAppContext;
import sun.awt.SunToolkit;

public final class AppContext {
    public static final Object EVENT_QUEUE_KEY = new StringBuffer("EventQueue");
    private static Hashtable threadGroup2appContext = null;
    private final Hashtable table;
    private final ThreadGroup threadGroup;
    private boolean isDisposed = false;
    private static int numAppContexts;
    private static MostRecentThreadAppContext mostRecentThreadAppContext;
    private long DISPOSAL_TIMEOUT = 5000L;
    private long THREAD_INTERRUPT_TIMEOUT = 1000L;
    private MostRecentKeyValue mostRecentKeyValue = null;

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                ThreadGroup threadGroup2 = threadGroup.getParent();
                while (threadGroup2 != null) {
                    threadGroup = threadGroup2;
                    threadGroup2 = threadGroup.getParent();
                }
                AppContext appContext = new AppContext(threadGroup);
                numAppContexts = 1;
                return appContext;
            }
        });
        mostRecentThreadAppContext = null;
    }

    AppContext(ThreadGroup threadGroup) {
        ++numAppContexts;
        this.table = new Hashtable(2);
        if (threadGroup2appContext == null) {
            threadGroup2appContext = new Hashtable(2, 0.2f);
        }
        this.threadGroup = threadGroup;
        threadGroup2appContext.put(threadGroup, this);
    }

    static /* synthetic */ int access$0() {
        return numAppContexts;
    }

    static /* synthetic */ MostRecentThreadAppContext access$3() {
        return mostRecentThreadAppContext;
    }

    public void dispose() throws IllegalThreadStateException {
        ThreadGroup[] threadGroupArray;
        if (this.threadGroup.parentOf(Thread.currentThread().getThreadGroup())) {
            throw new IllegalThreadStateException("Current Thread is contained within AppContext to be disposed.");
        }
        final Object object = this;
        synchronized (object) {
            if (this.isDisposed) {
                Object var2_2 = null;
                return;
            }
            this.isDisposed = true;
        }
        object = new Object();
        Runnable runnable = new Runnable(){

            public void run() {
                Frame[] frameArray = Frame.getFrames();
                int n = frameArray.length - 1;
                while (n >= 0) {
                    frameArray[n].dispose();
                    --n;
                }
                Object object2 = object;
                synchronized (object2) {
                    object.notifyAll();
                }
            }
        };
        Object object2 = object;
        synchronized (object2) {
            SunToolkit.postEvent(this, new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
            try {
                object.wait(this.DISPOSAL_TIMEOUT);
            }
            catch (InterruptedException interruptedException) {}
        }
        runnable = new Runnable(){

            public void run() {
                Object object2 = object;
                synchronized (object2) {
                    object.notifyAll();
                }
            }
        };
        object2 = object;
        synchronized (object2) {
            SunToolkit.postEvent(this, new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
            try {
                object.wait(this.DISPOSAL_TIMEOUT);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.threadGroup.interrupt();
        long l = System.currentTimeMillis();
        long l2 = l + this.THREAD_INTERRUPT_TIMEOUT;
        while (this.threadGroup.activeCount() > 0 && System.currentTimeMillis() < l2) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.threadGroup.stop();
        l = System.currentTimeMillis();
        l2 = l + this.THREAD_INTERRUPT_TIMEOUT;
        while (this.threadGroup.activeCount() > 0 && System.currentTimeMillis() < l2) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        int n = this.threadGroup.activeGroupCount();
        if (n > 0) {
            threadGroupArray = new ThreadGroup[n];
            n = this.threadGroup.enumerate(threadGroupArray);
            int n2 = 0;
            while (n2 < n) {
                threadGroup2appContext.remove(threadGroupArray[n2]);
                ++n2;
            }
        }
        if ((threadGroupArray = mostRecentThreadAppContext) != null && threadGroupArray.appContext == this) {
            mostRecentThreadAppContext = null;
        }
        try {
            this.threadGroup.destroy();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {}
        this.table.clear();
        --numAppContexts;
    }

    public Object get(Object object) {
        MostRecentKeyValue mostRecentKeyValue = this.mostRecentKeyValue;
        if (mostRecentKeyValue != null && mostRecentKeyValue.key == object) {
            return mostRecentKeyValue.value;
        }
        Object object2 = this.table.get(object);
        this.mostRecentKeyValue = new MostRecentKeyValue(object, object2);
        return object2;
    }

    public static final AppContext getAppContext() {
        if (numAppContexts == 1 && mostRecentThreadAppContext != null) {
            return AppContext.mostRecentThreadAppContext.appContext;
        }
        final Thread thread = Thread.currentThread();
        MostRecentThreadAppContext mostRecentThreadAppContext = AppContext.mostRecentThreadAppContext;
        if (mostRecentThreadAppContext != null && mostRecentThreadAppContext.thread == thread) {
            return mostRecentThreadAppContext.appContext;
        }
        return (AppContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup;
                ThreadGroup threadGroup2 = threadGroup = thread.getThreadGroup();
                AppContext appContext = (AppContext)threadGroup2appContext.get(threadGroup2);
                while (appContext == null) {
                    if ((threadGroup2 = threadGroup2.getParent()) == null) {
                        throw new RuntimeException("Invalid ThreadGroup");
                    }
                    appContext = (AppContext)threadGroup2appContext.get(threadGroup2);
                }
                ThreadGroup threadGroup3 = threadGroup;
                while (threadGroup3 != threadGroup2) {
                    threadGroup2appContext.put(threadGroup3, appContext);
                    threadGroup3 = threadGroup3.getParent();
                }
                AppContext.mostRecentThreadAppContext = new MostRecentThreadAppContext(thread, appContext);
                return appContext;
            }
        });
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public Object put(Object object, Object object2) {
        MostRecentKeyValue mostRecentKeyValue = this.mostRecentKeyValue;
        if (mostRecentKeyValue != null && mostRecentKeyValue.key == object) {
            mostRecentKeyValue.value = object2;
        }
        return this.table.put(object, object2);
    }

    public Object remove(Object object) {
        MostRecentKeyValue mostRecentKeyValue = this.mostRecentKeyValue;
        if (mostRecentKeyValue != null && mostRecentKeyValue.key == object) {
            mostRecentKeyValue.value = null;
        }
        return this.table.remove(object);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[threadGroup=" + this.threadGroup.getName() + "]";
    }
}

