/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.MAreaGeometry;
import sun.awt.Albert.TCAGNode;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGRect;
import sun.awt.Albert.TGrafExtractor;
import sun.awt.Albert.TGrafMatrix;

class TTransformedGeometry
extends MAreaGeometry {
    private MAreaGeometry fGeometry;
    private TGrafMatrix fMatrix;
    private TGRect fBounds;

    public TTransformedGeometry(MAreaGeometry mAreaGeometry, TGrafMatrix tGrafMatrix) {
        this.fGeometry = mAreaGeometry;
        this.fMatrix = (TGrafMatrix)tGrafMatrix.clone();
        this.fBounds = null;
        this.updateTimeStamp();
    }

    public TTransformedGeometry(TTransformedGeometry tTransformedGeometry) {
        super(tTransformedGeometry);
        this.fGeometry = null;
        this.fMatrix = null;
        this.fBounds = null;
        if (tTransformedGeometry.fGeometry != null) {
            this.fGeometry = (MAreaGeometry)tTransformedGeometry.fGeometry.clone();
        }
        if (tTransformedGeometry.fMatrix != null) {
            this.fMatrix = (TGrafMatrix)tTransformedGeometry.fMatrix.clone();
        }
        if (tTransformedGeometry.fBounds != null) {
            this.fBounds = (TGRect)tTransformedGeometry.fBounds.clone();
        }
    }

    public Object clone() {
        return new TTransformedGeometry(this);
    }

    public MAreaGeometry cloneAndTransform(TGrafMatrix tGrafMatrix) {
        if (tGrafMatrix.isIdentity() || this.fMatrix.isIdentity()) {
            return this.fGeometry;
        }
        TGrafMatrix tGrafMatrix2 = (TGrafMatrix)tGrafMatrix.clone();
        tGrafMatrix2.preConcatWith(this.fMatrix);
        if (tGrafMatrix2.isIdentity()) {
            return this.fGeometry;
        }
        return new TTransformedGeometry(this.fGeometry, tGrafMatrix2);
    }

    public boolean contains(TGPoint tGPoint) {
        return this.fGeometry.contains(this.fMatrix.untransformPoint(tGPoint));
    }

    public boolean contains(TGRect tGRect) {
        return this.fGeometry.contains(this.fMatrix.untransformBounds(tGRect));
    }

    public MAreaGeometry copyFrom(MAreaGeometry mAreaGeometry) {
        if (this.getClass().equals(mAreaGeometry.getClass())) {
            this.copyFrom((TTransformedGeometry)mAreaGeometry);
        } else {
            super.copyFrom(mAreaGeometry);
        }
        return this;
    }

    public final TTransformedGeometry copyFrom(TTransformedGeometry tTransformedGeometry) {
        if (this != tTransformedGeometry) {
            super.copyFrom(tTransformedGeometry);
            this.fGeometry = tTransformedGeometry.fGeometry;
            this.fMatrix = tTransformedGeometry.fMatrix;
            this.fBounds = tTransformedGeometry.fBounds;
        }
        return this;
    }

    public boolean equals(MAreaGeometry mAreaGeometry) {
        if (this.getClass().equals(mAreaGeometry.getClass())) {
            TTransformedGeometry tTransformedGeometry = (TTransformedGeometry)mAreaGeometry;
            return super.equals(mAreaGeometry) && this.fMatrix.equals(tTransformedGeometry.fMatrix) && (this.fGeometry == tTransformedGeometry.fGeometry || this.fGeometry != null && tTransformedGeometry.fGeometry != null && this.fGeometry.equals(tTransformedGeometry));
        }
        return false;
    }

    public void extract(TGrafExtractor tGrafExtractor, TCAGNode tCAGNode, TGrafMatrix tGrafMatrix) {
        TGrafMatrix tGrafMatrix2 = this.fMatrix;
        this.fMatrix = (TGrafMatrix)tGrafMatrix.clone();
        this.fMatrix.preConcatWith(tGrafMatrix2);
        this.fGeometry.extract(tGrafExtractor, tCAGNode, this.fMatrix);
        this.fMatrix = tGrafMatrix2;
    }

    public TGRect getBounds() {
        if (this.fBounds == null) {
            this.fBounds = this.fMatrix.transformBounds(this.fGeometry.getBounds());
        }
        return this.fBounds;
    }

    public boolean intersects(TGRect tGRect) {
        return this.fGeometry.intersects(this.fMatrix.untransformBounds(tGRect));
    }

    public boolean isEmpty() {
        return this.fGeometry.isEmpty();
    }

    public boolean isPolygonal() {
        return this.fGeometry.isPolygonal();
    }

    public boolean isRectangular() {
        return this.fMatrix.isRectilinear() && this.fGeometry.isRectangular();
    }

    public boolean isSingular() {
        return this.fGeometry.isSingular();
    }
}

