/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.MAreaGeometry;
import sun.awt.Albert.TCAGNode;
import sun.awt.Albert.TCAGSubtract;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGRect;
import sun.awt.Albert.TGrafExtractor;
import sun.awt.Albert.TGrafMatrix;

class TSubtractGeometry
extends MAreaGeometry {
    private MAreaGeometry fLeft;
    private MAreaGeometry fRight;
    private TGRect fBounds;

    public TSubtractGeometry() {
        this.fBounds = null;
    }

    public TSubtractGeometry(MAreaGeometry mAreaGeometry, MAreaGeometry mAreaGeometry2) {
        this.fLeft = mAreaGeometry;
        this.fRight = mAreaGeometry2;
        this.fBounds = null;
        this.updateTimeStamp();
    }

    public TSubtractGeometry(TSubtractGeometry tSubtractGeometry) {
        super(tSubtractGeometry);
        this.fLeft = null;
        this.fRight = null;
        this.fBounds = null;
        if (tSubtractGeometry.fLeft != null) {
            this.fLeft = (MAreaGeometry)tSubtractGeometry.fLeft.clone();
        }
        if (tSubtractGeometry.fRight != null) {
            this.fRight = (MAreaGeometry)tSubtractGeometry.fRight.clone();
        }
        if (tSubtractGeometry.fBounds != null) {
            this.fBounds = (TGRect)tSubtractGeometry.fBounds.clone();
        }
    }

    public Object clone() {
        return new TSubtractGeometry(this);
    }

    public MAreaGeometry cloneAndIntersect(MAreaGeometry mAreaGeometry) {
        TSubtractGeometry tSubtractGeometry = new TSubtractGeometry(this);
        tSubtractGeometry.fLeft = MAreaGeometry.intersect(tSubtractGeometry.fLeft, mAreaGeometry);
        tSubtractGeometry.fBounds = null;
        tSubtractGeometry.updateTimeStamp();
        return tSubtractGeometry;
    }

    public MAreaGeometry cloneAndSubtract(MAreaGeometry mAreaGeometry) {
        TSubtractGeometry tSubtractGeometry = new TSubtractGeometry(this);
        tSubtractGeometry.fRight = MAreaGeometry.add(tSubtractGeometry.fRight, mAreaGeometry);
        tSubtractGeometry.fBounds = null;
        tSubtractGeometry.updateTimeStamp();
        return tSubtractGeometry;
    }

    public boolean contains(TGPoint tGPoint) {
        return this.getBounds().contains(tGPoint) && this.fLeft.contains(tGPoint) && !this.fRight.contains(tGPoint);
    }

    public boolean contains(TGRect tGRect) {
        return this.fLeft.contains(tGRect) && !this.fRight.intersects(tGRect) && !this.fRight.contains(tGRect);
    }

    public final TSubtractGeometry copyFrom(TSubtractGeometry tSubtractGeometry) {
        if (this != tSubtractGeometry) {
            super.copyFrom(tSubtractGeometry);
            this.fLeft = tSubtractGeometry.fLeft;
            this.fRight = tSubtractGeometry.fRight;
            this.fBounds = tSubtractGeometry.fBounds;
        }
        return this;
    }

    public boolean equals(MAreaGeometry mAreaGeometry) {
        if (this.getClass().equals(mAreaGeometry.getClass())) {
            TSubtractGeometry tSubtractGeometry = (TSubtractGeometry)mAreaGeometry;
            return super.equals(mAreaGeometry) || this.fLeft == tSubtractGeometry.fLeft && this.fRight == tSubtractGeometry.fRight;
        }
        return false;
    }

    public void extract(TGrafExtractor tGrafExtractor, TCAGNode tCAGNode, TGrafMatrix tGrafMatrix) {
        TCAGSubtract tCAGSubtract = new TCAGSubtract(tCAGNode);
        tGrafExtractor.adoptCAGNode(tCAGSubtract);
        this.fLeft.extract(tGrafExtractor, tCAGSubtract, tGrafMatrix);
        this.fRight.extract(tGrafExtractor, tCAGSubtract.getRightLink(), tGrafMatrix);
    }

    public TGRect getBounds() {
        if (this.fBounds == null) {
            this.fBounds = (TGRect)this.fLeft.getBounds().clone();
        }
        return this.fBounds;
    }

    public boolean intersects(TGRect tGRect) {
        return this.fLeft.intersects(tGRect) && !this.fRight.contains(tGRect);
    }

    public boolean isEmpty() {
        return this.fLeft.isEmpty() && this.fRight.isEmpty();
    }

    public boolean isPolygonal() {
        return this.fLeft.isPolygonal() && this.fRight.isPolygonal();
    }

    public boolean isSingular() {
        return false;
    }
}

