/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

abstract class TRawArray {
    protected static final int kDefaultGrowAmount = 8;
    protected int fArraySize = 0;
    protected int fNumberOfValues = 0;
    protected int fGrowAmount = 8;

    public TRawArray() {
    }

    public TRawArray(int n) {
        this.fNumberOfValues = n;
        this.fArraySize = n;
    }

    abstract void allocateArray(int var1);

    public final TRawArray copyFrom(TRawArray tRawArray) {
        this.fNumberOfValues = tRawArray.fNumberOfValues;
        this.fArraySize = tRawArray.fArraySize;
        return this;
    }

    public final boolean equals(TRawArray tRawArray) {
        return this.fNumberOfValues == tRawArray.fNumberOfValues;
    }

    public int getGrowIncrement() {
        return this.fGrowAmount;
    }

    public int getNumberOfValues() {
        return this.fNumberOfValues;
    }

    abstract void newAllocation(int var1, int var2);

    abstract void reallocateArray(int var1);

    public void resize(int n) {
        if (n != this.fNumberOfValues) {
            if (this.fNumberOfValues == 0) {
                this.fArraySize = this.roundUpSize(n);
                this.allocateArray(this.fArraySize);
                this.newAllocation(0, this.fArraySize);
            } else if (n == 0) {
                this.fArraySize = 0;
                this.allocateArray(0);
            } else {
                int n2 = this.roundUpSize(n);
                if (n2 != this.fArraySize) {
                    int n3 = this.fArraySize;
                    this.reallocateArray(n2);
                    this.fArraySize = n2;
                    if (n2 > n3) {
                        this.newAllocation(n3, n2 - n3);
                    }
                }
            }
            this.fNumberOfValues = n;
        }
    }

    private int roundUpSize(int n) {
        return (n += this.fGrowAmount - 1) - n % this.fGrowAmount;
    }

    public void setGrowIncrement(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("RawArray.setGrowIncrement()");
        }
        this.fGrowAmount = n;
    }

    public void swap(TRawArray tRawArray) {
        int n = this.fNumberOfValues;
        this.fNumberOfValues = tRawArray.fNumberOfValues;
        tRawArray.fNumberOfValues = n;
        n = this.fArraySize;
        this.fArraySize = tRawArray.fArraySize;
        tRawArray.fArraySize = n;
        n = this.fGrowAmount;
        this.fGrowAmount = tRawArray.fGrowAmount;
        tRawArray.fGrowAmount = n;
    }
}

